/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.utils;

import dev.jeka.core.api.utils.JkUtilsObject;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public final class JkUtilsIterable {
    public static <T> List<T> listOf(Iterable<T> it) {
        if (it instanceof List) {
            return (List)it;
        }
        LinkedList<T> result = new LinkedList<T>();
        for (T t : it) {
            result.add(t);
        }
        return result;
    }

    public static <T> List<T> listOf(T ... items) {
        return Arrays.asList(items);
    }

    public static <T> List<T> listOf2orMore(T item1, T item2, T ... others) {
        ArrayList<T> result = new ArrayList<T>(others.length + 2);
        result.add(item1);
        result.add(item2);
        for (int i = 0; i < others.length; ++i) {
            result.add(others[i]);
        }
        return result;
    }

    public static <T> List<T> listOf1orMore(T item1, T ... others) {
        ArrayList<T> result = new ArrayList<T>(others.length + 1);
        result.add(item1);
        for (int i = 0; i < others.length; ++i) {
            result.add(others[i]);
        }
        return result;
    }

    public static <T> List<T> listWithoutDuplicateOf(Iterable<T> items) {
        HashSet<T> set = new HashSet<T>();
        LinkedList<T> result = new LinkedList<T>();
        for (T item : items) {
            if (set.contains(item)) continue;
            set.add(item);
            result.add(item);
        }
        return result;
    }

    public static <T> void addAllWithoutDuplicate(Collection<T> recipientList, Iterable<? extends T> items) {
        for (T item : items) {
            if (recipientList.contains(item)) continue;
            recipientList.add(item);
        }
    }

    public static <T> T[] arrayOf(Iterable<T> it, Class<T> clazz) {
        List<T> list = JkUtilsIterable.listOf(it);
        Object[] result = (Object[])Array.newInstance(clazz, list.size());
        int i = 0;
        for (T t : it) {
            result[i] = t;
            ++i;
        }
        return result;
    }

    public static <T> Set<T> setOf(T ... items) {
        HashSet<T> result = new HashSet<T>();
        result.addAll(Arrays.asList(items));
        return result;
    }

    public static <T> Set<T> setOf(Iterable<T> items) {
        HashSet<T> result = new HashSet<T>();
        for (T item : items) {
            result.add(item);
        }
        return result;
    }

    public static <T, U> Map<T, U> mapOf(T key, U value, Object ... others) {
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        result.put(key, value);
        for (int i = 0; i < others.length; i += 2) {
            Object otherKey = others[i];
            Object otherValue = others[i + 1];
            result.put(otherKey, otherValue);
        }
        return result;
    }

    public static <T, U> Map<T, U> mapOfAny(Object ... others) {
        LinkedHashMap<Object, Object> result = new LinkedHashMap<Object, Object>();
        for (int i = 0; i < others.length; i += 2) {
            Object otherKey = others[i];
            Object otherValue = others[i + 1];
            result.put(otherKey, otherValue);
        }
        return result;
    }

    private static <T> List<Iterable<T>> removeEmptyIt(Iterable<Iterable<T>> iterables) {
        LinkedList<Iterable<T>> result = new LinkedList<Iterable<T>>();
        for (Iterable<T> iterable : iterables) {
            if (!iterable.iterator().hasNext()) continue;
            result.add(iterable);
        }
        return result;
    }

    public static <K, V> void putMultiEntry(Map<K, V> map, Iterable<K> keys, V value) {
        for (K key : keys) {
            map.put(key, value);
        }
    }

    public static <T> List<T> concatLists(Iterable<? extends T> ... lists) {
        LinkedList<T> result = new LinkedList<T>();
        for (Iterable<T> iterable : lists) {
            for (T item : iterable) {
                result.add(item);
            }
        }
        return result;
    }

    public static Map<String, String> propertiesToMap(Properties properties) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Object propKey : properties.keySet()) {
            result.put(propKey.toString(), properties.getProperty(propKey.toString()));
        }
        return result;
    }

    public static String toString(Map<?, ?> map) {
        StringBuilder builder = new StringBuilder();
        Iterator<Map.Entry<?, ?>> it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<?, ?> entry = it.next();
            builder.append(entry.getKey()).append("=");
            builder.append(JkUtilsObject.toString(entry.getValue()));
            if (!it.hasNext()) continue;
            builder.append(", ");
        }
        return builder.toString();
    }

    public static List<String> toStrings(Map<?, ?> map) {
        LinkedList<String> result = new LinkedList<String>();
        Iterator<Map.Entry<?, ?>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<?, ?> name;
            Map.Entry<?, ?> entry = name = iterator.next();
            result.add(entry.getKey() + "=" + JkUtilsObject.toString(entry.getValue()));
        }
        return result;
    }

    public static <T> T[] concat(T[] a, T[] b) {
        int aLen = a.length;
        int bLen = b.length;
        Object[] c = (Object[])Array.newInstance(a.getClass().getComponentType(), aLen + bLen);
        System.arraycopy(a, 0, c, 0, aLen);
        System.arraycopy(b, 0, c, aLen, bLen);
        return c;
    }
}

