/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.utils;

import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.utils.JkUtilsAssert;
import dev.jeka.core.api.utils.JkUtilsIterable;
import dev.jeka.core.api.utils.JkUtilsThrowable;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipError;

public final class JkUtilsPath {
    private JkUtilsPath() {
    }

    public static List<Path> disambiguate(Iterable<Path> paths) {
        if (paths instanceof Path) {
            Path path2 = (Path)paths;
            LinkedList<Path> result = new LinkedList<Path>();
            result.add(path2);
            return result;
        }
        LinkedList<Path> result = new LinkedList<Path>();
        paths.forEach(path -> result.add((Path)path));
        return result;
    }

    public static Path firstExisting(Path ... paths) {
        for (int i = 0; i < paths.length; ++i) {
            if (paths[i] == null || !Files.exists(paths[i], new LinkOption[0])) continue;
            return paths[i];
        }
        return null;
    }

    public static Path get(URL url) {
        try {
            return Paths.get(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Url " + url + " can not be turned to an URI", e);
        }
    }

    public static Path zipRoot(Path zipFile) {
        FileSystem fileSystem;
        URI uri = URI.create("jar:" + zipFile.toUri());
        Map<String, String> env = JkUtilsIterable.mapOf("create", "true", new Object[0]);
        try {
            try {
                fileSystem = FileSystems.getFileSystem(uri);
            }
            catch (FileSystemNotFoundException e) {
                fileSystem = FileSystems.newFileSystem(uri, env);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (ZipError e) {
            throw JkUtilsThrowable.unchecked(e, "Error while opening zip archive " + zipFile);
        }
        return fileSystem.getPath("/", new String[0]);
    }

    public static List<File> toFiles(Collection<Path> paths) {
        LinkedList<File> result = new LinkedList<File>();
        for (Path path : paths) {
            result.add(path.toFile());
        }
        return result;
    }

    public static File[] toFiles(Path ... paths) {
        File[] result = new File[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            result[i] = paths[i].toFile();
        }
        return result;
    }

    public static Path[] toPaths(File ... files) {
        Path[] result = new Path[files.length];
        for (int i = 0; i < files.length; ++i) {
            result[i] = files[i].toPath();
        }
        return result;
    }

    public static List<Path> toPaths(Iterable<File> files) {
        LinkedList<Path> result = new LinkedList<Path>();
        for (File file : files) {
            result.add(file.toPath());
        }
        return result;
    }

    public static boolean isSameFile(Path path1, Path path2) {
        JkUtilsAssert.argument(Files.exists(path1, new LinkOption[0]), "path1 does not exist", new Object[0]);
        JkUtilsAssert.argument(Files.exists(path2, new LinkOption[0]), "path2 does not exist", new Object[0]);
        try {
            return Files.isSameFile(path1, path2);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static Path createTempFile(String prefix, String extension, FileAttribute ... fileAttributes) {
        try {
            return Files.createTempFile(prefix, extension, fileAttributes);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static List<String> readAllLines(Path path) {
        try {
            return Files.readAllLines(path);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static byte[] readAllBytes(Path path) {
        try {
            return Files.readAllBytes(path);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void deleteFile(Path path) {
        try {
            Files.delete(path);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void deleteIfExists(Path path) {
        try {
            Files.deleteIfExists(path);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void createFile(Path path, FileAttribute<?> ... attrs) {
        try {
            Files.createFile(path, attrs);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void createFileSafely(Path path, FileAttribute<?> ... attrs) {
        if (Files.exists(path, new LinkOption[0])) {
            return;
        }
        try {
            if (path.getParent() != null) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
            }
            Files.createFile(path, attrs);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void write(Path path, byte[] bytes, OpenOption ... options) {
        try {
            Files.write(path, bytes, options);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static Path createTempDirectory(String prefix, FileAttribute ... fileAttributes) {
        try {
            return Files.createTempDirectory(prefix, fileAttributes);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static DirectoryStream<Path> newDirectoryStream(Path root, DirectoryStream.Filter<Path> filter) {
        try {
            return Files.newDirectoryStream(root, filter);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<Path> listDirectChildren(Path path) {
        try (Stream<Path> stream = Files.list(path);){
            List<Path> list = stream.collect(Collectors.toList());
            return list;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void createDirectories(Path path, FileAttribute<?> ... attrs) {
        try {
            Files.createDirectories(path, attrs);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void copy(Path source, Path target, CopyOption ... copyOptions) {
        try {
            Files.copy(source, target, copyOptions);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static URL toUrl(Path path) {
        try {
            return path.toUri().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Stream<Path> walk(Path path, FileVisitOption ... options) {
        try {
            return Files.walk(path, options);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static Stream<Path> walk(Path path, int deep, FileVisitOption ... options) {
        try {
            return Files.walk(path, deep, options);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void walkFileTree(Path path, FileVisitor<Path> visitor) {
        try {
            Files.walkFileTree(path, visitor);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static int copyDirContent(Path sourceDir, Path targetDir, PathMatcher pathMatcher, CopyOption ... copyOptions) {
        CopyDirVisitor visitor = new CopyDirVisitor(sourceDir, targetDir, pathMatcher, copyOptions);
        JkUtilsPath.createDirectories(targetDir, new FileAttribute[0]);
        JkUtilsPath.walkFileTree(sourceDir, visitor);
        return visitor.count;
    }

    public static int childrenCount(Path dir, int max, boolean includeDirectories, PathMatcher pathMatcher) {
        CountFileVisitor visitor = new CountFileVisitor(dir, max, includeDirectories, pathMatcher);
        JkUtilsPath.walkFileTree(dir, visitor);
        return visitor.count;
    }

    public static Path relativizeFromWorkingDir(Path path) {
        return path.isAbsolute() ? Paths.get("", new String[0]).toAbsolutePath().relativize(path) : path;
    }

    public static Path relativizeFromDirIfAbsolute(Path referent, Path pathToRelativize) {
        return pathToRelativize.isAbsolute() ? Paths.get("", new String[0]).toAbsolutePath().relativize(pathToRelativize) : pathToRelativize;
    }

    public static Optional<Long> getLastModifiedTime(Path path, LinkOption ... options) {
        JkUtilsAssert.argument(Files.exists(path, new LinkOption[0]), "File " + path + " not found.", new Object[0]);
        try {
            return Optional.of(Files.getLastModifiedTime(path, options).toMillis());
        }
        catch (IOException e) {
            JkLog.warn("Cannot get last modified time of file " + path + ".", new Object[0]);
            return Optional.empty();
        }
    }

    private static class CountFileVisitor
    extends SimpleFileVisitor<Path> {
        private final Path fromPath;
        private final boolean includeDirectories;
        private final int countMax;
        private int count;
        private final PathMatcher pathMatcher;

        CountFileVisitor(Path fromPath, int countMax, boolean includeDirectories, PathMatcher pathMatcher) {
            this.fromPath = fromPath;
            this.countMax = countMax;
            this.includeDirectories = includeDirectories;
            this.pathMatcher = pathMatcher;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
            Path sourceRelativePath = this.fromPath.relativize(dir);
            if (!this.pathMatcher.matches(sourceRelativePath)) {
                return FileVisitResult.CONTINUE;
            }
            if (this.includeDirectories && !this.fromPath.equals(dir)) {
                ++this.count;
            }
            if (this.count > this.countMax) {
                return FileVisitResult.TERMINATE;
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
            Path relativePath = this.fromPath.relativize(file);
            if (!this.pathMatcher.matches(relativePath)) {
                return FileVisitResult.CONTINUE;
            }
            ++this.count;
            if (this.count > this.countMax) {
                return FileVisitResult.TERMINATE;
            }
            return FileVisitResult.CONTINUE;
        }
    }

    private static class CopyDirVisitor
    extends SimpleFileVisitor<Path> {
        private final Path fromDir;
        private final Path toDir;
        private final PathMatcher pathMatcher;
        private final CopyOption[] options;
        int count;

        CopyDirVisitor(Path fromDir, Path toDir, PathMatcher pathMatcher, CopyOption ... options) {
            this.fromDir = fromDir;
            this.toDir = toDir;
            this.options = options;
            this.pathMatcher = pathMatcher;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            Path sourceRelativePath = this.fromDir.relativize(dir);
            if (!this.pathMatcher.matches(sourceRelativePath)) {
                return FileVisitResult.CONTINUE;
            }
            Path relativePath = this.toDir.getFileSystem().getPath(this.toDir.toString(), sourceRelativePath.toString());
            Files.createDirectories(relativePath, new FileAttribute[0]);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Path relativePath = this.fromDir.relativize(file);
            if (!this.pathMatcher.matches(relativePath)) {
                return FileVisitResult.CONTINUE;
            }
            Path target = this.toDir.getFileSystem().getPath(this.toDir.toString(), relativePath.toString());
            if (target.getParent() != null) {
                Files.createDirectories(target.getParent(), new FileAttribute[0]);
            }
            Files.copy(file, target, this.options);
            ++this.count;
            return FileVisitResult.CONTINUE;
        }
    }
}

