/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.utils;

import dev.jeka.core.api.utils.JkUtilsString;
import dev.jeka.core.api.utils.JkUtilsThrowable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class JkUtilsReflect {
    private static final Map<Class<?>, Class<?>> PRIMITIVE_TO_WRAPPER = new HashMap();

    public static void setAccessibleIfNeeded(Field field) {
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
    }

    public static Method methodWithSameNameAndArgType(Method original, Class<?> targetClass) {
        for (Method method : targetClass.getMethods()) {
            if (!method.getName().equals(original.getName())) continue;
            Class<?>[] originalTypes = method.getParameterTypes();
            Class<?>[] types = method.getParameterTypes();
            if (types.length == 0 && originalTypes.length == 0) {
                return method;
            }
            if (types.length != originalTypes.length) continue;
            boolean found = false;
            for (int i = 0; i < originalTypes.length && originalTypes[i].getName().equals(types[i].getName()); ++i) {
                found = true;
            }
            if (!found) continue;
            return method;
        }
        throw new IllegalArgumentException("No method " + original + " found on class " + targetClass.getName());
    }

    public static List<Method> methodsHavingName(Class clazz, String name) {
        LinkedList<Method> result = new LinkedList<Method>();
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(name)) continue;
            result.add(method);
        }
        return result;
    }

    public static Class<?>[] getTypesOf(Object[] params) {
        Class[] result = new Class[params.length];
        for (int i = 0; i < params.length; ++i) {
            result[i] = params[i] == null ? null : params[i].getClass();
        }
        return result;
    }

    public static <T> T getFieldValue(Object object, Field field) {
        JkUtilsReflect.setAccessibleIfNeeded(field);
        try {
            return (T)field.get(object);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void setFieldValue(Object object, Field field, Object value) {
        try {
            JkUtilsReflect.setAccessibleIfNeeded(field);
            field.set(object, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object getFieldValue(Object object, String fieldName) {
        try {
            Field field = JkUtilsReflect.getField(object.getClass(), fieldName);
            if (field == null) {
                throw new IllegalArgumentException("No field '" + fieldName + "' found in " + object.getClass().getName() + " or its super classes");
            }
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            return field.get(object);
        }
        catch (Exception e) {
            throw JkUtilsThrowable.unchecked(e);
        }
    }

    public static Field getField(Class<?> clazz, String fieldName) {
        Field[] fields = clazz.getDeclaredFields();
        Field field = JkUtilsReflect.getField(fields, fieldName);
        if (field == null) {
            Class<?> superClass = clazz.getSuperclass();
            if (Object.class.equals(superClass)) {
                return null;
            }
            return JkUtilsReflect.getField(superClass, fieldName);
        }
        return field;
    }

    private static Field getField(Field[] fields, String fieldName) {
        for (Field field : fields) {
            if (!fieldName.equals(field.getName())) continue;
            return field;
        }
        return null;
    }

    public static <T> T newInstance(Class<T> clazz) {
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
            }
            return constructor.newInstance(new Object[0]);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            throw JkUtilsThrowable.unchecked(targetException, targetException.getMessage());
        }
        catch (Exception e) {
            throw JkUtilsThrowable.unchecked(e);
        }
    }

    public static <T> T newInstance(Class<T> clazz, Class<?> parameterType, Object parameter) {
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(parameterType);
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
            }
            return constructor.newInstance(parameter);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            throw new RuntimeException(e.getTargetException());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("No constructor found with parameter of type " + parameterType.getName() + " on class " + clazz, e);
        }
    }

    public static <T> T invoke(Object target, String methodName) {
        Method method;
        try {
            method = target.getClass().getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("No method " + methodName + " found on class " + methodName);
        }
        return JkUtilsReflect.invoke(target, method);
    }

    public static <T> T invoke(Object target, Method method) {
        if (!method.isAccessible()) {
            method.setAccessible(true);
        }
        try {
            return (T)method.invoke(target, new Object[0]);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            throw new RuntimeException(e.getTargetException());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <V> V invoke(Object target, Method method, Object ... params) {
        try {
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            return (V)method.invoke(target, params);
        }
        catch (InvocationTargetException e) {
            Throwable targetEx = e.getTargetException();
            if (targetEx instanceof Error) {
                throw (Error)targetEx;
            }
            throw JkUtilsThrowable.unchecked((Exception)targetEx);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Type mismatch. Expecting " + Arrays.toString(method.getParameterTypes()) + " but got " + Arrays.toString(params), e);
        }
        catch (Exception e) {
            throw JkUtilsThrowable.unchecked(e, "Error while invoking " + method + " with params " + Arrays.toString(params));
        }
    }

    private static String[] detailedTypesOf(Object ... params) {
        String[] result = new String[params.length];
        for (int i = 0; i < params.length; ++i) {
            result[i] = params[i] == null ? null : params[i].getClass().getName() + ":" + params[i].getClass().getClassLoader();
        }
        return result;
    }

    private static String[] classloaderOf(Class<?> ... params) {
        String[] result = new String[params.length];
        for (int i = 0; i < params.length; ++i) {
            ClassLoader classLoader = params[i].getClassLoader();
            result[i] = params[i] == null ? null : params[i].getName() + ":" + classLoader.toString();
        }
        return result;
    }

    public static Method getMethod(Class<?> clazz, String name, Class<?> ... argTypes) {
        try {
            return clazz.getMethod(name, argTypes);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("No method " + name + " with argTypes " + JkUtilsReflect.toString(argTypes) + " found on class " + clazz.getName());
        }
    }

    public static Method getMethodOrNull(Class<?> clazz, String name, Class<?> ... argTypes) {
        try {
            return clazz.getMethod(name, argTypes);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Method getDeclaredMethod(Class<?> clazz, String name, Class<?> ... argTypes) {
        try {
            Method method = clazz.getDeclaredMethod(name, argTypes);
            method.setAccessible(true);
            return method;
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Method findMethodMethodDeclaration(Class<?> clazz, String name, Class<?> ... argTypes) {
        try {
            return clazz.getDeclaredMethod(name, argTypes);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            if (clazz.equals(Object.class)) {
                return null;
            }
            return JkUtilsReflect.findMethodMethodDeclaration(clazz.getSuperclass(), name, argTypes);
        }
    }

    private static String toString(Class<?> ... classes) {
        return "[" + JkUtilsString.join(Arrays.asList(classes), ", ") + "]";
    }

    public static boolean isMethodPublicIn(Class<?> clazz, String method, Class<?> ... args) {
        try {
            clazz.getMethod(method, args);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        return true;
    }

    public static <T extends Annotation> T getInheritedAnnotation(Method method, Class<T> annotationClass) {
        T result = method.getAnnotation(annotationClass);
        if (result != null) {
            return result;
        }
        Class<?> methodSuperClass = method.getDeclaringClass().getSuperclass();
        if (methodSuperClass != null) {
            Method superMethod = JkUtilsReflect.getMethodOrNull(methodSuperClass, method.getName(), method.getParameterTypes());
            if (superMethod == null) {
                return null;
            }
            return JkUtilsReflect.getInheritedAnnotation(superMethod, annotationClass);
        }
        return null;
    }

    public static <T extends Annotation> T getInheritedAnnotation(Class<?> clazz, Class<T> annotationClass, String methodName, Class<?> ... argTypes) {
        Method method = JkUtilsReflect.getDeclaredMethod(clazz, methodName, argTypes);
        if (method == null) {
            if (clazz.equals(Object.class)) {
                return null;
            }
            return JkUtilsReflect.getInheritedAnnotation(clazz.getSuperclass(), annotationClass, methodName, argTypes);
        }
        return JkUtilsReflect.getInheritedAnnotation(method, annotationClass);
    }

    public static List<Field> getAllDeclaredFields(Class<?> clazz, Class<? extends Annotation> annotationClass) {
        LinkedList<Field> result = new LinkedList<Field>();
        for (Field field : clazz.getDeclaredFields()) {
            Annotation option = field.getAnnotation(annotationClass);
            if (option == null) continue;
            result.add(field);
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null) {
            result.addAll(JkUtilsReflect.getAllDeclaredFields(superClass, annotationClass));
        }
        return result;
    }

    public static List<Field> getAllDeclaredFields(Class<?> clazz, boolean includeSuperClass) {
        LinkedList<Field> result = new LinkedList<Field>();
        Collections.addAll(result, clazz.getDeclaredFields());
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null && includeSuperClass) {
            result.addAll(JkUtilsReflect.getAllDeclaredFields(superClass, true));
        }
        return result;
    }

    public static <T> T invokeStaticMethod(Class<?> clazz, String methodName, Object ... args) {
        return (T)JkUtilsReflect.invokeMethod(null, clazz, methodName, args);
    }

    public static <T> T invokeInstanceMethod(Object instance, String methodName, Object ... args) {
        return (T)JkUtilsReflect.invokeMethod(instance, null, methodName, args);
    }

    private static Object invokeMethod(Object target, Class<?> clazz, String methodName, Object ... args) {
        boolean staticMethod = target == null;
        Class<?> effectiveClass = clazz == null ? target.getClass() : clazz;
        String className = effectiveClass.getName();
        HashSet<Method> canditates = new HashSet<Method>(Arrays.asList(effectiveClass.getMethods()));
        canditates.addAll(Arrays.asList(effectiveClass.getDeclaredMethods()));
        Object[] types = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            types[i] = arg == null ? null : arg.getClass();
        }
        Set<Method> result = JkUtilsReflect.findMethodsCompatibleWith(staticMethod, canditates, methodName, types);
        if (result.isEmpty()) {
            throw new IllegalArgumentException("No " + (staticMethod ? "static" : "instance") + " method found on class " + className + " for method " + methodName + " and param types " + Arrays.toString(types));
        }
        if (result.size() > 1) {
            throw new IllegalArgumentException("Several " + (staticMethod ? "static" : "instance") + " methods match on class " + className + " for method " + methodName + " and param types " + Arrays.toString(types) + ". You should use method #invoke(Method, Object[] args) instead.");
        }
        Method method = result.iterator().next();
        return JkUtilsReflect.invoke(target, method, args);
    }

    private static Set<Method> findMethodsCompatibleWith(boolean staticMethod, Set<Method> methods, String methodName, Class<?>[] argTypes) {
        HashSet<Method> list = new HashSet<Method>(methods);
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Method method = (Method)it.next();
            if (!methodName.equals(method.getName())) {
                it.remove();
                continue;
            }
            if (argTypes.length != method.getParameterTypes().length) {
                it.remove();
                continue;
            }
            if (Modifier.isAbstract(method.getModifiers()) || Modifier.isStatic(method.getModifiers()) != staticMethod) {
                it.remove();
                continue;
            }
            if (JkUtilsReflect.isMethodArgCompatible(method, argTypes)) continue;
            it.remove();
        }
        return list;
    }

    private static boolean isMethodArgCompatible(Method method, Class<?> ... argTypes) {
        for (int i = 0; i < argTypes.length; ++i) {
            if (JkUtilsReflect.isCompatible(method.getParameterTypes()[i], argTypes[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean isCompatible(Class<?> type0, Class<?> type1) {
        if (type1 == null) {
            return true;
        }
        if (type0.getName().equals(type1.getName())) {
            return true;
        }
        if (type0.isPrimitive()) {
            return JkUtilsReflect.isCompatible(PRIMITIVE_TO_WRAPPER.get(type0), type1);
        }
        if (type1.isPrimitive()) {
            return JkUtilsReflect.isCompatible(type0, PRIMITIVE_TO_WRAPPER.get(type1));
        }
        return type0.isAssignableFrom(type1);
    }

    static {
        PRIMITIVE_TO_WRAPPER.put(Integer.TYPE, Integer.class);
        PRIMITIVE_TO_WRAPPER.put(Long.TYPE, Long.class);
        PRIMITIVE_TO_WRAPPER.put(Double.TYPE, Double.class);
        PRIMITIVE_TO_WRAPPER.put(Float.TYPE, Float.class);
        PRIMITIVE_TO_WRAPPER.put(Boolean.TYPE, Boolean.class);
        PRIMITIVE_TO_WRAPPER.put(Character.TYPE, Character.class);
        PRIMITIVE_TO_WRAPPER.put(Byte.TYPE, Byte.class);
        PRIMITIVE_TO_WRAPPER.put(Void.TYPE, Void.TYPE);
        PRIMITIVE_TO_WRAPPER.put(Short.TYPE, Short.TYPE);
    }
}

