/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.utils;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;

public final class JkUtilsString {
    private static final byte[] HEX_CHAR_TABLE = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};

    static String join(Iterable<?> items, String separator) {
        StringBuilder builder = new StringBuilder();
        Iterator<?> it = items.iterator();
        while (it.hasNext()) {
            builder.append(it.next().toString());
            if (!it.hasNext()) continue;
            builder.append(separator);
        }
        return builder.toString();
    }

    public static String capitalize(String string) {
        if (string.isEmpty()) {
            return string;
        }
        if (string.length() == 1) {
            return string.toUpperCase();
        }
        String first = string.substring(0, 1);
        String remaining = string.substring(1);
        return first.toUpperCase() + remaining;
    }

    public static String uncapitalize(String string) {
        if (string.isEmpty()) {
            return string;
        }
        if (string.length() == 1) {
            return string.toLowerCase();
        }
        String first = string.substring(0, 1);
        String remaining = string.substring(1);
        return first.toLowerCase() + remaining;
    }

    public static String firstMatching(String stringToMatch, String ... candidates) {
        for (String candidate : candidates) {
            if (!stringToMatch.contains(candidate)) continue;
            return candidate;
        }
        return null;
    }

    public static int countOccurrence(String matchedString, char occurrence) {
        int count = 0;
        for (char c : matchedString.toCharArray()) {
            if (c != occurrence) continue;
            ++count;
        }
        return count;
    }

    public static String[] splitTrimmed(String str, String delimiters) {
        if (str == null) {
            return new String[0];
        }
        StringTokenizer st = new StringTokenizer(str, delimiters);
        ArrayList<String> tokens = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            tokens.add(token.trim());
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    public static String substringAfterLast(String string, String delimiter) {
        int index = string.lastIndexOf(delimiter);
        if (index == -1 || string.endsWith(delimiter)) {
            return "";
        }
        return string.substring(index + 1);
    }

    public static String substringBeforeFirst(String string, String delimiter) {
        int index = string.indexOf(delimiter);
        if (index == -1) {
            return "";
        }
        return string.substring(0, index);
    }

    public static String substringAfterFirst(String string, String delimiter) {
        int index = string.indexOf(delimiter);
        if (index == -1) {
            return "";
        }
        return string.substring(index + delimiter.length());
    }

    public static String substringBeforeLast(String string, String delimiter) {
        int index = string.lastIndexOf(delimiter);
        if (index == -1 || string.startsWith(delimiter)) {
            return "";
        }
        return string.substring(0, index);
    }

    public static String repeat(String pattern, int count) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            builder.append(pattern);
        }
        return builder.toString();
    }

    public static String plurialize(int count, String singular, String plurial) {
        if (count > 1) {
            return "" + count + " " + plurial;
        }
        return "" + count + " " + singular;
    }

    public static String plurialize(int count, String singular) {
        return JkUtilsString.plurialize(count, singular, singular + 's');
    }

    public static <T> T parse(Class<T> type, String stringValue) throws IllegalArgumentException {
        if (type.equals(String.class)) {
            return (T)stringValue;
        }
        if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
            return (T)Boolean.valueOf(stringValue);
        }
        try {
            if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
                return (T)Integer.valueOf(stringValue);
            }
            if (type.equals(Long.class) || type.equals(Long.TYPE)) {
                return (T)Long.valueOf(stringValue);
            }
            if (type.equals(Short.class) || type.equals(Short.TYPE)) {
                return (T)Short.valueOf(stringValue);
            }
            if (type.equals(Byte.class) || type.equals(Byte.TYPE)) {
                return (T)Byte.valueOf(stringValue);
            }
            if (type.equals(Double.class) || type.equals(Double.TYPE)) {
                return (T)Double.valueOf(stringValue);
            }
            if (type.equals(Float.class) || type.equals(Float.TYPE)) {
                return (T)Float.valueOf(stringValue);
            }
            if (type.equals(File.class)) {
                return (T)new File(stringValue);
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        if (type.isEnum()) {
            Class<T> enumType = type;
            return Enum.valueOf(enumType, stringValue);
        }
        throw new IllegalArgumentException("Can't handle type " + type);
    }

    public static String toHexString(byte[] raw) throws IllegalArgumentException {
        byte[] hex = new byte[2 * raw.length];
        int index = 0;
        for (byte b : raw) {
            int v = b & 0xFF;
            hex[index++] = HEX_CHAR_TABLE[v >>> 4];
            hex[index++] = HEX_CHAR_TABLE[v & 0xF];
        }
        return new String(hex, StandardCharsets.US_ASCII);
    }

    public static boolean equalsAny(String stringToMatch, String ... candidates) {
        for (String candidate : candidates) {
            if (!JkUtilsString.equals(stringToMatch, candidate)) continue;
            return true;
        }
        return false;
    }

    public static boolean equals(String string1, String string2) {
        if (string1 == null) {
            return string2 == null;
        }
        return string1.equals(string2);
    }

    public static boolean endsWithAny(String stringToMatch, String ... candidates) {
        for (String candidate : candidates) {
            if (!stringToMatch.endsWith(candidate)) continue;
            return true;
        }
        return false;
    }

    public static boolean startsWithAny(String stringToMatch, String ... stringToCheckEquals) {
        for (String candidate : stringToCheckEquals) {
            if (!stringToMatch.startsWith(candidate)) continue;
            return true;
        }
        return false;
    }

    public static boolean isBlank(String string) {
        if (string == null) {
            return true;
        }
        return string.isEmpty() || " ".equals(string);
    }

    public static String escapeHtml(String s) {
        StringBuilder out = new StringBuilder(Math.max(16, s.length()));
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c > '\u007f' || c == '\"' || c == '<' || c == '>' || c == '&') {
                out.append("&#");
                out.append((int)c);
                out.append(';');
                continue;
            }
            out.append(c);
        }
        return out.toString();
    }

    public static String elipse(String string, int max) {
        if (string.length() <= max || max < 0) {
            return string;
        }
        return string.substring(0, max) + "...";
    }

    public static String[] translateCommandline(String toProcess) {
        if (toProcess == null || toProcess.length() == 0) {
            return new String[0];
        }
        boolean normal = false;
        boolean inQuote = true;
        int inDoubleQuote = 2;
        int state = 0;
        StringTokenizer tok = new StringTokenizer(toProcess, "\"' ", true);
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        boolean lastTokenHasBeenQuoted = false;
        block4: while (tok.hasMoreTokens()) {
            String nextTok = tok.nextToken();
            switch (state) {
                case 1: {
                    if ("'".equals(nextTok)) {
                        lastTokenHasBeenQuoted = true;
                        state = 0;
                        continue block4;
                    }
                    current.append(nextTok);
                    continue block4;
                }
                case 2: {
                    if ("\"".equals(nextTok)) {
                        lastTokenHasBeenQuoted = true;
                        state = 0;
                        continue block4;
                    }
                    current.append(nextTok);
                    continue block4;
                }
            }
            if ("'".equals(nextTok)) {
                state = 1;
            } else if ("\"".equals(nextTok)) {
                state = 2;
            } else if (" ".equals(nextTok)) {
                if (lastTokenHasBeenQuoted || current.length() != 0) {
                    result.add(current.toString());
                    current.setLength(0);
                }
            } else {
                current.append(nextTok);
            }
            lastTokenHasBeenQuoted = false;
        }
        if (lastTokenHasBeenQuoted || current.length() != 0) {
            result.add(current.toString());
        }
        if (state == 1 || state == 2) {
            throw new IllegalArgumentException("unbalanced quotes in " + toProcess);
        }
        return result.toArray(new String[result.size()]);
    }

    public static Integer parseInteger(String number) {
        try {
            return Integer.parseInt(number);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static String conformPackageName(String string) {
        return string.toLowerCase().replace('-', '_');
    }

    public static String padEnd(String string, int minLength, char padChar) {
        if (string.length() >= minLength) {
            return string;
        }
        StringBuilder sb = new StringBuilder(minLength);
        sb.append(string);
        for (int i = string.length(); i < minLength; ++i) {
            sb.append(padChar);
        }
        return sb.toString();
    }

    public static String padStart(String string, int minLength, char padChar) {
        if (string.length() >= minLength) {
            return string;
        }
        StringBuilder sb = new StringBuilder(minLength);
        for (int i = string.length(); i < minLength; ++i) {
            sb.append(padChar);
        }
        sb.append(string);
        return sb.toString();
    }
}

