/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.utils;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public final class JkUtilsTime {
    private JkUtilsTime() {
    }

    public static Date now() {
        return new Date();
    }

    public static String now(String pattern) {
        return new SimpleDateFormat(pattern).format(JkUtilsTime.now());
    }

    public static String nowUtc(String pattern) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return dateFormat.format(JkUtilsTime.now());
    }

    public static float durationInSeconds(long startNano) {
        long endNano = System.nanoTime();
        long durationMillis = (endNano - startNano) / 1000000L;
        return (float)durationMillis / 1000.0f;
    }

    public static long durationInMillis(long startNano) {
        long endNano = System.nanoTime();
        return (endNano - startNano) / 1000000L;
    }
}

