/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.tool;

import dev.jeka.core.api.utils.JkUtilsObject;
import dev.jeka.core.api.utils.JkUtilsReflect;
import dev.jeka.core.api.utils.JkUtilsString;
import dev.jeka.core.tool.FieldInjector;
import dev.jeka.core.tool.JkBean;
import dev.jeka.core.tool.JkDoc;
import dev.jeka.core.tool.JkInjectProperty;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

final class BeanDescription {
    private final List<BeanMethod> beanMethods;
    private final List<BeanField> beanFields;
    private final Class<? extends JkBean> beanClass;

    private BeanDescription(Class<? extends JkBean> beanClass, List<BeanMethod> beanMethods, List<BeanField> beanFields) {
        this.beanClass = beanClass;
        this.beanMethods = Collections.unmodifiableList(beanMethods);
        this.beanFields = Collections.unmodifiableList(beanFields);
    }

    static BeanDescription of(Class<? extends JkBean> beanClass) {
        LinkedList<BeanMethod> methods = new LinkedList<BeanMethod>();
        for (Method method : BeanDescription.executableMethods(beanClass)) {
            methods.add(BeanMethod.of(method));
        }
        Collections.sort(methods);
        LinkedList<BeanField> options = new LinkedList<BeanField>();
        for (NameAndField nameAndField : BeanDescription.fields(beanClass, "", true, null)) {
            options.add(BeanField.of(beanClass, nameAndField.field, nameAndField.name, nameAndField.rootClass));
        }
        Collections.sort(options);
        return new BeanDescription(beanClass, methods, options);
    }

    List<BeanMethod> beanMethods() {
        return this.beanMethods;
    }

    List<BeanField> beanFields() {
        return this.beanFields;
    }

    private static List<Method> executableMethods(Class<?> clazz) {
        LinkedList<Method> result = new LinkedList<Method>();
        for (Method method : clazz.getMethods()) {
            int modifier = method.getModifiers();
            if (!method.getReturnType().equals(Void.TYPE) || method.getParameterTypes().length != 0 || JkUtilsReflect.isMethodPublicIn(Object.class, method.getName(), new Class[0]) || Modifier.isAbstract(modifier) || Modifier.isStatic(modifier)) continue;
            result.add(method);
        }
        return result;
    }

    private static List<NameAndField> fields(Class<?> clazz, String prefix, boolean root, Class<?> rClass) {
        LinkedList<NameAndField> result = new LinkedList<NameAndField>();
        for (Field field : FieldInjector.getPropertyFields(clazz)) {
            Class<?> rootClass;
            Class<?> clazz2 = rootClass = root ? field.getDeclaringClass() : rClass;
            if (!BeanDescription.hasSubOption(field)) {
                result.add(new NameAndField(prefix + field.getName(), field, rootClass));
                continue;
            }
            List<NameAndField> subOpts = BeanDescription.fields(field.getType(), prefix + field.getName() + ".", false, rootClass);
            result.addAll(subOpts);
        }
        return result;
    }

    private static boolean hasSubOption(Field field) {
        return !JkUtilsReflect.getAllDeclaredFields(field.getType(), JkDoc.class).isEmpty();
    }

    String description() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Class<? extends JkBean> buildClass : this.beanClassHierarchy()) {
            stringBuilder.append(this.description(buildClass, "", true, false));
        }
        return stringBuilder.toString();
    }

    String flatDescription(String prefix) {
        return this.description(this.beanClass, prefix, false, true);
    }

    private String description(Class<?> beanClass, String prefix, boolean withHeader, boolean includeHierarchy) {
        int maxSize;
        String margin;
        List<BeanField> properties;
        List<BeanMethod> methods = includeHierarchy ? this.beanMethods : this.methodsOf(beanClass);
        List<BeanField> list = properties = includeHierarchy ? this.beanFields : this.optionsOf(beanClass);
        if (methods.isEmpty() && properties.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (withHeader) {
            stringBuilder.append("\nFrom " + beanClass.getName() + " :\n");
        }
        String string = margin = withHeader ? "  " : "";
        if (!methods.isEmpty()) {
            String displayedMethodName;
            stringBuilder.append(margin + "METHODS\n");
            maxSize = 0;
            for (BeanMethod method : methods) {
                displayedMethodName = prefix + method.name;
                if (displayedMethodName.length() <= maxSize) continue;
                maxSize = displayedMethodName.length();
            }
            for (BeanMethod methodDef : methods) {
                displayedMethodName = JkUtilsString.padEnd(prefix + methodDef.name, maxSize + 1, ' ');
                if (methodDef.description == null) {
                    stringBuilder.append(margin + "  " + displayedMethodName + " : No description available.\n");
                    continue;
                }
                stringBuilder.append(margin).append("  ").append(displayedMethodName).append(" : ").append(methodDef.description.replace("\n", " ")).append("\n");
            }
        }
        if (!properties.isEmpty()) {
            String displayName;
            stringBuilder.append(margin + "PROPERTIES\n");
            maxSize = 0;
            for (BeanField property : properties) {
                displayName = prefix + property.name;
                if (displayName.length() <= maxSize) continue;
                maxSize = displayName.length();
            }
            for (BeanField property : properties) {
                displayName = JkUtilsString.padEnd(prefix + property.name + "=", maxSize + 1, ' ');
                stringBuilder.append(property.description(displayName, margin));
            }
        }
        return stringBuilder.toString();
    }

    Map<String, String> optionValues(JkBean bean) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (BeanField optionDef : this.beanFields) {
            String name = optionDef.name;
            Object value = BeanField.value(bean, name);
            result.put(name, JkUtilsObject.toString(value));
        }
        return result;
    }

    Element toElement(Document document) {
        Element runEl = document.createElement("run");
        Element methodsEl = document.createElement("methods");
        runEl.appendChild(methodsEl);
        for (BeanMethod beanMethod : this.beanMethods) {
            Element methodEl = beanMethod.toXmlElement(document);
            methodsEl.appendChild(methodEl);
        }
        Element optionsEl = document.createElement("options");
        runEl.appendChild(optionsEl);
        for (BeanField beanField : this.beanFields) {
            Element optionEl = beanField.toElement(document);
            optionsEl.appendChild(optionEl);
        }
        return runEl;
    }

    private List<Class<? extends JkBean>> beanClassHierarchy() {
        ArrayList<Class<? extends JkBean>> result = new ArrayList<Class<? extends JkBean>>();
        Class<? extends JkBean> current = this.beanClass;
        while (JkBean.class.isAssignableFrom(current) || JkBean.class.isAssignableFrom(current)) {
            result.add(current);
            current = current.getSuperclass();
        }
        return result;
    }

    private List<BeanMethod> methodsOf(Class<?> runClass) {
        return this.beanMethods.stream().filter(beanMethod -> runClass.equals(((BeanMethod)beanMethod).declaringClass)).collect(Collectors.toList());
    }

    private List<BeanField> optionsOf(Class<?> runClass) {
        return this.beanFields.stream().filter(beanField -> runClass.equals(((BeanField)beanField).rootDeclaringClass)).collect(Collectors.toList());
    }

    private static class NameAndField {
        final String name;
        final Field field;
        final Class<?> rootClass;

        NameAndField(String name, Field field, Class<?> rootClass) {
            this.name = name;
            this.field = field;
            this.rootClass = rootClass;
        }

        public String toString() {
            return this.name + ", to " + this.rootClass.getName();
        }
    }

    static final class BeanField
    implements Comparable<BeanField> {
        private final String name;
        private final String description;
        private final Object bean;
        private final Object defaultValue;
        private final Class<?> rootDeclaringClass;
        private final Class<?> type;
        private final String injectedPropertyName;

        private BeanField(String name, String description, Object bean, Object defaultValue, Class<?> type, Class<?> declaringClass, String injectedPropertyName) {
            this.name = name;
            this.description = description;
            this.bean = bean;
            this.defaultValue = defaultValue;
            this.type = type;
            this.rootDeclaringClass = declaringClass;
            this.injectedPropertyName = injectedPropertyName;
        }

        static BeanField of(Class<? extends JkBean> beanClass, Field field, String name, Class<?> rootDeclaringClass) {
            JkDoc opt = field.getAnnotation(JkDoc.class);
            String descr = opt != null ? String.join((CharSequence)"\n", opt.value()) : null;
            Class<?> type = field.getType();
            JkBean instance = JkUtilsReflect.newInstance(beanClass);
            Object defaultValue = BeanField.value(instance, name);
            JkInjectProperty injectProperty = field.getAnnotation(JkInjectProperty.class);
            String propertyName = injectProperty != null ? injectProperty.value() : null;
            return new BeanField(name, descr, instance, defaultValue, type, rootDeclaringClass, propertyName);
        }

        private static Object value(Object runInstance, String optName) {
            if (!optName.contains(".")) {
                return JkUtilsReflect.getFieldValue(runInstance, optName);
            }
            String first = JkUtilsString.substringBeforeFirst(optName, ".");
            Object firstObject = JkUtilsReflect.getFieldValue(runInstance, first);
            if (firstObject == null) {
                Class<?> firstClass = JkUtilsReflect.getField(runInstance.getClass(), first).getType();
                firstObject = JkUtilsReflect.newInstance(firstClass);
            }
            String last = JkUtilsString.substringAfterFirst(optName, ".");
            return BeanField.value(firstObject, last);
        }

        @Override
        public int compareTo(BeanField other) {
            if (this.bean.getClass().equals(other.bean.getClass())) {
                return this.name.compareTo(other.name);
            }
            if (this.bean.getClass().isAssignableFrom(other.bean.getClass())) {
                return -1;
            }
            return 1;
        }

        String shortDescription() {
            return this.name + " = " + this.defaultValue;
        }

        String description(String displayName, String margin) {
            String desc = this.description != null ? this.description : "No description available.";
            String oneLineDesc = desc.replace("\n", " ");
            String envPart = this.injectedPropertyName == null ? "" : ", property: " + this.injectedPropertyName;
            return String.format("%s  %s  : %s (type: %s, default: %s%s)\n", margin, displayName, oneLineDesc, this.type(), this.defaultValue, envPart);
        }

        private String type() {
            if (this.type.isEnum()) {
                return "Enum of " + BeanField.enumValues(this.type);
            }
            return this.type.getSimpleName();
        }

        private static String enumValues(Class<?> enumClass) {
            ?[] values = enumClass.getEnumConstants();
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < values.length; ++i) {
                result.append(values[i].toString());
                if (i + 1 >= values.length) continue;
                result.append(", ");
            }
            return result.toString();
        }

        String defaultValue() {
            return this.defaultValue == null ? "null" : this.defaultValue.toString();
        }

        Element toElement(Document document) {
            Element optionEl = document.createElement("option");
            Element nameEl = document.createElement("name");
            nameEl.setTextContent(this.name);
            Element descriptionEl = document.createElement("description");
            if (this.description != null) {
                descriptionEl.appendChild(document.createCDATASection(this.description));
            }
            Element typeEl = document.createElement("type");
            typeEl.setTextContent(this.type());
            Element defaultValueEl = document.createElement("defaultValue");
            defaultValueEl.appendChild(document.createCDATASection(this.defaultValue()));
            optionEl.appendChild(nameEl);
            optionEl.appendChild(descriptionEl);
            optionEl.appendChild(typeEl);
            optionEl.appendChild(defaultValueEl);
            return optionEl;
        }
    }

    static final class BeanMethod
    implements Comparable<BeanMethod> {
        private final String name;
        private final String description;
        private final Class<?> declaringClass;

        private BeanMethod(String name, String description, Class<?> declaringClass) {
            this.name = name;
            this.description = description;
            this.declaringClass = declaringClass;
        }

        static BeanMethod of(Method method) {
            JkDoc jkDoc = JkUtilsReflect.getInheritedAnnotation(method, JkDoc.class);
            String descr = jkDoc != null ? String.join((CharSequence)"\n", jkDoc.value()) : null;
            return new BeanMethod(method.getName(), descr, method.getDeclaringClass());
        }

        @Override
        public int compareTo(BeanMethod other) {
            if (this.declaringClass.equals(other.declaringClass)) {
                return this.name.compareTo(other.name);
            }
            if (this.declaringClass.isAssignableFrom(other.declaringClass)) {
                return -1;
            }
            return 1;
        }

        Element toXmlElement(Document document) {
            Element methodEl = document.createElement("method");
            Element nameEl = document.createElement("name");
            nameEl.setTextContent(this.name);
            Element descriptionEl = document.createElement("description");
            if (this.description != null) {
                descriptionEl.appendChild(document.createCDATASection(this.description));
            }
            Element classEl = document.createElement("declaringClass");
            classEl.setTextContent(this.declaringClass.getName());
            methodEl.appendChild(nameEl);
            methodEl.appendChild(descriptionEl);
            methodEl.appendChild(classEl);
            return methodEl;
        }
    }
}

