/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.tool;

import dev.jeka.core.api.utils.JkUtilsReflect;
import dev.jeka.core.api.utils.JkUtilsString;
import dev.jeka.core.tool.JkBean;
import dev.jeka.core.tool.JkDoc;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

class BeanDoc
implements Comparable<BeanDoc> {
    private final String shortName;
    private final String fullName;
    private final Class<? extends JkBean> clazz;

    private static String longName(Class<?> clazz) {
        return clazz.getName();
    }

    BeanDoc(Class<? extends JkBean> clazz) {
        this.shortName = JkBean.name(clazz);
        this.fullName = BeanDoc.longName(clazz);
        this.clazz = clazz;
    }

    public List<String> pluginDependencies() {
        return JkUtilsReflect.getAllDeclaredFields(this.clazz, false).stream().filter(field -> JkBean.class.isAssignableFrom(field.getType())).map(Field::getType).map(Class::getName).collect(Collectors.toList());
    }

    public String shortName() {
        return this.shortName;
    }

    public String fullName() {
        return this.fullName;
    }

    public Class<? extends JkBean> beanClass() {
        return this.clazz;
    }

    public List<String> description() {
        if (this.clazz.getAnnotation(JkDoc.class) == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(this.clazz.getAnnotation(JkDoc.class).value());
    }

    public String shortDescription() {
        List<String> description = this.description();
        if (description.isEmpty()) {
            return null;
        }
        String result = description.get(0);
        return result.contains("\n") ? JkUtilsString.substringBeforeFirst(result, "\n") : result;
    }

    public List<String> activationEffect() {
        JkDoc doc = JkUtilsReflect.getInheritedAnnotation(this.clazz, JkDoc.class, "activate", new Class[0]);
        return doc == null ? Collections.emptyList() : Arrays.asList(doc.value());
    }

    boolean isDecoratedBeanDefined() {
        Method decorateRun = JkUtilsReflect.findMethodMethodDeclaration(this.clazz, "activate", new Class[0]);
        return decorateRun != null && !decorateRun.getDeclaringClass().equals(JkBean.class);
    }

    public String toString() {
        return "name=" + this.shortName + "(" + this.fullName + ")";
    }

    @Override
    public int compareTo(BeanDoc o) {
        return this.shortName.compareTo(o.shortName);
    }
}

