/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.tool;

import dev.jeka.core.api.depmanagement.JkDependency;
import dev.jeka.core.api.depmanagement.JkFileSystemDependency;
import dev.jeka.core.api.depmanagement.JkModuleDependency;
import dev.jeka.core.api.system.JkInfo;
import dev.jeka.core.api.utils.JkUtilsAssert;
import dev.jeka.core.api.utils.JkUtilsString;
import dev.jeka.core.api.utils.JkUtilsSystem;
import dev.jeka.core.tool.EngineCommand;
import dev.jeka.core.tool.JkException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

final class CommandLine {
    private static final String KBEAN_SYMBOL = "#";
    private static final char KBEAN_SYMBOL_CHAR = "#".charAt(0);
    private static final String AT_SYMBOL_CHAR = "@";
    private Map<String, String> standardOptions = new HashMap<String, String>();
    private Map<String, String> systemProperties = new HashMap<String, String>();
    private List<JkBeanAction> beanActions = new LinkedList<JkBeanAction>();
    private List<JkDependency> defDependencies = new LinkedList<JkDependency>();
    private String[] rawArgs;

    private CommandLine() {
    }

    static CommandLine parse(String[] words) {
        CommandLine result = new CommandLine();
        for (String word : words) {
            KeyValue keyValue;
            if (word.startsWith("-D")) {
                keyValue = KeyValue.of(word.substring(2), false);
                result.systemProperties.put(keyValue.key, keyValue.value);
                continue;
            }
            if (word.startsWith("-")) {
                keyValue = KeyValue.of(word.substring(1), true);
                result.standardOptions.put(keyValue.key, keyValue.value);
                continue;
            }
            if (word.startsWith(AT_SYMBOL_CHAR)) {
                result.defDependencies.add(CommandLine.toDependency(word.substring(1)));
                continue;
            }
            result.beanActions.add(new JkBeanAction(word));
        }
        result.rawArgs = words;
        return result;
    }

    Map<String, String> getStandardOptions() {
        return this.standardOptions;
    }

    Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    List<JkBeanAction> getBeanActions() {
        return this.beanActions;
    }

    List<JkDependency> getDefDependencies() {
        return this.defDependencies;
    }

    String[] rawArgs() {
        return this.rawArgs;
    }

    boolean containsDefaultBean() {
        return this.beanActions.stream().anyMatch(beanAction -> beanAction.beanName == null);
    }

    boolean isHelp() {
        if (!this.beanActions.isEmpty()) {
            return false;
        }
        return this.standardOptions.isEmpty() || this.standardOptions.containsKey("help") || this.standardOptions.containsKey("h");
    }

    List<String> involvedBeanNames() {
        return this.beanActions.stream().filter(beanAction -> beanAction.beanName != null).map(beanAction -> beanAction.beanName).distinct().collect(Collectors.toList());
    }

    static JkDependency toDependency(String depDescription) {
        boolean specifiedVersion;
        boolean hasDoubleDotes = JkModuleDependency.isModuleDependencyDescription(depDescription);
        if (!hasDoubleDotes || JkUtilsSystem.IS_WINDOWS && depDescription.substring(1).startsWith(":\\") || depDescription.substring(1).startsWith(":/")) {
            Path candidatePath = Paths.get(depDescription, new String[0]);
            if (Files.exists(candidatePath, new LinkOption[0])) {
                return JkFileSystemDependency.of(candidatePath);
            }
            throw new JkException("Command line argument " + depDescription + " cannot be recognized as a file. Is " + candidatePath.toAbsolutePath() + " an existing file ?", new Object[0]);
        }
        JkModuleDependency moduleDependency = JkModuleDependency.of(depDescription);
        boolean bl = specifiedVersion = !moduleDependency.hasUnspecifiedVersion();
        if (specifiedVersion) {
            return moduleDependency;
        }
        if (moduleDependency.getModuleId().getGroup().equals("dev.jeka")) {
            moduleDependency = moduleDependency.withVersion(JkInfo.getJekaVersion());
            return moduleDependency;
        }
        throw new JkException("Command line argument " + depDescription + " does not mention a version. Use description as groupId:artefactId:version. Version can be '+' for taking the latest.", new Object[0]);
    }

    private static class KeyValue {
        String key;
        String value;

        private KeyValue() {
        }

        static KeyValue of(String arg, boolean nullableValue) {
            int equalIndex = arg.indexOf("=");
            KeyValue keyValue = new KeyValue();
            if (equalIndex <= -1) {
                if (!nullableValue) {
                    throw new JkException("Argument '" + arg + "' does not mention '=' as expected to assign a value.", new Object[0]);
                }
                keyValue.key = arg;
                return keyValue;
            }
            keyValue.key = arg.substring(0, equalIndex);
            keyValue.value = arg.substring(equalIndex + 1);
            return keyValue;
        }
    }

    static class JkBeanAction {
        final EngineCommand.Action action;
        final String beanName;
        final String member;
        final String value;

        JkBeanAction(String expression) {
            String beanExpression;
            if (expression.contains(CommandLine.KBEAN_SYMBOL)) {
                this.beanName = JkUtilsString.substringBeforeFirst(expression, CommandLine.KBEAN_SYMBOL);
                beanExpression = JkUtilsString.substringAfterFirst(expression, CommandLine.KBEAN_SYMBOL);
            } else {
                this.beanName = null;
                beanExpression = expression;
            }
            if (beanExpression.isEmpty()) {
                this.action = EngineCommand.Action.BEAN_REGISTRATION;
                this.member = null;
                this.value = null;
            } else if (beanExpression.contains("=")) {
                this.action = EngineCommand.Action.PROPERTY_INJECT;
                this.member = JkUtilsString.substringBeforeFirst(beanExpression, "=");
                JkUtilsAssert.argument(!this.member.isEmpty(), "Illegal expression " + expression, new Object[0]);
                this.value = JkUtilsString.substringAfterFirst(beanExpression, "=");
            } else {
                this.action = EngineCommand.Action.METHOD_INVOKE;
                this.member = beanExpression;
                this.value = null;
            }
        }

        public String toString() {
            return "action=" + (Object)((Object)this.action) + ", beanName='" + this.beanName + '\'' + ", member='" + this.member + '\'' + ", value='" + this.value + '\'';
        }
    }
}

