/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.tool;

import dev.jeka.core.api.depmanagement.JkDependencySet;
import dev.jeka.core.api.depmanagement.JkRepo;
import dev.jeka.core.api.depmanagement.JkRepoFromProperties;
import dev.jeka.core.api.depmanagement.resolution.JkDependencyResolver;
import dev.jeka.core.api.file.JkPathMatcher;
import dev.jeka.core.api.file.JkPathSequence;
import dev.jeka.core.api.file.JkPathTree;
import dev.jeka.core.api.file.JkPathTreeSet;
import dev.jeka.core.api.java.JkClassLoader;
import dev.jeka.core.api.java.JkClasspath;
import dev.jeka.core.api.java.JkJavaCompileSpec;
import dev.jeka.core.api.java.JkJavaCompiler;
import dev.jeka.core.api.kotlin.JkKotlinCompiler;
import dev.jeka.core.api.kotlin.JkKotlinJvmCompileSpec;
import dev.jeka.core.api.system.JkBusyIndicator;
import dev.jeka.core.api.system.JkLocator;
import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.system.JkMemoryBufferLogDecorator;
import dev.jeka.core.api.utils.JkUtilsPath;
import dev.jeka.core.tool.AppendableUrlClassloader;
import dev.jeka.core.tool.CommandLine;
import dev.jeka.core.tool.EngineBeanClassResolver;
import dev.jeka.core.tool.EngineCommand;
import dev.jeka.core.tool.EngineCompilationUpdateTracker;
import dev.jeka.core.tool.EngineSourceParser;
import dev.jeka.core.tool.Environment;
import dev.jeka.core.tool.HelpDisplayer;
import dev.jeka.core.tool.JkBean;
import dev.jeka.core.tool.JkException;
import dev.jeka.core.tool.JkRuntime;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.tools.ToolProvider;

final class Engine {
    private static final JkPathMatcher JAVA_DEF_SOURCE_MATCHER = JkPathMatcher.of(true, "**.java").and(false, "**/_*", "_*");
    private static final JkPathMatcher KOTLIN_DEF_SOURCE_MATCHER = JkPathMatcher.of(true, "**.kt").and(false, "**/_*", "_*");
    static final JkPathMatcher JAVA_OR_KOTLIN_SOURCE_MATCHER = JAVA_DEF_SOURCE_MATCHER.or(KOTLIN_DEF_SOURCE_MATCHER);
    private final Path projectBaseDir;
    private final JkDependencyResolver dependencyResolver;
    private final EngineBeanClassResolver beanClassesResolver;

    Engine(Path baseDir) {
        this.projectBaseDir = baseDir;
        this.beanClassesResolver = new EngineBeanClassResolver(baseDir);
        this.dependencyResolver = ((JkDependencyResolver)JkDependencyResolver.of().getDefaultParams().setFailOnDependencyResolutionError((boolean)true).__).addRepos(JkRepoFromProperties.getDownloadRepo(), JkRepo.ofLocal());
    }

    void execute(CommandLine commandLine) {
        JkLog.startTask("Compile def and initialise KBeans", new Object[0]);
        JkDependencySet commandLineDependencies = JkDependencySet.of(commandLine.getDefDependencies());
        JkLog.trace("Inject classpath from command line : " + commandLineDependencies, new Object[0]);
        CompilationResult result = this.resolveAndCompile(new HashMap<Path, JkPathSequence>(), true, !Environment.standardOptions.ignoreCompileFail);
        JkPathSequence computedClasspath = result.classpath.andPrepend(this.dependencyResolver.resolve(commandLineDependencies).getFiles());
        AppendableUrlClassloader.addEntriesOnContextClassLoader(computedClasspath);
        this.beanClassesResolver.setClasspath(computedClasspath);
        if (commandLine.isHelp()) {
            JkLog.endTask();
            Engine.stopBusyIndicator();
            this.help();
            return;
        }
        JkLog.startTask("Setting up runtime", new Object[0]);
        JkRuntime runtime = JkRuntime.get(this.projectBaseDir);
        runtime.setClasspath(computedClasspath);
        List<EngineCommand> resolvedCommands = this.beanClassesResolver.resolve(commandLine, Environment.standardOptions.jkCBeanName());
        JkLog.startTask("Init runtime", new Object[0]);
        runtime.init(resolvedCommands);
        JkLog.endTask();
        JkLog.endTask();
        JkLog.endTask();
        JkLog.info("KBeans are ready to run.", new Object[0]);
        Engine.stopBusyIndicator();
        if (!result.compileFailedProjects.getEntries().isEmpty()) {
            JkLog.warn("Def compilation failed on projects " + result.compileFailedProjects.getEntries().stream().map(path -> "'" + path + "'").collect(Collectors.toList()), new Object[0]);
            JkLog.warn("As -dci option is on, the failure will be ignored.", new Object[0]);
        }
        if (Environment.standardOptions.logRuntimeInformation != null) {
            JkLog.info("Jeka Classpath : ", new Object[0]);
            computedClasspath.iterator().forEachRemaining(item -> JkLog.info("    " + item, new Object[0]));
            if (JkLog.isVerbose()) {
                System.out.println("Classloader : " + JkClassLoader.ofCurrent());
            }
        }
        runtime.run(resolvedCommands);
    }

    private CompilationContext preCompile() {
        List<Path> sourceFiles = JkPathTree.of(this.beanClassesResolver.defSourceDir).andMatcher(JAVA_OR_KOTLIN_SOURCE_MATCHER).getFiles();
        JkLog.trace("Parse source code of " + sourceFiles, new Object[0]);
        EngineSourceParser parser = EngineSourceParser.of(this.projectBaseDir, sourceFiles);
        JkDependencySet parsedDependencies = parser.dependencies();
        return new CompilationContext(this.jekaClasspath().and(this.dependencyResolver.resolve(parser.dependencies()).getFiles()), new LinkedList<Path>(parser.projects()), parser.compileOptions());
    }

    private CompilationResult resolveAndCompile(Map<Path, JkPathSequence> yetCompiledProjects, boolean compileSources, boolean failOnCompileError) {
        CompilationResult compilationResult;
        if (yetCompiledProjects.containsKey(this.projectBaseDir)) {
            JkLog.trace("Project '%s' already compiled. Skip", this.projectBaseDir);
            return new CompilationResult(JkPathSequence.of(), JkPathSequence.of(), yetCompiledProjects.get(this.projectBaseDir));
        }
        yetCompiledProjects.put(this.projectBaseDir, JkPathSequence.of());
        String msg = "Scanning sources and compiling def classes for project '" + this.projectBaseDir.getFileName() + "'";
        JkLog.startTask(msg, new Object[0]);
        CompilationContext compilationContext = this.preCompile();
        LinkedList<Path> importedProjectClasspath = new LinkedList<Path>();
        LinkedList<Path> failedProjects = new LinkedList<Path>();
        for (Path importedProjectDir : compilationContext.importedProjectDirs) {
            Engine importedProjectEngine = new Engine(importedProjectDir);
            compilationResult = importedProjectEngine.resolveAndCompile(yetCompiledProjects, compileSources, failOnCompileError);
            importedProjectClasspath.addAll(compilationResult.classpath.getEntries());
            failedProjects.addAll(compilationResult.compileFailedProjects.getEntries());
        }
        JkPathSequence classpath = compilationContext.classpath.and(importedProjectClasspath).withoutDuplicates();
        EngineCompilationUpdateTracker compilationTracker = new EngineCompilationUpdateTracker(this.projectBaseDir);
        if (compileSources && this.beanClassesResolver.hasDefSource()) {
            if (Environment.standardOptions.forceCompile() || compilationTracker.isOutdated()) {
                JkLog.trace("Compile classpath : " + classpath, new Object[0]);
                SingleCompileResult result = this.compileDef(classpath, compilationContext.compileOptions, failOnCompileError);
                if (!result.success) {
                    failedProjects.add(this.projectBaseDir);
                    compilationTracker.deleteCompileFlag();
                } else {
                    classpath = classpath.and(result.extraClasspath);
                    compilationTracker.updateCompileFlag();
                }
            } else {
                JkLog.trace("Last def classes are up-to-date : No need to compile.", new Object[0]);
            }
        }
        JkLog.endTask();
        JkPathSequence resultClasspath = classpath.andPrepend(this.beanClassesResolver.defClassDir);
        yetCompiledProjects.put(this.projectBaseDir, resultClasspath);
        compilationResult = new CompilationResult(JkPathSequence.of(compilationContext.importedProjectDirs), JkPathSequence.of(failedProjects).withoutDuplicates(), resultClasspath);
        JkRuntime runtime = JkRuntime.get(this.projectBaseDir);
        runtime.setDependencyResolver(this.dependencyResolver);
        runtime.setImportedProjects(compilationResult.importedProjects);
        runtime.setClasspath(compilationResult.classpath);
        return compilationResult;
    }

    private SingleCompileResult compileDef(JkPathSequence defClasspath, List<String> compileOptions, boolean failOnCompileError) {
        JkJavaCompileSpec javaCompileSpec;
        JkPathTree.of(this.beanClassesResolver.defClassDir).deleteContent();
        JkPathSequence extraClasspath = JkPathSequence.of();
        if (this.hasKotlin()) {
            JkKotlinCompiler kotlinCompiler = JkKotlinCompiler.ofJvm(this.dependencyResolver.getRepos()).setLogOutput(true).setFailOnError(failOnCompileError).addOption("-nowarn");
            compileOptions.forEach(option -> kotlinCompiler.addOption((String)option));
            JkPathSequence kotlinClasspath = defClasspath.and(kotlinCompiler.getStdJdk8Lib());
            JkKotlinJvmCompileSpec kotlinCompileSpec = this.defKotlinCompileSpec(kotlinClasspath);
            if (JkLog.isVerbose()) {
                kotlinCompiler.addOption("-verbose");
            }
            boolean success = this.wrapCompile(() -> kotlinCompiler.compile(kotlinCompileSpec), failOnCompileError);
            if (!failOnCompileError && !success) {
                return new SingleCompileResult(false, JkPathSequence.of());
            }
            if (kotlinCompiler.isProvidedCompiler()) {
                extraClasspath = extraClasspath.and(kotlinCompiler.getStdLib());
                AppendableUrlClassloader.addEntriesOnContextClassLoader(kotlinCompiler.getStdLib());
            }
        }
        if ((javaCompileSpec = this.defJavaCompileSpec(defClasspath, compileOptions)).getSources().containFiles() && ToolProvider.getSystemJavaCompiler() == null) {
            throw new JkException("The running Java platform (" + System.getProperty("java.home") + ") does not provide compiler (javac). Please provide a JDK java platform by pointing JAVA_HOME or JEKA_JDK environment variable to a JDK directory.", new Object[0]);
        }
        boolean success = this.wrapCompile(() -> JkJavaCompiler.of().compile(javaCompileSpec), failOnCompileError);
        if (!success) {
            return new SingleCompileResult(false, JkPathSequence.of());
        }
        JkPathTree.of(this.beanClassesResolver.defSourceDir).andMatching(false, "**/*.java", "*.java", "**/*.kt", "*.kt").copyTo(this.beanClassesResolver.defClassDir, StandardCopyOption.REPLACE_EXISTING);
        return new SingleCompileResult(true, extraClasspath);
    }

    private JkPathSequence jekaClasspath() {
        boolean devMode = Files.isDirectory(JkLocator.getJekaJarPath(), new LinkOption[0]);
        JkPathSequence result = JkPathSequence.of(this.bootLibs());
        result = devMode ? result.and(JkClasspath.ofCurrentRuntime()) : result.and(JkLocator.getJekaJarPath());
        JkLog.trace("Use Jeka " + result + " for compilation.", new Object[0]);
        return result.withoutDuplicates();
    }

    private JkPathSequence bootLibs() {
        LinkedList<Path> extraLibs = new LinkedList<Path>();
        Path bootDir = this.projectBaseDir.resolve("jeka/boot");
        if (Files.exists(bootDir, new LinkOption[0])) {
            extraLibs.addAll(JkPathTree.of(bootDir).andMatching(true, "**.jar").getFiles());
        }
        return JkPathSequence.of(extraLibs);
    }

    private boolean wrapCompile(Supplier<Boolean> compileTask, boolean failOnError) {
        boolean success = compileTask.get();
        if (!success && failOnError) {
            throw new JkException("Compilation of Jeka files failed. Run jeka with '-dci' option to ignore compilation failure.", new Object[0]);
        }
        return success;
    }

    private boolean hasKotlin() {
        return JkPathTree.of(this.beanClassesResolver.defSourceDir).andMatcher(KOTLIN_DEF_SOURCE_MATCHER).count(1, false) > 0;
    }

    private JkJavaCompileSpec defJavaCompileSpec(JkPathSequence classpath, List<String> options) {
        JkPathTree defSource = JkPathTree.of(this.beanClassesResolver.defSourceDir).andMatcher(JAVA_DEF_SOURCE_MATCHER);
        JkUtilsPath.createDirectories(this.beanClassesResolver.defClassDir, new FileAttribute[0]);
        return JkJavaCompileSpec.of().setClasspath(classpath.and(this.beanClassesResolver.defClassDir)).setOutputDir(this.beanClassesResolver.defClassDir).setSources(defSource.toSet()).addOptions(options);
    }

    private JkKotlinJvmCompileSpec defKotlinCompileSpec(JkPathSequence defClasspath) {
        JkUtilsPath.createDirectories(this.beanClassesResolver.defClassDir, new FileAttribute[0]);
        return JkKotlinJvmCompileSpec.of().setClasspath(defClasspath).setSources(JkPathTreeSet.ofRoots(this.beanClassesResolver.defSourceDir)).setOutputDir(JkUtilsPath.relativizeFromWorkingDir(this.beanClassesResolver.defClassDir));
    }

    public String toString() {
        return this.projectBaseDir.getFileName().toString();
    }

    private static void stopBusyIndicator() {
        if (JkMemoryBufferLogDecorator.isActive()) {
            JkBusyIndicator.stop();
            JkMemoryBufferLogDecorator.inactivateOnJkLog();
        }
    }

    private void help() {
        List<Class<? extends JkBean>> localBeanClasses = this.beanClassesResolver.defBeanClasses();
        List<Class> globalBeanClasses = this.beanClassesResolver.globalBeanClassNames().stream().map(className -> JkClassLoader.ofCurrent().load((String)className)).filter(beanClass -> !localBeanClasses.contains(beanClass)).collect(Collectors.toList());
        HelpDisplayer.help(localBeanClasses, globalBeanClasses, false);
    }

    private static class SingleCompileResult {
        boolean success;
        JkPathSequence extraClasspath;

        SingleCompileResult(boolean success, JkPathSequence extraClasspath) {
            this.success = success;
            this.extraClasspath = extraClasspath;
        }
    }

    private static class CompilationResult {
        JkPathSequence compileFailedProjects;
        JkPathSequence classpath;
        JkPathSequence importedProjects;

        CompilationResult(JkPathSequence importedProjects, JkPathSequence compileFailedProjects, JkPathSequence resultClasspath) {
            this.importedProjects = importedProjects;
            this.compileFailedProjects = compileFailedProjects;
            this.classpath = resultClasspath;
        }
    }

    private static class CompilationContext {
        private final JkPathSequence classpath;
        private final List<Path> importedProjectDirs;
        private final List<String> compileOptions;

        CompilationContext(JkPathSequence classpath, List<Path> importedProjectDirs, List<String> compileOptions) {
            this.classpath = classpath;
            this.importedProjectDirs = Collections.unmodifiableList(importedProjectDirs);
            this.compileOptions = Collections.unmodifiableList(compileOptions);
        }
    }
}

