/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.tool;

import dev.jeka.core.api.file.JkPathFile;
import dev.jeka.core.api.file.JkPathTree;
import dev.jeka.core.api.java.JkJavaVersion;
import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.utils.JkUtilsPath;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;

class EngineCompilationUpdateTracker {
    private static final String LAST_UPDATE_FILE_NAME = "def-last-update-time.txt";
    private final Path projectBaseDir;
    private static boolean globallyOutdated;

    EngineCompilationUpdateTracker(Path projectBaseDir) {
        this.projectBaseDir = projectBaseDir;
    }

    boolean isOutdated() {
        boolean result;
        if (globallyOutdated) {
            return true;
        }
        long defLastUptateTime = this.lastModifiedAccordingFileAttributes();
        globallyOutdated = result = this.isWorkOutdated(defLastUptateTime);
        return result;
    }

    void updateCompileFlag() {
        long defLastUptateTime = this.lastModifiedAccordingFileAttributes();
        this.writeLastUpdateFile(defLastUptateTime, JkJavaVersion.ofCurrent());
    }

    void deleteCompileFlag() {
        this.flagFile().deleteIfExist();
    }

    private boolean isWorkOutdated(long lastModifiedAccordingFileAttributes) {
        TimestampAndJavaVersion timestampAndJavaVersion = this.lastModifiedAccordingFlag();
        return timestampAndJavaVersion.timestamp < lastModifiedAccordingFileAttributes || !JkJavaVersion.ofCurrent().equals(timestampAndJavaVersion.javaVersion);
    }

    private long lastModifiedAccordingFileAttributes() {
        Path def = this.projectBaseDir.resolve("jeka/def");
        return JkPathTree.of(def).stream(new FileVisitOption[0]).map(path -> JkUtilsPath.getLastModifiedTime(path, new LinkOption[0])).map(optional -> optional.orElse(System.currentTimeMillis())).reduce(0L, Math::max);
    }

    private void writeLastUpdateFile(long lastModifiedAccordingFileAttributes, JkJavaVersion javaVersion) {
        Path work = this.projectBaseDir.resolve("jeka/.work");
        if (!Files.exists(work, new LinkOption[0])) {
            return;
        }
        String infoString = Long.toString(lastModifiedAccordingFileAttributes) + ";" + javaVersion;
        this.flagFile().deleteIfExist().createIfNotExist().write(infoString.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    private JkPathFile flagFile() {
        return JkPathFile.of(this.projectBaseDir.resolve("jeka/.work").resolve(LAST_UPDATE_FILE_NAME));
    }

    private TimestampAndJavaVersion lastModifiedAccordingFlag() {
        Path work = this.projectBaseDir.resolve("jeka/.work");
        if (!Files.exists(work, new LinkOption[0])) {
            return new TimestampAndJavaVersion(0L, JkJavaVersion.ofCurrent());
        }
        Path lastUpdateFile = work.resolve(LAST_UPDATE_FILE_NAME);
        if (!Files.exists(lastUpdateFile, new LinkOption[0])) {
            return new TimestampAndJavaVersion(0L, JkJavaVersion.ofCurrent());
        }
        try {
            String content = JkUtilsPath.readAllLines(lastUpdateFile).get(0);
            String[] items = content.split(";");
            return new TimestampAndJavaVersion(Long.parseLong(items[0]), JkJavaVersion.of(items[1]));
        }
        catch (RuntimeException e) {
            JkLog.warn("Error caught when reading file content of " + lastUpdateFile + ". " + e.getMessage(), new Object[0]);
            return new TimestampAndJavaVersion(0L, JkJavaVersion.ofCurrent());
        }
    }

    private static class TimestampAndJavaVersion {
        final long timestamp;
        final JkJavaVersion javaVersion;

        public TimestampAndJavaVersion(long timestamp, JkJavaVersion javaVersion) {
            this.timestamp = timestamp;
            this.javaVersion = javaVersion;
        }
    }
}

