/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.tool;

import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.utils.JkUtilsReflect;
import dev.jeka.core.tool.JkBean;
import dev.jeka.core.tool.JkInjectProject;
import dev.jeka.core.tool.JkRuntime;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public final class JkImportedJkBeans {
    private final JkBean holder;
    private List<JkBean> directs;
    private List<JkBean> transitives;
    private List<Path> importedBeanRoots = Collections.emptyList();

    JkImportedJkBeans(JkBean holder) {
        this.holder = holder;
        this.directs = JkImportedJkBeans.computeDirects(holder);
    }

    JkImportedJkBeans() {
        this.holder = null;
        this.directs = Collections.emptyList();
    }

    public List<JkBean> get(boolean includeTransitives) {
        return includeTransitives ? Optional.ofNullable(this.transitives).orElseGet(() -> {
            this.transitives = this.computeTransitives(new HashSet<Path>());
            return this.transitives;
        }) : Optional.ofNullable(this.directs).orElseGet(() -> {
            this.directs = JkImportedJkBeans.computeDirects(this.holder);
            return this.directs;
        });
    }

    public <T extends JkBean> List<T> get(Class<T> jkBeanClass, boolean includeTransitives) {
        return this.get(includeTransitives).stream().map(JkBean::getRuntime).map(runtime -> runtime.getBeanOptional(jkBeanClass)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    void setImportedBeanRoots(Set<Path> roots) {
        this.importedBeanRoots = new LinkedList<Path>(roots);
    }

    private List<JkBean> computeTransitives(Set<Path> files) {
        LinkedList<JkBean> result = new LinkedList<JkBean>();
        for (JkBean jkBean : this.directs) {
            Path dir = jkBean.getBaseDir();
            if (files.contains(dir)) continue;
            result.addAll(jkBean.getImportedJkBeans().computeTransitives(files));
            result.add(jkBean);
            files.add(dir);
        }
        return result;
    }

    private static List<JkBean> computeDirects(JkBean masterBean) {
        LinkedList<JkBean> result = new LinkedList<JkBean>();
        List<Field> fields = JkUtilsReflect.getAllDeclaredFields(masterBean.getClass(), JkInjectProject.class);
        if (!fields.isEmpty()) {
            JkLog.trace("Projects imported by " + masterBean + " : " + fields, new Object[0]);
        }
        for (Field field : fields) {
            JkInjectProject jkProject = field.getAnnotation(JkInjectProject.class);
            Object importedJkClass = JkImportedJkBeans.createImportedJkBean(field.getType(), jkProject.value(), masterBean.getBaseDir());
            try {
                JkUtilsReflect.setFieldValue(masterBean, field, importedJkClass);
            }
            catch (RuntimeException e) {
                Path currentClassBaseDir;
                for (currentClassBaseDir = Paths.get(masterBean.getClass().getProtectionDomain().getCodeSource().getLocation().getPath(), new String[0]); !Files.exists(currentClassBaseDir.resolve("jeka/def"), new LinkOption[0]) && currentClassBaseDir != null; currentClassBaseDir = currentClassBaseDir.getParent()) {
                }
                if (currentClassBaseDir == null) {
                    throw new IllegalStateException("Can't inject imported run instance of type " + importedJkClass.getClass().getSimpleName() + " into field " + field.getDeclaringClass().getName() + "#" + field.getName() + " from directory " + masterBean.getBaseDir() + " while working dir is " + Paths.get("", new String[0]).toAbsolutePath());
                }
                throw new IllegalStateException("Can't inject imported run instance of type " + importedJkClass.getClass().getSimpleName() + " into field " + field.getDeclaringClass().getName() + "#" + field.getName() + " from directory " + masterBean.getBaseDir() + "\nJeka class is located in " + currentClassBaseDir + " while working dir is " + Paths.get("", new String[0]).toAbsolutePath() + ".\nPlease set working dir to " + currentClassBaseDir, e);
            }
            result.add((JkBean)importedJkClass);
        }
        return result;
    }

    private static <T extends JkBean> T createImportedJkBean(Class<T> importedBeanClass, String relativePath, Path holderBaseDir) {
        Path importedProjectDir = holderBaseDir.resolve(relativePath).normalize();
        JkLog.startTask("Import bean " + importedBeanClass + " from " + importedProjectDir, new Object[0]);
        JkRuntime runtime = JkRuntime.get(importedProjectDir);
        JkRuntime.setBaseDirContext(importedProjectDir);
        T result = JkRuntime.get(importedProjectDir).getBean(importedBeanClass);
        JkRuntime.setBaseDirContext(Paths.get("", new String[0]));
        JkLog.endTask();
        return result;
    }
}

