/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.tool;

import dev.jeka.core.api.depmanagement.JkRepo;
import dev.jeka.core.api.depmanagement.JkRepoFromProperties;
import dev.jeka.core.api.depmanagement.resolution.JkDependencyResolver;
import dev.jeka.core.api.file.JkPathSequence;
import dev.jeka.core.api.java.JkClassLoader;
import dev.jeka.core.api.java.JkClasspath;
import dev.jeka.core.api.system.JkInfo;
import dev.jeka.core.api.system.JkLocator;
import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.system.JkMemoryBufferLogDecorator;
import dev.jeka.core.api.utils.JkUtilsIterable;
import dev.jeka.core.api.utils.JkUtilsPath;
import dev.jeka.core.api.utils.JkUtilsReflect;
import dev.jeka.core.tool.EngineBeanClassResolver;
import dev.jeka.core.tool.EngineCommand;
import dev.jeka.core.tool.Environment;
import dev.jeka.core.tool.JkBean;
import dev.jeka.core.tool.JkInjectProject;
import dev.jeka.core.tool.JkProperties;
import dev.jeka.core.tool.JkRuntime;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public final class JkInit {
    public static <T extends JkBean> T instanceOf(Class<T> clazz, String ... args) {
        Environment.initialize(args);
        JkProperties.isDefined("");
        if (!Files.isDirectory(Paths.get("jeka", new String[0]), new LinkOption[0])) {
            throw new IllegalStateException("The current directory " + Paths.get("", new String[0]).toAbsolutePath() + " does not seem to be a Jeka project as it does not contain a 'jeka' folder.");
        }
        JkLog.setDecorator(Environment.standardOptions.logStyle);
        if (Environment.standardOptions.logRuntimeInformation != null) {
            JkInit.displayRuntimeInfo();
            JkLog.info("Jeka Classpath : ", new Object[0]);
            JkClassLoader.ofCurrent().getClasspath().getEntries().forEach(item -> JkLog.info("    " + item, new Object[0]));
        }
        boolean memoryBufferLogActivated = false;
        if (!Environment.standardOptions.logSetup && !JkMemoryBufferLogDecorator.isActive()) {
            JkMemoryBufferLogDecorator.activateOnJkLog();
            JkLog.info("", new Object[0]);
            memoryBufferLogActivated = true;
        }
        try {
            EngineBeanClassResolver engineBeanClassResolver = new EngineBeanClassResolver(Paths.get("", new String[0]));
            LinkedList<EngineCommand> commands = new LinkedList<EngineCommand>();
            commands.add(new EngineCommand(EngineCommand.Action.BEAN_REGISTRATION, clazz, null, null));
            commands.addAll(engineBeanClassResolver.resolve(Environment.commandLine, JkBean.name(clazz)));
            JkRuntime jkRuntime = JkRuntime.get(Paths.get("", new String[0]));
            jkRuntime.setImportedProjects(JkInit.getImportedProjects(clazz));
            jkRuntime.setDependencyResolver(((JkDependencyResolver)JkDependencyResolver.of().getDefaultParams().setFailOnDependencyResolutionError((boolean)true).__).addRepos(JkRepoFromProperties.getDownloadRepo(), JkRepo.ofLocal()));
            jkRuntime.setClasspath(JkPathSequence.of(JkClasspath.ofCurrentRuntime()));
            jkRuntime.init(commands);
            T jkBean = jkRuntime.getBean(clazz);
            JkLog.info(((JkBean)jkBean).toString() + " is ready to run.", new Object[0]);
            if (memoryBufferLogActivated) {
                JkMemoryBufferLogDecorator.inactivateOnJkLog();
            }
            return jkBean;
        }
        catch (RuntimeException e) {
            if (memoryBufferLogActivated) {
                JkMemoryBufferLogDecorator.flush();
                JkMemoryBufferLogDecorator.inactivateOnJkLog();
            }
            throw e;
        }
    }

    public static <T extends JkBean> T instanceOf(Class<T> clazz, String[] args, String extraArg, String ... extraArgs) {
        String[] allExtraArgs = JkUtilsIterable.concat(new String[]{extraArg}, extraArgs);
        String[] effectiveArgs = JkUtilsIterable.concat(allExtraArgs, args);
        return JkInit.instanceOf(clazz, effectiveArgs);
    }

    static void displayRuntimeInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nWorking Directory : " + System.getProperty("user.dir"));
        sb.append("\nCommand Line : " + String.join((CharSequence)" ", Arrays.asList(Environment.commandLine.rawArgs())));
        sb.append(JkInit.propsAsString("Specified properties", JkProperties.toDisplayedMap(JkProperties.getAllStartingWith("jeka."))));
        sb.append("\nJava Home : " + System.getProperty("java.home"));
        sb.append("\nJava Version : " + System.getProperty("java.version") + ", " + System.getProperty("java.vendor"));
        sb.append("\nJeka Version : " + JkInfo.getJekaVersion());
        if (JkInit.embedded(JkLocator.getJekaHomeDir().normalize())) {
            sb.append("\nJeka Home : " + JkInit.bootDir().normalize() + " ( embedded !!! )");
        } else {
            sb.append("\nJeka Home : " + JkLocator.getJekaHomeDir());
        }
        sb.append("\nJeka User Home : " + JkLocator.getJekaUserHomeDir().toAbsolutePath().normalize());
        sb.append("\nJeka Cache Dir : " + JkLocator.getCacheDir().toAbsolutePath().normalize());
        sb.append("\nJeka download Repositories : " + JkRepoFromProperties.getDownloadRepo());
        JkLog.info(sb.toString(), new Object[0]);
    }

    private static String propsAsString(String message, Map<String, String> props) {
        StringBuilder sb = new StringBuilder();
        if (props.isEmpty()) {
            sb.append("\n" + message + " : none.");
        } else if (props.size() <= 3) {
            sb.append("\n" + message + " : " + JkUtilsIterable.toString(props));
        } else {
            sb.append("\n" + message + " : ");
            JkUtilsIterable.toStrings(props).forEach(line -> sb.append("  " + line));
        }
        return sb.toString();
    }

    private static boolean embedded(Path jarFolder) {
        if (!Files.exists(JkInit.bootDir(), new LinkOption[0])) {
            return false;
        }
        return JkUtilsPath.isSameFile(JkInit.bootDir(), jarFolder);
    }

    private static Path bootDir() {
        return Paths.get("jeka/boot", new String[0]);
    }

    private static JkPathSequence getImportedProjects(Class<?> clazz) {
        List<Path> paths = JkUtilsReflect.getAllDeclaredFields(clazz, true).stream().map(field -> field.getAnnotation(JkInjectProject.class)).filter(Objects::nonNull).map(jkInjectProject -> jkInjectProject.value()).map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList());
        return JkPathSequence.of(paths).withoutDuplicates();
    }
}

