/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.tool;

import dev.jeka.core.api.depmanagement.JkModuleId;
import dev.jeka.core.api.depmanagement.JkVersion;
import dev.jeka.core.api.depmanagement.resolution.JkDependencyResolver;
import dev.jeka.core.api.java.JkManifest;
import dev.jeka.core.api.system.JkInfo;
import dev.jeka.core.api.system.JkLocator;
import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.utils.JkUtilsIO;
import dev.jeka.core.api.utils.JkUtilsPath;
import dev.jeka.core.tool.JkBean;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class JkJekaVersionCompatibilityChecker {
    public static final String MANIFEST_BREAKING_CHANGE_URL_ENTRY = "Jeka-Breaking-Change-Url";
    public static final String MANIFEST_LOWEST_JEKA_COMPATIBLE_VERSION_ENTRY = "Jeka-Lowest-Compatible-Version";

    private JkJekaVersionCompatibilityChecker() {
    }

    static void checkCompatibility(Class pluginClass, JkDependencyResolver resolver) {
        JkManifest<Void> manifest = JkManifest.of().loadFromClass(pluginClass);
        String breakingChangeUrl = manifest.getMainAttribute(MANIFEST_BREAKING_CHANGE_URL_ENTRY);
        String lowestJekaCompatibleVersion = manifest.getMainAttribute(MANIFEST_LOWEST_JEKA_COMPATIBLE_VERSION_ENTRY);
        JkVersion jekaVersion = JkVersion.of(JkInfo.getJekaVersion());
        if (lowestJekaCompatibleVersion != null && !jekaVersion.isUnspecified()) {
            JkVersion minVersion = JkVersion.of(lowestJekaCompatibleVersion);
            if (jekaVersion.isSnapshot()) {
                JkLog.warn("You are not running a release Jeka version. Plugin " + pluginClass + " which is compatible with Jeka version " + minVersion + " or greater may not work properly.", new Object[0]);
            } else if (jekaVersion.compareTo(minVersion) < 0) {
                JkLog.warn("You are running Jeka version " + jekaVersion + " but " + pluginClass + " plugin is supposed to work with " + minVersion + " or higher. It may not work properly.", new Object[0]);
                JkJekaVersionCompatibilityChecker.printUpperJekaVersion(resolver, minVersion);
            }
        }
        if (breakingChangeUrl == null) {
            return;
        }
        JkVersion pluginVersion = JkVersion.of(JkManifest.of().loadFromClass(pluginClass).getMainAttribute("Implementation-Version"));
        if (pluginVersion.isSnapshot() || jekaVersion.isSnapshot()) {
            return;
        }
        CompatibilityCache cache = new CompatibilityCache(pluginClass);
        PluginAndJekaVersion effectiveVersions = new PluginAndJekaVersion(pluginVersion, jekaVersion);
        PluginAndJekaVersion cachedBreakingVersion = cache.findBreakingVersion(effectiveVersions);
        if (cachedBreakingVersion == null) {
            CompatibilityBreak compatibilityBreak;
            try {
                compatibilityBreak = CompatibilityBreak.of(breakingChangeUrl);
            }
            catch (UncheckedIOException e) {
                JkLog.warn("Unable to access " + breakingChangeUrl + ". No version compatibility won't be checked.", new Object[0]);
                return;
            }
            PluginAndJekaVersion remoteBreakingVersion = compatibilityBreak.getBreakingJekaVersion(effectiveVersions);
            if (remoteBreakingVersion != null) {
                JkJekaVersionCompatibilityChecker.logJekaBreakingVersion(effectiveVersions, remoteBreakingVersion, pluginClass);
            }
            cache.addEntry(effectiveVersions, remoteBreakingVersion);
        } else if (cachedBreakingVersion != PluginAndJekaVersion.EMPTY) {
            JkJekaVersionCompatibilityChecker.logJekaBreakingVersion(effectiveVersions, cachedBreakingVersion, pluginClass);
        }
    }

    private static void logJekaBreakingVersion(PluginAndJekaVersion effectiveVersions, PluginAndJekaVersion breakingVersion, Class pluginClass) {
        JkLog.error("You are running Jeka version " + effectiveVersions.jekaVersion + " but plugin " + pluginClass.getName() + " version " + effectiveVersions.pluginVersion + " does not work with jeka version " + breakingVersion.jekaVersion + " or higher.", new String[0]);
        JkLog.error("Please use a Jeka version lower than " + breakingVersion.jekaVersion + " or a plugin version higher than " + breakingVersion.pluginVersion, new String[0]);
    }

    public static void setCompatibilityRange(JkManifest manifest, String lowestVersion, String breakingChangeUrl) {
        manifest.addMainAttribute(MANIFEST_LOWEST_JEKA_COMPATIBLE_VERSION_ENTRY, lowestVersion).addMainAttribute(MANIFEST_BREAKING_CHANGE_URL_ENTRY, breakingChangeUrl);
    }

    private static void printUpperJekaVersion(JkDependencyResolver dependencyResolver, JkVersion minVersion) {
        JkLog.warn("Jeka version upper or equals to " + minVersion + " are ; ", new Object[0]);
        List<String> versions = dependencyResolver.searchVersions(JkModuleId.of("dev.jeka:jeka-core"));
        versions.stream().map(version -> JkVersion.of(version)).filter(version -> version.compareTo(minVersion) >= 0).map(Objects::toString).forEach(x$0 -> JkLog.warn(x$0, new Object[0]));
    }

    static class PluginAndJekaVersion {
        static final PluginAndJekaVersion EMPTY = new PluginAndJekaVersion((JkVersion)null, null);
        final JkVersion pluginVersion;
        final JkVersion jekaVersion;

        PluginAndJekaVersion(JkVersion pluginVersion, JkVersion jekaVersion) {
            this.pluginVersion = pluginVersion;
            this.jekaVersion = jekaVersion;
        }

        PluginAndJekaVersion(String pluginVersion, String jekaVersion) {
            this(JkVersion.of(pluginVersion), JkVersion.of(jekaVersion));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PluginAndJekaVersion that = (PluginAndJekaVersion)o;
            if (this.pluginVersion != null ? !this.pluginVersion.equals(that.pluginVersion) : that.pluginVersion != null) {
                return false;
            }
            return this.jekaVersion != null ? this.jekaVersion.equals(that.jekaVersion) : that.jekaVersion == null;
        }

        public int hashCode() {
            int result = this.pluginVersion != null ? this.pluginVersion.hashCode() : 0;
            result = 31 * result + (this.jekaVersion != null ? this.jekaVersion.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "PluginAndJekaVersion{pluginVersion=" + this.pluginVersion + ", jekaVersion=" + this.jekaVersion + '}';
        }
    }

    static class CompatibilityBreak {
        private final Map<JkVersion, JkVersion> versionMap;

        private CompatibilityBreak(Map<JkVersion, JkVersion> versionMap) {
            this.versionMap = versionMap;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        static CompatibilityBreak of(String url) {
            try (InputStream is = JkUtilsIO.inputStream(new URL(url));){
                CompatibilityBreak compatibilityBreak = CompatibilityBreak.of(is);
                return compatibilityBreak;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        static CompatibilityBreak of(InputStream inputStream) {
            List<String> lines = JkUtilsIO.readAsLines(inputStream);
            LinkedHashMap<JkVersion, JkVersion> versionMap = new LinkedHashMap<JkVersion, JkVersion>();
            for (String line : lines) {
                String[] items = line.split(":");
                if (items.length != 2) continue;
                JkVersion pluginVersion = JkVersion.of(items[0].trim());
                JkVersion jekaVersion = JkVersion.of(items[1].trim());
                versionMap.put(pluginVersion, jekaVersion);
            }
            return new CompatibilityBreak(versionMap);
        }

        PluginAndJekaVersion getBreakingJekaVersion(PluginAndJekaVersion effectiveVersions) {
            Map.Entry<JkVersion, JkVersion> result = null;
            for (Map.Entry<JkVersion, JkVersion> entry : this.versionMap.entrySet()) {
                if (effectiveVersions.pluginVersion.compareTo(entry.getKey()) > 0 || effectiveVersions.jekaVersion.compareTo(entry.getValue()) < 0 || result != null && entry.getValue().compareTo(result.getValue()) >= 0) continue;
                result = entry;
            }
            return result == null ? null : new PluginAndJekaVersion((JkVersion)result.getKey(), (JkVersion)result.getValue());
        }
    }

    private static class CompatibilityCache {
        private final Path cachePath;

        CompatibilityCache(Class<JkBean> pluginClass) {
            this.cachePath = JkLocator.getJekaHomeDir().resolve("plugins-compatibility").resolve(pluginClass.getName() + "-compatibility.txt");
        }

        boolean exist() {
            return Files.exists(this.cachePath, new LinkOption[0]);
        }

        PluginAndJekaVersion findBreakingVersion(PluginAndJekaVersion effectiveVersions) {
            if (!this.exist()) {
                return null;
            }
            List<String> lines = JkUtilsPath.readAllLines(this.cachePath);
            for (String line : lines) {
                PluginAndJekaVersion cachedBreakingVersion;
                String[] items = line.split(":");
                if (items.length <= 2 || !(cachedBreakingVersion = new PluginAndJekaVersion(items[0].trim(), items[1].trim())).equals(effectiveVersions)) continue;
                if (items.length > 3) {
                    return new PluginAndJekaVersion(items[2].trim(), items[3].trim());
                }
                return PluginAndJekaVersion.EMPTY;
            }
            return null;
        }

        void addEntry(PluginAndJekaVersion effectiveVersions, PluginAndJekaVersion breakingVersions) {
            if (!this.exist()) {
                JkUtilsPath.createFileSafely(this.cachePath, new FileAttribute[0]);
            }
            String line = effectiveVersions.pluginVersion + " : " + effectiveVersions.jekaVersion;
            if (breakingVersions != null) {
                line = line + " : " + breakingVersions.pluginVersion + " : " + breakingVersions.jekaVersion + "\n";
            }
            JkUtilsPath.write(this.cachePath, line.getBytes(Charset.forName("UTF-8")), StandardOpenOption.APPEND);
        }
    }
}

