/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.tool;

import dev.jeka.core.api.system.JkLocator;
import dev.jeka.core.api.system.JkProperty;
import dev.jeka.core.api.utils.JkUtilsFile;
import dev.jeka.core.api.utils.JkUtilsString;
import dev.jeka.core.tool.Environment;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public final class JkProperties {
    public static final String GLOBAL_PROPERTY_FILE_NAME = "global.properties";
    public static final String PROJECT_PROPERTY_FILE_NAME = "project.properties";
    private static final JkProperties INSTANCE;
    private final Map<String, String> props;

    private JkProperties(Map<String, String> props) {
        this.props = props;
    }

    public static String get(String key) {
        return JkProperty.get(key);
    }

    public static boolean isDefined(String key) {
        if (System.getProperties().containsKey(key)) {
            return true;
        }
        return JkProperties.INSTANCE.props.containsKey(key);
    }

    public static Map<String, String> getAll() {
        return Collections.unmodifiableMap(JkProperties.INSTANCE.props);
    }

    public static Map<String, String> getAllStartingWith(String prefix) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String key : JkProperties.INSTANCE.props.keySet()) {
            if (!key.startsWith(prefix)) continue;
            result.put(key, JkProperties.get(key));
        }
        return result;
    }

    public static Map<String, String> toDisplayedMap(Map<String, String> props) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        for (Map.Entry<String, String> entry : props.entrySet()) {
            String value = JkUtilsString.firstMatching(entry.getKey().toLowerCase(), "password", "pwd") != null && entry.getValue() != null ? "*****" : entry.getValue();
            result.put(entry.getKey(), value);
        }
        return result;
    }

    private static Map<String, String> readGlobalProperties() {
        Path userPropFile = JkLocator.getJekaUserHomeDir().resolve(GLOBAL_PROPERTY_FILE_NAME);
        if (Files.exists(userPropFile, new LinkOption[0])) {
            return JkUtilsFile.readPropertyFileAsMap(userPropFile);
        }
        return Collections.emptyMap();
    }

    private static Map<String, String> readProjectProperties(Path projectBaseDir) {
        Path presetCommandsFile = projectBaseDir.resolve("jeka/project.properties");
        if (Files.exists(presetCommandsFile, new LinkOption[0])) {
            return JkUtilsFile.readPropertyFileAsMap(presetCommandsFile);
        }
        return Collections.emptyMap();
    }

    static {
        TreeMap<String, String> props = new TreeMap<String, String>();
        props.putAll(JkProperties.readGlobalProperties());
        props.putAll(JkProperties.readProjectProperties(Paths.get("", new String[0])));
        props.putAll(Environment.commandLine.getSystemProperties());
        INSTANCE = new JkProperties(props);
        props.forEach((k, v) -> System.setProperty(k, v));
    }
}

