/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.tool;

import dev.jeka.core.api.depmanagement.resolution.JkDependencyResolver;
import dev.jeka.core.api.file.JkPathSequence;
import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.utils.JkUtilsAssert;
import dev.jeka.core.api.utils.JkUtilsIterable;
import dev.jeka.core.api.utils.JkUtilsReflect;
import dev.jeka.core.tool.EngineCommand;
import dev.jeka.core.tool.FieldInjector;
import dev.jeka.core.tool.JkBean;
import dev.jeka.core.tool.JkException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public final class JkRuntime {
    private static final ThreadLocal<Path> BASE_DIR_CONTEXT = new ThreadLocal();
    private static final Map<Path, JkRuntime> RUNTIMES = new LinkedHashMap<Path, JkRuntime>();
    private final Path projectBaseDir;
    private JkDependencyResolver dependencyResolver;
    private JkPathSequence classpath;
    private JkPathSequence importedProjects;
    private List<EngineCommand> fieldInjections = Collections.emptyList();
    private final Map<Class<? extends JkBean>, JkBean> beans = new LinkedHashMap<Class<? extends JkBean>, JkBean>();

    private JkRuntime(Path projectBaseDir) {
        this.projectBaseDir = projectBaseDir;
    }

    public static JkRuntime get(Path projectBaseDir) {
        return RUNTIMES.computeIfAbsent(projectBaseDir, path -> new JkRuntime((Path)path));
    }

    static JkRuntime getCurrentContextBaseDir() {
        return JkRuntime.get(JkRuntime.getBaseDirContext());
    }

    static void setBaseDirContext(Path baseDir) {
        JkUtilsAssert.argument(baseDir == null || Files.exists(baseDir, new LinkOption[0]), "Project " + baseDir + " not found.", new Object[0]);
        BASE_DIR_CONTEXT.set(baseDir);
    }

    private static Path getBaseDirContext() {
        return Optional.ofNullable(BASE_DIR_CONTEXT.get()).orElseGet(() -> {
            JkRuntime.setBaseDirContext(Paths.get("", new String[0]));
            return BASE_DIR_CONTEXT.get();
        });
    }

    Path getProjectBaseDir() {
        return this.projectBaseDir;
    }

    public JkDependencyResolver getDependencyResolver() {
        return this.dependencyResolver;
    }

    public JkPathSequence getClasspath() {
        return this.classpath;
    }

    public JkPathSequence getImportedProjects() {
        return this.importedProjects;
    }

    public <T extends JkBean> T getBean(Class<T> jkBeanClass) {
        JkUtilsAssert.argument(jkBeanClass != null, "KBean class cannot be null.", new Object[0]);
        JkBean result = this.beans.get(jkBeanClass);
        if (result == null) {
            JkLog.startTask("Instantiate KBean " + jkBeanClass + " in project '" + this.projectBaseDir + "'", new Object[0]);
            Path previousProject = BASE_DIR_CONTEXT.get();
            BASE_DIR_CONTEXT.set(this.projectBaseDir);
            result = this.instantiate(jkBeanClass);
            BASE_DIR_CONTEXT.set(previousProject);
            JkLog.endTask();
            this.beans.put(jkBeanClass, result);
        }
        return (T)result;
    }

    public <T extends JkBean> Optional<T> getBeanOptional(Class<T> jkBeanClass) {
        return Optional.ofNullable(this.beans.get(jkBeanClass));
    }

    public List<JkBean> getBeans() {
        return new LinkedList<JkBean>(this.beans.values());
    }

    void setDependencyResolver(JkDependencyResolver resolverArg) {
        this.dependencyResolver = resolverArg;
    }

    void setClasspath(JkPathSequence pathSequence) {
        this.classpath = pathSequence;
    }

    void setImportedProjects(JkPathSequence importedProjects) {
        this.importedProjects = importedProjects;
    }

    void init(List<EngineCommand> commands) {
        JkLog.trace("Initialize JkRuntime with " + commands, new Object[0]);
        this.fieldInjections = commands.stream().filter(engineCommand -> engineCommand.getAction() == EngineCommand.Action.PROPERTY_INJECT).collect(Collectors.toList());
        JkLog.startTask("Register KBeans", new Object[0]);
        List beans = commands.stream().filter(engineCommand -> engineCommand.getAction() != EngineCommand.Action.PROPERTY_INJECT).map(EngineCommand::getBeanClass).distinct().map(this::getBean).collect(Collectors.toList());
        JkLog.endTask();
    }

    void run(List<EngineCommand> commands) {
        for (EngineCommand engineCommand : commands) {
            Method method;
            JkBean bean = this.getBean(engineCommand.getBeanClass());
            if (engineCommand.getAction() != EngineCommand.Action.METHOD_INVOKE) continue;
            try {
                method = bean.getClass().getMethod(engineCommand.getMember(), new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new JkException("No public no-args method '" + engineCommand.getMember() + "' found on KBean " + bean.getClass(), new Object[0]);
            }
            JkUtilsReflect.invoke((Object)bean, method);
        }
    }

    private JkBean instantiate(Class<? extends JkBean> beanClass) {
        if (Modifier.isAbstract(beanClass.getModifiers())) {
            throw new JkException("KBean class " + beanClass + " in " + this.projectBaseDir + " is abstract and therefore cannot be instantiated. Please, use a concrete type to declare imported KBeans.", new Object[0]);
        }
        JkBean bean = JkUtilsReflect.newInstance(beanClass);
        this.fieldInjections.stream().filter(engineCommand -> engineCommand.getAction() == EngineCommand.Action.PROPERTY_INJECT).filter(engineCommand -> engineCommand.getBeanClass().equals(bean.getClass())).forEach(action -> {
            Set<String> injectedProp = FieldInjector.inject(bean, JkUtilsIterable.mapOf(action.getMember(), action.getValue(), new Object[0]));
            if (injectedProp.isEmpty()) {
                throw new JkException("Field %s does not exist in KBean %s", injectedProp, bean);
            }
        });
        FieldInjector.injectAnnotatedProperties(bean);
        return bean;
    }

    public String toString() {
        return "JkRuntime{projectBaseDir=" + this.projectBaseDir + ", beans=" + this.beans.keySet() + '}';
    }
}

