/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.tool;

import dev.jeka.core.api.java.JkClassLoader;
import dev.jeka.core.api.system.JkBusyIndicator;
import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.system.JkMemoryBufferLogDecorator;
import dev.jeka.core.api.utils.JkUtilsIO;
import dev.jeka.core.api.utils.JkUtilsString;
import dev.jeka.core.api.utils.JkUtilsTime;
import dev.jeka.core.tool.AppendableUrlClassloader;
import dev.jeka.core.tool.CommandLine;
import dev.jeka.core.tool.Engine;
import dev.jeka.core.tool.Environment;
import dev.jeka.core.tool.JkInit;
import dev.jeka.core.tool.JkProperties;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;

public final class Main {
    public static void main(String[] args) {
        if (!(Thread.currentThread().getContextClassLoader() instanceof AppendableUrlClassloader)) {
            AppendableUrlClassloader urlClassLoader = new AppendableUrlClassloader();
            Thread.currentThread().setContextClassLoader(urlClassLoader);
            Object[] argArray = new Object[]{args};
            JkClassLoader.of(urlClassLoader).invokeStaticMethod(false, Main.class.getName(), "main", argArray);
            return;
        }
        long start = System.nanoTime();
        try {
            Environment.initialize(args);
            JkProperties.isDefined("");
            JkLog.setDecorator(Environment.standardOptions.logStyle);
            if (Environment.standardOptions.logBanner) {
                Main.displayIntro();
            }
            if (Environment.standardOptions.logRuntimeInformation != null) {
                JkInit.displayRuntimeInfo();
            }
            JkLog.setAcceptAnimation(!Environment.standardOptions.logNoAnimation);
            if (!Environment.standardOptions.logSetup) {
                JkBusyIndicator.start("Preparing Jeka classes and instance (Use -lsu option for details)");
                JkMemoryBufferLogDecorator.activateOnJkLog();
                JkLog.info("", new Object[0]);
            }
            Path workingDir = Paths.get("", new String[0]);
            Engine engine = new Engine(workingDir);
            engine.execute(Environment.commandLine);
            if (Environment.standardOptions.logBanner) {
                Main.displayOutro(start);
            }
            System.exit(0);
        }
        catch (Throwable e) {
            JkBusyIndicator.stop();
            if (JkMemoryBufferLogDecorator.isActive()) {
                JkMemoryBufferLogDecorator.flush();
            }
            JkLog.restoreToInitialState();
            System.err.println("An error occurred during def class execution.");
            System.err.println("It may come from user code/setting or a bug in Jeka.");
            System.err.println("To investigate, relaunch command with options :");
            System.err.println("    -ls=DEBUG to see code class/line where each log has been emitted.");
            System.err.println("    -lv to increase log verbosity.");
            System.err.println("    -lst to simply log the stacktrace of the thrown exception.");
            System.err.println("If error reveals to coming from Jeka engine, please report to : https://github.com/jerkar/jeka/issues");
            System.err.println();
            if (JkLog.isVerbose() || Environment.standardOptions.logStyle == JkLog.Style.DEBUG || Environment.standardOptions.logStackTrace) {
                e.printStackTrace(System.err);
            } else {
                System.err.println("Error : " + e.getMessage());
            }
            if (Environment.standardOptions.logBanner) {
                int length = Main.printAscii(true, "text-failed.ascii");
                System.err.println(JkUtilsString.repeat(" ", length) + "Total run duration : " + JkUtilsTime.durationInSeconds(start) + " seconds.");
            } else {
                System.err.println("Failed !");
            }
            System.exit(1);
        }
    }

    public static void exec(Path projectDir, String ... args) {
        ClassLoader originalClassloader = Thread.currentThread().getContextClassLoader();
        if (!(originalClassloader instanceof URLClassLoader)) {
            URLClassLoader urlClassLoader = new URLClassLoader(new URL[0], originalClassloader);
            Thread.currentThread().setContextClassLoader(urlClassLoader);
            JkClassLoader.of(urlClassLoader).invokeStaticMethod(false, "dev.jeka.core.tool.Main", "exec", projectDir, args);
            return;
        }
        JkLog.setAcceptAnimation(!Environment.standardOptions.logNoAnimation);
        if (!Environment.standardOptions.logSetup) {
            JkBusyIndicator.start("Preparing Jeka classes and instance (Use -lsu option for details)");
            JkMemoryBufferLogDecorator.activateOnJkLog();
        }
        Engine engine = new Engine(projectDir);
        engine.execute(CommandLine.parse(args));
    }

    private static int printAscii(boolean error, String fileName) {
        InputStream inputStream = Main.class.getResourceAsStream(fileName);
        List<String> lines = JkUtilsIO.readAsLines(inputStream);
        int i = 0;
        for (String line : lines) {
            if (i < line.length()) {
                i = line.length();
            }
            if (error) {
                System.err.println(line);
                continue;
            }
            System.out.println(line);
        }
        return i;
    }

    private static void displayIntro() {
        int length = Main.printAscii(false, "text-jeka.ascii");
        JkLog.info(JkUtilsString.repeat(" ", length) + "The 100%% Java Build Tool.\n", new Object[0]);
    }

    private static void displayOutro(long startTs) {
        int length = Main.printAscii(false, "text-success.ascii");
        System.out.println(JkUtilsString.repeat(" ", length) + "Total run duration : " + JkUtilsTime.durationInSeconds(startTs) + " seconds.");
    }

    private Main() {
    }
}

