/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.tool.builtins.git;

import dev.jeka.core.api.system.JkPrompt;
import dev.jeka.core.api.tooling.JkGitProcess;
import dev.jeka.core.tool.JkBean;
import dev.jeka.core.tool.JkDoc;

@JkDoc(value={"Provides common Git scripts/commands out of the box."})
public class GitJkBean
extends JkBean {
    private final JkGitProcess git = JkGitProcess.of(this.getBaseDir());

    protected GitJkBean() {
    }

    @JkDoc(value={"Perform a dirty check first then put a tag at the HEAD and push it to remote."})
    public void tagRemote() {
        JkGitProcess aGit = (JkGitProcess)((JkGitProcess)((JkGitProcess)this.git.clone()).setLogCommand(false)).setLogOutput(false);
        System.out.println("Existing tags on origin :");
        ((JkGitProcess)((JkGitProcess)aGit.clone()).setLogOutput(true)).exec("ls-remote", "--tag", "--sort=creatordate", "origin");
        if (aGit.isWorkspaceDirty()) {
            System.out.println("Git workspace is dirty. Please clean your Git workspace and retry");
            return;
        }
        if (!aGit.isRemoteEqual()) {
            System.out.println("The current tracking branch is not aligned with the remote. Please update/push and retry.");
            return;
        }
        System.out.println("You are about to tag commit : " + this.git.getCurrentCommit());
        String newTag = JkPrompt.ask("Enter new tag : ");
        ((JkGitProcess)aGit.setLogCommand(true)).tagAndPush(newTag);
    }

    public JkGitProcess getGitProcess() {
        return this.git;
    }
}

