/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.tool.builtins.ide;

import dev.jeka.core.api.depmanagement.JkDependency;
import dev.jeka.core.api.file.JkPathTree;
import dev.jeka.core.api.project.JkIdeSupport;
import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.tooling.eclipse.JkEclipseClasspathGenerator;
import dev.jeka.core.api.tooling.eclipse.JkEclipseProjectGenerator;
import dev.jeka.core.api.utils.JkUtilsPath;
import dev.jeka.core.tool.JkBean;
import dev.jeka.core.tool.JkDoc;
import dev.jeka.core.tool.Main;
import dev.jeka.core.tool.builtins.ide.IdeSupport;
import dev.jeka.core.tool.builtins.scaffold.ScaffoldJkBean;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;

@JkDoc(value={"Generates Eclipse files (.project and .classpath)."})
public final class EclipseJkBean
extends JkBean {
    @JkDoc(value={"If true, .classpath will include javadoc reference for declared dependencies."})
    boolean javadoc = false;
    @JkDoc(value={"If not null, this value will be used as the JRE container path in .classpath."})
    public String jreContainer = null;
    @JkDoc(value={"If true, dependency paths will be expressed relatively to Eclipse path variables instead of absolute paths."})
    public boolean useVarPath = true;
    private final Map<JkDependency, Properties> attributes = new HashMap<JkDependency, Properties>();
    private final Map<JkDependency, Properties> accessRules = new HashMap<JkDependency, Properties>();
    private final ScaffoldJkBean scaffold = this.getRuntime().getBean(ScaffoldJkBean.class);

    protected EclipseJkBean() {
    }

    public void setStandardJREContainer(String jreName) {
        this.jreContainer = "org.eclipse.jdt.launching.JRE_CONTAINER/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/" + jreName;
    }

    @JkDoc(value={"Generates Eclipse files (.classpath and .project) in the current directory. The files reflect project dependencies and source layout."})
    public void files() {
        Path dotProject = this.getBaseDir().resolve(".project");
        JkIdeSupport projectIde = IdeSupport.getProjectIde(this);
        if (projectIde != null) {
            LinkedList<Path> importedRunProjects = new LinkedList<Path>();
            for (JkBean importedJkBean : this.getImportedJkBeans().get(false)) {
                importedRunProjects.add(importedJkBean.getBaseDir());
            }
            JkEclipseClasspathGenerator classpathGenerator = JkEclipseClasspathGenerator.of(projectIde);
            classpathGenerator.setDefDependencies(this.getRuntime().getDependencyResolver(), IdeSupport.classpathAsDependencySet());
            classpathGenerator.setIncludeJavadoc(this.javadoc);
            classpathGenerator.setJreContainer(this.jreContainer);
            classpathGenerator.setImportedProjects(importedRunProjects);
            classpathGenerator.setUsePathVariables(this.useVarPath);
            this.attributes.entrySet().forEach(entry -> classpathGenerator.addAttributes((JkDependency)entry.getKey(), (Properties)entry.getValue()));
            this.accessRules.entrySet().forEach(entry -> classpathGenerator.addAccessRules((JkDependency)entry.getKey(), (Properties)entry.getValue()));
            String result = classpathGenerator.generate();
            Path dotClasspath = this.getBaseDir().resolve(".classpath");
            JkUtilsPath.write(dotClasspath, result.getBytes(Charset.forName("UTF-8")), new OpenOption[0]);
            JkLog.info("File " + dotClasspath + " generated.", new Object[0]);
            if (!Files.exists(dotProject, new LinkOption[0])) {
                JkEclipseProjectGenerator.ofJavaNature(this.getBaseDir().getFileName().toString()).writeTo(dotProject);
                JkLog.info("File " + dotProject + " generated.", new Object[0]);
            }
        } else if (!Files.exists(dotProject, new LinkOption[0])) {
            JkEclipseProjectGenerator.ofSimpleNature(this.getBaseDir().getFileName().toString()).writeTo(dotProject);
            JkLog.info("File " + dotProject + " generated.", new Object[0]);
        }
    }

    @JkDoc(value={"Generates Eclipse files (.project and .classpath) on all sub-folders of the current directory. Only sub-folders having a jeka/def directory are taken in account. See eclipse#files."})
    public void all() {
        Iterable folders = JkPathTree.of(this.getBaseDir()).andMatching(true, "**/jeka/def", "jeka/def").andMatching(false, "**/jeka/output/**").stream(new FileVisitOption[0]).collect(Collectors.toList());
        for (Path folder : folders) {
            Path projectFolder = folder.getParent().getParent();
            JkLog.startTask("Generate Eclipse files on " + projectFolder, new Object[0]);
            Main.exec(projectFolder, "eclipse#files");
            JkLog.endTask();
        }
    }

    public EclipseJkBean addAttribute(JkDependency dependency, String name, String value) {
        this.attributes.putIfAbsent(dependency, new Properties());
        this.attributes.get(dependency).put(name, value);
        return this;
    }

    public EclipseJkBean addAccessRule(JkDependency dependency, String kind, String pattern) {
        this.accessRules.putIfAbsent(dependency, new Properties());
        this.accessRules.get(dependency).put(kind, pattern);
        return this;
    }
}

