/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.tool.builtins.ide;

import dev.jeka.core.api.file.JkPathFile;
import dev.jeka.core.api.file.JkPathTree;
import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.tooling.intellij.JkIml;
import dev.jeka.core.api.tooling.intellij.JkImlGenerator;
import dev.jeka.core.api.utils.JkUtilsAssert;
import dev.jeka.core.tool.JkBean;
import dev.jeka.core.tool.JkDoc;
import dev.jeka.core.tool.Main;
import dev.jeka.core.tool.builtins.ide.IdeSupport;
import dev.jeka.core.tool.builtins.ide.IntellijModulesXmlGenerator;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Consumer;

@JkDoc(value={"Generates Idea Intellij metadata files (*.iml and modules.xml)."})
public final class IntellijJkBean
extends JkBean {
    @JkDoc(value={"If true, dependency paths will be expressed relatively to $JEKA_REPO$ and $JEKA_HOME$ path variable instead of absolute paths."})
    public boolean useVarPath = true;
    @JkDoc(value={"If true, the iml generation fails when a dependency can not be resolved. If false, it will be ignored (only a warning will be notified)."})
    public boolean failOnDepsResolutionError = true;
    private LinkedHashSet<String> projectLibraries = new LinkedHashSet();
    private Consumer<JkImlGenerator> imlGeneratorConfigurer = jkImlGenerator2 -> {};

    public IntellijJkBean configureImlGenerator(Consumer<JkImlGenerator> imlGeneratorConfigurer) {
        this.imlGeneratorConfigurer = this.imlGeneratorConfigurer.andThen(imlGeneratorConfigurer);
        return this;
    }

    public IntellijJkBean configureIml(Consumer<JkIml> imlConfigurer) {
        this.configureImlGenerator(imlGeneratorConfigurer -> imlGeneratorConfigurer.configureIml(imlConfigurer));
        return this;
    }

    public IntellijJkBean useJekaDefinedInModule(String intellijModule) {
        this.configureImlGenerator(imlGenerator -> imlGenerator.setExcludeJekaLib(true));
        return this.configureIml(iml -> iml.getComponent().addModuleOrderEntry(intellijModule, JkIml.Scope.TEST));
    }

    public IntellijJkBean excludeJekaLib() {
        return this.configureImlGenerator(imlGenerator -> imlGenerator.setExcludeJekaLib(true));
    }

    @JkDoc(value={"Generates IntelliJ [my-module].iml file."})
    public void iml() {
        JkLog.startTask("Generating Iml for project '%s'...", this.getBaseDirName());
        Path basePath = this.getBaseDir();
        JkImlGenerator imlGenerator = this.imlGenerator();
        this.imlGeneratorConfigurer.accept(imlGenerator);
        JkIml iml = imlGenerator.computeIml();
        JkPathFile imlFile = JkPathFile.of(IntellijJkBean.findImlFile(basePath)).deleteIfExist().createIfNotExist().write(iml.toDoc().toXml().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        JkLog.info("Iml file generated at " + imlFile.get(), new Object[0]);
        JkLog.endTask();
    }

    private static Path findImlFile(Path dir) {
        String fileName = dir.getFileName().toString().equals("") ? dir.toAbsolutePath().getFileName().toString() : dir.getFileName().toString();
        return JkImlGenerator.findImlFile(dir).orElse(dir.resolve(".idea").resolve(fileName + ".iml"));
    }

    @JkDoc(value={"Generates ./idea/modules.xml file."})
    public void modulesXml() {
        this.checkProjectRoot();
        Path current = this.getBaseDir();
        List<Path> imls = JkPathTree.of(this.getBaseDir()).andMatching(true, "**.iml").getFiles();
        IntellijModulesXmlGenerator intellijModulesXmlGenerator = new IntellijModulesXmlGenerator(current, imls);
        intellijModulesXmlGenerator.generate();
        JkLog.info("File generated at : " + intellijModulesXmlGenerator.outputFile(), new Object[0]);
    }

    @JkDoc(value={"Generates iml files on this folder and its descendant recursively."})
    public void allIml() {
        JkPathTree.of(this.getBaseDir()).andMatching(true, "**/jeka/def", "jeka/def").andMatching(false, "**/jeka/output/**").stream(new FileVisitOption[0]).distinct().map(path -> path.getParent().getParent()).map(path -> path == null ? this.getBaseDir() : path).forEach(this::generateImlExec);
    }

    private void generateImlExec(Path moduleDir) {
        JkLog.startTask("Generate iml file on '%s'", moduleDir);
        Main.exec(moduleDir, "intellij#iml", "-dci");
        JkLog.endTask();
    }

    public IntellijJkBean addProjectLibrary(String xml) {
        this.projectLibraries.add(xml);
        return this;
    }

    @JkDoc(value={"Shorthand for intellij#allIml + intellij#modulesXml."})
    public void fullProject() {
        this.checkProjectRoot();
        this.allIml();
        this.modulesXml();
    }

    private void checkProjectRoot() {
        IntellijModulesXmlGenerator intellijModulesXmlGenerator = new IntellijModulesXmlGenerator(this.getBaseDir(), Collections.emptyList());
        JkUtilsAssert.state(Files.exists(intellijModulesXmlGenerator.outputFile(), new LinkOption[0]), "Folder where Jeka has run '%s' seems not to be the root of the project cause no file %s has been found here.\nPlease relaunch this command from IntelliJ project root directory.", this.getBaseDir().toAbsolutePath(), intellijModulesXmlGenerator.outputFile());
    }

    private JkImlGenerator imlGenerator() {
        JkImlGenerator imlGenerator = JkImlGenerator.of().setBaseDir(this.getBaseDir()).setDefClasspath(this.getRuntime().getClasspath()).setDefImportedProjects(this.getRuntime().getImportedProjects()).setIdeSupport(IdeSupport.getProjectIde(this)).setFailOnDepsResolutionError(this.failOnDepsResolutionError).setUseVarPath(this.useVarPath);
        return imlGenerator;
    }
}

