/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.tool.builtins.project;

import dev.jeka.core.api.depmanagement.JkDependencySet;
import dev.jeka.core.api.depmanagement.JkRepo;
import dev.jeka.core.api.depmanagement.JkRepoFromProperties;
import dev.jeka.core.api.depmanagement.artifact.JkArtifactId;
import dev.jeka.core.api.depmanagement.artifact.JkStandardFileArtifactProducer;
import dev.jeka.core.api.depmanagement.resolution.JkDependencyResolver;
import dev.jeka.core.api.depmanagement.resolution.JkResolveResult;
import dev.jeka.core.api.depmanagement.resolution.JkResolvedDependencyNode;
import dev.jeka.core.api.file.JkPathFile;
import dev.jeka.core.api.function.JkConsumers;
import dev.jeka.core.api.java.JkJavaCompiler;
import dev.jeka.core.api.java.JkJavaProcess;
import dev.jeka.core.api.project.JkCompileLayout;
import dev.jeka.core.api.project.JkIdeSupport;
import dev.jeka.core.api.project.JkProject;
import dev.jeka.core.api.project.JkProjectCompilation;
import dev.jeka.core.api.project.JkProjectConstruction;
import dev.jeka.core.api.project.JkProjectTesting;
import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.testing.JkTestProcessor;
import dev.jeka.core.api.utils.JkUtilsIO;
import dev.jeka.core.api.utils.JkUtilsPath;
import dev.jeka.core.api.utils.JkUtilsString;
import dev.jeka.core.tool.JkBean;
import dev.jeka.core.tool.JkDoc;
import dev.jeka.core.tool.JkProperties;
import dev.jeka.core.tool.builtins.scaffold.JkScaffolder;
import dev.jeka.core.tool.builtins.scaffold.ScaffoldJkBean;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.function.Consumer;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

@JkDoc(value={"Provides a configured JkProject instance for building JVM based projects."})
public class ProjectJkBean
extends JkBean
implements JkIdeSupport.JkSupplier {
    public final JkPackOptions pack = new JkPackOptions();
    public final JkTestOptions test = new JkTestOptions();
    @JkDoc(value={"Extra arguments to be passed to the compiler (e.g. -Xlint:unchecked)."})
    public String compilerExtraArgs;
    @JkDoc(value={"The template used for scaffolding the build class"})
    public ScaffoldTemplate scaffoldTemplate = ScaffoldTemplate.SIMPLE_FACADE;
    @JkDoc(value={"The output file for the xml dependency description."})
    public Path output;
    private final ScaffoldJkBean scaffoldJkBean = this.getBean(ScaffoldJkBean.class);
    private JkProject project;
    private JkConsumers<JkProject, Void> projectConfigurators = JkConsumers.of();

    private JkProject createProject() {
        Path baseDir = this.getBaseDir();
        JkProject project = JkProject.of().setBaseDir(baseDir);
        project.getConstruction().addTextAndLocalDependencies();
        if (!JkLog.isAcceptAnimation()) {
            project.getConstruction().getTesting().getTestProcessor().getEngineBehavior().setProgressDisplayer(JkTestProcessor.JkProgressOutputStyle.SILENT);
        }
        JkJavaCompiler<JkProjectConstruction> compiler = project.getConstruction().getCompiler();
        compiler.setJdkHomesWithProperties(JkProperties.getAllStartingWith("jdk."));
        this.applyRepo(project);
        this.projectConfigurators.accept(project);
        this.applyPostSetupOptions(project);
        this.scaffoldJkBean.configure((JkScaffolder scaffolder) -> this.configureScaffolder((JkScaffolder)scaffolder, project));
        return project;
    }

    private void applyRepo(JkProject project) {
        project.getPublication().getMaven().setRepos(Optional.ofNullable(JkRepoFromProperties.getPublishRepository()).orElse(JkRepo.ofLocal()).toSet());
        project.getPublication().getIvy().setRepos(Optional.ofNullable(JkRepoFromProperties.getPublishRepository()).orElse(JkRepo.ofLocalIvy()).toSet());
        JkRepo downloadRepo = JkRepoFromProperties.getDownloadRepo();
        JkDependencyResolver<JkProjectConstruction> resolver = project.getConstruction().getDependencyResolver();
        if (!resolver.getRepos().contains(downloadRepo.getUrl())) {
            resolver.addRepos(downloadRepo);
        }
    }

    private void applyPostSetupOptions(JkProject aProject) {
        JkStandardFileArtifactProducer<JkProject> artifactProducer = aProject.getArtifactProducer();
        JkArtifactId sources = JkProject.SOURCES_ARTIFACT_ID;
        if (this.pack.sources != null && !this.pack.sources.booleanValue()) {
            artifactProducer.removeArtifact(sources);
        } else if (this.pack.sources != null && this.pack.sources.booleanValue() && !artifactProducer.getArtifactIds().contains(sources)) {
            Consumer<Path> sourceJar = aProject.getDocumentation()::createSourceJar;
            artifactProducer.putArtifact(sources, sourceJar);
        }
        JkArtifactId javadoc = JkProject.JAVADOC_ARTIFACT_ID;
        if (this.pack.javadoc != null && !this.pack.javadoc.booleanValue()) {
            artifactProducer.removeArtifact(javadoc);
        } else if (this.pack.javadoc != null && this.pack.javadoc.booleanValue() && !artifactProducer.getArtifactIds().contains(javadoc)) {
            Consumer<Path> javadocJar = aProject.getDocumentation()::createJavadocJar;
            artifactProducer.putArtifact(javadoc, javadocJar);
        }
        JkTestProcessor<JkProjectTesting> testProcessor = aProject.getConstruction().getTesting().getTestProcessor();
        if (this.test.fork != null && this.test.fork.booleanValue() && testProcessor.getForkingProcess() == null) {
            JkJavaProcess javaProcess = JkJavaProcess.ofJava(JkTestProcessor.class.getName()).addJavaOptions(this.test.jvmOptions);
            testProcessor.setForkingProcess(javaProcess);
        } else if (this.test.fork != null && !this.test.fork.booleanValue() && testProcessor.getForkingProcess() != null) {
            testProcessor.setForkingProcess(false);
        }
        if (this.test.skip != null) {
            aProject.getConstruction().getTesting().setSkipped(this.test.skip);
        }
        if (this.compilerExtraArgs != null) {
            aProject.getConstruction().getCompilation().addJavaCompilerOptions(JkUtilsString.translateCommandline(this.compilerExtraArgs));
        }
    }

    private void configureScaffolder(JkScaffolder scaffolder, JkProject project) {
        scaffolder.setJekaClassCodeProvider(() -> {
            String snippet = this.scaffoldTemplate == ScaffoldTemplate.NORMAL ? "buildclass.snippet" : (this.scaffoldTemplate == ScaffoldTemplate.PLUGIN ? "buildclassplugin.snippet" : "buildclassfacade.snippet");
            String template = JkUtilsIO.read(ProjectJkBean.class.getResource(snippet));
            String baseDirName = this.getBaseDir().getFileName().toString();
            return template.replace("${group}", baseDirName).replace("${name}", baseDirName);
        });
        scaffolder.setClassFilename("Build.java");
        scaffolder.getExtraActions().append(() -> {
            JkLog.info("Create source directories.", new Object[0]);
            JkCompileLayout<JkProjectCompilation<JkProjectConstruction>> prodLayout = project.getConstruction().getCompilation().getLayout();
            prodLayout.resolveSources().toList().stream().forEach(tree -> tree.createIfNotExist());
            prodLayout.resolveResources().toList().stream().forEach(tree -> tree.createIfNotExist());
            JkCompileLayout<JkProjectCompilation<JkProjectTesting>> testLayout = project.getConstruction().getTesting().getCompilation().getLayout();
            testLayout.resolveSources().toList().stream().forEach(tree -> tree.createIfNotExist());
            testLayout.resolveResources().toList().stream().forEach(tree -> tree.createIfNotExist());
            JkPathFile.of(project.getBaseDir().resolve("jeka/dependency.txt")).fetchContentFrom(ProjectJkBean.class.getResource("dependencies.txt"));
            Path libs = project.getBaseDir().resolve("jeka/libs");
            JkPathFile.of(libs.resolve("readme.txt")).fetchContentFrom(ProjectJkBean.class.getResource("libs-readme.txt"));
            JkUtilsPath.createDirectories(libs.resolve("compile+runtime"), new FileAttribute[0]);
            JkUtilsPath.createDirectories(libs.resolve("compile"), new FileAttribute[0]);
            JkUtilsPath.createDirectories(libs.resolve("runtime"), new FileAttribute[0]);
            JkUtilsPath.createDirectories(libs.resolve("test"), new FileAttribute[0]);
            JkUtilsPath.createDirectories(libs.resolve("sources"), new FileAttribute[0]);
            if (this.scaffoldTemplate == ScaffoldTemplate.PLUGIN) {
                Path breakinkChangeFile = this.getProject().getBaseDir().resolve("breaking_versions.txt");
                String text = "## Next line means plugin 2.4.0.RC11 is not compatible with Jeka 0.9.0.RELEASE and above\n## 2.4.0.RC11 : 0.9.0.RELEASE   (remove this comment and leading '##' to be effective)";
                JkPathFile.of(breakinkChangeFile).createIfNotExist().write(text.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                Path sourceDir = project.getConstruction().getCompilation().getLayout().getSources().toList().get(0).getRoot();
                String pluginCode = JkUtilsIO.read(ProjectJkBean.class.getResource("pluginclass.snippet"));
                JkPathFile.of(sourceDir.resolve("your/basepackage/JkPluginXxxxxxx.java")).createIfNotExist().write(pluginCode.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
        });
    }

    public JkProject getProject() {
        return Optional.ofNullable(this.project).orElseGet(() -> {
            this.project = this.createProject();
            return this.project;
        });
    }

    public ProjectJkBean configure(Consumer<JkProject> projectConfigurator) {
        this.projectConfigurators.append(projectConfigurator);
        return this;
    }

    @JkDoc(value={"Perform declared pre compilation task as generating sources."})
    public void preCompile() {
        this.getProject().getConstruction().getCompilation().getPreCompileActions().run();
    }

    @JkDoc(value={"Performs compilation and resource processing."})
    public void compile() {
        this.getProject().getConstruction().getCompilation().run();
    }

    @JkDoc(value={"Compiles and run tests defined within the project (typically Junit tests)."})
    public void test() {
        this.getProject().getConstruction().getTesting().run();
    }

    @JkDoc(value={"Generates from scratch artifacts defined through 'pack' options (Perform compilation and testing if needed).  \nDoes not re-generate artifacts already generated : execute 'clean java#pack' to re-generate artifacts."})
    public void pack() {
        this.getProject().getArtifactProducer().makeAllMissingArtifacts();
    }

    @JkDoc(value={"Displays resolved dependency tree on console."})
    public final void showDependencies() {
        JkProjectConstruction construction = this.getProject().getConstruction();
        this.showDependencies("compile", construction.getCompilation().getDependencies());
        this.showDependencies("runtime", construction.getRuntimeDependencies());
        this.showDependencies("test", construction.getTesting().getCompilation().getDependencies());
    }

    private void showDependencies(String purpose, JkDependencySet deps) {
        JkLog.info("\nDependencies for " + purpose + " : ", new Object[0]);
        JkResolveResult resolveResult = this.getProject().getConstruction().getDependencyResolver().resolve(deps);
        JkResolvedDependencyNode tree = resolveResult.getDependencyTree();
        JkLog.info("------------------------------", new Object[0]);
        JkLog.info(String.join((CharSequence)"\n", tree.toStrings()), new Object[0]);
        JkLog.info("", new Object[0]);
    }

    @JkDoc(value={"Displays resolved dependency tree in xml"})
    public void showDependenciesXml() {
        Writer out;
        Transformer transformer = null;
        try {
            transformer = TransformerFactory.newInstance().newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        transformer.setOutputProperty("indent", "yes");
        if (this.output == null) {
            out = new PrintWriter(JkLog.getOutPrintStream());
        } else {
            try {
                JkPathFile.of(this.output).createIfNotExist();
                out = new FileWriter(this.output.toFile());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        Document document = this.getProject().getConstruction().getDependenciesAsXml();
        try {
            transformer.transform(new DOMSource(document), new StreamResult(out));
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    @JkDoc(value={"Displays information about the Java project to build."})
    public void info() {
        JkLog.info(this.getProject().getInfo(), new Object[0]);
        JkLog.info("\nExecute 'java#showDependencies' to display details on dependencies.", new Object[0]);
    }

    @JkDoc(value={"Publishes produced artifacts to configured repository."})
    public void publish() {
        JkLog.info("Publish " + this.getProject() + " ...", new Object[0]);
        this.getProject().getPublication().publish();
    }

    @JkDoc(value={"Publishes produced artifacts to local repository."})
    public void publishLocal() {
        this.getProject().getPublication().publishLocal();
    }

    @Override
    public JkIdeSupport getJavaIdeSupport() {
        return this.getProject().getJavaIdeSupport();
    }

    public static enum ScaffoldTemplate {
        NORMAL,
        SIMPLE_FACADE,
        PLUGIN;

    }

    public static final class JkTestOptions {
        @JkDoc(value={"If true, tests are not run."})
        public Boolean skip;
        @JkDoc(value={"If true, tests will be executed in a forked process."})
        public Boolean fork;
        @JkDoc(value={"Argument passed to the JVM if tests are executed in a forked process. E.g. -Xms2G -Xmx2G."})
        public String jvmOptions;
    }

    public static class JkPackOptions {
        @JkDoc(value={"If true, javadoc jar is added in the list of artifact to produce/publish."})
        public Boolean javadoc;
        @JkDoc(value={"If true, sources jar is added in the list of artifact to produce/publish."})
        public Boolean sources;
    }
}

