/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.tool.builtins.release;

import dev.jeka.core.api.depmanagement.JkVersion;
import dev.jeka.core.api.project.JkProject;
import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.tooling.JkGitProcess;
import dev.jeka.core.tool.JkBean;
import dev.jeka.core.tool.JkDoc;
import dev.jeka.core.tool.builtins.git.GitJkBean;
import dev.jeka.core.tool.builtins.project.ProjectJkBean;
import java.util.Optional;

@JkDoc(value={"Manages versioning of projects by extracting Git information.", "The version is inferred from git : ", "  - If git workspace is dirty (different than last commit), version values [branch]-SNAPSHOT", "  - If last commit contains a message containing [comment_version_prefix]xxxxx, version values xxxxx", "  - If last commit is tagged, version values [last tag on last commit]", "The inferred version is applied to project.publication.maven.version and project.publication.ivy.publication.", "After, if last commit message specifies a version and this version differs from tag, last commit is tagged with specified version."})
public class VersionFromGitJkBean
extends JkBean {
    public static final String TAG_TASK_NAME = "version-from-git-tag";
    @JkDoc(value={"The prefix to use in commit message to specify a version."})
    public String commentVersionPrefix = "Release:";
    @JkDoc(value={"Tags with following prefix. This may help to distinguish tags for versioning from others."})
    public String tagPrefixForVersion = "";
    @JkDoc(value={"If true and a ProjectJkBean project is bound to the build instance, the project will be configured for publishing with the inferred version."})
    public boolean autoConfigureProject = true;
    @JkDoc(value={"If true and autoConfigureProject, project will be configured to push tag after project.publication.publish() succeed."})
    public boolean tagAfterPublish = true;
    private JkGitProcess git;
    private transient JkVersion cachedVersion;

    protected VersionFromGitJkBean() {
        GitJkBean gitPlugin = this.getRuntime().getBeanOptional(GitJkBean.class).orElse(null);
        JkGitProcess jkGitProcess = this.git = gitPlugin != null ? gitPlugin.getGitProcess() : JkGitProcess.of(this.getBaseDir());
        if (this.autoConfigureProject) {
            ProjectJkBean projectPlugin = this.getRuntime().getBeanOptional(ProjectJkBean.class).orElse(null);
            if (projectPlugin == null) {
                return;
            }
            projectPlugin.configure(project -> this.configure((JkProject)project, this.tagAfterPublish));
        }
    }

    public void configure(JkProject project, boolean tag) {
        project.getPublication().setVersion(() -> this.version().toString());
        if (tag) {
            project.getPublication().getPostActions().append(TAG_TASK_NAME, this::tagIfDiffers);
        }
    }

    public JkGitProcess git() {
        return (JkGitProcess)this.git.clone();
    }

    public JkVersion version() {
        if (this.cachedVersion != null) {
            return this.cachedVersion;
        }
        boolean dirty = this.git.isWorkspaceDirty();
        if (dirty) {
            this.cachedVersion = JkVersion.of(this.git.getCurrentBranch()).toSnapshot();
        } else {
            String commitCommentVersion = this.git.extractSuffixFromLastCommitMessage(this.commentVersionPrefix);
            this.cachedVersion = JkVersion.of(Optional.ofNullable(commitCommentVersion).orElseGet(() -> this.git.getVersionFromTag(this.tagPrefixForVersion)));
        }
        return this.cachedVersion;
    }

    public String versionAsText() {
        return this.version().getValue();
    }

    public boolean tagIfDiffers() {
        String commitCommentVersion = this.git.extractSuffixFromLastCommitMessage(this.commentVersionPrefix);
        if (commitCommentVersion == null) {
            return false;
        }
        String currentTagVersion = this.git.getVersionFromTag(this.tagPrefixForVersion);
        if (!commitCommentVersion.equals(currentTagVersion)) {
            JkLog.info("Tagging git with " + commitCommentVersion, new Object[0]);
            this.git.tagAndPush(this.tagPrefixForVersion + commitCommentVersion);
            return true;
        }
        return false;
    }

    public VersionFromGitJkBean refresh() {
        this.cachedVersion = null;
        return this;
    }

    @JkDoc(value={"Display inferred version on console."})
    public void showVersion() {
        JkLog.info(this.version().toString(), new Object[0]);
    }
}

