/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.tool.builtins.repos;

import dev.jeka.core.api.depmanagement.JkRepo;
import dev.jeka.core.api.depmanagement.publication.JkNexusRepos;
import dev.jeka.core.api.project.JkProject;
import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.utils.JkUtilsString;
import dev.jeka.core.tool.JkBean;
import dev.jeka.core.tool.JkDoc;
import dev.jeka.core.tool.builtins.project.ProjectJkBean;
import java.util.Optional;

@JkDoc(value={"Provides features to release Nexus repos (as OSSRH) after publication."})
public class NexusJkBean
extends JkBean {
    private static final String TASK_NAME = "Closing and releasing repositories";
    @JkDoc(value={"Close and Release automatically repository after publish."})
    public boolean closeAndRelease = true;
    @JkDoc(value={"Comma separated filters for taking in account only specified repositories with specified profile name."})
    public String profileNamesFilter = "";

    protected NexusJkBean() throws Exception {
        ProjectJkBean projectBean = this.getRuntime().getBeanOptional(ProjectJkBean.class).orElse(null);
        if (projectBean == null) {
            JkLog.warn("No project plugin configured here.", new Object[0]);
            return;
        }
        projectBean.configure(this::configure);
    }

    private void configure(JkProject project) {
        project.getPublication().getPostActions().append(TASK_NAME, () -> {
            String[] profileNames = JkUtilsString.isBlank(this.profileNamesFilter) ? new String[]{} : this.profileNamesFilter.split(",");
            JkRepo repo = NexusJkBean.getFirst(project);
            if (repo != null) {
                JkNexusRepos.ofUrlAndCredentials(repo).closeAndReleaseOpenRepositories(profileNames);
            } else {
                JkLog.warn("No remote repository configured for publishing", new Object[0]);
            }
        });
    }

    public void closeAndOrRelease() {
        Optional<ProjectJkBean> projectPlugin = this.getRuntime().getBeanOptional(ProjectJkBean.class);
        if (!projectPlugin.isPresent()) {
            JkLog.warn("No project plugin configured here.", new Object[0]);
            return;
        }
        String[] profileNames = this.profileNamesFilter.split(",");
        JkRepo repo = NexusJkBean.getFirst(projectPlugin.get().getProject());
        if (repo != null) {
            JkNexusRepos.ofUrlAndCredentials(repo).closeAndRelease(profileNames);
        } else {
            JkLog.warn("No remote repository configured for publishing", new Object[0]);
        }
    }

    public static void configureForOSSRHRepo(JkProject project, String ... profileNames) {
        JkRepo repo = project.getPublication().getMaven().getRepos().getRepoConfigHavingUrl("https://oss.sonatype.org/service/local/staging/deploy/maven2/");
        NexusJkBean.configureForRepo(project, repo, profileNames);
    }

    public static void configureForFirstRemoteRepo(JkProject project, String ... profileNames) {
        JkRepo repo = NexusJkBean.getFirst(project);
        NexusJkBean.configureForRepo(project, repo, profileNames);
    }

    public static void configureForRepo(JkProject project, JkRepo repo, String ... profileNames) {
        if (repo == null) {
            JkLog.warn("No Nexus OSSRH repo found.", new Object[0]);
            return;
        }
        JkNexusRepos nexusRepos = JkNexusRepos.ofUrlAndCredentials(repo);
        NexusJkBean.configureForRepo(project, nexusRepos, profileNames);
    }

    public static void configureForRepo(JkProject project, JkNexusRepos nexusRepos, String ... profileNames) {
        project.getPublication().getPostActions().append(TASK_NAME, () -> nexusRepos.closeAndReleaseOpenRepositories(profileNames));
    }

    private static JkRepo getFirst(JkProject project) {
        JkRepo repo = project.getPublication().findFirstNonLocalRepo();
        if (repo != null && repo.getCredentials() == null || repo.getCredentials().isEmpty()) {
            JkLog.warn("No credentials found on repo " + repo, new Object[0]);
        }
        return repo;
    }
}

