/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.tool.builtins.scaffold;

import dev.jeka.core.api.depmanagement.JkModuleId;
import dev.jeka.core.api.depmanagement.JkRepo;
import dev.jeka.core.api.depmanagement.resolution.JkDependencyResolver;
import dev.jeka.core.api.file.JkPathFile;
import dev.jeka.core.api.function.JkRunnables;
import dev.jeka.core.api.system.JkInfo;
import dev.jeka.core.api.system.JkLocator;
import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.utils.JkUtilsAssert;
import dev.jeka.core.api.utils.JkUtilsIterable;
import dev.jeka.core.api.utils.JkUtilsPath;
import dev.jeka.core.api.utils.JkUtilsString;
import dev.jeka.core.api.utils.JkUtilsSystem;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class JkScaffolder {
    private final Path baseDir;
    private Supplier<String> jkClassCodeProvider;
    private String classFilename = "Build.java";
    private String wrapperJekaVersion;
    private JkDependencyResolver dependencyResolver;
    private final JkRunnables extraActions = JkRunnables.of();
    private String cachedJekaVersion;

    JkScaffolder(Path baseDir) {
        this.jkClassCodeProvider = () -> "";
        this.baseDir = baseDir;
        this.dependencyResolver = JkDependencyResolver.of().addRepos(JkRepo.ofLocal(), JkRepo.ofMavenCentral());
    }

    public JkScaffolder setWrapperJekaVersion(String wrapperJekaVersion) {
        this.wrapperJekaVersion = wrapperJekaVersion;
        return this;
    }

    public JkScaffolder setDependencyResolver(JkDependencyResolver jkDependencyResolver) {
        this.dependencyResolver = jkDependencyResolver;
        return this;
    }

    public void run() {
        Path def = this.baseDir.resolve("jeka/def");
        JkUtilsPath.createDirectories(def, new FileAttribute[0]);
        JkLog.info("Create " + def, new Object[0]);
        Path buildClass = def.resolve(this.classFilename);
        JkLog.info("Create " + buildClass, new Object[0]);
        String code = this.jkClassCodeProvider.get();
        if (code.contains("${jekaVersion}")) {
            String version = JkUtilsString.isBlank(this.wrapperJekaVersion) ? this.jekaVersion() : this.wrapperJekaVersion;
            code = code.replace("${jekaVersion}", version);
        }
        JkUtilsPath.write(buildClass, code.getBytes(Charset.forName("UTF-8")), new OpenOption[0]);
        JkPathFile.of(this.baseDir.resolve("jeka/project.properties")).fetchContentFrom(JkScaffolder.class.getResource("project.properties"));
        JkPathFile.of(this.baseDir.resolve("jeka/cmd.properties")).fetchContentFrom(JkScaffolder.class.getResource("cmd.properties"));
        Path manualHtml = JkLocator.getJekaHomeDir().resolve("doc/reference-guide.html");
        if (Files.exists(manualHtml, new LinkOption[0])) {
            JkPathFile.of(manualHtml).copyToDir(this.baseDir.resolve("jeka"), new CopyOption[0]);
        }
        JkUtilsPath.createDirectories(this.baseDir.resolve("jeka").resolve("boot"), new FileAttribute[0]);
        this.extraActions.run();
    }

    public void wrapper() {
        JkLog.info("Create shell files.", new Object[0]);
        Path jekaBat = JkLocator.getJekaHomeDir().resolve("wrapper/jekaw.bat");
        JkUtilsAssert.state(Files.exists(jekaBat, new LinkOption[0]), "Jeka should be run from an installed version in order to shell scripts", new Object[0]);
        JkUtilsPath.copy(jekaBat, this.baseDir.resolve("jekaw.bat"), StandardCopyOption.REPLACE_EXISTING);
        Path jekawPath = this.baseDir.resolve("jekaw");
        JkUtilsPath.copy(JkLocator.getJekaHomeDir().resolve("wrapper/jekaw"), jekawPath, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
        JkPathFile.of(jekawPath).setPosixExecPermissions(true, true, true);
        Path jekaWrapperJar = JkLocator.getJekaJarPath().getParent().resolve("dev.jeka.jeka-core-wrapper.jar");
        Path wrapperFolder = this.baseDir.resolve("jeka/wrapper");
        JkUtilsPath.createDirectories(wrapperFolder, new FileAttribute[0]);
        Path target = wrapperFolder.resolve(jekaWrapperJar.getFileName());
        JkLog.info("Copy jeka wrapper jar to " + this.baseDir.relativize(target), new Object[0]);
        JkUtilsPath.copy(jekaWrapperJar, target, StandardCopyOption.REPLACE_EXISTING);
        String version = JkUtilsString.isBlank(this.wrapperJekaVersion) ? this.jekaVersion() : this.wrapperJekaVersion;
        Path tempProps = JkUtilsPath.createTempFile("jeka-", ".properties", new FileAttribute[0]);
        Path jekaPropertiesPath = wrapperFolder.resolve("wrapper.properties");
        if (!Files.exists(jekaPropertiesPath, new LinkOption[0])) {
            JkPathFile.of(tempProps).fetchContentFrom(JkScaffolder.class.getResource("wrapper.properties")).copyReplacingTokens(jekaPropertiesPath, JkUtilsIterable.mapOf("${version}", version, new Object[0]), Charset.forName("utf-8")).deleteIfExist();
        }
    }

    public void wrapperWithDelegate(String delegateFolder) {
        JkPathFile newBatFile = JkPathFile.of(this.baseDir.resolve("jekaw.bat"));
        JkPathFile newShellFile = JkPathFile.of(this.baseDir.resolve("jekaw"));
        Path batDelegate = this.baseDir.resolve(delegateFolder).resolve("jekaw.bat");
        if (!Files.exists(batDelegate, new LinkOption[0]) && JkUtilsSystem.IS_WINDOWS) {
            throw new IllegalArgumentException("Cannot find file " + batDelegate);
        }
        String content = delegateFolder + "\\jekaw %*";
        content = content.replace('/', '\\');
        newBatFile.deleteIfExist().createIfNotExist().write(content.getBytes(Charset.forName("utf8")), new OpenOption[0]);
        Path shellDelegate = this.baseDir.resolve(delegateFolder).resolve("jekaw");
        if (!Files.exists(shellDelegate, new LinkOption[0]) && !JkUtilsSystem.IS_WINDOWS) {
            throw new IllegalStateException("Cannot find file " + batDelegate);
        }
        String content2 = "#!/bin/sh\n\n" + delegateFolder.replace('\\', '/') + "/jekaw $@";
        newShellFile.deleteIfExist().createIfNotExist().write(content2.getBytes(Charset.forName("utf8")), new OpenOption[0]).setPosixExecPermissions(true, true, true);
    }

    public void setJekaClassCodeProvider(Supplier<String> codeProvider) {
        this.jkClassCodeProvider = codeProvider;
    }

    public void setClassFilename(String classFilename) {
        this.classFilename = classFilename;
    }

    public JkRunnables getExtraActions() {
        return this.extraActions;
    }

    private String jekaVersion() {
        if (this.cachedJekaVersion != null) {
            return this.cachedJekaVersion;
        }
        List<String> allVersions = this.dependencyResolver.searchVersions(JkModuleId.of("dev.jeka:jeka-core"));
        List versions = allVersions.stream().filter(version -> version.endsWith(".RELEASE")).collect(Collectors.toList());
        if (versions.isEmpty()) {
            JkLog.warn("Didn't find any version of dev.jeka:jeka-core in " + this.dependencyResolver, new Object[0]);
            JkLog.warn("Will use current one : " + JkInfo.getJekaVersion(), new Object[0]);
            return JkInfo.getJekaVersion();
        }
        this.cachedJekaVersion = (String)versions.get(versions.size() - 1);
        return this.cachedJekaVersion;
    }
}

