/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.tool.builtins.scaffold;

import dev.jeka.core.api.depmanagement.JkRepoFromProperties;
import dev.jeka.core.api.depmanagement.resolution.JkDependencyResolver;
import dev.jeka.core.api.function.JkConsumers;
import dev.jeka.core.api.utils.JkUtilsIO;
import dev.jeka.core.api.utils.JkUtilsString;
import dev.jeka.core.tool.JkBean;
import dev.jeka.core.tool.JkDoc;
import dev.jeka.core.tool.builtins.scaffold.JkScaffolder;
import java.util.function.Consumer;

@JkDoc(value={"Generates project skeletons (folder structure and basic build files)."})
public class ScaffoldJkBean
extends JkBean {
    private JkScaffolder scaffolder;
    @JkDoc(value={"If set then the wrapper shell script will delegate 'jekaw' call to jekaw script located in the specified folder"})
    public String wrapDelegatePath;
    @JkDoc(value={"Set the Jeka version to fetch for the wrapper. If null, it will use the same Jeka version than the running one."})
    public String wrapperJekaVersion;
    private JkConsumers<JkScaffolder, Void> configurators = JkConsumers.of();

    protected ScaffoldJkBean() {
        this.scaffolder = new JkScaffolder(this.getBaseDir());
        this.scaffolder.setJekaClassCodeProvider(() -> JkUtilsIO.read(ScaffoldJkBean.class.getResource("buildclass.snippet")));
        JkDependencyResolver<Void> dependencyResolver = JkDependencyResolver.of().addRepos(JkRepoFromProperties.getDownloadRepo().toSet());
        this.scaffolder.setDependencyResolver(dependencyResolver);
    }

    @JkDoc(value={"Generates project skeleton (folders and files necessary to work with the project)."})
    public void run() {
        this.scaffolder.run();
    }

    @JkDoc(value={"Copies Jeka wrapper executable inside the project in order to be run in wrapper mode."})
    public void wrapper() {
        if (JkUtilsString.isBlank(this.wrapDelegatePath)) {
            this.scaffolder.wrapper();
        } else {
            this.scaffolder.wrapperWithDelegate(this.wrapDelegatePath);
        }
    }

    public JkScaffolder getScaffolder() {
        if (this.scaffolder == null) {
            this.scaffolder = this.createScaffolder();
        }
        return this.scaffolder;
    }

    public ScaffoldJkBean configure(Consumer<JkScaffolder> configurator) {
        this.configurators.append(configurator);
        return this;
    }

    private JkScaffolder createScaffolder() {
        JkScaffolder scaffolder = new JkScaffolder(this.getBaseDir());
        scaffolder.setJekaClassCodeProvider(() -> JkUtilsIO.read(ScaffoldJkBean.class.getResource("buildclass.snippet")));
        JkDependencyResolver<Void> dependencyResolver = JkDependencyResolver.of().addRepos(JkRepoFromProperties.getDownloadRepo().toSet());
        scaffolder.setDependencyResolver(dependencyResolver);
        this.configurators.accept(scaffolder);
        return scaffolder;
    }
}

