/*
 * Decompiled with CFR 0.152.
 */
package dev.jordond.compass;

import dev.jordond.compass.Altitude;
import dev.jordond.compass.Azimuth;
import dev.jordond.compass.Coordinates;
import dev.jordond.compass.Speed;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u000e\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Ldev/jordond/compass/Location;", "", "coordinates", "Ldev/jordond/compass/Coordinates;", "accuracy", "", "azimuth", "Ldev/jordond/compass/Azimuth;", "speed", "Ldev/jordond/compass/Speed;", "altitude", "Ldev/jordond/compass/Altitude;", "timestampMillis", "", "(Ldev/jordond/compass/Coordinates;DLdev/jordond/compass/Azimuth;Ldev/jordond/compass/Speed;Ldev/jordond/compass/Altitude;J)V", "getAccuracy", "()D", "getAltitude", "()Ldev/jordond/compass/Altitude;", "getAzimuth", "()Ldev/jordond/compass/Azimuth;", "getCoordinates", "()Ldev/jordond/compass/Coordinates;", "getSpeed", "()Ldev/jordond/compass/Speed;", "getTimestampMillis", "()J", "compass-core"})
public final class Location {
    @NotNull
    private final Coordinates coordinates;
    private final double accuracy;
    @Nullable
    private final Azimuth azimuth;
    @Nullable
    private final Speed speed;
    @Nullable
    private final Altitude altitude;
    private final long timestampMillis;

    public Location(@NotNull Coordinates coordinates, double accuracy, @Nullable Azimuth azimuth, @Nullable Speed speed, @Nullable Altitude altitude, long timestampMillis) {
        Intrinsics.checkNotNullParameter((Object)coordinates, (String)"coordinates");
        this.coordinates = coordinates;
        this.accuracy = accuracy;
        this.azimuth = azimuth;
        this.speed = speed;
        this.altitude = altitude;
        this.timestampMillis = timestampMillis;
    }

    @NotNull
    public final Coordinates getCoordinates() {
        return this.coordinates;
    }

    public final double getAccuracy() {
        return this.accuracy;
    }

    @Nullable
    public final Azimuth getAzimuth() {
        return this.azimuth;
    }

    @Nullable
    public final Speed getSpeed() {
        return this.speed;
    }

    @Nullable
    public final Altitude getAltitude() {
        return this.altitude;
    }

    public final long getTimestampMillis() {
        return this.timestampMillis;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Location)) {
            return false;
        }
        Location location = (Location)other;
        if (!Intrinsics.areEqual((Object)this.coordinates, (Object)location.coordinates)) {
            return false;
        }
        if (Double.compare(this.accuracy, location.accuracy) != 0) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.azimuth, (Object)location.azimuth)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.speed, (Object)location.speed)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.altitude, (Object)location.altitude)) {
            return false;
        }
        return this.timestampMillis == location.timestampMillis;
    }

    public int hashCode() {
        int result = this.coordinates.hashCode();
        result = result * 31 + Double.hashCode(this.accuracy);
        result = result * 31 + (this.azimuth == null ? 0 : this.azimuth.hashCode());
        result = result * 31 + (this.speed == null ? 0 : this.speed.hashCode());
        result = result * 31 + (this.altitude == null ? 0 : this.altitude.hashCode());
        result = result * 31 + Long.hashCode(this.timestampMillis);
        return result;
    }

    @NotNull
    public String toString() {
        return "Location(coordinates=" + this.coordinates + ", accuracy=" + this.accuracy + ", azimuth=" + this.azimuth + ", speed=" + this.speed + ", altitude=" + this.altitude + ", timestampMillis=" + this.timestampMillis + ")";
    }
}

