/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.nms;

import com.google.common.collect.ImmutableList;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import dev.jorel.commandapi.CommandAPI;
import dev.jorel.commandapi.CommandAPIHandler;
import dev.jorel.commandapi.CommandRegistrationStrategy;
import dev.jorel.commandapi.PaperCommandRegistration;
import dev.jorel.commandapi.SafeVarHandle;
import dev.jorel.commandapi.SpigotCommandRegistration;
import dev.jorel.commandapi.arguments.ArgumentSubType;
import dev.jorel.commandapi.arguments.SuggestionProviders;
import dev.jorel.commandapi.commandsenders.AbstractCommandSender;
import dev.jorel.commandapi.commandsenders.BukkitCommandSender;
import dev.jorel.commandapi.commandsenders.BukkitNativeProxyCommandSender;
import dev.jorel.commandapi.nms.NMS_Common;
import dev.jorel.commandapi.wrappers.ComplexRecipeImpl;
import dev.jorel.commandapi.wrappers.FloatRange;
import dev.jorel.commandapi.wrappers.FunctionWrapper;
import dev.jorel.commandapi.wrappers.IntegerRange;
import dev.jorel.commandapi.wrappers.Location2D;
import dev.jorel.commandapi.wrappers.NativeProxyCommandSender;
import dev.jorel.commandapi.wrappers.ParticleData;
import dev.jorel.commandapi.wrappers.ScoreboardSlot;
import dev.jorel.commandapi.wrappers.SimpleFunctionWrapper;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Registry;
import org.bukkit.Server;
import org.bukkit.Vibration;
import org.bukkit.World;
import org.bukkit.advancement.Advancement;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandSender;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.craftbukkit.v1_21_R1.CraftLootTable;
import org.bukkit.craftbukkit.v1_21_R1.CraftParticle;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.CraftSound;
import org.bukkit.craftbukkit.v1_21_R1.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R1.command.BukkitCommandWrapper;
import org.bukkit.craftbukkit.v1_21_R1.command.VanillaCommandWrapper;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R1.help.CustomHelpTopic;
import org.bukkit.craftbukkit.v1_21_R1.help.SimpleHelpMap;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R1.potion.CraftPotionEffectType;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.help.HelpTopic;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.loot.LootTable;

public class NMS_1_21_R1
extends NMS_Common {
    private static final SafeVarHandle<SimpleHelpMap, Map<String, HelpTopic>> helpMapTopics;
    private static final Field entitySelectorUsesSelector;
    private static final Field serverFunctionLibraryDispatcher;
    private static final boolean vanillaCommandDispatcherFieldExists;
    private static final ep COMMAND_BUILD_CONTEXT;

    private static NamespacedKey fromResourceLocation(akr key) {
        return NamespacedKey.fromString((String)(key.b() + ":" + key.a()));
    }

    public final ArgumentType<?> _ArgumentBlockPredicate() {
        return gl.a((ep)COMMAND_BUILD_CONTEXT);
    }

    public final ArgumentType<?> _ArgumentBlockState() {
        return gm.a((ep)COMMAND_BUILD_CONTEXT);
    }

    public ArgumentType<?> _ArgumentChatComponent() {
        return fc.a((ep)COMMAND_BUILD_CONTEXT);
    }

    public final ArgumentType<?> _ArgumentEnchantment() {
        return fs.a((ep)COMMAND_BUILD_CONTEXT, (akq)lu.aL);
    }

    public final ArgumentType<?> _ArgumentEntity(ArgumentSubType subType) {
        return switch (subType) {
            case ArgumentSubType.ENTITYSELECTOR_MANY_ENTITIES -> fg.b();
            case ArgumentSubType.ENTITYSELECTOR_MANY_PLAYERS -> fg.d();
            case ArgumentSubType.ENTITYSELECTOR_ONE_ENTITY -> fg.a();
            case ArgumentSubType.ENTITYSELECTOR_ONE_PLAYER -> fg.c();
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf(subType));
        };
    }

    public final ArgumentType<?> _ArgumentItemPredicate() {
        return hf.a((ep)COMMAND_BUILD_CONTEXT);
    }

    public final ArgumentType<?> _ArgumentItemStack() {
        return hc.a((ep)COMMAND_BUILD_CONTEXT);
    }

    public final ArgumentType<?> _ArgumentParticle() {
        return fq.a((ep)COMMAND_BUILD_CONTEXT);
    }

    public final ArgumentType<?> _ArgumentSyntheticBiome() {
        return fs.a((ep)COMMAND_BUILD_CONTEXT, (akq)lu.aF);
    }

    public final Map<String, HelpTopic> getHelpMap() {
        return (Map)helpMapTopics.get((Object)((SimpleHelpMap)Bukkit.getHelpMap()));
    }

    public String[] compatibleVersions() {
        return new String[]{"1.21", "1.21.1"};
    }

    private static String serializeNMSItemStack(cuq is) {
        return new hd(is.h(), is.d()).a((jo.a)COMMAND_BUILD_CONTEXT);
    }

    public final String convert(ItemStack is) {
        return NMS_1_21_R1.serializeNMSItemStack(CraftItemStack.asNMSCopy((ItemStack)is));
    }

    public final String convert(ParticleData<?> particle) {
        lk particleOptions = CraftParticle.createParticleParam((Particle)particle.particle(), (Object)particle.data());
        akr particleKey = lt.i.b((Object)particleOptions.a());
        Codec codec = particleOptions.a().c().codec();
        DataResult result = codec.encodeStart((DynamicOps)up.a, (Object)particleOptions);
        ub particleOptionsTag = (ub)result.result().get();
        String dataString = particleOptionsTag.e().isEmpty() ? "" : particleOptionsTag.s_();
        return particleKey.toString() + dataString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int runCommandFunction(ig<et> commandFunction, et css) {
        bnf profiler = ((MinecraftServer)this.getMinecraftServer()).aT();
        profiler.a(() -> "function " + String.valueOf(commandFunction.a()));
        AtomicInteger result = new AtomicInteger();
        eq onCommandResult = (succeeded, resultValue) -> result.set(resultValue);
        try {
            ii instantiatedFunction = commandFunction.a((ub)null, this.getBrigadierDispatcher());
            eu.a((et)css, executioncontext -> hs.a((hs)executioncontext, (ii)instantiatedFunction, (ev)css, (eq)onCommandResult));
        }
        catch (ew instantiatedFunction) {
        }
        catch (Exception exception) {
            LogUtils.getLogger().warn("Failed to execute function {}", (Object)commandFunction.a(), (Object)exception);
        }
        finally {
            profiler.c();
        }
        return result.get();
    }

    private final SimpleFunctionWrapper convertFunction(ig<et> commandFunction) {
        ToIntFunction<et> appliedObj = css -> this.runCommandFunction(commandFunction, (et)css);
        String[] commands = new String[]{};
        try {
            ii instantiatedFunction = commandFunction.a((ub)null, this.getBrigadierDispatcher());
            List cArr = instantiatedFunction.b();
            commands = new String[cArr.size()];
            int size = cArr.size();
            for (int i = 0; i < size; ++i) {
                commands[i] = cArr.get(i).toString();
            }
        }
        catch (ew ew2) {
            // empty catch block
        }
        return new SimpleFunctionWrapper(NMS_1_21_R1.fromResourceLocation(commandFunction.a()), appliedObj, commands);
    }

    public final void createDispatcherFile(File file, CommandDispatcher<et> dispatcher) throws IOException {
        Files.asCharSink((File)file, (Charset)StandardCharsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)iq.a(dispatcher, (CommandNode)dispatcher.getRoot())));
    }

    public final HelpTopic generateHelpTopic(String commandName, String shortDescription, String fullDescription, String permission) {
        return new CustomHelpTopic(commandName, shortDescription, fullDescription, permission);
    }

    public Advancement getAdvancement(CommandContext<et> cmdCtx, String key) throws CommandSyntaxException {
        return fu.a(cmdCtx, (String)key).toBukkit();
    }

    public Component getAdventureChat(CommandContext<et> cmdCtx, String key) throws CommandSyntaxException {
        return GsonComponentSerializer.gson().deserialize((Object)wz.a.a((wz)fk.a(cmdCtx, (String)key), (jo.a)COMMAND_BUILD_CONTEXT));
    }

    public NamedTextColor getAdventureChatColor(CommandContext<et> cmdCtx, String key) {
        Integer color = fb.a(cmdCtx, (String)key).f();
        return color == null ? NamedTextColor.WHITE : NamedTextColor.namedColor((int)color);
    }

    public final Component getAdventureChatComponent(CommandContext<et> cmdCtx, String key) {
        return GsonComponentSerializer.gson().deserialize((Object)wz.a.a((wz)fc.a(cmdCtx, (String)key), (jo.a)COMMAND_BUILD_CONTEXT));
    }

    public final Object getBiome(CommandContext<et> cmdCtx, String key, ArgumentSubType subType) throws CommandSyntaxException {
        akr resourceLocation = fs.a(cmdCtx, (String)key, (akq)lu.aF).h().a();
        return switch (subType) {
            case ArgumentSubType.BIOME_BIOME -> {
                Biome biome = null;
                try {
                    biome = Biome.valueOf((String)resourceLocation.a().toUpperCase());
                }
                catch (IllegalArgumentException biomeNotFound) {
                    biome = null;
                }
                Biome var5_7 = biome;
                yield var5_7;
            }
            case ArgumentSubType.BIOME_NAMESPACEDKEY -> {
                NamespacedKey var5_8;
                yield var5_8 = NMS_1_21_R1.fromResourceLocation(resourceLocation);
            }
            default -> {
                NamespacedKey var5_9;
                yield var5_9 = null;
            }
        };
    }

    public final Predicate<Block> getBlockPredicate(CommandContext<et> cmdCtx, String key) throws CommandSyntaxException {
        Predicate predicate = gl.a(cmdCtx, (String)key);
        return block -> predicate.test(new dtg((dcz)((et)cmdCtx.getSource()).e(), new jd(block.getX(), block.getY(), block.getZ()), true));
    }

    public final BlockData getBlockState(CommandContext<et> cmdCtx, String key) {
        return CraftBlockData.fromData((dtc)gm.a(cmdCtx, (String)key).a());
    }

    public et getBrigadierSourceFromCommandSender(AbstractCommandSender<? extends CommandSender> sender) {
        return VanillaCommandWrapper.getListener((CommandSender)((CommandSender)sender.getSource()));
    }

    public final BaseComponent[] getChat(CommandContext<et> cmdCtx, String key) throws CommandSyntaxException {
        return ComponentSerializer.parse((String)wz.a.a((wz)fk.a(cmdCtx, (String)key), (jo.a)COMMAND_BUILD_CONTEXT));
    }

    public final World getDimension(CommandContext<et> cmdCtx, String key) throws CommandSyntaxException {
        return fe.a(cmdCtx, (String)key).getWorld();
    }

    public final Enchantment getEnchantment(CommandContext<et> cmdCtx, String key) throws CommandSyntaxException {
        dac enchantment = (dac)fs.g(cmdCtx, (String)key).a();
        akr resource = ((MinecraftServer)this.getMinecraftServer()).bc().d(lu.aL).b((Object)enchantment);
        return (Enchantment)Registry.ENCHANTMENT.get(NMS_1_21_R1.fromResourceLocation(resource));
    }

    public final Object getEntitySelector(CommandContext<et> cmdCtx, String str, ArgumentSubType subType, boolean allowEmpty) throws CommandSyntaxException {
        Object object;
        hi argument = (hi)cmdCtx.getArgument(str, hi.class);
        try {
            entitySelectorUsesSelector.set(argument, false);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        switch (subType) {
            case ENTITYSELECTOR_MANY_ENTITIES: {
                try {
                    ArrayList<CraftEntity> result = new ArrayList<CraftEntity>();
                    for (bsr entity : argument.b((et)cmdCtx.getSource())) {
                        result.add(entity.getBukkitEntity());
                    }
                    if (result.isEmpty() && !allowEmpty) {
                        throw fg.d.create();
                    }
                    ArrayList<CraftEntity> arrayList = result;
                    object = arrayList;
                    break;
                }
                catch (CommandSyntaxException e) {
                    if (allowEmpty) {
                        ArrayList arrayList = new ArrayList();
                        object = arrayList;
                        break;
                    }
                    throw e;
                }
            }
            case ENTITYSELECTOR_MANY_PLAYERS: {
                try {
                    ArrayList<CraftPlayer> result = new ArrayList<CraftPlayer>();
                    for (aqv player : argument.d((et)cmdCtx.getSource())) {
                        result.add(player.getBukkitEntity());
                    }
                    if (result.isEmpty() && !allowEmpty) {
                        throw fg.e.create();
                    }
                    ArrayList<CraftPlayer> arrayList = result;
                    object = arrayList;
                    break;
                }
                catch (CommandSyntaxException e) {
                    if (allowEmpty) {
                        ArrayList arrayList = new ArrayList();
                        object = arrayList;
                        break;
                    }
                    throw e;
                }
            }
            case ENTITYSELECTOR_ONE_ENTITY: {
                CraftEntity craftEntity;
                object = craftEntity = argument.a((et)cmdCtx.getSource()).getBukkitEntity();
                break;
            }
            case ENTITYSELECTOR_ONE_PLAYER: {
                CraftPlayer craftPlayer = argument.c((et)cmdCtx.getSource()).getBukkitEntity();
                object = craftPlayer;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected value: " + String.valueOf(subType));
            }
        }
        return object;
    }

    public final EntityType getEntityType(CommandContext<et> cmdCtx, String key) throws CommandSyntaxException {
        return EntityType.fromName((String)bsx.a((bsx)((bsx)fs.e(cmdCtx, (String)key).a())).a());
    }

    public FloatRange getFloatRange(CommandContext<et> cmdCtx, String key) {
        dh.c range = fr.a.a(cmdCtx, (String)key);
        Double lowBoxed = range.a().orElse(null);
        Double highBoxed = range.b().orElse(null);
        double low = lowBoxed == null ? -3.4028234663852886E38 : lowBoxed;
        double high = highBoxed == null ? 3.4028234663852886E38 : highBoxed;
        return new FloatRange((float)low, (float)high);
    }

    public final FunctionWrapper[] getFunction(CommandContext<et> cmdCtx, String key) throws CommandSyntaxException {
        ArrayList<FunctionWrapper> result = new ArrayList<FunctionWrapper>();
        et css = ((et)cmdCtx.getSource()).a().b(2);
        for (ig commandFunction : hb.a(cmdCtx, (String)key)) {
            result.add(FunctionWrapper.fromSimpleFunctionWrapper((SimpleFunctionWrapper)this.convertFunction((ig<et>)commandFunction), (Object)css, entity -> ((et)cmdCtx.getSource()).a(((CraftEntity)entity).getHandle())));
        }
        return result.toArray(new FunctionWrapper[0]);
    }

    public SimpleFunctionWrapper getFunction(NamespacedKey key) {
        akr resourceLocation = akr.a((String)key.getNamespace(), (String)key.getKey());
        Optional commandFunctionOptional = ((MinecraftServer)this.getMinecraftServer()).aF().a(resourceLocation);
        if (commandFunctionOptional.isPresent()) {
            return this.convertFunction((ig<et>)((ig)commandFunctionOptional.get()));
        }
        throw new IllegalStateException("Failed to get defined function " + String.valueOf(key) + "! This should never happen - please report this to the CommandAPIdevelopers, we'd love to know how you got this error message!");
    }

    public Set<NamespacedKey> getFunctions() {
        HashSet<NamespacedKey> result = new HashSet<NamespacedKey>();
        for (akr resourceLocation : ((MinecraftServer)this.getMinecraftServer()).aF().d()) {
            result.add(NMS_1_21_R1.fromResourceLocation(resourceLocation));
        }
        return result;
    }

    public IntegerRange getIntRange(CommandContext<et> cmdCtx, String key) {
        dh.d range = fr.b.a(cmdCtx, (String)key);
        Integer lowBoxed = range.a().orElse(null);
        Integer highBoxed = range.b().orElse(null);
        int low = lowBoxed == null ? Integer.MIN_VALUE : lowBoxed;
        int high = highBoxed == null ? Integer.MAX_VALUE : highBoxed;
        return new IntegerRange(low, high);
    }

    public final ItemStack getItemStack(CommandContext<et> cmdCtx, String key) throws CommandSyntaxException {
        hd input = hc.a(cmdCtx, (String)key);
        cuq item = input.a(1, false);
        return CraftItemStack.asBukkitCopy((cuq)item);
    }

    public final Predicate<ItemStack> getItemStackPredicate(CommandContext<et> cmdCtx, String key) throws CommandSyntaxException {
        hf.d predicate = hf.a(cmdCtx, (String)key);
        return arg_0 -> NMS_1_21_R1.lambda$getItemStackPredicate$6((Predicate)predicate, arg_0);
    }

    public final Location2D getLocation2DBlock(CommandContext<et> cmdCtx, String key) throws CommandSyntaxException {
        aqi blockPos = gq.a(cmdCtx, (String)key);
        return new Location2D(this.getWorldForCSS((et)cmdCtx.getSource()), (double)blockPos.c(), (double)blockPos.d());
    }

    public final Location2D getLocation2DPrecise(CommandContext<et> cmdCtx, String key) throws CommandSyntaxException {
        exb vecPos = gv.a(cmdCtx, (String)key);
        return new Location2D(this.getWorldForCSS((et)cmdCtx.getSource()), (double)vecPos.i, (double)vecPos.j);
    }

    public final Location getLocationBlock(CommandContext<et> cmdCtx, String key) throws CommandSyntaxException {
        jd blockPos = gp.c(cmdCtx, (String)key);
        return new Location(this.getWorldForCSS((et)cmdCtx.getSource()), (double)blockPos.u(), (double)blockPos.v(), (double)blockPos.w());
    }

    public final Location getLocationPrecise(CommandContext<et> cmdCtx, String key) throws CommandSyntaxException {
        exc vecPos = gw.b(cmdCtx, (String)key).a((et)cmdCtx.getSource());
        return new Location(this.getWorldForCSS((et)cmdCtx.getSource()), vecPos.a(), vecPos.b(), vecPos.c());
    }

    public final LootTable getLootTable(CommandContext<et> cmdCtx, String key) {
        return CraftLootTable.minecraftToBukkit((akr)fu.c(cmdCtx, (String)key));
    }

    public NamespacedKey getMinecraftKey(CommandContext<et> cmdCtx, String key) {
        return NMS_1_21_R1.fromResourceLocation(fu.c(cmdCtx, (String)key));
    }

    public final ParticleData<?> getParticle(CommandContext<et> cmdCtx, String key) {
        Particle particle;
        lk particleOptions = fq.a(cmdCtx, (String)key);
        Server server = Bukkit.getServer();
        if (server instanceof CraftServer) {
            CraftServer server2 = (CraftServer)server;
            particle = CraftParticle.minecraftToBukkit((ll)particleOptions.a());
        } else {
            particle = null;
        }
        if (particleOptions instanceof lq) {
            return new ParticleData(particle, null);
        }
        if (particleOptions instanceof le) {
            le options = (le)particleOptions;
            return new ParticleData(particle, (Object)CraftBlockData.fromData((dtc)options.b()));
        }
        if (particleOptions instanceof lg) {
            lg options = (lg)particleOptions;
            return this.getParticleDataAsDustColorTransitionOption(particle, options);
        }
        if (particleOptions instanceof lh) {
            lh options = (lh)particleOptions;
            Color color = Color.fromRGB((int)((int)(options.b().x() * 255.0f)), (int)((int)(options.b().y() * 255.0f)), (int)((int)(options.b().z() * 255.0f)));
            return new ParticleData(particle, (Object)new Particle.DustOptions(color, options.d()));
        }
        if (particleOptions instanceof li) {
            li options = (li)particleOptions;
            return new ParticleData(particle, (Object)CraftItemStack.asBukkitCopy((cuq)options.b()));
        }
        if (particleOptions instanceof lr) {
            lr options = (lr)particleOptions;
            return this.getParticleDataAsVibrationParticleOption(cmdCtx, particle, options);
        }
        if (particleOptions instanceof lp) {
            lp options = (lp)particleOptions;
            return new ParticleData(particle, (Object)options.b());
        }
        if (particleOptions instanceof lo) {
            lo options = (lo)particleOptions;
            return new ParticleData(particle, (Object)Float.valueOf(options.b()));
        }
        if (particleOptions instanceof lf) {
            lf options = (lf)particleOptions;
            return this.getParticleDataAsColorParticleOption(particle, options);
        }
        CommandAPI.getLogger().warning("Invalid particle data type for " + particle.getDataType().toString());
        return new ParticleData(particle, null);
    }

    private ParticleData<Color> getParticleDataAsColorParticleOption(Particle particle, lf options) {
        Color color = Color.fromARGB((int)((int)(options.e() * 255.0f)), (int)((int)(options.b() * 255.0f)), (int)((int)(options.c() * 255.0f)), (int)((int)(options.d() * 255.0f)));
        return new ParticleData(particle, (Object)color);
    }

    private ParticleData<Particle.DustTransition> getParticleDataAsDustColorTransitionOption(Particle particle, lg options) {
        Color color = Color.fromRGB((int)((int)(options.b().x() * 255.0f)), (int)((int)(options.b().y() * 255.0f)), (int)((int)(options.b().z() * 255.0f)));
        Color toColor = Color.fromRGB((int)((int)(options.c().x() * 255.0f)), (int)((int)(options.c().y() * 255.0f)), (int)((int)(options.c().z() * 255.0f)));
        return new ParticleData(particle, (Object)new Particle.DustTransition(color, toColor, options.d()));
    }

    private ParticleData<?> getParticleDataAsVibrationParticleOption(CommandContext<et> cmdCtx, Particle particle, lr options) {
        exc origin = ((et)cmdCtx.getSource()).d();
        aqu level = ((et)cmdCtx.getSource()).e();
        Location from = new Location((World)level.getWorld(), origin.c, origin.d, origin.e);
        dyd dyd2 = options.b();
        if (!(dyd2 instanceof dxv)) {
            CommandAPI.getLogger().warning("Unknown or unsupported vibration destination " + String.valueOf(options.b()));
            return new ParticleData(particle, null);
        }
        dxv positionSource = (dxv)dyd2;
        exc to = (exc)positionSource.a((dcw)level).get();
        Vibration.Destination.BlockDestination destination = new Vibration.Destination.BlockDestination(new Location((World)level.getWorld(), to.a(), to.b(), to.c()));
        return new ParticleData(particle, (Object)new Vibration(from, (Vibration.Destination)destination, options.c()));
    }

    public Object getPotionEffect(CommandContext<et> cmdCtx, String key, ArgumentSubType subType) throws CommandSyntaxException {
        return switch (subType) {
            case ArgumentSubType.POTION_EFFECT_POTION_EFFECT -> CraftPotionEffectType.minecraftToBukkit((brx)((brx)fs.f(cmdCtx, (String)key).a()));
            case ArgumentSubType.POTION_EFFECT_NAMESPACEDKEY -> NMS_1_21_R1.fromResourceLocation(fu.c(cmdCtx, (String)key));
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf(subType));
        };
    }

    public final Recipe getRecipe(CommandContext<et> cmdCtx, String key) throws CommandSyntaxException {
        czb recipe = fu.b(cmdCtx, (String)key);
        return new ComplexRecipeImpl(NMS_1_21_R1.fromResourceLocation(recipe.a()), recipe.toBukkitRecipe());
    }

    public ScoreboardSlot getScoreboardSlot(CommandContext<et> cmdCtx, String key) {
        return ScoreboardSlot.ofMinecraft((int)fz.a(cmdCtx, (String)key).a());
    }

    public Collection<String> getScoreHolderMultiple(CommandContext<et> cmdCtx, String key) throws CommandSyntaxException {
        Collection scoreHolders = fy.b(cmdCtx, (String)key);
        HashSet<String> scoreHolderNames = new HashSet<String>();
        for (eyf scoreHolder : scoreHolders) {
            scoreHolderNames.add(scoreHolder.cB());
        }
        return scoreHolderNames;
    }

    public String getScoreHolderSingle(CommandContext<et> cmdCtx, String key) throws CommandSyntaxException {
        return fy.a(cmdCtx, (String)key).cB();
    }

    public BukkitCommandSender<? extends CommandSender> getSenderForCommand(CommandContext<et> cmdCtx, boolean isNative) {
        CraftEntity proxy;
        et css = (et)cmdCtx.getSource();
        CommandSender sender = css.getBukkitSender();
        if (sender == null) {
            sender = Bukkit.getConsoleSender();
        }
        exc pos = css.d();
        exb rot = css.k();
        World world = this.getWorldForCSS(css);
        Location location = new Location(world, pos.a(), pos.b(), pos.c(), rot.j, rot.i);
        bsr proxyEntity = css.f();
        CraftEntity craftEntity = proxy = proxyEntity == null ? null : proxyEntity.getBukkitEntity();
        if (isNative || proxy != null && !sender.equals((Object)proxy)) {
            if (proxy == null) {
                proxy = sender;
            }
            return new BukkitNativeProxyCommandSender(new NativeProxyCommandSender(sender, (CommandSender)proxy, location, world));
        }
        return this.wrapCommandSender(sender);
    }

    public final SimpleCommandMap getSimpleCommandMap() {
        return ((CraftServer)Bukkit.getServer()).getCommandMap();
    }

    public final Object getSound(CommandContext<et> cmdCtx, String key, ArgumentSubType subType) {
        akr soundResource = fu.c(cmdCtx, (String)key);
        return switch (subType) {
            case ArgumentSubType.SOUND_SOUND -> {
                avo soundEvent = (avo)lt.b.a(soundResource);
                if (soundEvent == null) {
                    yield null;
                }
                yield CraftSound.minecraftToBukkit((avo)soundEvent);
            }
            case ArgumentSubType.SOUND_NAMESPACEDKEY -> NamespacedKey.fromString((String)(soundResource.b() + ":" + soundResource.a()));
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf(subType));
        };
    }

    public SuggestionProvider<et> getSuggestionProvider(SuggestionProviders provider) {
        return switch (provider) {
            case SuggestionProviders.FUNCTION -> (context, builder) -> {
                alg functionData = ((MinecraftServer)this.getMinecraftServer()).aF();
                ey.a((Iterable)functionData.e(), (SuggestionsBuilder)builder, (String)"#");
                return ey.a((Iterable)functionData.d(), (SuggestionsBuilder)builder);
            };
            case SuggestionProviders.RECIPES -> is.b;
            case SuggestionProviders.SOUNDS -> is.c;
            case SuggestionProviders.ADVANCEMENTS -> (cmdCtx, builder) -> ey.a(((MinecraftServer)this.getMinecraftServer()).aE().b().stream().map(ag::a), (SuggestionsBuilder)builder);
            case SuggestionProviders.LOOT_TABLES -> (cmdCtx, builder) -> ey.a((Iterable)((MinecraftServer)this.getMinecraftServer()).be().a(lu.bc), (SuggestionsBuilder)builder);
            case SuggestionProviders.BIOMES -> (arg_0, arg_1) -> this._ArgumentSyntheticBiome().listSuggestions(arg_0, arg_1);
            case SuggestionProviders.ENTITIES -> is.d;
            default -> (context, builder) -> Suggestions.empty();
        };
    }

    public final SimpleFunctionWrapper[] getTag(NamespacedKey key) {
        Collection customFunctions = ((MinecraftServer)this.getMinecraftServer()).aF().b(akr.a((String)key.getNamespace(), (String)key.getKey()));
        SimpleFunctionWrapper[] convertedCustomFunctions = new SimpleFunctionWrapper[customFunctions.size()];
        int index = 0;
        for (ig customFunction : customFunctions) {
            convertedCustomFunctions[index++] = this.convertFunction((ig<et>)customFunction);
        }
        return convertedCustomFunctions;
    }

    public Set<NamespacedKey> getTags() {
        HashSet<NamespacedKey> result = new HashSet<NamespacedKey>();
        for (akr resourceLocation : ((MinecraftServer)this.getMinecraftServer()).aF().e()) {
            result.add(NMS_1_21_R1.fromResourceLocation(resourceLocation));
        }
        return result;
    }

    public World getWorldForCSS(et css) {
        return css.e() == null ? null : css.e().getWorld();
    }

    public final void reloadDataPacks() {
        CommandAPI.logNormal((String)"Reloading datapacks...");
        Iterator recipes = Bukkit.recipeIterator();
        MinecraftServer.a serverResources = ((MinecraftServer)this.getMinecraftServer()).az;
        serverResources.b().e = ((MinecraftServer)this.getMinecraftServer()).aH();
        try {
            serverFunctionLibraryDispatcher.set(serverResources.b().a(), this.getBrigadierDispatcher());
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        ArrayList<String> packIDs = new ArrayList<String>(((MinecraftServer)this.getMinecraftServer()).aG().d());
        List disabledPacks = ((MinecraftServer)this.getMinecraftServer()).bb().D().a().b();
        for (String availablePack : ((MinecraftServer)this.getMinecraftServer()).aG().b()) {
            if (disabledPacks.contains(availablePack) || packIDs.contains(availablePack)) continue;
            packIDs.add(availablePack);
        }
        ArrayList<String> collection = packIDs;
        CompletableFuture<List> first = CompletableFuture.supplyAsync(() -> {
            atp serverPackRepository = ((MinecraftServer)this.getMinecraftServer()).aG();
            ArrayList<asq> packResources = new ArrayList<asq>();
            for (String packID : collection) {
                atm pack = serverPackRepository.c(packID);
                if (pack == null) continue;
                packResources.add(pack.f());
            }
            return packResources;
        });
        CompletionStage second = first.thenCompose(packResources -> {
            atx resourceManager = new atx(ass.b, packResources);
            CompletableFuture simpleReloadInstance = auk.a((aue)resourceManager, (List)serverResources.b().f(), (Executor)((MinecraftServer)this.getMinecraftServer()).ax, (Executor)((Executor)this.getMinecraftServer()), CompletableFuture.completedFuture(azs.a), (boolean)LogUtils.getLogger().isDebugEnabled()).a();
            return simpleReloadInstance.thenApply(x -> serverResources);
        });
        CompletionStage third = ((CompletableFuture)second).thenAcceptAsync(resources -> {
            ((MinecraftServer)this.getMinecraftServer()).az.close();
            ((MinecraftServer)this.getMinecraftServer()).az = serverResources;
            ((MinecraftServer)this.getMinecraftServer()).server.syncCommands();
            ((MinecraftServer)this.getMinecraftServer()).aG().b(collection);
            Collection selectedIDs = ((MinecraftServer)this.getMinecraftServer()).aG().d();
            ImmutableList enabledIDs = ImmutableList.copyOf((Collection)selectedIDs);
            ArrayList<String> disabledIDs = new ArrayList<String>(((MinecraftServer)this.getMinecraftServer()).aG().b());
            disabledIDs.removeIf(((List)enabledIDs)::contains);
            ((MinecraftServer)this.getMinecraftServer()).bb().a(new ddr(new dck((List)enabledIDs, disabledIDs), ((MinecraftServer)this.getMinecraftServer()).bb().D().b()));
            ((MinecraftServer)this.getMinecraftServer()).az.b().g();
            ((MinecraftServer)this.getMinecraftServer()).ba().a((aue)((MinecraftServer)this.getMinecraftServer()).az.a());
        });
        if (((MinecraftServer)this.getMinecraftServer()).bx()) {
            ((MinecraftServer)this.getMinecraftServer()).b(((CompletableFuture)third)::isDone);
        }
        try {
            this.registerBukkitRecipesSafely(recipes);
            CommandAPI.logNormal((String)"Finished reloading datapacks");
        }
        catch (Exception e) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            e.printStackTrace(printWriter);
            CommandAPI.logError((String)("Failed to load datapacks, can't proceed with normal server load procedure. Try fixing your datapacks?\n" + stringWriter.toString()));
        }
    }

    public Message generateMessageFromJson(String json) {
        return wz.a.a((String)json, (jo.a)COMMAND_BUILD_CONTEXT);
    }

    public <T> T getMinecraftServer() {
        Server server = Bukkit.getServer();
        if (server instanceof CraftServer) {
            CraftServer server2 = (CraftServer)server;
            return (T)server2.getServer();
        }
        return null;
    }

    public ArgumentType<?> _ArgumentMobEffect() {
        return fs.a((ep)COMMAND_BUILD_CONTEXT, (akq)lu.W);
    }

    public ArgumentType<?> _ArgumentEntitySummon() {
        return fs.a((ep)COMMAND_BUILD_CONTEXT, (akq)lu.z);
    }

    public CommandRegistrationStrategy<et> createCommandRegistrationStrategy() {
        Class<?> bukkitCommandNode_bukkitBrigCommand;
        if (vanillaCommandDispatcherFieldExists) {
            return new SpigotCommandRegistration(((MinecraftServer)this.getMinecraftServer()).vanillaCommandDispatcher.a(), (SimpleCommandMap)this.getPaper().getCommandMap(), () -> ((MinecraftServer)this.getMinecraftServer()).aH().a(), command -> command instanceof VanillaCommandWrapper, node -> new VanillaCommandWrapper(((MinecraftServer)this.getMinecraftServer()).vanillaCommandDispatcher, node), node -> node.getCommand() instanceof BukkitCommandWrapper);
        }
        try {
            bukkitCommandNode_bukkitBrigCommand = Class.forName("io.papermc.paper.command.brigadier.bukkit.BukkitCommandNode$BukkitBrigCommand");
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Expected to find class", e);
        }
        return new PaperCommandRegistration(() -> ((MinecraftServer)this.getMinecraftServer()).aH().a(), node -> bukkitCommandNode_bukkitBrigCommand.isInstance(node.getCommand()));
    }

    private static /* synthetic */ boolean lambda$getItemStackPredicate$6(Predicate predicate, ItemStack item) {
        return predicate.test(CraftItemStack.asNMSCopy((ItemStack)item));
    }

    static {
        boolean fieldExists;
        Server server = Bukkit.getServer();
        if (server instanceof CraftServer) {
            CraftServer server2 = (CraftServer)server;
            COMMAND_BUILD_CONTEXT = ep.a((jo.a)server2.getServer().bc(), (cpl)server2.getServer().bb().D().b());
        } else {
            COMMAND_BUILD_CONTEXT = null;
        }
        helpMapTopics = SafeVarHandle.ofOrNull(SimpleHelpMap.class, (String)"helpTopics", (String)"helpTopics", Map.class);
        entitySelectorUsesSelector = CommandAPIHandler.getField(hi.class, (String)"p", (String)"usesSelector");
        serverFunctionLibraryDispatcher = CommandAPIHandler.getField(alf.class, (String)"h", (String)"dispatcher");
        try {
            MinecraftServer.class.getDeclaredField("vanillaCommandDispatcher");
            fieldExists = true;
        }
        catch (NoSuchFieldException | SecurityException e) {
            fieldExists = false;
        }
        vanillaCommandDispatcherFieldExists = fieldExists;
    }
}

