/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.arguments;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.jorel.commandapi.ArgumentTree;
import dev.jorel.commandapi.CommandPermission;
import dev.jorel.commandapi.IStringTooltip;
import dev.jorel.commandapi.SuggestionInfo;
import dev.jorel.commandapi.arguments.ArgumentSuggestions;
import dev.jorel.commandapi.arguments.CommandAPIArgumentType;
import dev.jorel.commandapi.nms.NMS;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import org.bukkit.command.CommandSender;

public abstract class Argument<T>
extends ArgumentTree {
    private final String nodeName;
    private final ArgumentType<?> rawType;
    private Optional<ArgumentSuggestions> suggestions = Optional.empty();
    private Optional<ArgumentSuggestions> addedSuggestions = Optional.empty();
    private CommandPermission permission = CommandPermission.NONE;
    private Predicate<CommandSender> requirements = s -> true;
    private boolean isListed = true;

    public abstract Class<T> getPrimitiveType();

    public abstract CommandAPIArgumentType getArgumentType();

    protected Argument(String nodeName, ArgumentType<?> rawType) {
        this.nodeName = nodeName;
        this.rawType = rawType;
    }

    public final ArgumentType<?> getRawType() {
        return this.rawType;
    }

    public final String getNodeName() {
        return this.nodeName;
    }

    public abstract <CommandSourceStack> T parseArgument(NMS<CommandSourceStack> var1, CommandContext<CommandSourceStack> var2, String var3) throws CommandSyntaxException;

    public Argument<T> includeSuggestions(ArgumentSuggestions suggestions) {
        this.addedSuggestions = Optional.of(suggestions);
        return this;
    }

    @Deprecated(forRemoval=true)
    public Argument<T> includeSuggestions(Function<SuggestionInfo, String[]> suggestions) {
        return this.includeSuggestions(ArgumentSuggestions.strings(suggestions));
    }

    @Deprecated(forRemoval=true)
    public Argument<T> includeSuggestionsT(Function<SuggestionInfo, IStringTooltip[]> suggestions) {
        return this.includeSuggestions(ArgumentSuggestions.stringsWithTooltips(suggestions));
    }

    public Optional<ArgumentSuggestions> getIncludedSuggestions() {
        return this.addedSuggestions;
    }

    public Argument<T> replaceSuggestions(ArgumentSuggestions suggestions) {
        this.suggestions = Optional.of(suggestions);
        return this;
    }

    @Deprecated(forRemoval=true)
    public Argument<T> replaceSuggestions(Function<SuggestionInfo, String[]> suggestions) {
        return this.replaceSuggestions(ArgumentSuggestions.strings(suggestions));
    }

    @Deprecated(forRemoval=true)
    public Argument<T> replaceSuggestionsT(Function<SuggestionInfo, IStringTooltip[]> suggestions) {
        return this.replaceSuggestions(ArgumentSuggestions.stringsWithTooltips(suggestions));
    }

    public final Optional<ArgumentSuggestions> getOverriddenSuggestions() {
        return this.suggestions;
    }

    public final Argument<T> withPermission(CommandPermission permission) {
        this.permission = permission;
        return this;
    }

    public final Argument<T> withPermission(String permission) {
        this.permission = CommandPermission.fromString(permission);
        return this;
    }

    public final CommandPermission getArgumentPermission() {
        return this.permission;
    }

    public final Predicate<CommandSender> getRequirements() {
        return this.requirements;
    }

    public final Argument<T> withRequirement(Predicate<CommandSender> requirement) {
        this.requirements = this.requirements.and(requirement);
        return this;
    }

    public boolean isListed() {
        return this.isListed;
    }

    public Argument<T> setListed(boolean listed) {
        this.isListed = listed;
        return this;
    }
}

