/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi;

import dev.jorel.commandapi.CommandPermission;
import dev.jorel.commandapi.exceptions.InvalidCommandNameException;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Predicate;
import org.bukkit.command.CommandSender;

final class CommandMetaData {
    final String commandName;
    CommandPermission permission = CommandPermission.NONE;
    String[] aliases = new String[0];
    Predicate<CommandSender> requirements = s -> true;
    Optional<String> shortDescription = Optional.empty();
    Optional<String> fullDescription = Optional.empty();

    CommandMetaData(String commandName) {
        if (commandName == null || commandName.isEmpty() || commandName.contains(" ")) {
            throw new InvalidCommandNameException(commandName);
        }
        this.commandName = commandName;
    }

    public CommandMetaData(CommandMetaData original) {
        this(original.commandName);
        this.permission = original.permission;
        this.aliases = Arrays.copyOf(original.aliases, original.aliases.length);
        this.requirements = original.requirements;
        this.shortDescription = original.shortDescription.isPresent() ? Optional.of(original.shortDescription.get()) : Optional.empty();
        this.fullDescription = original.fullDescription.isPresent() ? Optional.of(original.fullDescription.get()) : Optional.empty();
    }
}

