/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.arguments;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.jorel.commandapi.CommandAPI;
import dev.jorel.commandapi.CommandAPIHandler;
import dev.jorel.commandapi.arguments.CommandAPIArgumentType;
import dev.jorel.commandapi.arguments.SafeOverrideableArgument;
import dev.jorel.commandapi.nms.NMS;

public class NBTCompoundArgument<NBTContainer>
extends SafeOverrideableArgument<NBTContainer, NBTContainer> {
    public NBTCompoundArgument(String nodeName) {
        super(nodeName, CommandAPIHandler.getInstance().getNMS()._ArgumentNBTCompound(), Object::toString);
        if (CommandAPI.getConfiguration().getNBTContainerClass() == null || CommandAPI.getConfiguration().getNBTContainerConstructor() == null) {
            throw new NullPointerException("The NBTCompoundArgument hasn't been initialized properly! Use CommandAPIConfig.initializeNBTAPI() in your onLoad() method");
        }
    }

    @Override
    public Class<NBTContainer> getPrimitiveType() {
        return CommandAPI.getConfiguration().getNBTContainerClass();
    }

    @Override
    public CommandAPIArgumentType getArgumentType() {
        return CommandAPIArgumentType.NBT_COMPOUND;
    }

    @Override
    public <CommandListenerWrapper> NBTContainer parseArgument(NMS<CommandListenerWrapper> nms, CommandContext<CommandListenerWrapper> cmdCtx, String key, Object[] previousArgs) throws CommandSyntaxException {
        return (NBTContainer)nms.getNBTCompound(cmdCtx, key, CommandAPI.getConfiguration().getNBTContainerConstructor());
    }
}

