/*
 * Decompiled with CFR 0.152.
 */
package dev.katsute.mal4j;

import dev.katsute.mal4j.APIStruct;
import dev.katsute.mal4j.Json;
import dev.katsute.mal4j.Logging;
import dev.katsute.mal4j.Regex9;
import dev.katsute.mal4j.exception.ReflectedClassException;
import dev.katsute.mal4j.exception.StaticInitializerException;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

class APICall {
    private final String method;
    private final String baseURL;
    private final String path;
    private final Map<String, String> headers = new HashMap<String, String>();
    private static final Pattern pathArg;
    private final Map<String, String> pathVars = new HashMap<String, String>();
    private final Map<String, String> queries = new HashMap<String, String>();
    private boolean formUrlEncoded = false;
    private final Map<String, String> fields = new HashMap<String, String>();
    private static final boolean useNetHttp;
    private static final Pattern blockedURI;
    private static final URIEncoder encoder;
    private static final String UTF8;

    APICall(String method, String baseURL, String path) {
        this.method = method;
        this.baseURL = baseURL;
        this.path = path;
    }

    APICall(String baseURL, Method method, Object ... args) {
        this.baseURL = baseURL;
        APIStruct.Endpoint endpoint = method.getAnnotation(APIStruct.Endpoint.class);
        if (endpoint != null) {
            this.method = endpoint.method();
            this.path = endpoint.value();
        } else {
            this.method = "GET";
            this.path = "";
        }
        if (method.getAnnotation(APIStruct.FormUrlEncoded.class) != null) {
            this.formUrlEncoded = true;
        }
        int size = method.getParameterAnnotations().length;
        for (int i = 0; i < size; ++i) {
            Object arg = args[i];
            for (Annotation annotation : method.getParameterAnnotations()[i]) {
                if (arg == null) continue;
                Class<? extends Annotation> type = annotation.annotationType();
                if (type == APIStruct.Path.class) {
                    this.withPathVar(((APIStruct.Path)annotation).value(), arg, ((APIStruct.Path)annotation).encoded());
                    continue;
                }
                if (type == APIStruct.Header.class) {
                    this.withHeader(((APIStruct.Header)annotation).value(), Objects.toString(arg));
                    continue;
                }
                if (type == APIStruct.Query.class) {
                    this.withQuery(((APIStruct.Query)annotation).value(), arg, ((APIStruct.Query)annotation).encoded());
                    continue;
                }
                if (type != APIStruct.Field.class) continue;
                this.withField(((APIStruct.Field)annotation).value(), arg, ((APIStruct.Field)annotation).encoded());
            }
        }
    }

    final APICall withHeader(String header, String value) {
        if (value == null) {
            this.headers.remove(header);
        } else {
            this.headers.put(header, value);
        }
        return this;
    }

    final APICall withPathVar(String pathVar, String value) {
        return this.withPathVar(pathVar, value, false);
    }

    final APICall withPathVar(String pathVar, Object value, boolean encoded) {
        if (value == null) {
            this.pathVars.remove(pathVar);
        } else {
            this.pathVars.put(pathVar, encoded ? Objects.toString(value) : APICall.encodeUTF8(Objects.toString(value)));
        }
        return this;
    }

    final APICall withQuery(String query, Object value) {
        return this.withQuery(query, value, false);
    }

    final APICall withQuery(String query, Object value, boolean encoded) {
        if (value == null) {
            this.queries.remove(query);
        } else {
            this.queries.put(query, encoded ? Objects.toString(value) : APICall.encodeUTF8(Objects.toString(value)));
        }
        return this;
    }

    final APICall formUrlEncoded() {
        return this.formUrlEncoded(true);
    }

    final APICall formUrlEncoded(boolean formUrlEncoded) {
        this.formUrlEncoded = formUrlEncoded;
        return this;
    }

    final APICall withField(String field, Object value) {
        return this.withField(field, value, false);
    }

    final APICall withField(String field, Object value, boolean encoded) {
        if (value == null) {
            this.fields.remove(field);
        } else {
            this.fields.put(field, encoded ? Objects.toString(value) : APICall.encodeUTF8(Objects.toString(value)));
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private APIStruct.Response<String> call() throws IOException, InterruptedException {
        int code;
        String body;
        String URL2 = this.baseURL + Regex9.replaceAll(this.path, pathArg.matcher(this.path), result -> this.pathVars.get(result.group(1))) + (this.queries.isEmpty() ? "" : '?' + this.queries.entrySet().stream().map(e -> (String)e.getKey() + '=' + (String)e.getValue()).collect(Collectors.joining("&")));
        String data = this.fields.isEmpty() ? "" : this.fields.entrySet().stream().map(e -> (String)e.getKey() + '=' + (String)e.getValue()).collect(Collectors.joining("&"));
        Logging.debug();
        Logging.debug("-- BEGIN CONNECTION ------------------------------");
        Logging.debug("\u25bc Request");
        Logging.debug("\tURL: " + URL2);
        Logging.debug("\tMethod: " + this.method.toUpperCase());
        if (!this.headers.entrySet().isEmpty()) {
            Logging.debug("\t\u25bc Headers");
            for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                Logging.debug("\t\t" + entry.getKey() + ": " + entry.getValue());
            }
        }
        if (this.formUrlEncoded) {
            Logging.debug("\tBody:");
            Logging.debug("\t\t" + data);
        }
        if (useNetHttp) {
            try {
                Object HttpRequestBuilder_Instance = JDK11.HttpRequest_NewBuilder.invoke(null, new Object[0]);
                JDK11.HttpRequestBuilder_URI.invoke(HttpRequestBuilder_Instance, URI.create(Regex9.replaceAll(URL2, blockedURI.matcher(URL2), encoder)));
                JDK11.HttpRequestBuilder_Method.invoke(HttpRequestBuilder_Instance, this.method, JDK11.BodyPublishers_NoBody.invoke(null, new Object[0]));
                for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                    JDK11.HttpRequestBuilder_Header.invoke(HttpRequestBuilder_Instance, entry.getKey(), entry.getValue());
                }
                JDK11.HttpRequestBuilder_Header.invoke(HttpRequestBuilder_Instance, "Cache-Control", "no-cache, no-store, must-revalidate");
                JDK11.HttpRequestBuilder_Header.invoke(HttpRequestBuilder_Instance, "Accept", "application/json; charset=UTF-8");
                if (this.formUrlEncoded) {
                    JDK11.HttpRequestBuilder_Header.invoke(HttpRequestBuilder_Instance, "Content-Type", "application/x-www-form-urlencoded");
                    JDK11.HttpRequestBuilder_Method.invoke(HttpRequestBuilder_Instance, this.method, JDK11.BodyPublishers_StringBody.invoke(null, data));
                }
                Object HttpClientBuilder_Instance = JDK11.HttpClient_NewBuilder.invoke(null, new Object[0]);
                JDK11.HttpClientBuilder_ConnectTimeout.invoke(HttpClientBuilder_Instance, Duration.ofSeconds(10L));
                Object HttpClient_Instance = JDK11.HttpClientBuilder_Build.invoke(HttpClientBuilder_Instance, new Object[0]);
                Object HttpResponse_Instance = JDK11.HttpClient_Send.invoke(HttpClient_Instance, JDK11.HttpRequestBuilder_Build.invoke(HttpRequestBuilder_Instance, new Object[0]), JDK11.BodyHandlers_StringBody.invoke(null, StandardCharsets.UTF_8));
                body = (String)JDK11.HttpResponse_Body.invoke(HttpResponse_Instance, new Object[0]);
                code = (Integer)JDK11.HttpResponse_Code.invoke(HttpResponse_Instance, new Object[0]);
            }
            catch (ClassCastException | IllegalAccessException | InvocationTargetException e2) {
                throw new ReflectedClassException("Failed to use reflected HttpClient, please report this to the maintainers of Mal4J", e2);
            }
        }
        HttpURLConnection conn = (HttpURLConnection)URI.create(Regex9.replaceAll(URL2, blockedURI.matcher(URL2), encoder)).toURL().openConnection();
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            conn.setRequestProperty(entry.getKey(), entry.getValue());
        }
        conn.setRequestProperty("Cache-Control", "no-cache, no-store, must-revalidate");
        conn.setRequestProperty("Accept", "application/json; charset=UTF-8");
        conn.setConnectTimeout(10000);
        conn.setReadTimeout(10000);
        try {
            conn.setRequestMethod(this.method);
        }
        catch (ProtocolException ignored) {
            conn.setRequestMethod("POST");
            conn.setRequestProperty("X-HTTP-Method-Override", "PATCH");
        }
        if (this.formUrlEncoded) {
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            conn.setDoOutput(true);
            try (DataOutputStream OUT = new DataOutputStream(conn.getOutputStream());){
                OUT.writeBytes(data);
                OUT.flush();
            }
        }
        try (BufferedReader IN = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));){
            String buffer;
            StringBuilder OUT = new StringBuilder();
            while ((buffer = IN.readLine()) != null) {
                OUT.append(buffer);
            }
            body = OUT.toString();
        }
        catch (IOException ignored) {
            body = "{}";
        }
        finally {
            conn.disconnect();
        }
        code = conn.getResponseCode();
        Logging.debug("\u25bc Response");
        Logging.debug("\tCode: " + code);
        Logging.debug("\tBody:");
        Logging.debug("\t\t" + body);
        Logging.debug("-- END CONNECTION --------------------------------");
        return new APIStruct.Response<String>(URL2, body, body, code);
    }

    final <T> APIStruct.Response<T> call(Function<String, T> processor) throws IOException, InterruptedException {
        APIStruct.Response<String> response = this.call();
        String body = response.body();
        return new APIStruct.Response<T>(response.URL(), body, processor.apply(body), response.code());
    }

    public final String toString() {
        return "APICall{useNetHttp=" + useNetHttp + ", method='" + this.method + '\'' + ", baseURL='" + this.baseURL + '\'' + ", headers=" + this.headers + ", path='" + this.path + '\'' + ", pathVars=" + this.pathVars + ", queries=" + this.queries + ", formUrlEncoded=" + this.formUrlEncoded + ", fields=" + this.fields + '}';
    }

    static <C> C create(String baseURL, Class<C> service) {
        if (!service.isInterface()) {
            throw new IllegalArgumentException("Service must be an interface");
        }
        InterfaceInvocation handler = new InterfaceInvocation(baseURL, service);
        return (C)Proxy.newProxyInstance(service.getClassLoader(), new Class[]{service}, (InvocationHandler)handler);
    }

    static String encodeUTF8(String s) {
        try {
            return URLEncoder.encode(s, UTF8);
        }
        catch (UnsupportedEncodingException e) {
            Logging.getLogger().severe("Failed to encode '" + s + "' to " + UTF8 + ", please report this to the maintainers of Mal4J");
            e.printStackTrace();
            return s;
        }
    }

    static String decodeUTF8(String s) {
        try {
            return URLDecoder.decode(s, UTF8);
        }
        catch (UnsupportedEncodingException e) {
            Logging.getLogger().severe("Failed to decode '" + s + "' to " + UTF8 + ", please report this to the maintainers of Mal4J");
            e.printStackTrace();
            return s;
        }
    }

    static {
        block10: {
            pathArg = Pattern.compile("\\{(.*?)\\}");
            String version = System.getProperty("java.version");
            boolean bl = useNetHttp = (version != null ? Integer.parseInt(version.contains(".") ? version.substring(0, version.indexOf(".")) : version) : 0) >= 11;
            if (!useNetHttp) {
                try {
                    Field methods = null;
                    try {
                        methods = HttpURLConnection.class.getDeclaredField("methods");
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        // empty catch block
                    }
                    if (methods == null) break block10;
                    Field modifiers = null;
                    try {
                        modifiers = Field.class.getDeclaredField("modifiers");
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        // empty catch block
                    }
                    if (modifiers != null) {
                        modifiers.setAccessible(true);
                        try {
                            modifiers.setInt(methods, methods.getModifiers() & 0xFFFFFFEF);
                            methods.setAccessible(true);
                            String[] nativeMethods = (String[])methods.get(null);
                            HashSet<String> newMethods = new HashSet<String>(Arrays.asList(nativeMethods));
                            newMethods.add("PATCH");
                            methods.set(null, newMethods.toArray(new String[0]));
                            modifiers.setInt(methods, methods.getModifiers() | 0x10);
                            methods.setAccessible(false);
                            modifiers.setAccessible(false);
                        }
                        catch (IllegalAccessException illegalAccessException) {}
                    }
                }
                catch (RuntimeException e) {
                    if (!e.getClass().getSimpleName().equals("InaccessibleObjectException")) break block10;
                    throw new StaticInitializerException("Reflect module is not accessible in JDK 9+; add '--add-opens java.base/java.lang.reflect=Mal4J --add-opens java.base/java.net=Mal4J' to VM options, remove module-info.java, or compile the project in JDK 8 or JDK 11+", e);
                }
            }
        }
        blockedURI = Pattern.compile("[{}|\\\\^\\[\\]`]");
        encoder = new URIEncoder();
        UTF8 = StandardCharsets.UTF_8.name();
    }

    private static class JDK11 {
        private static Class<?> HttpRequest;
        private static Method HttpRequest_NewBuilder;
        private static Class<?> HttpRequestBuilder;
        private static Method HttpRequestBuilder_URI;
        private static Method HttpRequestBuilder_Method;
        private static Method HttpRequestBuilder_Header;
        private static Method BodyPublishers_NoBody;
        private static Method BodyPublishers_StringBody;
        private static Method HttpRequestBuilder_Build;
        private static Class<?> HttpClientBuilder;
        private static Method HttpClientBuilder_ConnectTimeout;
        private static Method HttpClientBuilder_Build;
        private static Class<?> HttpClient;
        private static Method HttpClient_NewBuilder;
        private static Method HttpClient_Send;
        private static Method BodyHandlers_StringBody;
        private static Method HttpResponse_Body;
        private static Method HttpResponse_Code;

        private JDK11() {
        }

        static {
            if (useNetHttp) {
                try {
                    HttpRequest = Class.forName("java.net.http.HttpRequest");
                    HttpRequest_NewBuilder = HttpRequest.getDeclaredMethod("newBuilder", new Class[0]);
                    HttpRequestBuilder = Class.forName("java.net.http.HttpRequest$Builder");
                    HttpRequestBuilder_URI = HttpRequestBuilder.getDeclaredMethod("uri", URI.class);
                    HttpRequestBuilder_Method = HttpRequestBuilder.getDeclaredMethod("method", String.class, Class.forName("java.net.http.HttpRequest$BodyPublisher"));
                    HttpRequestBuilder_Header = HttpRequestBuilder.getDeclaredMethod("header", String.class, String.class);
                    BodyPublishers_NoBody = Class.forName("java.net.http.HttpRequest$BodyPublishers").getDeclaredMethod("noBody", new Class[0]);
                    BodyPublishers_StringBody = Class.forName("java.net.http.HttpRequest$BodyPublishers").getDeclaredMethod("ofString", String.class);
                    HttpRequestBuilder_Build = HttpRequestBuilder.getDeclaredMethod("build", new Class[0]);
                    HttpClientBuilder = Class.forName("java.net.http.HttpClient$Builder");
                    HttpClientBuilder_ConnectTimeout = HttpClientBuilder.getDeclaredMethod("connectTimeout", Duration.class);
                    HttpClientBuilder_Build = HttpClientBuilder.getDeclaredMethod("build", new Class[0]);
                    HttpClient = Class.forName("java.net.http.HttpClient");
                    HttpClient_NewBuilder = HttpClient.getDeclaredMethod("newBuilder", new Class[0]);
                    HttpClient_Send = HttpClient.getDeclaredMethod("send", Class.forName("java.net.http.HttpRequest"), Class.forName("java.net.http.HttpResponse$BodyHandler"));
                    BodyHandlers_StringBody = Class.forName("java.net.http.HttpResponse$BodyHandlers").getDeclaredMethod("ofString", Charset.class);
                    HttpResponse_Body = Class.forName("java.net.http.HttpResponse").getDeclaredMethod("body", new Class[0]);
                    HttpResponse_Code = Class.forName("java.net.http.HttpResponse").getDeclaredMethod("statusCode", new Class[0]);
                }
                catch (ClassNotFoundException | NoSuchMethodException e) {
                    throw new StaticInitializerException("Failed to initialize HttpClient, please report this to the maintainers of Mal4J", e);
                }
            }
        }
    }

    private static class URIEncoder
    implements Function<MatchResult, String> {
        private URIEncoder() {
        }

        @Override
        public final String apply(MatchResult matchResult) {
            char ch = matchResult.group().charAt(0);
            switch (ch) {
                case '{': {
                    return "%7B";
                }
                case '}': {
                    return "%7D";
                }
                case '|': {
                    return "%7C";
                }
                case '\\': {
                    return "%5C";
                }
                case '^': {
                    return "%5E";
                }
                case '[': {
                    return "%5B";
                }
                case ']': {
                    return "%5D";
                }
                case '`': {
                    return "%60";
                }
            }
            return matchResult.group(0);
        }
    }

    private static class InterfaceInvocation
    implements InvocationHandler {
        private final String baseURL;
        private final Class<?> service;

        public InterfaceInvocation(String baseURL, Class<?> service) {
            this.baseURL = baseURL;
            this.service = service;
        }

        @Override
        public final Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getDeclaringClass() != this.service) {
                return method.invoke((Object)this, args);
            }
            try {
                return new APICall(this.baseURL, method, args).call(Json::parse);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

