/*
 * Decompiled with CFR 0.152.
 */
package dev.katsute.mal4j;

import dev.katsute.mal4j.Logging;
import java.util.Date;
import java.util.Objects;

public final class AccessToken {
    private final String token_type;
    private final Long expiry_in_seconds;
    private final transient String access_token;
    private final transient String refresh_token;

    public AccessToken(String access_token) {
        this("Bearer", access_token, null, null);
    }

    public AccessToken(String access_token, String refresh_token) {
        this("Bearer", access_token, refresh_token, null);
    }

    public AccessToken(String access_token, String refresh_token, long expiry_in_seconds) {
        this("Bearer", access_token, refresh_token, expiry_in_seconds);
    }

    AccessToken(String token_type, String access_token, String refresh_token, Long expiry_in_seconds) {
        this.token_type = Objects.requireNonNull(token_type, "Token type can not be null");
        this.access_token = Objects.requireNonNull(access_token, "Access token can not be null");
        this.refresh_token = refresh_token;
        this.expiry_in_seconds = expiry_in_seconds;
        Logging.addMask(this.access_token);
        Logging.addMask(this.refresh_token);
    }

    public final String getToken() {
        return this.token_type + ' ' + this.access_token;
    }

    public final String getRefreshToken() {
        return Objects.requireNonNull(this.refresh_token, "Refresh token is missing");
    }

    public final Date getExpiry() {
        return new Date(this.getExpiryEpochSeconds() * 1000L);
    }

    public final long getExpiryEpochSeconds() {
        return Objects.requireNonNull(this.expiry_in_seconds, "Access token is missing expiry date");
    }

    public final long getTimeUntilExpires() {
        return this.getExpiryEpochSeconds() - System.currentTimeMillis() / 1000L;
    }

    public final boolean isExpired() {
        return this.getTimeUntilExpires() <= 0L;
    }

    public final String toString() {
        return "AccessToken{token_type='" + this.token_type + '\'' + ", expires=" + this.expiry_in_seconds + '}';
    }
}

