/*
 * Decompiled with CFR 0.152.
 */
package dev.katsute.mal4j;

import dev.katsute.mal4j.Logging;
import java.util.Objects;
import java.util.regex.Pattern;

public final class Authorization {
    private static final Pattern allowedPKCE = Pattern.compile("[\\w\\-.~]*");
    private final String client_id;
    private final String client_secret;
    private final String authorization_code;
    private final String pkce;
    private final String redirect_uri;

    public Authorization(String client_id, String client_secret, String authorization_code, String PKCE) {
        this(client_id, client_secret, authorization_code, PKCE, null);
    }

    public Authorization(String client_id, String client_secret, String authorization_code, String PKCE, String redirect_uri) {
        int PKCE_len;
        Objects.requireNonNull(client_id, "Client ID must not be null");
        Objects.requireNonNull(authorization_code, "Authorization code must not be null");
        Objects.requireNonNull(PKCE, "PKCE code challenge must not be null");
        Logging.addMask(client_id);
        Logging.addMask(client_secret);
        Logging.addMask(authorization_code);
        Logging.addMask(PKCE);
        if (authorization_code.startsWith("https://") || authorization_code.startsWith("http://") || authorization_code.startsWith("www.")) {
            Logging.getLogger().warning("Authorization code looks like a URL, make sure you are passing the authorization code and not the authorization URL");
        }
        if ((PKCE_len = PKCE.length()) < 43 || PKCE_len > 128) {
            throw new IllegalArgumentException("PKCE code challenge must be between 43 and 128 characters, was " + PKCE_len + " characters");
        }
        if (!allowedPKCE.matcher(PKCE).matches()) {
            throw new IllegalArgumentException("PKCE code challenge contains illegal characters, only a-z , A-Z , 0-9 , _ , . , - , and ~ are allowed");
        }
        this.client_id = client_id;
        this.client_secret = client_secret;
        this.authorization_code = authorization_code;
        this.pkce = PKCE;
        this.redirect_uri = redirect_uri;
    }

    public final String getClientID() {
        return this.client_id;
    }

    public final String getClientSecret() {
        return this.client_secret;
    }

    public final String getAuthorizationCode() {
        return this.authorization_code;
    }

    public final String getPKCE() {
        return this.pkce;
    }

    public final String getRedirectURI() {
        return this.redirect_uri;
    }

    public final String toString() {
        return "Authorization{redirect_uri='" + this.redirect_uri + '\'' + '}';
    }
}

