/*
 * Decompiled with CFR 0.152.
 */
package dev.katsute.mal4j;

import dev.katsute.mal4j.Regex9;
import dev.katsute.mal4j.exception.JsonSyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class Json {
    private final String json;
    private final int len;
    private static final Pattern escUnicode = Pattern.compile("(?<!\\\\)\\\\u([\\da-f]{4})");
    private static final Function<MatchResult, String> unicodeReplacer = matchResult -> String.valueOf((char)Integer.parseInt(matchResult.group(1), 16));
    private final Matcher unicodeMatcher = escUnicode.matcher("");

    private Json(String json) {
        this.json = Objects.requireNonNull(json);
        this.len = json.length();
    }

    static Object parse(String json) {
        return new Json(json).parse();
    }

    private String parseString(String raw) {
        return Regex9.replaceAll(raw, this.unicodeMatcher.reset(raw), unicodeReplacer).replace("\\\\u", "\\u");
    }

    private Object parse() {
        if (this.len < 1) {
            throw new JsonSyntaxException("Json string was empty", this.json);
        }
        switch (this.json.charAt(0)) {
            case '{': {
                if (this.json.charAt(this.len - 1) == '}') {
                    return this.parseObject(this.json, 0, this.len);
                }
                throw new JsonSyntaxException("Missing closing bracket '}'", this.json);
            }
            case '[': {
                if (this.json.charAt(this.len - 1) == ']') {
                    return this.parseArray(this.json, 0, this.len);
                }
                throw new JsonSyntaxException("Missing closing bracket ']'", this.json);
            }
        }
        throw new JsonSyntaxException("Unexpected starting character: '" + this.json.charAt(0) + "', expected '{' or '['", this.json);
    }

    private List<Object> parseArray(String json, int start, int end) {
        ArrayList<Object> list = new ArrayList<Object>();
        Expect E = Expect.START_OF_VALUE;
        Type T = Type.UNKNOWN;
        boolean isEscaped = false;
        String V = null;
        block66: for (int i = start + 1; i < end; ++i) {
            char ch = json.charAt(i);
            switch (E.ordinal()) {
                case 3: {
                    switch (ch) {
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            continue block66;
                        }
                        case '[': {
                            int n = i;
                            i = this.findEndToken(json, i, '[', ']');
                            list.add(this.parseArray(json, n, i + 1));
                            E = Expect.END_OF_VALUE;
                            continue block66;
                        }
                        case '{': {
                            int n = i;
                            i = this.findEndToken(json, i, '{', '}');
                            list.add(this.parseObject(json, n, i + 1));
                            E = Expect.END_OF_VALUE;
                            continue block66;
                        }
                        case '\"': {
                            T = Type.STRING;
                            E = Expect.LITERAL;
                            V = "";
                            continue block66;
                        }
                        case 'f': 
                        case 't': {
                            T = Type.BOOLEAN;
                            E = Expect.LITERAL;
                            V = String.valueOf(ch);
                            continue block66;
                        }
                        case 'n': {
                            T = Type.NULL;
                            E = Expect.LITERAL;
                            V = String.valueOf(ch);
                            continue block66;
                        }
                        case '-': {
                            T = Type.INTEGER;
                            E = Expect.NUMBER;
                            V = String.valueOf(ch);
                            continue block66;
                        }
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            T = Type.INTEGER;
                            E = Expect.LITERAL;
                            V = String.valueOf(ch);
                            continue block66;
                        }
                        case ']': {
                            return list;
                        }
                    }
                    throw new JsonSyntaxException("Unexpected literal '" + ch + "'", json);
                }
                case 4: {
                    switch (ch) {
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            break;
                        }
                        case ',': 
                        case ']': {
                            E = Expect.START_OF_VALUE;
                            switch (T.ordinal()) {
                                case 1: {
                                    list.add(null);
                                    break;
                                }
                                case 2: {
                                    list.add(Boolean.parseBoolean(V));
                                    break;
                                }
                                case 3: {
                                    try {
                                        list.add(Integer.parseInt(V));
                                    }
                                    catch (NumberFormatException ignored) {
                                        list.add(Long.parseLong(V));
                                    }
                                    break;
                                }
                                case 4: {
                                    try {
                                        list.add(Double.parseDouble(V));
                                    }
                                    catch (NumberFormatException ignored) {
                                        list.add(Long.parseLong(V));
                                    }
                                    break;
                                }
                                case 5: {
                                    if (V == null) break;
                                    list.add(this.parseString(V));
                                    break;
                                }
                            }
                            V = null;
                            T = Type.UNKNOWN;
                            if (ch != ']') break;
                            return list;
                        }
                    }
                    continue block66;
                }
                case 5: {
                    switch (T.ordinal()) {
                        case 1: {
                            V = V + ch;
                            if (!"null".startsWith(V)) {
                                throw new JsonSyntaxException("Unexpected value '" + V + "', expected null", json);
                            }
                            if (!"null".equals(V)) continue block66;
                            E = Expect.END_OF_VALUE;
                            continue block66;
                        }
                        case 2: {
                            V = V + ch;
                            if (!"false".startsWith(V) && !"true".startsWith(V)) {
                                throw new JsonSyntaxException("Unexpected value '" + V + "', expected a boolean", json);
                            }
                            if (!"false".equals(V) && !"true".equals(V)) continue block66;
                            E = Expect.END_OF_VALUE;
                            continue block66;
                        }
                        case 3: {
                            switch (ch) {
                                case '\t': 
                                case '\n': 
                                case '\r': 
                                case ' ': {
                                    E = Expect.END_OF_VALUE;
                                    continue block66;
                                }
                                case '.': {
                                    T = Type.DOUBLE;
                                    E = Expect.NUMBER;
                                    V = V + ch;
                                    continue block66;
                                }
                                case '0': 
                                case '1': 
                                case '2': 
                                case '3': 
                                case '4': 
                                case '5': 
                                case '6': 
                                case '7': 
                                case '8': 
                                case '9': {
                                    V = V + ch;
                                    continue block66;
                                }
                                case ',': 
                                case ']': {
                                    E = Expect.END_OF_VALUE;
                                    --i;
                                    continue block66;
                                }
                            }
                            throw new JsonSyntaxException("Unexpected token '" + ch + "', expected a number or ','", json);
                        }
                        case 4: {
                            switch (ch) {
                                case '\t': 
                                case '\n': 
                                case '\r': 
                                case ' ': {
                                    E = Expect.END_OF_VALUE;
                                    continue block66;
                                }
                                case '.': {
                                    throw new JsonSyntaxException("Unexpected token '.'", json);
                                }
                                case '0': 
                                case '1': 
                                case '2': 
                                case '3': 
                                case '4': 
                                case '5': 
                                case '6': 
                                case '7': 
                                case '8': 
                                case '9': {
                                    V = V + ch;
                                    continue block66;
                                }
                                case ',': 
                                case ']': {
                                    E = Expect.END_OF_VALUE;
                                    --i;
                                    continue block66;
                                }
                            }
                            throw new JsonSyntaxException("Unexpected token '" + ch + "', expected a number", json);
                        }
                        case 5: {
                            switch (ch) {
                                case '\n': 
                                case '\r': {
                                    throw new JsonSyntaxException("Unexpected token '" + ch + "'", json);
                                }
                                case '\\': {
                                    if (isEscaped) {
                                        V = V + ch;
                                    }
                                    isEscaped = !isEscaped;
                                    continue block66;
                                }
                                case '\"': {
                                    if (!isEscaped) {
                                        E = Expect.END_OF_VALUE;
                                        continue block66;
                                    }
                                    V = V + ch;
                                    isEscaped = false;
                                    continue block66;
                                }
                            }
                            if (!isEscaped) {
                                if (ch == 'u' && i > 0 && json.charAt(i - 1) == '\\') {
                                    V = V + '\\';
                                }
                                V = V + ch;
                                continue block66;
                            }
                            isEscaped = false;
                            switch (ch) {
                                case 't': {
                                    V = V + '\t';
                                    continue block66;
                                }
                                case 'r': {
                                    V = V + '\r';
                                    continue block66;
                                }
                                case 'n': {
                                    V = V + '\n';
                                    continue block66;
                                }
                                case 'u': {
                                    V = V + "\\u";
                                    continue block66;
                                }
                                case '/': {
                                    V = V + '/';
                                    continue block66;
                                }
                            }
                            throw new JsonSyntaxException("Unknown escape character '\\" + ch + "'", json);
                        }
                    }
                }
                case 6: {
                    switch (ch) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            E = Expect.LITERAL;
                            V = V + ch;
                            continue block66;
                        }
                    }
                    throw new JsonSyntaxException("Unexpected token '" + ch + "', expected a number", json);
                }
            }
        }
        throw new JsonSyntaxException("Missing closing bracket ']'", json);
    }

    private JsonObject parseObject(String json, int start, int end) {
        JsonObject obj = new JsonObject();
        Expect E = Expect.START_OF_KEY;
        Type T = Type.UNKNOWN;
        boolean isEscaped = false;
        String K = null;
        String V = null;
        block89: for (int i = start + 1; i < end; ++i) {
            char ch = json.charAt(i);
            switch (E.ordinal()) {
                case 0: {
                    switch (ch) {
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            continue block89;
                        }
                        case '\"': {
                            E = Expect.KEY;
                            K = "";
                            continue block89;
                        }
                        case '}': {
                            return obj;
                        }
                    }
                    throw new JsonSyntaxException("Unexpected literal '" + ch + "', expected '\"'", json);
                }
                case 1: {
                    switch (ch) {
                        case '\n': 
                        case '\r': {
                            throw new JsonSyntaxException("Unexpected token '" + ch + "'", json);
                        }
                        case '\\': {
                            if (isEscaped) {
                                K = K + ch;
                            }
                            isEscaped = !isEscaped;
                            continue block89;
                        }
                        case '\"': {
                            if (!isEscaped) {
                                E = Expect.END_OF_KEY;
                                continue block89;
                            }
                            K = K + ch;
                            isEscaped = false;
                            continue block89;
                        }
                    }
                    if (!isEscaped) {
                        if (ch == 'u' && i > 0 && json.charAt(i - 1) == '\\') {
                            K = K + '\\';
                        }
                        K = K + ch;
                        continue block89;
                    }
                    isEscaped = false;
                    switch (ch) {
                        case 't': {
                            K = K + '\t';
                            continue block89;
                        }
                        case 'r': {
                            V = V + '\r';
                            continue block89;
                        }
                        case 'n': {
                            K = K + '\n';
                            continue block89;
                        }
                        case '/': {
                            K = K + '/';
                            continue block89;
                        }
                        case 'u': {
                            K = K + "\\u";
                            continue block89;
                        }
                    }
                    throw new JsonSyntaxException("Unknown escape character '\\" + ch + "'", json);
                }
                case 2: {
                    switch (ch) {
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            continue block89;
                        }
                        case ':': {
                            E = Expect.START_OF_VALUE;
                            continue block89;
                        }
                    }
                    throw new JsonSyntaxException("Unexpected character '" + ch + "', expected ':'", json);
                }
                case 3: {
                    switch (ch) {
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            continue block89;
                        }
                        case '[': {
                            int n = i;
                            i = this.findEndToken(json, i, '[', ']');
                            obj.set(K, this.parseArray(json, n, i + 1));
                            K = null;
                            E = Expect.END_OF_VALUE;
                            continue block89;
                        }
                        case '{': {
                            int n = i;
                            i = this.findEndToken(json, i, '{', '}');
                            obj.set(K, this.parseObject(json, n, i + 1));
                            K = null;
                            E = Expect.END_OF_VALUE;
                            continue block89;
                        }
                        case '\"': {
                            T = Type.STRING;
                            E = Expect.LITERAL;
                            V = "";
                            continue block89;
                        }
                        case 'f': 
                        case 't': {
                            T = Type.BOOLEAN;
                            E = Expect.LITERAL;
                            V = String.valueOf(ch);
                            continue block89;
                        }
                        case 'n': {
                            T = Type.NULL;
                            E = Expect.LITERAL;
                            V = String.valueOf(ch);
                            continue block89;
                        }
                        case '-': {
                            T = Type.INTEGER;
                            E = Expect.NUMBER;
                            V = String.valueOf(ch);
                            continue block89;
                        }
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            T = Type.INTEGER;
                            E = Expect.LITERAL;
                            V = String.valueOf(ch);
                            continue block89;
                        }
                    }
                    throw new JsonSyntaxException("Unexpected literal '" + ch + "'", json);
                }
                case 4: {
                    switch (ch) {
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            break;
                        }
                        case ',': 
                        case '}': {
                            E = Expect.START_OF_KEY;
                            switch (T.ordinal()) {
                                case 1: {
                                    obj.set(K, null);
                                    break;
                                }
                                case 2: {
                                    obj.set(K, Boolean.parseBoolean(V));
                                    break;
                                }
                                case 3: {
                                    try {
                                        obj.set(K, Integer.parseInt(V));
                                    }
                                    catch (NumberFormatException ignored) {
                                        obj.set(K, Long.parseLong(V));
                                    }
                                    break;
                                }
                                case 4: {
                                    try {
                                        obj.set(K, Double.parseDouble(V));
                                    }
                                    catch (NumberFormatException ignored) {
                                        obj.set(K, Long.parseLong(V));
                                    }
                                    break;
                                }
                                case 5: {
                                    if (K == null || V == null) break;
                                    obj.set(this.parseString(K), this.parseString(V));
                                }
                            }
                            K = null;
                            V = null;
                            T = Type.UNKNOWN;
                            if (ch != '}') break;
                            return obj;
                        }
                    }
                    continue block89;
                }
                case 5: {
                    switch (T.ordinal()) {
                        case 1: {
                            V = V + ch;
                            if (!"null".startsWith(V)) {
                                throw new JsonSyntaxException("Unexpected value '" + V + "', expected null", json);
                            }
                            if (!"null".equals(V)) continue block89;
                            E = Expect.END_OF_VALUE;
                            continue block89;
                        }
                        case 2: {
                            V = V + ch;
                            if (!"false".startsWith(V) && !"true".startsWith(V)) {
                                throw new JsonSyntaxException("Unexpected value '" + V + "', expected a boolean", json);
                            }
                            if (!"false".equals(V) && !"true".equals(V)) continue block89;
                            E = Expect.END_OF_VALUE;
                            continue block89;
                        }
                        case 3: {
                            switch (ch) {
                                case '\t': 
                                case '\n': 
                                case '\r': 
                                case ' ': {
                                    E = Expect.END_OF_VALUE;
                                    continue block89;
                                }
                                case '.': {
                                    T = Type.DOUBLE;
                                    E = Expect.NUMBER;
                                    V = V + ch;
                                    continue block89;
                                }
                                case '0': 
                                case '1': 
                                case '2': 
                                case '3': 
                                case '4': 
                                case '5': 
                                case '6': 
                                case '7': 
                                case '8': 
                                case '9': {
                                    V = V + ch;
                                    continue block89;
                                }
                                case ',': 
                                case '}': {
                                    E = Expect.END_OF_VALUE;
                                    --i;
                                    continue block89;
                                }
                            }
                            throw new JsonSyntaxException("Unexpected token '" + ch + "', expected a number or ','", json);
                        }
                        case 4: {
                            switch (ch) {
                                case '\t': 
                                case '\n': 
                                case '\r': 
                                case ' ': {
                                    E = Expect.END_OF_VALUE;
                                    continue block89;
                                }
                                case '.': {
                                    throw new JsonSyntaxException("Unexpected token '.'", json);
                                }
                                case '0': 
                                case '1': 
                                case '2': 
                                case '3': 
                                case '4': 
                                case '5': 
                                case '6': 
                                case '7': 
                                case '8': 
                                case '9': {
                                    V = V + ch;
                                    continue block89;
                                }
                                case ',': 
                                case '}': {
                                    E = Expect.END_OF_VALUE;
                                    --i;
                                    continue block89;
                                }
                            }
                            throw new JsonSyntaxException("Unexpected token '" + ch + "', expected a number", json);
                        }
                        case 5: {
                            switch (ch) {
                                case '\n': 
                                case '\r': {
                                    throw new JsonSyntaxException("Unexpected token '" + ch + "'", json);
                                }
                                case '\\': {
                                    if (isEscaped) {
                                        V = V + ch;
                                    }
                                    isEscaped = !isEscaped;
                                    continue block89;
                                }
                                case '\"': {
                                    if (!isEscaped) {
                                        E = Expect.END_OF_VALUE;
                                        continue block89;
                                    }
                                    V = V + ch;
                                    isEscaped = false;
                                    continue block89;
                                }
                            }
                            if (!isEscaped) {
                                if (ch == 'u' && i > 0 && json.charAt(i - 1) == '\\') {
                                    V = V + '\\';
                                }
                                V = V + ch;
                                continue block89;
                            }
                            isEscaped = false;
                            switch (ch) {
                                case 't': {
                                    V = V + '\t';
                                    continue block89;
                                }
                                case 'r': {
                                    V = V + '\r';
                                    continue block89;
                                }
                                case 'n': {
                                    V = V + '\n';
                                    continue block89;
                                }
                                case 'u': {
                                    V = V + "\\u";
                                    continue block89;
                                }
                                case '/': {
                                    V = V + '/';
                                    continue block89;
                                }
                            }
                            throw new JsonSyntaxException("Unknown escape character '\\" + ch + "'", json);
                        }
                    }
                    continue block89;
                }
                case 6: {
                    switch (ch) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            E = Expect.LITERAL;
                            V = V + ch;
                            continue block89;
                        }
                    }
                    throw new JsonSyntaxException("Unexpected token '" + ch + "', expected a number", json);
                }
            }
        }
        throw new JsonSyntaxException("Missing closing bracket '}'", json);
    }

    private int findEndToken(String json, int start, char open, char close) {
        boolean isString = false;
        boolean isEscaped = false;
        int depth = 0;
        for (int i = start + 1; i < this.len; ++i) {
            char ch = json.charAt(i);
            if (ch == '\\' || isEscaped) {
                isEscaped = !isEscaped;
                continue;
            }
            if (ch == '\"') {
                isString = !isString;
                continue;
            }
            if (isString) continue;
            if (ch == open) {
                ++depth;
                continue;
            }
            if (ch != close) continue;
            if (depth == 0) {
                return i;
            }
            --depth;
        }
        throw new JsonSyntaxException("Missing closing bracket '" + close + "'", json);
    }

    static class JsonObject {
        private final Map<String, Object> map = new HashMap<String, Object>();

        JsonObject() {
        }

        public final Object get(String key) {
            return this.map.get(key);
        }

        public final String getString(String key) {
            Object value = this.map.get(key);
            return value == null ? null : (value instanceof String ? (String)value : value.toString());
        }

        public final Integer getInt(String key) {
            Object value = this.map.get(key);
            if (value instanceof String) {
                try {
                    return Integer.valueOf((String)value);
                }
                catch (NumberFormatException ignored) {
                    return null;
                }
            }
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            return null;
        }

        public final Double getDouble(String key) {
            Object value = this.map.get(key);
            if (value instanceof String) {
                try {
                    return Double.valueOf((String)value);
                }
                catch (NumberFormatException ignored) {
                    return null;
                }
            }
            if (value instanceof Number) {
                return ((Number)value).doubleValue();
            }
            return null;
        }

        public final Float getFloat(String key) {
            Object value = this.map.get(key);
            if (value instanceof String) {
                try {
                    return Float.valueOf((String)value);
                }
                catch (NumberFormatException ignored) {
                    return null;
                }
            }
            if (value instanceof Number) {
                return Float.valueOf(((Number)value).floatValue());
            }
            return null;
        }

        public final Long getLong(String key) {
            Object value = this.map.get(key);
            if (value instanceof String) {
                try {
                    return Long.valueOf((String)value);
                }
                catch (NumberFormatException ignored) {
                    return null;
                }
            }
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
            return null;
        }

        public final Boolean getBoolean(String key) {
            Object value = this.map.get(key);
            if (value instanceof String) {
                if (((String)value).equalsIgnoreCase("true")) {
                    return true;
                }
                if (((String)value).equalsIgnoreCase("false")) {
                    return false;
                }
                return null;
            }
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            return null;
        }

        public final JsonObject getJsonObject(String key) {
            Object value = this.map.get(key);
            if (value instanceof JsonObject) {
                return (JsonObject)value;
            }
            return new JsonObject();
        }

        public final String[] getStringArray(String key) {
            List list = (List)this.map.get(key);
            if (list == null) {
                return null;
            }
            ArrayList<String> arr = new ArrayList<String>();
            for (Object o : list) {
                arr.add(o == null ? null : (o instanceof String ? (String)o : o.toString()));
            }
            return arr.toArray(new String[0]);
        }

        public final JsonObject[] getJsonArray(String key) {
            List list = (List)this.map.get(key);
            if (list == null) {
                return null;
            }
            ArrayList<JsonObject> arr = new ArrayList<JsonObject>();
            for (Object o : list) {
                arr.add(o instanceof JsonObject ? (JsonObject)o : new JsonObject());
            }
            return arr.toArray(new JsonObject[0]);
        }

        public final boolean containsKey(String key) {
            return this.map.containsKey(key);
        }

        public final int size() {
            return this.map.size();
        }

        private void set(String key, Object value) {
            this.map.put(key, value);
        }

        public final String toString() {
            return "JsonObject{map=" + this.map + '}';
        }
    }

    static enum Expect {
        START_OF_KEY,
        KEY,
        END_OF_KEY,
        START_OF_VALUE,
        END_OF_VALUE,
        LITERAL,
        NUMBER;

    }

    static enum Type {
        UNKNOWN,
        NULL,
        BOOLEAN,
        INTEGER,
        DOUBLE,
        STRING;

    }
}

