/*
 * Decompiled with CFR 0.152.
 */
package dev.katsute.mal4j;

import java.util.HashSet;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public abstract class Logging {
    private static final Logger logger = Logger.getLogger("dev.katsute.mal4j");
    private static boolean debug;
    private static final HashSet<String> secrets;

    public static Logger getLogger() {
        if (!new Exception().getStackTrace()[1].toString().startsWith("dev.katsute.mal4j.")) {
            throw new SecurityException("Logging not allowed for this class");
        }
        return logger;
    }

    static void setDebug(boolean debug) {
        Logging.debug = debug;
    }

    static void addMask(String secret) {
        if (secret != null) {
            secrets.add(secret);
        }
    }

    static void addMask(ThrowingSupplier<String> runnable) {
        try {
            Logging.addMask(runnable.get());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static void debug() {
        if (debug) {
            System.out.println();
        }
    }

    static void debug(String message) {
        if (message == null) {
            return;
        }
        if (debug) {
            String buffer = message;
            for (String secret : secrets) {
                buffer = buffer.replace(secret, "***");
            }
            System.out.println(buffer);
        }
    }

    static {
        logger.setUseParentHandlers(false);
        logger.addHandler(new ConsoleHandler(){
            {
                this.setFormatter(new Formatter(){

                    @Override
                    public final String format(LogRecord record) {
                        return record.getLevel() + ": " + record.getMessage() + "\r\n";
                    }
                });
            }
        });
        debug = false;
        secrets = new HashSet();
    }

    static interface ThrowingSupplier<R> {
        public R get() throws Throwable;
    }
}

