/*
 * Decompiled with CFR 0.152.
 */
package dev.katsute.mal4j;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import dev.katsute.mal4j.APICall;
import dev.katsute.mal4j.APIStruct;
import dev.katsute.mal4j.AccessToken;
import dev.katsute.mal4j.AuthResponseHandler;
import dev.katsute.mal4j.Authorization;
import dev.katsute.mal4j.Json;
import dev.katsute.mal4j.Logging;
import dev.katsute.mal4j.MyAnimeListAuthenticationService;
import dev.katsute.mal4j.exception.HttpException;
import dev.katsute.mal4j.exception.InvalidTokenException;
import dev.katsute.mal4j.exception.UnauthorizedAccessException;
import java.awt.Desktop;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.zip.GZIPOutputStream;

public final class MyAnimeListAuthenticator {
    private static final String authUrl = "https://myanimelist.net/v1/oauth2/authorize?response_type=code&client_id=%s&code_challenge=%s&code_challenge_method=plain";
    private static final String authState = "&state=%s";
    private static final String redirectURI = "&redirect_uri=%s";
    private final MyAnimeListAuthenticationService authService = MyAnimeListAuthenticationService.create();
    private final Authorization authorization;
    private AccessToken token;
    private static final AuthResponseHandler defaultHandler = new AuthResponseHandler(){
        private static final String HTML = "<!DOCTYPE html><html><head><title>MyAnimeList Authenticator</title><style>html,body{width:100%;height:100%;-webkit-user-select: none;-ms-user-select: none;user-select: none;}body{display:flex;align-items:center;justify-content:center;background-color:#2E51A2;margin:0px;*{width:100%}}*{font-family:Helvetica,Arial,sans-serif;color:white;text-align:center}</style></head><body><div><h1>Authentication {{ state }}</h1><p title=\"{{ hint }}\">{{ message }}</p></div></body></html>";
        private static final String OK = "&#10004;&#65039;";
        private static final String FAIL = "&#10060;";

        @Override
        public final String getResponse(String code, String error, String message, String hint) {
            String err;
            String pass = code == null ? "Failed &#10060;" : "Completed &#10004;&#65039;";
            String string = err = error == null ? "" : error;
            String msg = code == null ? "<b>" + err.substring(0, 1).toUpperCase() + err.substring(1).replace('_', ' ') + "</b>: " + (message == null ? "" : message) : "You may now close the window.";
            return HTML.replace("{{ state }}", pass).replace("{{ hint }}", hint != null ? hint : "").replace("{{ message }}", msg);
        }
    };

    private MyAnimeListAuthenticator(String client_id, String client_secret, int port, AuthResponseHandler handler, Consumer<String> urlCallback, boolean openBrowser, long timeout, String redirect_URI) throws IOException {
        String[] auth = MyAnimeListAuthenticator.authenticateWithLocalServer(client_id, port, handler, urlCallback, openBrowser, timeout, redirect_URI);
        this.authorization = new Authorization(client_id, client_secret, auth[0], auth[1], redirect_URI);
        this.token = this.parseToken(this.authService.getToken(client_id, client_secret, "authorization_code", auth[0], auth[1], redirect_URI));
    }

    public MyAnimeListAuthenticator(Authorization authorization) {
        this(authorization, null);
    }

    public MyAnimeListAuthenticator(Authorization authorization, AccessToken token) {
        Objects.requireNonNull(authorization, "Authorization must not be null");
        this.authorization = authorization;
        if (token != null) {
            Logging.addMask(token::getToken);
            Logging.addMask(token::getRefreshToken);
        }
        this.token = token != null ? token : this.parseToken(this.authService.getToken(authorization.getClientID(), authorization.getClientSecret(), "authorization_code", authorization.getAuthorizationCode(), authorization.getPKCE(), authorization.getRedirectURI()));
    }

    public final Authorization getAuthorization() {
        return this.authorization;
    }

    public final AccessToken getAccessToken() {
        return this.token;
    }

    public final AccessToken refreshAccessToken() {
        this.token = this.parseToken(this.authService.refreshToken(this.authorization.getClientID(), this.authorization.getClientSecret(), "refresh_token", this.authorization.getAuthorizationCode(), this.authorization.getPKCE(), this.token.getRefreshToken()));
        Logging.addMask(this.token::getToken);
        Logging.addMask(this.token::getRefreshToken);
        return this.token;
    }

    public static String getAuthorizationURL(String client_id, String PKCE_code_challenge) {
        return MyAnimeListAuthenticator.getAuthorizationURL(client_id, PKCE_code_challenge, null, null);
    }

    public static String getAuthorizationURL(String client_id, String PKCE_code_challenge, String redirect_URI) {
        return MyAnimeListAuthenticator.getAuthorizationURL(client_id, PKCE_code_challenge, redirect_URI, null);
    }

    public static String getAuthorizationURL(String client_id, String PKCE_code_challenge, String redirect_URI, String state) {
        Objects.requireNonNull(client_id, "Client ID must not be null");
        Objects.requireNonNull(PKCE_code_challenge, "PKCE must not be null");
        return String.format(authUrl, client_id, PKCE_code_challenge) + (redirect_URI != null ? String.format(redirectURI, APICall.encodeUTF8(redirect_URI)) : "") + (state != null ? String.format(authState, state) : "");
    }

    public static boolean canOpenBrowser() {
        return Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE);
    }

    private static String[] authenticateWithLocalServer(String client_id, int port, AuthResponseHandler responseHandler, Consumer<String> urlCallback, boolean openBrowser, long timeout, String redirectURI) throws IOException {
        Objects.requireNonNull(client_id, "Client ID must not be null");
        String verify = MyAnimeListAuthenticator.generatePKCE(128);
        String state = MyAnimeListAuthenticator.generateSHA256(client_id + '&' + verify);
        String url = MyAnimeListAuthenticator.getAuthorizationURL(client_id, verify, redirectURI, state);
        if (urlCallback != null) {
            new Thread(() -> urlCallback.accept(url)).start();
        }
        ExecutorService exec = Executors.newSingleThreadExecutor();
        CountDownLatch latch = new CountDownLatch(1);
        HttpServer server = HttpServer.create(new InetSocketAddress(port), 0);
        server.setExecutor(exec);
        AuthHandler handler = new AuthHandler(latch, responseHandler);
        server.createContext("/", handler);
        server.start();
        if (openBrowser) {
            if (!MyAnimeListAuthenticator.canOpenBrowser()) {
                Logging.getLogger().severe("Desktop is not supported on this operating system. Please go to this URL manually: '" + url + "' or use a URL callback");
            } else {
                try {
                    Desktop.getDesktop().browse(new URI(url));
                }
                catch (URISyntaxException ignored) {
                    exec.shutdownNow();
                    server.stop(0);
                    throw new IllegalArgumentException("URL syntax was invalid (most likely the client id or redirect URI wasn't encoded correctly)");
                }
            }
        }
        try {
            latch.await(timeout, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        exec.shutdownNow();
        server.stop(0);
        if (handler.getAuth() == null) {
            throw new NullPointerException("Failed to authorize request (server was closed before a response could be received)");
        }
        if (!state.equals(handler.getState())) {
            throw new UnauthorizedAccessException("Failed to authorize request (packet was intercepted by an unauthorized source)");
        }
        return new String[]{handler.getAuth(), verify};
    }

    private AccessToken parseToken(APIStruct.Response<Json.JsonObject> response) {
        Json.JsonObject body = response.body();
        if (response.code() == 200) {
            return new AccessToken(body.getString("token_type"), body.getString("access_token"), body.getString("refresh_token"), System.currentTimeMillis() / 1000L + body.getLong("expires_in"));
        }
        if (response.code() == 401) {
            throw new InvalidTokenException("The OAuth token provided is either invalid or expired");
        }
        String error = body.getString("error");
        throw new HttpException(response.URL(), response.code(), error != null ? error.trim() : response.raw());
    }

    public static String generatePKCE(int length) {
        SecureRandom random = new SecureRandom();
        byte[] codeVerifier = new byte[length];
        random.nextBytes(codeVerifier);
        return Base64.getUrlEncoder().withoutPadding().encodeToString(codeVerifier).substring(0, length);
    }

    private static String generateSHA256(String str) {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("An exception that should not have been thrown has been thrown, please report this to the maintainers of Mal4J", e);
        }
        byte[] encodedHash = digest.digest(str.getBytes(StandardCharsets.UTF_8));
        StringBuilder hexString = new StringBuilder(2 * encodedHash.length);
        for (byte hash : encodedHash) {
            String hex = Integer.toHexString(0xFF & hash);
            hexString.append(hex.length() == 1 ? Character.valueOf('0') : hex);
        }
        return hexString.toString();
    }

    public final String toString() {
        return "MyAnimeListAuthenticator{authorization=" + this.authorization + ", token=" + this.token + '}';
    }

    private static final class AuthHandler
    implements HttpHandler {
        private final CountDownLatch latch;
        private final AuthResponseHandler handler;
        private final transient AtomicReference<String> auth = new AtomicReference();
        private final transient AtomicReference<String> state = new AtomicReference();

        private Map<String, String> parseWwwFormEnc(String query) {
            String[] pairs;
            HashMap<String, String> OUT = new HashMap<String, String>();
            for (String pair : pairs = query.split("&")) {
                if (!pair.contains("=")) continue;
                String[] kv = pair.split("=");
                OUT.put(APICall.decodeUTF8(kv[0]), kv.length == 2 ? APICall.decodeUTF8(kv[1]) : null);
            }
            return OUT;
        }

        private AuthHandler(CountDownLatch latch) {
            this(latch, defaultHandler);
        }

        private AuthHandler(CountDownLatch latch, AuthResponseHandler handler) {
            this.latch = latch;
            this.handler = handler == null ? defaultHandler : handler;
        }

        @Override
        public final void handle(HttpExchange exchange) throws IOException {
            Map<String, String> query = this.parseWwwFormEnc(exchange.getRequestURI().getRawQuery());
            this.state.set(query.get("state"));
            this.auth.set(query.get("code"));
            exchange.getResponseHeaders().set("Accept-Encoding", "gzip");
            exchange.getResponseHeaders().set("Content-Encoding", "gzip");
            exchange.getResponseHeaders().set("Connection", "keep-alive");
            exchange.sendResponseHeaders(200, 0L);
            try (GZIPOutputStream OUT = new GZIPOutputStream(exchange.getResponseBody());){
                OUT.write(this.handler.getResponse(query.get("code"), query.get("error"), query.get("message"), query.get("hint")).getBytes(StandardCharsets.UTF_8));
                OUT.finish();
                OUT.flush();
            }
            this.latch.countDown();
        }

        public final String getAuth() {
            return this.auth.get();
        }

        public final String getState() {
            return this.state.get();
        }
    }

    public static final class LocalServerBuilder {
        private final String client_id;
        private final String client_secret;
        private final int port;
        private boolean openBrowser = false;
        private long timeout = 180L;
        private String redirect_URI = null;
        private AuthResponseHandler responseHandler = null;
        private Consumer<String> urlCallback = null;

        public LocalServerBuilder(String client_id, int port) {
            this(client_id, null, port);
        }

        public LocalServerBuilder(String client_id, String client_secret, int port) {
            Objects.requireNonNull(client_id, "Client ID must not be null");
            this.client_id = client_id;
            this.client_secret = client_secret;
            this.port = port;
        }

        public final LocalServerBuilder openBrowser() {
            return this.openBrowser(true);
        }

        public final LocalServerBuilder openBrowser(boolean openBrowser) {
            if (!MyAnimeListAuthenticator.canOpenBrowser()) {
                Logging.getLogger().warning("System does not support openBrowser()");
            }
            this.openBrowser = openBrowser;
            return this;
        }

        public final LocalServerBuilder setTimeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public final LocalServerBuilder setRedirectURI(String redirectURI) {
            this.redirect_URI = redirectURI;
            return this;
        }

        public final LocalServerBuilder setResponseHandler(AuthResponseHandler responseHandler) {
            this.responseHandler = responseHandler;
            return this;
        }

        public final LocalServerBuilder setURLCallback(Consumer<String> consumer) {
            this.urlCallback = consumer;
            return this;
        }

        public final MyAnimeListAuthenticator build() throws IOException {
            return new MyAnimeListAuthenticator(this.client_id, this.client_secret, this.port, this.responseHandler, this.urlCallback, this.openBrowser, this.timeout, this.redirect_URI);
        }

        public final String toString() {
            return "MyAnimeListAuthenticator.LocalServerBuilder{port=" + this.port + ", openBrowser=" + this.openBrowser + ", timeout=" + this.timeout + ", redirect_URI='" + this.redirect_URI + '\'' + ", responseHandler=" + this.responseHandler + '}';
        }
    }
}

