/*
 * Decompiled with CFR 0.152.
 */
package dev.katsute.mal4j;

import dev.katsute.mal4j.APICall;
import dev.katsute.mal4j.APIStruct;
import dev.katsute.mal4j.Fields;
import dev.katsute.mal4j.Json;
import dev.katsute.mal4j.Logging;
import dev.katsute.mal4j.MyAnimeList;
import dev.katsute.mal4j.MyAnimeListAuthenticator;
import dev.katsute.mal4j.MyAnimeListSchema;
import dev.katsute.mal4j.MyAnimeListSchema_Anime;
import dev.katsute.mal4j.MyAnimeListSchema_Character;
import dev.katsute.mal4j.MyAnimeListSchema_Forum;
import dev.katsute.mal4j.MyAnimeListSchema_Manga;
import dev.katsute.mal4j.MyAnimeListSchema_People;
import dev.katsute.mal4j.MyAnimeListSchema_User;
import dev.katsute.mal4j.MyAnimeListService;
import dev.katsute.mal4j.PaginatedIterator;
import dev.katsute.mal4j.anime.Anime;
import dev.katsute.mal4j.anime.AnimeListStatus;
import dev.katsute.mal4j.anime.AnimeRanking;
import dev.katsute.mal4j.anime.property.AnimeRankingType;
import dev.katsute.mal4j.anime.property.time.Season;
import dev.katsute.mal4j.character.Character;
import dev.katsute.mal4j.exception.ExperimentalFeatureException;
import dev.katsute.mal4j.exception.HttpException;
import dev.katsute.mal4j.exception.InvalidTokenException;
import dev.katsute.mal4j.forum.ForumCategory;
import dev.katsute.mal4j.forum.ForumTopic;
import dev.katsute.mal4j.forum.ForumTopicDetail;
import dev.katsute.mal4j.forum.Post;
import dev.katsute.mal4j.manga.Manga;
import dev.katsute.mal4j.manga.MangaListStatus;
import dev.katsute.mal4j.manga.MangaRanking;
import dev.katsute.mal4j.manga.property.MangaRankingType;
import dev.katsute.mal4j.people.Person;
import dev.katsute.mal4j.property.ExperimentalFeature;
import dev.katsute.mal4j.query.AnimeCharacterQuery;
import dev.katsute.mal4j.query.AnimeListUpdate;
import dev.katsute.mal4j.query.AnimeRankingQuery;
import dev.katsute.mal4j.query.AnimeSearchQuery;
import dev.katsute.mal4j.query.AnimeSeasonQuery;
import dev.katsute.mal4j.query.AnimeSuggestionQuery;
import dev.katsute.mal4j.query.ForumSearchQuery;
import dev.katsute.mal4j.query.ForumTopicDetailPostQuery;
import dev.katsute.mal4j.query.MangaListUpdate;
import dev.katsute.mal4j.query.MangaRankingQuery;
import dev.katsute.mal4j.query.MangaSearchQuery;
import dev.katsute.mal4j.query.UserAnimeListQuery;
import dev.katsute.mal4j.query.UserMangaListQuery;
import dev.katsute.mal4j.user.User;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.regex.Pattern;

final class MyAnimeListImpl
extends MyAnimeList {
    private transient String token = null;
    private transient String client_id = null;
    private final boolean isTokenAuth;
    private MyAnimeListAuthenticator authenticator;
    private final MyAnimeListService service = MyAnimeListService.create();
    private final List<ExperimentalFeature> nativeFeatures = Arrays.asList(new ExperimentalFeature[0]);
    private final List<ExperimentalFeature> enabledFeatures = new ArrayList<ExperimentalFeature>();
    private static final String inverted = "^%s$|^%s(?=,)|(?<=\\w)\\{%s}|(?:^|,)%s\\{.*?}|,%s|(?<=\\{)%s,";

    MyAnimeListImpl(String token_or_client, boolean isToken) {
        Objects.requireNonNull(token_or_client, (isToken ? "OAuth token" : "Client ID") + " can not be null");
        this.isTokenAuth = isToken;
        if (isToken) {
            if (!token_or_client.startsWith("Bearer ")) {
                throw new InvalidTokenException("OAuth token should start with 'Bearer'");
            }
            this.token = token_or_client;
        } else {
            this.client_id = token_or_client;
        }
        Logging.addMask(token_or_client);
    }

    MyAnimeListImpl(MyAnimeListAuthenticator authenticator) {
        Objects.requireNonNull(authenticator, "Authenticator cannot be null");
        this.authenticator = authenticator;
        this.token = authenticator.getAccessToken().getToken();
        this.isTokenAuth = true;
    }

    @Override
    public final synchronized void refreshToken() {
        if (this.authenticator == null) {
            throw new UnsupportedOperationException("OAuth token refresh can only be used with authorization");
        }
        this.token = this.authenticator.refreshAccessToken().getToken();
    }

    final void checkExperimentalFeatureEnabled(ExperimentalFeature feature) {
        if (this.nativeFeatures.contains((Object)feature) || this.enabledFeatures.contains((Object)feature) || this.enabledFeatures.contains((Object)ExperimentalFeature.ALL)) {
            return;
        }
        throw new ExperimentalFeatureException("The feature " + feature.name() + " is an experimental feature and must be enabled using the enableExperimentalFeature method");
    }

    @Override
    public final void enableExperimentalFeature(ExperimentalFeature feature) {
        if (this.nativeFeatures.contains((Object)feature)) {
            Logging.getLogger().warning("The feature " + feature.name() + " is no longer an experimental feature, you do not have to enable it anymore");
        } else if (!this.enabledFeatures.contains((Object)feature)) {
            this.enabledFeatures.add(feature);
        }
    }

    final void clearExperimentalFeatures() {
        this.enabledFeatures.clear();
    }

    @Override
    public final AnimeSearchQuery getAnime() {
        return new AnimeSearchQuery(){

            @Override
            public final List<Anime> search() {
                Json.JsonObject response = MyAnimeListImpl.handleResponse(() -> MyAnimeListImpl.this.service.getAnime(MyAnimeListImpl.this.isTokenAuth ? MyAnimeListImpl.this.token : null, !MyAnimeListImpl.this.isTokenAuth ? MyAnimeListImpl.this.client_id : null, this.query, this.limit, this.offset, MyAnimeListImpl.convertFields(Fields.anime, this.fields), this.nsfw));
                if (response == null) {
                    return null;
                }
                ArrayList<Anime> anime = new ArrayList<Anime>();
                Json.JsonObject[] arr = response.getJsonArray("data");
                if (arr == null) {
                    return null;
                }
                for (Json.JsonObject iterator : arr) {
                    anime.add(MyAnimeListSchema_Anime.asAnime(MyAnimeListImpl.this, iterator.getJsonObject("node")));
                }
                return anime;
            }

            @Override
            public final PaginatedIterator<Anime> searchAll() {
                return new PagedIterator<Anime>(this.offset, offset -> MyAnimeListImpl.this.service.getAnime(MyAnimeListImpl.this.isTokenAuth ? MyAnimeListImpl.this.token : null, !MyAnimeListImpl.this.isTokenAuth ? MyAnimeListImpl.this.client_id : null, this.query, this.limit, (Integer)offset, MyAnimeListImpl.convertFields(Fields.anime, this.fields), this.nsfw), iterator -> MyAnimeListSchema_Anime.asAnime(MyAnimeListImpl.this, iterator.getJsonObject("node")));
            }
        };
    }

    @Override
    public final Anime getAnime(long id) {
        return this.getAnime(id, null);
    }

    @Override
    public final Anime getAnime(long id, String ... fields) {
        return MyAnimeListSchema_Anime.asAnime(this, this.getAnimeSchema(id, fields));
    }

    final Json.JsonObject getAnimeSchema(long id, String ... fields) {
        return MyAnimeListImpl.handleResponse(() -> this.service.getAnime(this.isTokenAuth ? this.token : null, !this.isTokenAuth ? this.client_id : null, id, MyAnimeListImpl.convertFields(Fields.anime, fields)));
    }

    @Override
    public final AnimeCharacterQuery getAnimeCharacters(final long id) {
        this.checkExperimentalFeatureEnabled(ExperimentalFeature.CHARACTERS);
        return new AnimeCharacterQuery(){

            @Override
            public final List<Character> search() {
                Json.JsonObject response = MyAnimeListImpl.handleResponse(() -> MyAnimeListImpl.this.service.getAnimeCharacters(MyAnimeListImpl.this.isTokenAuth ? MyAnimeListImpl.this.token : null, !MyAnimeListImpl.this.isTokenAuth ? MyAnimeListImpl.this.client_id : null, id, this.limit, this.offset, MyAnimeListImpl.convertFields(Fields.character, this.fields)));
                if (response == null) {
                    return null;
                }
                ArrayList<Character> characters = new ArrayList<Character>();
                Json.JsonObject[] arr = response.getJsonArray("data");
                if (arr == null) {
                    return null;
                }
                for (Json.JsonObject iterator : arr) {
                    characters.add(MyAnimeListSchema_Character.asCharacter(MyAnimeListImpl.this, iterator.getJsonObject("node")));
                }
                return characters;
            }

            @Override
            public final PaginatedIterator<Character> searchAll() {
                return new PagedIterator<Character>(this.offset, offset -> MyAnimeListImpl.this.service.getAnimeCharacters(MyAnimeListImpl.this.isTokenAuth ? MyAnimeListImpl.this.token : null, !MyAnimeListImpl.this.isTokenAuth ? MyAnimeListImpl.this.client_id : null, id, this.limit, (Integer)offset, MyAnimeListImpl.convertFields(Fields.character, this.fields)), iterator -> MyAnimeListSchema_Character.asCharacter(MyAnimeListImpl.this, iterator.getJsonObject("node")));
            }
        };
    }

    @Override
    public final AnimeRankingQuery getAnimeRanking(AnimeRankingType rankingType) {
        return this.getAnimeRanking(Objects.requireNonNull(rankingType, "Ranking type cannot be null").field());
    }

    @Override
    public final AnimeRankingQuery getAnimeRanking(String rankingType) {
        return new AnimeRankingQuery(Objects.requireNonNull(rankingType, "Ranking type cannot be null")){

            @Override
            public final List<AnimeRanking> search() {
                Json.JsonObject response = MyAnimeListImpl.handleResponse(() -> MyAnimeListImpl.this.service.getAnimeRanking(MyAnimeListImpl.this.isTokenAuth ? MyAnimeListImpl.this.token : null, !MyAnimeListImpl.this.isTokenAuth ? MyAnimeListImpl.this.client_id : null, this.rankingType, this.limit, this.offset, MyAnimeListImpl.convertFields(Fields.anime, this.fields), this.nsfw));
                if (response == null) {
                    return null;
                }
                ArrayList<AnimeRanking> anime = new ArrayList<AnimeRanking>();
                Json.JsonObject[] arr = response.getJsonArray("data");
                if (arr == null) {
                    return null;
                }
                for (Json.JsonObject iterator : arr) {
                    anime.add(MyAnimeListSchema_Anime.asAnimeRanking(MyAnimeListImpl.this, iterator));
                }
                return anime;
            }

            @Override
            public final PaginatedIterator<AnimeRanking> searchAll() {
                return new PagedIterator<AnimeRanking>(this.offset, offset -> MyAnimeListImpl.this.service.getAnimeRanking(MyAnimeListImpl.this.isTokenAuth ? MyAnimeListImpl.this.token : null, !MyAnimeListImpl.this.isTokenAuth ? MyAnimeListImpl.this.client_id : null, this.rankingType, this.limit, (Integer)offset, MyAnimeListImpl.convertFields(Fields.anime, this.fields), this.nsfw), iterator -> MyAnimeListSchema_Anime.asAnimeRanking(MyAnimeListImpl.this, iterator));
            }
        };
    }

    @Override
    public final AnimeSeasonQuery getAnimeSeason(int year, Season season) {
        return new AnimeSeasonQuery(year, Objects.requireNonNull(season, "Season cannot be null")){

            @Override
            public final List<Anime> search() {
                Json.JsonObject response = MyAnimeListImpl.handleResponse(() -> MyAnimeListImpl.this.service.getAnimeSeason(MyAnimeListImpl.this.isTokenAuth ? MyAnimeListImpl.this.token : null, !MyAnimeListImpl.this.isTokenAuth ? MyAnimeListImpl.this.client_id : null, this.year, this.season.field(), this.sort, this.limit, this.offset, MyAnimeListImpl.convertFields(Fields.anime, this.fields), this.nsfw));
                if (response == null) {
                    return null;
                }
                ArrayList<Anime> anime = new ArrayList<Anime>();
                Json.JsonObject[] arr = response.getJsonArray("data");
                if (arr == null) {
                    return null;
                }
                for (Json.JsonObject iterator : arr) {
                    anime.add(MyAnimeListSchema_Anime.asAnime(MyAnimeListImpl.this, iterator.getJsonObject("node")));
                }
                return anime;
            }

            @Override
            public final PaginatedIterator<Anime> searchAll() {
                return new PagedIterator<Anime>(this.offset, offset -> MyAnimeListImpl.this.service.getAnimeSeason(MyAnimeListImpl.this.isTokenAuth ? MyAnimeListImpl.this.token : null, !MyAnimeListImpl.this.isTokenAuth ? MyAnimeListImpl.this.client_id : null, this.year, this.season.field(), this.sort, this.limit, (Integer)offset, MyAnimeListImpl.convertFields(Fields.anime, this.fields), this.nsfw), iterator -> MyAnimeListSchema_Anime.asAnime(MyAnimeListImpl.this, iterator.getJsonObject("node")));
            }
        };
    }

    @Override
    public final AnimeSuggestionQuery getAnimeSuggestions() {
        return new AnimeSuggestionQuery(){

            @Override
            public final List<Anime> search() {
                Json.JsonObject response = MyAnimeListImpl.handleResponse(() -> MyAnimeListImpl.this.service.getAnimeSuggestions(Objects.requireNonNull(MyAnimeListImpl.this.token, "Client ID not supported for this endpoint, create a MyAnimeList object with either an Authenticator or Token"), this.limit, this.offset, MyAnimeListImpl.convertFields(Fields.anime, this.fields), this.nsfw));
                if (response == null) {
                    return null;
                }
                ArrayList<Anime> anime = new ArrayList<Anime>();
                Json.JsonObject[] arr = response.getJsonArray("data");
                if (arr == null) {
                    return null;
                }
                for (Json.JsonObject iterator : arr) {
                    anime.add(MyAnimeListSchema_Anime.asAnime(MyAnimeListImpl.this, iterator.getJsonObject("node")));
                }
                return anime;
            }

            @Override
            public final PaginatedIterator<Anime> searchAll() {
                return new PagedIterator<Anime>(this.offset, offset -> MyAnimeListImpl.this.service.getAnimeSuggestions(Objects.requireNonNull(MyAnimeListImpl.this.token, "Client ID not supported for this endpoint, create MyAnimeList object with either an Authenticator or Token"), this.limit, (Integer)offset, MyAnimeListImpl.convertFields(Fields.anime, this.fields), this.nsfw), iterator -> MyAnimeListSchema_Anime.asAnime(MyAnimeListImpl.this, iterator.getJsonObject("node")));
            }
        };
    }

    @Override
    public final AnimeListUpdate updateAnimeListing(long id) {
        return new AnimeListUpdate(id){

            @Override
            public final synchronized AnimeListStatus update() {
                Json.JsonObject response = MyAnimeListImpl.handleResponse(() -> MyAnimeListImpl.this.service.updateAnimeListing(Objects.requireNonNull(MyAnimeListImpl.this.token, "Client ID not supported for this endpoint, create MyAnimeList object with either an Authenticator or Token"), this.id, this.status, this.rewatching, this.score, MyAnimeListSchema.asYMD(this.startDate), MyAnimeListSchema.asYMD(this.finishDate), this.watchedEpisodes, this.priority, this.timesRewatched, this.rewatchValue, MyAnimeListImpl.toCommaSeparatedString(this.tags), this.comments));
                if (response == null) {
                    return null;
                }
                return MyAnimeListSchema_Anime.asAnimeListStatus((MyAnimeList)MyAnimeListImpl.this, response, this.id);
            }
        };
    }

    @Override
    public final synchronized void deleteAnimeListing(long id) {
        block2: {
            try {
                MyAnimeListImpl.handleVoidResponse(() -> this.service.deleteAnimeListing(Objects.requireNonNull(this.token, "Client ID not supported for this endpoint, create MyAnimeList object with either an Authenticator or Token"), (int)id));
            }
            catch (HttpException e) {
                if (e.code() == 404) break block2;
                throw e;
            }
        }
    }

    @Override
    public final UserAnimeListQuery getUserAnimeListing() {
        return this.getUserAnimeListing("@me");
    }

    @Override
    public final UserAnimeListQuery getUserAnimeListing(String username) {
        return new UserAnimeListQuery(Objects.requireNonNull(username, "Username cannot be null")){

            @Override
            public final List<AnimeListStatus> search() {
                Json.JsonObject response = MyAnimeListImpl.handleResponse(() -> MyAnimeListImpl.this.service.getUserAnimeListing(MyAnimeListImpl.this.isTokenAuth ? MyAnimeListImpl.this.token : null, !MyAnimeListImpl.this.isTokenAuth ? MyAnimeListImpl.this.client_id : null, this.username.equals("@me") ? "@me" : APICall.encodeUTF8(this.username), this.status, this.sort, this.limit, this.offset, MyAnimeListImpl.convertFields(Fields.anime, this.fields), this.nsfw));
                if (response == null) {
                    return null;
                }
                ArrayList<AnimeListStatus> anime = new ArrayList<AnimeListStatus>();
                Json.JsonObject[] arr = response.getJsonArray("data");
                if (arr == null) {
                    return null;
                }
                for (Json.JsonObject iterator : arr) {
                    anime.add(MyAnimeListSchema_Anime.asAnimeListStatus((MyAnimeList)MyAnimeListImpl.this, iterator.getJsonObject("list_status"), MyAnimeListSchema_Anime.asAnime(MyAnimeListImpl.this, iterator.getJsonObject("node"))));
                }
                return anime;
            }

            @Override
            public final PaginatedIterator<AnimeListStatus> searchAll() {
                return new PagedIterator<AnimeListStatus>(this.offset, offset -> MyAnimeListImpl.this.service.getUserAnimeListing(MyAnimeListImpl.this.isTokenAuth ? MyAnimeListImpl.this.token : null, !MyAnimeListImpl.this.isTokenAuth ? MyAnimeListImpl.this.client_id : null, this.username.equals("@me") ? "@me" : APICall.encodeUTF8(this.username), this.status, this.sort, this.limit, (Integer)offset, MyAnimeListImpl.convertFields(Fields.anime, this.fields), this.nsfw), iterator -> MyAnimeListSchema_Anime.asAnimeListStatus((MyAnimeList)MyAnimeListImpl.this, iterator.getJsonObject("list_status"), MyAnimeListSchema_Anime.asAnime(MyAnimeListImpl.this, iterator.getJsonObject("node"))));
            }
        };
    }

    @Override
    public final Character getCharacter(long id) {
        return this.getCharacter(id, null);
    }

    @Override
    public final Character getCharacter(long id, String ... fields) {
        this.checkExperimentalFeatureEnabled(ExperimentalFeature.CHARACTERS);
        return MyAnimeListSchema_Character.asCharacter(this, this.getCharacterSchema(id, fields));
    }

    final Json.JsonObject getCharacterSchema(long id, String ... fields) {
        return MyAnimeListImpl.handleResponse(() -> this.service.getCharacter(this.isTokenAuth ? this.token : null, !this.isTokenAuth ? this.client_id : null, id, MyAnimeListImpl.convertFields(Fields.character, fields)));
    }

    @Override
    public final List<ForumCategory> getForumBoards() {
        Json.JsonObject response = MyAnimeListImpl.handleResponse(() -> this.service.getForumBoards(this.isTokenAuth ? this.token : null, !this.isTokenAuth ? this.client_id : null));
        if (response == null) {
            return null;
        }
        ArrayList<ForumCategory> categories = new ArrayList<ForumCategory>();
        Json.JsonObject[] arr = response.getJsonArray("categories");
        if (arr == null) {
            return null;
        }
        for (Json.JsonObject iterator : arr) {
            categories.add(MyAnimeListSchema_Forum.asForumCategory(this, iterator));
        }
        return categories;
    }

    @Override
    public final ForumTopicDetail getForumTopicDetail(long id) {
        return this.getForumTopicDetail(id, null, null);
    }

    @Override
    public final ForumTopicDetail getForumTopicDetail(long id, Integer limit) {
        return this.getForumTopicDetail(id, limit, null);
    }

    @Override
    public final ForumTopicDetail getForumTopicDetail(long id, Integer limit, Integer offset) {
        Json.JsonObject response = MyAnimeListImpl.handleResponse(() -> this.service.getForumBoard(this.isTokenAuth ? this.token : null, !this.isTokenAuth ? this.client_id : null, id, limit, offset));
        return response != null ? MyAnimeListSchema_Forum.asForumTopic(this, response.getJsonObject("data"), id) : null;
    }

    @Override
    public final ForumTopicDetailPostQuery getForumTopicDetailPostQuery(final long id) {
        return new ForumTopicDetailPostQuery(){

            @Override
            public final List<Post> search() {
                Json.JsonObject response = MyAnimeListImpl.handleResponse(() -> MyAnimeListImpl.this.service.getForumBoard(MyAnimeListImpl.this.isTokenAuth ? MyAnimeListImpl.this.token : null, !MyAnimeListImpl.this.isTokenAuth ? MyAnimeListImpl.this.client_id : null, id, this.limit, this.offset));
                if (response == null) {
                    return null;
                }
                ArrayList<Post> posts = new ArrayList<Post>();
                Json.JsonObject[] arr = response.getJsonObject("data").getJsonArray("posts");
                if (arr == null) {
                    return null;
                }
                for (Json.JsonObject iterator : arr) {
                    posts.add(MyAnimeListSchema_Forum.asPost((MyAnimeList)MyAnimeListImpl.this, iterator, id));
                }
                return posts;
            }

            @Override
            public final PaginatedIterator<Post> searchAll() {
                return new PagedIterator<Post>(this.offset, offset -> MyAnimeListImpl.this.service.getForumBoard(MyAnimeListImpl.this.isTokenAuth ? MyAnimeListImpl.this.token : null, !MyAnimeListImpl.this.isTokenAuth ? MyAnimeListImpl.this.client_id : null, id, this.limit, (Integer)offset), iterator -> MyAnimeListSchema_Forum.asPost((MyAnimeList)MyAnimeListImpl.this, iterator, id));
            }
        };
    }

    @Override
    public final ForumSearchQuery getForumTopics() {
        return new ForumSearchQuery(){

            @Override
            public final List<ForumTopic> search() {
                Json.JsonObject response = MyAnimeListImpl.handleResponse(() -> MyAnimeListImpl.this.service.getForumTopics(MyAnimeListImpl.this.isTokenAuth ? MyAnimeListImpl.this.token : null, !MyAnimeListImpl.this.isTokenAuth ? MyAnimeListImpl.this.client_id : null, this.boardId, this.subboardId, this.limit, this.offset, this.sort.field(), this.query, this.topicUsername, this.username));
                if (response == null) {
                    return null;
                }
                ArrayList<ForumTopic> topics = new ArrayList<ForumTopic>();
                Json.JsonObject[] arr = response.getJsonArray("data");
                if (arr == null) {
                    return null;
                }
                for (Json.JsonObject iterator : arr) {
                    topics.add(MyAnimeListSchema_Forum.asForumTopicDetail(MyAnimeListImpl.this, iterator, this.boardId, this.subboardId));
                }
                return topics;
            }

            @Override
            public final PaginatedIterator<ForumTopic> searchAll() {
                return new PagedIterator<ForumTopic>(this.offset, offset -> MyAnimeListImpl.this.service.getForumTopics(MyAnimeListImpl.this.isTokenAuth ? MyAnimeListImpl.this.token : null, !MyAnimeListImpl.this.isTokenAuth ? MyAnimeListImpl.this.client_id : null, this.boardId, this.subboardId, this.limit, (Integer)offset, this.sort.field(), this.query, this.topicUsername, this.username), iterator -> MyAnimeListSchema_Forum.asForumTopicDetail(MyAnimeListImpl.this, iterator, this.boardId, this.subboardId));
            }
        };
    }

    @Override
    public final MangaSearchQuery getManga() {
        return new MangaSearchQuery(){

            @Override
            public final List<Manga> search() {
                Json.JsonObject response = MyAnimeListImpl.handleResponse(() -> MyAnimeListImpl.this.service.getManga(MyAnimeListImpl.this.isTokenAuth ? MyAnimeListImpl.this.token : null, !MyAnimeListImpl.this.isTokenAuth ? MyAnimeListImpl.this.client_id : null, this.query, this.limit, this.offset, MyAnimeListImpl.convertFields(Fields.manga, this.fields), this.nsfw));
                if (response == null) {
                    return null;
                }
                ArrayList<Manga> manga = new ArrayList<Manga>();
                Json.JsonObject[] arr = response.getJsonArray("data");
                if (arr == null) {
                    return null;
                }
                for (Json.JsonObject iterator : arr) {
                    manga.add(MyAnimeListSchema_Manga.asManga(MyAnimeListImpl.this, iterator.getJsonObject("node")));
                }
                return manga;
            }

            @Override
            public final PaginatedIterator<Manga> searchAll() {
                return new PagedIterator<Manga>(this.offset, offset -> MyAnimeListImpl.this.service.getManga(MyAnimeListImpl.this.isTokenAuth ? MyAnimeListImpl.this.token : null, !MyAnimeListImpl.this.isTokenAuth ? MyAnimeListImpl.this.client_id : null, this.query, this.limit, (Integer)offset, MyAnimeListImpl.convertFields(Fields.manga, this.fields), this.nsfw), iterator -> MyAnimeListSchema_Manga.asManga(MyAnimeListImpl.this, iterator.getJsonObject("node")));
            }
        };
    }

    @Override
    public final Manga getManga(long id) {
        return this.getManga(id, null);
    }

    @Override
    public final Manga getManga(long id, String ... fields) {
        return MyAnimeListSchema_Manga.asManga(this, this.getMangaSchema(id, fields));
    }

    final Json.JsonObject getMangaSchema(long id, String ... fields) {
        return MyAnimeListImpl.handleResponse(() -> this.service.getManga(this.isTokenAuth ? this.token : null, !this.isTokenAuth ? this.client_id : null, id, MyAnimeListImpl.convertFields(Fields.manga, fields)));
    }

    @Override
    public final MangaRankingQuery getMangaRanking(MangaRankingType rankingType) {
        return this.getMangaRanking(Objects.requireNonNull(rankingType, "Ranking type cannot be null").field());
    }

    @Override
    public final MangaRankingQuery getMangaRanking(String rankingType) {
        return new MangaRankingQuery(Objects.requireNonNull(rankingType, "Ranking type cannot be null")){

            @Override
            public final List<MangaRanking> search() {
                Json.JsonObject response = MyAnimeListImpl.handleResponse(() -> MyAnimeListImpl.this.service.getMangaRanking(MyAnimeListImpl.this.isTokenAuth ? MyAnimeListImpl.this.token : null, !MyAnimeListImpl.this.isTokenAuth ? MyAnimeListImpl.this.client_id : null, this.rankingType, this.limit, this.offset, MyAnimeListImpl.convertFields(Fields.manga, this.fields), this.nsfw));
                if (response == null) {
                    return null;
                }
                ArrayList<MangaRanking> manga = new ArrayList<MangaRanking>();
                Json.JsonObject[] arr = response.getJsonArray("data");
                if (arr == null) {
                    return null;
                }
                for (Json.JsonObject iterator : arr) {
                    manga.add(MyAnimeListSchema_Manga.asMangaRanking(MyAnimeListImpl.this, iterator));
                }
                return manga;
            }

            @Override
            public final PaginatedIterator<MangaRanking> searchAll() {
                return new PagedIterator<MangaRanking>(this.offset, offset -> MyAnimeListImpl.this.service.getMangaRanking(MyAnimeListImpl.this.isTokenAuth ? MyAnimeListImpl.this.token : null, !MyAnimeListImpl.this.isTokenAuth ? MyAnimeListImpl.this.client_id : null, this.rankingType, this.limit, (Integer)offset, MyAnimeListImpl.convertFields(Fields.manga, this.fields), this.nsfw), iterator -> MyAnimeListSchema_Manga.asMangaRanking(MyAnimeListImpl.this, iterator));
            }
        };
    }

    @Override
    public final MangaListUpdate updateMangaListing(long id) {
        return new MangaListUpdate(id){

            @Override
            public final synchronized MangaListStatus update() {
                Json.JsonObject response = MyAnimeListImpl.handleResponse(() -> MyAnimeListImpl.this.service.updateMangaListing(Objects.requireNonNull(MyAnimeListImpl.this.token, "Client ID not supported for this endpoint, create MyAnimeList object with either an Authenticator or Token"), this.id, this.status, this.rereading, this.score, MyAnimeListSchema.asYMD(this.startDate), MyAnimeListSchema.asYMD(this.finishDate), this.volumesRead, this.chaptersRead, this.priority, this.timesReread, this.rereadValue, MyAnimeListImpl.toCommaSeparatedString(this.tags), this.comments));
                if (response == null) {
                    return null;
                }
                return MyAnimeListSchema_Manga.asMangaListStatus((MyAnimeList)MyAnimeListImpl.this, response, this.id);
            }
        };
    }

    @Override
    public final synchronized void deleteMangaListing(long id) {
        block2: {
            try {
                MyAnimeListImpl.handleVoidResponse(() -> this.service.deleteMangaListing(Objects.requireNonNull(this.token, "Client ID not supported for this endpoint, create MyAnimeList object with either an Authenticator or Token"), id));
            }
            catch (HttpException e) {
                if (e.code() == 404) break block2;
                throw e;
            }
        }
    }

    @Override
    public final UserMangaListQuery getUserMangaListing() {
        return this.getUserMangaListing("@me");
    }

    @Override
    public final UserMangaListQuery getUserMangaListing(String username) {
        return new UserMangaListQuery(Objects.requireNonNull(username, "Username cannot be null")){

            @Override
            public final List<MangaListStatus> search() {
                Json.JsonObject response = MyAnimeListImpl.handleResponse(() -> MyAnimeListImpl.this.service.getUserMangaListing(MyAnimeListImpl.this.isTokenAuth ? MyAnimeListImpl.this.token : null, !MyAnimeListImpl.this.isTokenAuth ? MyAnimeListImpl.this.client_id : null, this.username.equals("@me") ? "@me" : APICall.encodeUTF8(this.username), this.status, this.sort, this.limit, this.offset, MyAnimeListImpl.convertFields(Fields.manga, this.fields), this.nsfw));
                if (response == null) {
                    return null;
                }
                ArrayList<MangaListStatus> manga = new ArrayList<MangaListStatus>();
                Json.JsonObject[] arr = response.getJsonArray("data");
                if (arr == null) {
                    return null;
                }
                for (Json.JsonObject iterator : arr) {
                    manga.add(MyAnimeListSchema_Manga.asMangaListStatus((MyAnimeList)MyAnimeListImpl.this, iterator.getJsonObject("list_status"), MyAnimeListSchema_Manga.asManga(MyAnimeListImpl.this, iterator.getJsonObject("node"))));
                }
                return manga;
            }

            @Override
            public final PaginatedIterator<MangaListStatus> searchAll() {
                return new PagedIterator<MangaListStatus>(this.offset, offset -> MyAnimeListImpl.this.service.getUserMangaListing(MyAnimeListImpl.this.isTokenAuth ? MyAnimeListImpl.this.token : null, !MyAnimeListImpl.this.isTokenAuth ? MyAnimeListImpl.this.client_id : null, this.username.equals("@me") ? "@me" : APICall.encodeUTF8(this.username), this.status, this.sort, this.limit, (Integer)offset, MyAnimeListImpl.convertFields(Fields.manga, this.fields), this.nsfw), iterator -> MyAnimeListSchema_Manga.asMangaListStatus((MyAnimeList)MyAnimeListImpl.this, iterator.getJsonObject("list_status"), MyAnimeListSchema_Manga.asManga(MyAnimeListImpl.this, iterator.getJsonObject("node"))));
            }
        };
    }

    @Override
    public final Person getPerson(long id) {
        return this.getPerson(id, null);
    }

    @Override
    public final Person getPerson(long id, String ... fields) {
        this.checkExperimentalFeatureEnabled(ExperimentalFeature.PEOPLE);
        return MyAnimeListSchema_People.asPerson(this, MyAnimeListImpl.handleResponse(() -> this.service.getPerson(this.isTokenAuth ? this.token : null, !this.isTokenAuth ? this.client_id : null, id, MyAnimeListImpl.convertFields(Fields.people, fields))));
    }

    @Override
    public final User getAuthenticatedUser() {
        return this.getUser("@me", null);
    }

    @Override
    public final User getAuthenticatedUser(String ... fields) {
        return this.getUser("@me", fields);
    }

    @Override
    public final User getUser(String username) {
        return this.getUser(username, null);
    }

    @Override
    public final User getUser(String username, String ... fields) {
        Objects.requireNonNull(username, "Username cannot be null");
        return MyAnimeListSchema_User.asUser(this, MyAnimeListImpl.handleResponse(() -> this.service.getUser(Objects.requireNonNull(this.token, "Client ID not supported for this endpoint, create MyAnimeList object with either an Authenticator or Token"), username.equals("@me") ? "@me" : APICall.encodeUTF8(username), MyAnimeListImpl.convertFields(Fields.user, fields))));
    }

    private static void handleVoidResponse(ExceptionSupplier<APIStruct.Response<?>, IOException> supplier) {
        MyAnimeListImpl.handleResponseCodes(supplier);
    }

    private static Json.JsonObject handleResponse(ExceptionSupplier<APIStruct.Response<?>, IOException> supplier) {
        APIStruct.Response<?> response = MyAnimeListImpl.handleResponseCodes(supplier);
        return response.code() == 200 ? (Json.JsonObject)response.body() : null;
    }

    private static APIStruct.Response<?> handleResponseCodes(ExceptionSupplier<APIStruct.Response<?>, IOException> supplier) {
        try {
            APIStruct.Response<?> response = supplier.get();
            switch (response.code()) {
                case 200: {
                    return response;
                }
                case 401: {
                    throw new InvalidTokenException("The OAuth token provided is either invalid or expired");
                }
            }
            try {
                throw new HttpException(response.URL(), response.code(), (((Json.JsonObject)response.body()).getString("message") + ' ' + ((Json.JsonObject)response.body()).getString("error")).trim());
            }
            catch (Throwable ignored) {
                throw new HttpException(response.URL(), response.code(), response.raw());
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public final String toString() {
        return "MyAnimeList{authenticator=" + this.authenticator + ", service=" + this.service + '}';
    }

    private static String toCommaSeparatedString(List<String> fields) {
        return MyAnimeListImpl.toCommaSeparatedString(fields == null ? null : fields.toArray(new String[0]));
    }

    private static String toCommaSeparatedString(String ... fields) {
        if (fields != null) {
            if (fields.length == 0) {
                return "";
            }
            StringBuilder SB = new StringBuilder();
            for (String field : fields) {
                if (field.trim().length() <= 0) continue;
                SB.append(field).append(',');
            }
            return SB.toString().endsWith(",") ? SB.deleteCharAt(SB.length() - 1).toString() : "";
        }
        return null;
    }

    private static String convertFields(String defaultFields, List<String> fields) {
        return MyAnimeListImpl.convertFields(defaultFields, fields == null ? null : fields.toArray(new String[0]));
    }

    private static String convertFields(String defaultFields, String ... fields) {
        if (fields == null || fields.length == 1 && fields[0].equals("%INVERTED_MODIFIER%")) {
            return defaultFields;
        }
        if (fields.length == 0) {
            return "";
        }
        boolean inverted = false;
        for (String field : fields) {
            if (!field.equals("%INVERTED_MODIFIER%")) continue;
            inverted = true;
            break;
        }
        if (!inverted) {
            return MyAnimeListImpl.toCommaSeparatedString(fields);
        }
        String buffer = defaultFields;
        for (String field : fields) {
            buffer = buffer.replaceAll(inverted.replace("%s", Pattern.quote(field)), "");
        }
        return buffer;
    }

    private static interface ExceptionSupplier<T, E extends Throwable> {
        public T get() throws E;
    }

    private static class PagedIterator<T>
    extends PaginatedIterator<T> {
        private final Function<Integer, APIStruct.Response<Json.JsonObject>> fullPageSupplier;
        private final Function<Json.JsonObject, T> listAdapter;
        private final AtomicReference<Integer> nextOffset = new AtomicReference();
        private Json.JsonObject nextPage = null;

        PagedIterator(Integer offset, Function<Integer, APIStruct.Response<Json.JsonObject>> fullPageSupplier, Function<Json.JsonObject, T> listAdapter) {
            this.fullPageSupplier = fullPageSupplier;
            this.listAdapter = listAdapter;
            this.nextOffset.set(offset);
            this.list = this.getNextPage();
            this.size = this.list == null ? 0 : this.list.size();
        }

        @Override
        final boolean hasNextPage() {
            return this.nextOffset.get() != -1;
        }

        @Override
        final synchronized List<T> getNextPage() {
            Json.JsonObject response;
            Json.JsonObject jsonObject = response = this.nextPage != null ? this.nextPage : MyAnimeListImpl.handleResponse(() -> this.fullPageSupplier.apply(this.nextOffset.get()));
            if (response == null) {
                this.nextOffset.set(-1);
                return null;
            }
            ArrayList<T> list = new ArrayList<T>();
            for (Json.JsonObject data : response.get("data") instanceof Json.JsonObject && response.getJsonObject("data").containsKey("posts") ? response.getJsonObject("data").getJsonArray("posts") : response.getJsonArray("data")) {
                list.add(this.listAdapter.apply(data));
            }
            if (response.getJsonObject("paging").containsKey("next")) {
                Integer b4 = this.nextOffset.get();
                this.nextOffset.set((b4 == null ? 0 : b4) + list.size());
                this.nextPage = MyAnimeListImpl.handleResponse(() -> this.fullPageSupplier.apply(this.nextOffset.get()));
                if ((this.nextPage.get("data") instanceof Json.JsonObject && this.nextPage.getJsonObject("data").containsKey("posts") ? this.nextPage.getJsonObject("data").getJsonArray("posts") : this.nextPage.getJsonArray("data")).length > 0) {
                    return list;
                }
            }
            this.nextPage = null;
            this.nextOffset.set(-1);
            return list;
        }
    }
}

