/*
 * Decompiled with CFR 0.152.
 */
package dev.katsute.mal4j;

import dev.katsute.mal4j.Json;
import dev.katsute.mal4j.anime.property.time.Time;
import dev.katsute.mal4j.property.NullableDate;
import java.lang.reflect.Array;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.function.Function;

abstract class MyAnimeListSchema {
    private static final String YMD = "yyyy-MM-dd";
    private static final String YM = "yyyy-MM";
    private static final String Y = "yyyy";
    private static final String ISO8601 = "yyyy-MM-dd'T'HH:mm:ssXXX";

    MyAnimeListSchema() {
    }

    protected static <R> R[] adaptList(Json.JsonObject[] list, Function<Json.JsonObject, R> adapter, Class<R> Class2) {
        if (list == null) {
            return null;
        }
        int len = list.length;
        Object[] array = (Object[])Array.newInstance(Class2, len);
        for (int i = 0; i < len; ++i) {
            array[i] = adapter.apply(list[i]);
        }
        return array;
    }

    protected static Long parseDate(String date) {
        if (date == null) {
            return null;
        }
        try {
            int len = date.length();
            return new SimpleDateFormat(len == 10 ? YMD : (len == 7 ? YM : Y)).parse(date).getTime();
        }
        catch (ParseException e) {
            return null;
        }
    }

    protected static NullableDate parseNullableDate(String date) {
        Integer d;
        Integer m;
        Integer y;
        long t;
        if (date == null) {
            return null;
        }
        int len = date.length();
        String[] parts = date.split("-");
        try {
            t = new SimpleDateFormat(len == 10 ? YMD : (len == 7 ? YM : Y)).parse(date).getTime();
            y = parts.length >= 1 ? Integer.valueOf(parts[0]) : null;
            m = parts.length >= 2 ? Integer.valueOf(parts[1]) : null;
            d = parts.length >= 3 ? Integer.valueOf(parts[2]) : null;
        }
        catch (NumberFormatException | ParseException ignored) {
            return null;
        }
        return new NullableDate(){
            private final Long time;
            private final Integer year;
            private final Integer month;
            private final Integer day;
            {
                this.time = t;
                this.year = y;
                this.month = m;
                this.day = d;
            }

            @Override
            public final Integer getYear() {
                return this.year;
            }

            @Override
            public final Integer getMonth() {
                return this.month;
            }

            @Override
            public final Integer getDay() {
                return this.day;
            }

            @Override
            public final Long getMillis() {
                return this.time;
            }

            @Override
            public final Date getDate() {
                return new Date(this.time);
            }

            public final String toString() {
                return "NullableDate{year=" + this.year + ", month=" + this.month + ", day=" + this.day + '}';
            }
        };
    }

    static String asYMD(Long millis) {
        return millis == null ? null : new SimpleDateFormat(YMD).format(new Date(millis));
    }

    protected static Long parseISO8601(String timestamp) {
        if (timestamp == null) {
            return null;
        }
        try {
            return new SimpleDateFormat(ISO8601).parse(timestamp).getTime();
        }
        catch (ParseException ignored) {
            return null;
        }
    }

    static String asISO8601(Long millis) {
        return millis == null ? null : new SimpleDateFormat(ISO8601).format(new Date(millis));
    }

    protected static Time asTime(String time) {
        if (time == null || !time.contains(":")) {
            return null;
        }
        String[] hhmm = time.split(":");
        final int h = Integer.parseInt(hhmm[0]);
        final int m = Integer.parseInt(hhmm[1]);
        return new Time(){
            private final Integer hour;
            private final Integer hour12;
            private final Boolean am;
            private final Integer minute;
            {
                this.hour = h;
                this.hour12 = h > 12 ? h - 12 : (h == 0 ? 12 : h);
                this.am = this.hour <= 12;
                this.minute = m;
            }

            @Override
            public final Integer getHour() {
                return this.hour;
            }

            @Override
            public final Integer get12Hour() {
                return this.hour12;
            }

            @Override
            public final Boolean isAM() {
                return this.am;
            }

            @Override
            public final Boolean isPM() {
                return this.am == false;
            }

            @Override
            public final Integer getMinute() {
                return this.minute;
            }

            public final String toString() {
                return "Time{hour=" + this.hour + ", hour12=" + this.hour12 + ", am=" + this.am + ", minute=" + this.minute + '}';
            }
        };
    }
}

