/*
 * Decompiled with CFR 0.152.
 */
package dev.katsute.mal4j;

import dev.katsute.mal4j.Json;
import dev.katsute.mal4j.MyAnimeList;
import dev.katsute.mal4j.MyAnimeListImpl;
import dev.katsute.mal4j.MyAnimeListSchema;
import dev.katsute.mal4j.MyAnimeListSchema_Common;
import dev.katsute.mal4j.MyAnimeListSchema_Manga;
import dev.katsute.mal4j.anime.Anime;
import dev.katsute.mal4j.anime.AnimeListStatus;
import dev.katsute.mal4j.anime.AnimeRanking;
import dev.katsute.mal4j.anime.AnimeRecommendation;
import dev.katsute.mal4j.anime.RelatedAnime;
import dev.katsute.mal4j.anime.property.AnimeAirStatus;
import dev.katsute.mal4j.anime.property.AnimeRating;
import dev.katsute.mal4j.anime.property.AnimeSource;
import dev.katsute.mal4j.anime.property.AnimeStatistics;
import dev.katsute.mal4j.anime.property.AnimeStatus;
import dev.katsute.mal4j.anime.property.AnimeType;
import dev.katsute.mal4j.anime.property.Broadcast;
import dev.katsute.mal4j.anime.property.EndingTheme;
import dev.katsute.mal4j.anime.property.OpeningTheme;
import dev.katsute.mal4j.anime.property.RewatchValue;
import dev.katsute.mal4j.anime.property.StartSeason;
import dev.katsute.mal4j.anime.property.Studio;
import dev.katsute.mal4j.anime.property.Video;
import dev.katsute.mal4j.anime.property.time.DayOfWeek;
import dev.katsute.mal4j.anime.property.time.Season;
import dev.katsute.mal4j.anime.property.time.Time;
import dev.katsute.mal4j.manga.RelatedManga;
import dev.katsute.mal4j.property.AlternativeTitles;
import dev.katsute.mal4j.property.ExperimentalFeature;
import dev.katsute.mal4j.property.Genre;
import dev.katsute.mal4j.property.NSFW;
import dev.katsute.mal4j.property.NullableDate;
import dev.katsute.mal4j.property.Picture;
import dev.katsute.mal4j.property.Priority;
import dev.katsute.mal4j.property.RelationType;
import dev.katsute.mal4j.query.AnimeCharacterQuery;
import dev.katsute.mal4j.query.AnimeListUpdate;
import java.util.Arrays;
import java.util.Date;
import java.util.Objects;

abstract class MyAnimeListSchema_Anime
extends MyAnimeListSchema {
    MyAnimeListSchema_Anime() {
    }

    static AnimeStatistics asAnimeStatistics(MyAnimeList mal, final Json.JsonObject schema) {
        return schema == null ? null : new AnimeStatistics(){
            private final Integer watching;
            private final Integer completed;
            private final Integer onHold;
            private final Integer dropped;
            private final Integer planToWatch;
            private final Integer userCount;
            {
                this.watching = schema.getJsonObject("status").getInt("watching");
                this.completed = schema.getJsonObject("status").getInt("completed");
                this.onHold = schema.getJsonObject("status").getInt("on_hold");
                this.dropped = schema.getJsonObject("status").getInt("dropped");
                this.planToWatch = schema.getJsonObject("status").getInt("plan_to_watch");
                this.userCount = schema.getInt("num_list_users");
            }

            @Override
            public final Integer getWatching() {
                return this.watching;
            }

            @Override
            public final Integer getCompleted() {
                return this.completed;
            }

            @Override
            public final Integer getOnHold() {
                return this.onHold;
            }

            @Override
            public final Integer getDropped() {
                return this.dropped;
            }

            @Override
            public final Integer getPlanToWatch() {
                return this.planToWatch;
            }

            @Override
            public final Integer getUserCount() {
                return this.userCount;
            }

            public final String toString() {
                return "AnimeStatistics{watching=" + this.watching + ", completed=" + this.completed + ", onHold=" + this.onHold + ", dropped=" + this.dropped + ", planToWatch=" + this.planToWatch + ", userCount=" + this.userCount + '}';
            }
        };
    }

    static Broadcast asBroadcast(MyAnimeList mal, final Json.JsonObject schema) {
        return schema == null ? null : new Broadcast(){
            private final DayOfWeek dayOfWeek;
            private final Time time;
            {
                this.dayOfWeek = DayOfWeek.asEnum(schema.getString("day_of_the_week"));
                this.time = MyAnimeListSchema.asTime(schema.getString("start_time"));
            }

            @Override
            public final DayOfWeek getDayOfWeek() {
                return this.dayOfWeek;
            }

            @Override
            public final Time getStartTime() {
                return this.time;
            }

            public String toString() {
                return "Broadcast{dayOfWeek=" + this.dayOfWeek + ", time=" + this.time + '}';
            }
        };
    }

    static StartSeason asStartSeason(MyAnimeList mal, final Json.JsonObject schema) {
        return schema == null ? null : new StartSeason(){
            private final Integer year;
            private final Season season;
            {
                this.year = schema.getInt("year");
                this.season = Season.asEnum(schema.getString("season"));
            }

            @Override
            public final Integer getYear() {
                return this.year;
            }

            @Override
            public final Season getSeason() {
                return this.season;
            }

            public final String toString() {
                return "StartSeason{year=" + this.year + ", season=" + this.season + '}';
            }
        };
    }

    static Studio asStudio(MyAnimeList mal, final Json.JsonObject schema) {
        return schema == null ? null : new Studio(){
            private final Long id;
            private final String name;
            {
                this.id = schema.getLong("id");
                this.name = schema.getString("name");
            }

            @Override
            public final Long getID() {
                return this.id;
            }

            @Override
            public final String getName() {
                return this.name;
            }

            public final String toString() {
                return "Studio{id=" + this.id + ", name='" + this.name + '\'' + '}';
            }
        };
    }

    static OpeningTheme asOpeningTheme(MyAnimeList mal, final Json.JsonObject schema, final Anime anime) {
        return schema == null ? null : new OpeningTheme(){
            private final Long id;
            private final String text;
            {
                this.id = schema.getLong("id");
                this.text = schema.getString("text");
            }

            @Override
            public final Long getID() {
                return this.id;
            }

            @Override
            public final String getText() {
                return this.text;
            }

            @Override
            public final Anime getAnime() {
                return anime;
            }

            public final String toString() {
                return "OpeningTheme{id=" + this.id + ", text='" + this.text + '\'' + '}';
            }
        };
    }

    static EndingTheme asEndingTheme(MyAnimeList mal, final Json.JsonObject schema, final Anime anime) {
        return schema == null ? null : new EndingTheme(){
            private final Long id;
            private final String text;
            {
                this.id = schema.getLong("id");
                this.text = schema.getString("text");
            }

            @Override
            public final Long getID() {
                return this.id;
            }

            @Override
            public final String getText() {
                return this.text;
            }

            @Override
            public final Anime getAnime() {
                return anime;
            }

            public final String toString() {
                return "EndingTheme{id=" + this.id + ", text='" + this.text + '\'' + '}';
            }
        };
    }

    static Video asVideo(MyAnimeList mal, final Json.JsonObject schema) {
        return schema == null ? null : new Video(){
            private final Long id;
            private final String title;
            private final String url;
            private final String thumbnail;
            private final Long createdAt;
            private final Long updatedAt;
            {
                this.id = schema.getLong("id");
                this.title = schema.getString("title");
                this.url = schema.getString("url");
                this.thumbnail = schema.getString("thumbnail");
                this.createdAt = schema.getLong("created_at");
                this.updatedAt = schema.getLong("updated_at");
            }

            @Override
            public final Long getID() {
                return this.id;
            }

            @Override
            public final String getTitle() {
                return this.title;
            }

            @Override
            public final String getURL() {
                return this.url;
            }

            @Override
            public final String getThumbnail() {
                return this.thumbnail;
            }

            @Override
            public final Date getCreatedAt() {
                return this.createdAt == null ? null : new Date(this.createdAt);
            }

            @Override
            public final Long getCreatedAtEpochMillis() {
                return this.createdAt;
            }

            @Override
            public final Date getUpdatedAt() {
                return this.updatedAt == null ? null : new Date(this.updatedAt);
            }

            @Override
            public final Long getUpdatedAtEpochMillis() {
                return this.updatedAt;
            }

            public final String toString() {
                return "Video{id=" + this.id + ", title='" + this.title + '\'' + ", url='" + this.url + '\'' + ", thumbnail='" + this.thumbnail + '\'' + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + '}';
            }
        };
    }

    static Anime asAnime(final MyAnimeList mal, final Json.JsonObject schema) {
        return schema == null ? null : new Anime(){
            boolean draft = true;
            private final Long id = schema.getLong("id");
            private String title;
            private Picture mainPicture;
            private AlternativeTitles alternativeTitles;
            private NullableDate startDate;
            private NullableDate endDate;
            private String synopsis;
            private Float meanRating;
            private Integer rank;
            private Integer popularity;
            private Integer usersListing;
            private Integer usersScoring;
            private String nsfw;
            private NSFW e_nsfw;
            private Genre[] genres;
            private Long createdAt;
            private Long updatedAt;
            private String type;
            private AnimeType e_type;
            private String status;
            private AnimeAirStatus e_status;
            private AnimeListStatus listStatus;
            private Integer episodes;
            private StartSeason startSeason;
            private Broadcast broadcast;
            private String source;
            private AnimeSource e_source;
            private Integer episodeLength;
            private String rating;
            private AnimeRating e_rating;
            private Studio[] studios;
            private Picture[] pictures;
            private String background;
            private RelatedAnime[] relatedAnime;
            private RelatedManga[] relatedManga;
            private AnimeRecommendation[] recommendations;
            private AnimeStatistics statistics;
            private OpeningTheme[] openingThemes;
            private EndingTheme[] endingThemes;
            private Video[] videos;
            {
                this.populate(schema);
            }

            private void populate() {
                if (this.draft) {
                    this.draft = false;
                    this.populate(((MyAnimeListImpl)mal).getAnimeSchema(this.id, null));
                }
            }

            private void populate(Json.JsonObject schema2) {
                this.title = schema2.getString("title");
                this.mainPicture = MyAnimeListSchema_Common.asPicture(mal, schema2.getJsonObject("main_picture"));
                this.alternativeTitles = MyAnimeListSchema_Common.asAlternativeTitles(mal, schema2.getJsonObject("alternative_titles"));
                this.startDate = MyAnimeListSchema.parseNullableDate(schema2.getString("start_date"));
                this.endDate = MyAnimeListSchema.parseNullableDate(schema2.getString("end_date"));
                this.synopsis = schema2.getString("synopsis");
                this.meanRating = schema2.getFloat("mean");
                this.rank = schema2.getInt("rank");
                this.popularity = schema2.getInt("popularity");
                this.usersListing = schema2.getInt("num_list_users");
                this.usersScoring = schema2.getInt("num_scoring_users");
                this.nsfw = schema2.getString("nsfw");
                this.e_nsfw = NSFW.asEnum(this.nsfw);
                this.genres = MyAnimeListSchema.adaptList(schema2.getJsonArray("genres"), g -> MyAnimeListSchema_Common.asGenre(mal, g, true), Genre.class);
                this.createdAt = MyAnimeListSchema.parseISO8601(schema2.getString("created_at"));
                this.updatedAt = MyAnimeListSchema.parseISO8601(schema2.getString("updated_at"));
                this.type = schema2.getString("media_type");
                this.e_type = AnimeType.asEnum(this.type);
                this.status = schema2.getString("status");
                this.e_status = AnimeAirStatus.asEnum(this.status);
                this.listStatus = MyAnimeListSchema_Anime.asAnimeListStatus(mal, schema2.getJsonObject("my_list_status"), this.id, this);
                this.episodes = schema2.getInt("num_episodes");
                this.startSeason = MyAnimeListSchema_Anime.asStartSeason(mal, schema2.getJsonObject("start_season"));
                this.broadcast = MyAnimeListSchema_Anime.asBroadcast(mal, schema2.getJsonObject("broadcast"));
                this.source = schema2.getString("source");
                this.e_source = AnimeSource.asEnum(this.source);
                this.episodeLength = schema2.getInt("average_episode_duration");
                this.rating = schema2.getString("rating");
                this.e_rating = AnimeRating.asEnum(this.rating);
                this.studios = MyAnimeListSchema.adaptList(schema2.getJsonArray("studios"), s -> MyAnimeListSchema_Anime.asStudio(mal, s), Studio.class);
                this.pictures = MyAnimeListSchema.adaptList(schema2.getJsonArray("pictures"), p -> MyAnimeListSchema_Common.asPicture(mal, p), Picture.class);
                this.background = schema2.getString("background");
                this.relatedAnime = MyAnimeListSchema.adaptList(schema2.getJsonArray("related_anime"), a -> MyAnimeListSchema_Anime.asRelatedAnime(mal, a), RelatedAnime.class);
                this.relatedManga = MyAnimeListSchema.adaptList(schema2.getJsonArray("related_manga"), m -> MyAnimeListSchema_Manga.asRelatedManga(mal, m), RelatedManga.class);
                this.recommendations = MyAnimeListSchema.adaptList(schema2.getJsonArray("recommendations"), r -> MyAnimeListSchema_Anime.asAnimeRecommendation(mal, r), AnimeRecommendation.class);
                this.statistics = MyAnimeListSchema_Anime.asAnimeStatistics(mal, schema2.getJsonObject("statistics"));
                this.openingThemes = MyAnimeListSchema.adaptList(schema2.getJsonArray("opening_themes"), o -> MyAnimeListSchema_Anime.asOpeningTheme(mal, o, this), OpeningTheme.class);
                this.endingThemes = MyAnimeListSchema.adaptList(schema2.getJsonArray("ending_themes"), o -> MyAnimeListSchema_Anime.asEndingTheme(mal, o, this), EndingTheme.class);
                this.videos = MyAnimeListSchema.adaptList(schema2.getJsonArray("videos"), o -> MyAnimeListSchema_Anime.asVideo(mal, o), Video.class);
            }

            @Override
            public final Long getID() {
                return this.id;
            }

            @Override
            public final String getTitle() {
                if (this.title == null && this.draft) {
                    this.populate();
                }
                return this.title;
            }

            @Override
            public final Picture getMainPicture() {
                if (this.mainPicture == null && this.draft) {
                    this.populate();
                }
                return this.mainPicture;
            }

            @Override
            public final AlternativeTitles getAlternativeTitles() {
                if (this.alternativeTitles == null && this.draft) {
                    this.populate();
                }
                return this.alternativeTitles;
            }

            @Override
            public final NullableDate getStartDate() {
                if (this.startDate == null && this.draft) {
                    this.populate();
                }
                return this.startDate;
            }

            @Override
            public final NullableDate getEndDate() {
                if (this.endDate == null && this.draft) {
                    this.populate();
                }
                return this.endDate;
            }

            @Override
            public final String getSynopsis() {
                if (this.synopsis == null && this.draft) {
                    this.populate();
                }
                return this.synopsis;
            }

            @Override
            public final Float getMeanRating() {
                if (this.meanRating == null && this.draft) {
                    this.populate();
                }
                return this.meanRating;
            }

            @Override
            public final Integer getRank() {
                if (this.rank == null && this.draft) {
                    this.populate();
                }
                return this.rank;
            }

            @Override
            public final Integer getPopularity() {
                if (this.popularity == null && this.draft) {
                    this.populate();
                }
                return this.popularity;
            }

            @Override
            public final Integer getUserListingCount() {
                if (this.usersListing == null && this.draft) {
                    this.populate();
                }
                return this.usersListing;
            }

            @Override
            public final Integer getUserScoringCount() {
                if (this.usersScoring == null && this.draft) {
                    this.populate();
                }
                return this.usersScoring;
            }

            @Override
            public final NSFW getNSFW() {
                if (this.e_nsfw == null && this.draft) {
                    this.populate();
                }
                return this.e_nsfw;
            }

            @Override
            public final String getRawNSFW() {
                if (this.nsfw == null && this.draft) {
                    this.populate();
                }
                return this.nsfw;
            }

            @Override
            public final Genre[] getGenres() {
                if (this.genres == null && this.draft) {
                    this.populate();
                }
                return this.genres != null ? Arrays.copyOf(this.genres, this.genres.length) : null;
            }

            @Override
            public final Date getCreatedAt() {
                if (this.createdAt == null && this.draft) {
                    this.populate();
                }
                return this.createdAt == null ? null : new Date(this.createdAt);
            }

            @Override
            public final Long getCreatedAtEpochMillis() {
                if (this.createdAt == null && this.draft) {
                    this.populate();
                }
                return this.createdAt;
            }

            @Override
            public final Date getUpdatedAt() {
                if (this.updatedAt == null && this.draft) {
                    this.populate();
                }
                return this.updatedAt == null ? null : new Date(this.updatedAt);
            }

            @Override
            public final Long getUpdatedAtEpochMillis() {
                if (this.updatedAt == null && this.draft) {
                    this.populate();
                }
                return this.updatedAt;
            }

            @Override
            public final AnimeType getType() {
                if (this.e_type == AnimeType.Unknown && this.draft) {
                    this.populate();
                }
                return this.e_type;
            }

            @Override
            public final String getRawType() {
                if (this.type == null && this.draft) {
                    this.populate();
                }
                return this.type;
            }

            @Override
            public final AnimeAirStatus getStatus() {
                if (this.e_status == AnimeAirStatus.Unknown && this.draft) {
                    this.populate();
                }
                return this.e_status;
            }

            @Override
            public final String getRawStatus() {
                if (this.status == null && this.draft) {
                    this.populate();
                }
                return this.status;
            }

            @Override
            public final AnimeListStatus getListStatus() {
                if (this.listStatus == null && this.draft) {
                    this.populate();
                }
                return this.listStatus;
            }

            @Override
            public final Integer getEpisodes() {
                if (this.episodes == null && this.draft) {
                    this.populate();
                }
                return this.episodes;
            }

            @Override
            public final StartSeason getStartSeason() {
                if (this.startSeason == null && this.draft) {
                    this.populate();
                }
                return this.startSeason;
            }

            @Override
            public final Broadcast getBroadcast() {
                if (this.broadcast == null && this.draft) {
                    this.populate();
                }
                return this.broadcast;
            }

            @Override
            public final AnimeSource getSource() {
                if (this.e_source == AnimeSource.Unknown && this.draft) {
                    this.populate();
                }
                return this.e_source;
            }

            @Override
            public final String getRawSource() {
                if (this.source == null && this.draft) {
                    this.populate();
                }
                return this.source;
            }

            @Override
            public final Integer getAverageEpisodeLength() {
                if (this.episodeLength == null && this.draft) {
                    this.populate();
                }
                return this.episodeLength;
            }

            @Override
            public final AnimeRating getRating() {
                if (this.e_rating == null && this.draft) {
                    this.populate();
                }
                return this.e_rating;
            }

            @Override
            public final String getRawRating() {
                if (this.rating == null && this.draft) {
                    this.populate();
                }
                return this.rating;
            }

            @Override
            public final Studio[] getStudios() {
                if (this.studios == null && this.draft) {
                    this.populate();
                }
                return this.studios != null ? Arrays.copyOf(this.studios, this.studios.length) : null;
            }

            @Override
            public final Picture[] getPictures() {
                if (this.pictures == null && this.draft) {
                    this.populate();
                }
                return this.pictures != null ? Arrays.copyOf(this.pictures, this.pictures.length) : null;
            }

            @Override
            public final String getBackground() {
                if (this.background == null && this.draft) {
                    this.populate();
                }
                return this.background;
            }

            @Override
            public final RelatedAnime[] getRelatedAnime() {
                if (this.relatedAnime == null && this.draft) {
                    this.populate();
                }
                return this.relatedAnime != null ? Arrays.copyOf(this.relatedAnime, this.relatedAnime.length) : null;
            }

            @Override
            public final RelatedManga[] getRelatedManga() {
                if (this.relatedManga == null && this.draft) {
                    this.populate();
                }
                return this.relatedManga != null ? Arrays.copyOf(this.relatedManga, this.relatedManga.length) : null;
            }

            public final AnimeRecommendation[] getRecommendations() {
                if (this.recommendations == null && this.draft) {
                    this.populate();
                }
                return this.recommendations != null ? Arrays.copyOf(this.recommendations, this.recommendations.length) : null;
            }

            @Override
            public final AnimeStatistics getStatistics() {
                if (this.statistics == null && this.draft) {
                    this.populate();
                }
                return this.statistics;
            }

            @Override
            public final OpeningTheme[] getOpeningThemes() {
                ((MyAnimeListImpl)mal).checkExperimentalFeatureEnabled(ExperimentalFeature.OP_ED_THEMES);
                if (this.openingThemes == null && this.draft) {
                    this.populate();
                }
                return this.openingThemes != null ? Arrays.copyOf(this.openingThemes, this.openingThemes.length) : null;
            }

            @Override
            public final EndingTheme[] getEndingThemes() {
                ((MyAnimeListImpl)mal).checkExperimentalFeatureEnabled(ExperimentalFeature.OP_ED_THEMES);
                if (this.endingThemes == null && this.draft) {
                    this.populate();
                }
                return this.endingThemes != null ? Arrays.copyOf(this.endingThemes, this.endingThemes.length) : null;
            }

            @Override
            public final Video[] getVideos() {
                ((MyAnimeListImpl)mal).checkExperimentalFeatureEnabled(ExperimentalFeature.VIDEOS);
                if (this.videos == null && this.draft) {
                    this.populate();
                }
                return this.videos != null ? Arrays.copyOf(this.videos, this.videos.length) : null;
            }

            @Override
            public final AnimeCharacterQuery getCharacters() {
                return mal.getAnimeCharacters(this.id);
            }

            public final String toString() {
                return "Anime{id=" + this.id + ", title='" + this.title + '\'' + ", mainPicture=" + this.mainPicture + ", alternativeTitles=" + this.alternativeTitles + ", startDate=" + this.startDate + ", endDate=" + this.endDate + ", synopsis='" + this.synopsis + '\'' + ", meanRating=" + this.meanRating + ", rank=" + this.rank + ", popularity=" + this.popularity + ", usersListing=" + this.usersListing + ", usersScoring=" + this.usersScoring + ", nsfw=" + this.nsfw + ", genres=" + Arrays.toString(this.genres) + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", type=" + this.type + ", status=" + this.status + ", listStatus=" + this.listStatus + ", episodes=" + this.episodes + ", startSeason=" + this.startSeason + ", broadcast=" + this.broadcast + ", source=" + this.source + ", episodeLength=" + this.episodeLength + ", rating=" + this.rating + ", studios=" + Arrays.toString(this.studios) + ", pictures=" + Arrays.toString(this.pictures) + ", background='" + this.background + '\'' + ", relatedAnime=" + Arrays.toString(this.relatedAnime) + ", relatedManga=" + Arrays.toString(this.relatedManga) + ", recommendations=" + Arrays.toString(this.recommendations) + ", statistics=" + this.statistics + ", openingThemes=" + Arrays.toString(this.openingThemes) + ", endingThemes=" + Arrays.toString(this.endingThemes) + ", videos=" + Arrays.toString(this.videos) + '}';
            }
        };
    }

    static AnimeListStatus asAnimeListStatus(MyAnimeList mal, Json.JsonObject schema, long anime_id) {
        return MyAnimeListSchema_Anime.asAnimeListStatus(mal, schema, anime_id, null);
    }

    static AnimeListStatus asAnimeListStatus(MyAnimeList mal, Json.JsonObject schema, Anime anime) {
        return MyAnimeListSchema_Anime.asAnimeListStatus(mal, schema, null, Objects.requireNonNull(anime, "Anime must not be null"));
    }

    private static AnimeListStatus asAnimeListStatus(final MyAnimeList mal, final Json.JsonObject schema, final Long anime_id, final Anime anime_full) {
        if (anime_id == null && anime_full == null) {
            throw new NullPointerException("Anime and ID must not both be null");
        }
        return schema == null ? null : new AnimeListStatus(){
            private Anime anime;
            private final Long id;
            private final String status;
            private final AnimeStatus e_status;
            private final Integer score;
            private final Long startDate;
            private final Long finishDate;
            private final Integer priority;
            private final Priority e_priority;
            private final String[] tags;
            private final String comments;
            private final Long updatedAt;
            private final Integer watchedEpisodes;
            private final Boolean rewatching;
            private final Integer timesRewatched;
            private final Integer rewatchValue;
            private final RewatchValue e_rewatchValue;
            {
                this.anime = anime_full;
                this.id = anime_id != null ? anime_id : anime_full.getID();
                this.status = schema.getString("status");
                this.e_status = AnimeStatus.asEnum(this.status);
                this.score = schema.getInt("score");
                this.startDate = MyAnimeListSchema.parseDate(schema.getString("start_date"));
                this.finishDate = MyAnimeListSchema.parseDate(schema.getString("finish_date"));
                this.priority = schema.getInt("priority");
                this.e_priority = Priority.asEnum(this.priority);
                this.tags = schema.getStringArray("tags");
                this.comments = schema.getString("comments");
                this.updatedAt = MyAnimeListSchema.parseISO8601(schema.getString("updated_at"));
                this.watchedEpisodes = schema.getInt("num_episodes_watched");
                this.rewatching = schema.getBoolean("is_rewatching");
                this.timesRewatched = schema.getInt("num_times_rewatched");
                this.rewatchValue = schema.getInt("rewatch_value");
                this.e_rewatchValue = RewatchValue.asEnum(this.rewatchValue);
            }

            @Override
            public final AnimeStatus getStatus() {
                return this.e_status;
            }

            @Override
            public final String getRawStatus() {
                return this.status;
            }

            @Override
            public final Integer getScore() {
                return this.score;
            }

            @Override
            public final Date getStartDate() {
                return this.startDate == null ? null : new Date(this.startDate);
            }

            @Override
            public final Date getFinishDate() {
                return this.finishDate == null ? null : new Date(this.finishDate);
            }

            @Override
            public final Priority getPriority() {
                return this.e_priority;
            }

            @Override
            public final Integer getRawPriority() {
                return this.priority;
            }

            @Override
            public final String[] getTags() {
                return this.tags != null ? Arrays.copyOf(this.tags, this.tags.length) : null;
            }

            @Override
            public final String getComments() {
                return this.comments;
            }

            @Override
            public final Date getUpdatedAt() {
                return this.updatedAt == null ? null : new Date(this.updatedAt);
            }

            @Override
            public final Long getUpdatedAtEpochMillis() {
                return this.updatedAt;
            }

            @Override
            public final Integer getWatchedEpisodes() {
                return this.watchedEpisodes;
            }

            @Override
            public final Boolean isRewatching() {
                return this.rewatching;
            }

            @Override
            public final Integer getTimesRewatched() {
                return this.timesRewatched;
            }

            @Override
            public final RewatchValue getRewatchValue() {
                return this.e_rewatchValue;
            }

            @Override
            public final Integer getRawRewatchValue() {
                return this.rewatchValue;
            }

            @Override
            public final Anime getAnime() {
                return this.anime != null ? this.anime : (this.anime = mal.getAnime(this.id));
            }

            @Override
            public final AnimeListUpdate edit() {
                return mal.updateAnimeListing(this.id != null ? this.id : this.anime.getID());
            }

            public final String toString() {
                return "AnimeListStatus{id=" + this.id + ", status=" + this.status + ", score=" + this.score + ", startDate=" + this.startDate + ", finishDate=" + this.finishDate + ", priority=" + this.priority + ", tags=" + Arrays.toString(this.tags) + ", comments='" + this.comments + '\'' + ", updatedAt=" + this.updatedAt + ", watchedEpisodes=" + this.watchedEpisodes + ", rewatching=" + this.rewatching + ", timesRewatched=" + this.timesRewatched + ", rewatchValue=" + this.rewatchValue + '}';
            }
        };
    }

    static AnimeRanking asAnimeRanking(final MyAnimeList mal, final Json.JsonObject schema) {
        return schema == null ? null : new AnimeRanking(){
            private final Anime anime;
            private final Integer ranking;
            private final Integer previousRanking;
            {
                this.anime = MyAnimeListSchema_Anime.asAnime(mal, schema.getJsonObject("node"));
                this.ranking = schema.getJsonObject("ranking").getInt("rank");
                this.previousRanking = schema.getJsonObject("ranking").getInt("previous_rank");
            }

            @Override
            public final Integer getRanking() {
                return this.ranking;
            }

            @Override
            public final Integer getPreviousRank() {
                return this.previousRanking;
            }

            @Override
            public final Anime getAnime() {
                return this.anime;
            }

            public final String toString() {
                return "AnimeRanking{anime=" + this.anime + ", ranking=" + this.ranking + ", previousRanking=" + this.previousRanking + '}';
            }
        };
    }

    static AnimeRecommendation asAnimeRecommendation(final MyAnimeList mal, final Json.JsonObject schema) {
        return schema == null ? null : new AnimeRecommendation(){
            private final Anime anime;
            private final Integer recommendations;
            {
                this.anime = MyAnimeListSchema_Anime.asAnime(mal, schema.getJsonObject("node"));
                this.recommendations = schema.getInt("num_recommendations");
            }

            @Override
            public final Integer getRecommendations() {
                return this.recommendations;
            }

            @Override
            public final Anime getAnime() {
                return this.anime;
            }

            public final String toString() {
                return "AnimeRecommendation{anime=" + this.anime + ", recommendations=" + this.recommendations + '}';
            }
        };
    }

    static RelatedAnime asRelatedAnime(final MyAnimeList mal, final Json.JsonObject schema) {
        return schema == null ? null : new RelatedAnime(){
            private final Anime anime;
            private final String relationType;
            private final RelationType e_relationType;
            private final String relationTypeFormatted;
            {
                this.anime = MyAnimeListSchema_Anime.asAnime(mal, schema.getJsonObject("node"));
                this.relationType = schema.getString("relation_type");
                this.e_relationType = RelationType.asEnum(this.relationType);
                this.relationTypeFormatted = schema.getString("relation_type_formatted");
            }

            @Override
            public final RelationType getRelationType() {
                return this.e_relationType;
            }

            @Override
            public final String getRawRelationType() {
                return this.relationType;
            }

            @Override
            public final String getRelationTypeFormat() {
                return this.relationTypeFormatted;
            }

            @Override
            public final Anime getAnime() {
                return this.anime;
            }

            public final String toString() {
                return "RelatedAnime{anime=" + this.anime + ", relationType=" + this.relationType + ", relationTypeFormatted='" + this.relationTypeFormatted + '\'' + '}';
            }
        };
    }
}

