/*
 * Decompiled with CFR 0.152.
 */
package dev.katsute.mal4j;

import dev.katsute.mal4j.Json;
import dev.katsute.mal4j.MyAnimeList;
import dev.katsute.mal4j.MyAnimeListImpl;
import dev.katsute.mal4j.MyAnimeListSchema;
import dev.katsute.mal4j.MyAnimeListSchema_Anime;
import dev.katsute.mal4j.MyAnimeListSchema_Common;
import dev.katsute.mal4j.anime.Anime;
import dev.katsute.mal4j.character.Animeography;
import dev.katsute.mal4j.character.Character;
import dev.katsute.mal4j.property.Picture;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

abstract class MyAnimeListSchema_Character
extends MyAnimeListSchema {
    MyAnimeListSchema_Character() {
    }

    static Character asCharacter(final MyAnimeList mal, final Json.JsonObject schema) {
        return schema == null ? null : new Character(){
            boolean draft = true;
            private final Long id = schema.getLong("id");
            private String firstName;
            private String lastName;
            private String alternativeNames;
            private Picture mainPicture;
            private Integer favorites;
            private Picture[] pictures;
            private String biography;
            private Map<String, String> biographyDetails;
            private Animeography[] animeography;
            {
                this.populate(schema);
            }

            private void populate() {
                if (this.draft) {
                    this.draft = false;
                    this.populate(((MyAnimeListImpl)mal).getCharacterSchema(this.id, null));
                }
            }

            private void populate(Json.JsonObject schema2) {
                this.firstName = schema2.getString("first_name");
                this.lastName = schema2.getString("last_name");
                this.alternativeNames = schema2.getString("alternative_name");
                this.mainPicture = MyAnimeListSchema_Common.asPicture(mal, schema2.getJsonObject("main_picture"));
                this.favorites = schema2.getInt("num_favorites");
                this.pictures = MyAnimeListSchema.adaptList(schema2.getJsonArray("pictures"), s -> MyAnimeListSchema_Common.asPicture(mal, s), Picture.class);
                this.biography = schema2.getString("biography");
                this.biographyDetails = this.biography == null ? null : MyAnimeListSchema_Common.asMap(this.biography);
                this.animeography = MyAnimeListSchema.adaptList(schema2.getJsonArray("animeography"), s -> MyAnimeListSchema_Character.asAnimeography(mal, s), Animeography.class);
            }

            @Override
            public final Long getID() {
                return this.id;
            }

            @Override
            public final String getFirstName() {
                if (this.firstName == null && this.draft) {
                    this.populate();
                }
                return this.firstName;
            }

            @Override
            public final String getLastName() {
                if (this.lastName == null && this.draft) {
                    this.populate();
                }
                return this.lastName;
            }

            @Override
            public final String[] getAlternativeNames() {
                if (this.alternativeNames == null && this.draft) {
                    this.populate();
                }
                return this.alternativeNames != null ? this.alternativeNames.split(", ") : null;
            }

            @Override
            public final Picture getMainPicture() {
                if (this.mainPicture == null && this.draft) {
                    this.populate();
                }
                return this.mainPicture;
            }

            @Override
            public final Integer getFavorites() {
                if (this.favorites == null && this.draft) {
                    this.populate();
                }
                return this.favorites;
            }

            @Override
            public final Picture[] getPictures() {
                if (this.pictures == null && this.draft) {
                    this.populate();
                }
                return this.pictures != null ? Arrays.copyOf(this.pictures, this.pictures.length) : null;
            }

            @Override
            public final String getBiography() {
                if (this.biography == null && this.draft) {
                    this.populate();
                }
                return this.biography;
            }

            @Override
            public final Map<String, String> getBiographyDetails() {
                if (this.biographyDetails == null && this.draft) {
                    this.populate();
                }
                return this.biographyDetails == null ? null : new HashMap<String, String>(this.biographyDetails);
            }

            @Override
            public final Animeography[] getAnimeography() {
                if (this.animeography == null && this.draft) {
                    this.populate();
                }
                return this.animeography != null ? Arrays.copyOf(this.animeography, this.animeography.length) : null;
            }

            public final String toString() {
                return "Character{id=" + this.id + ", firstName='" + this.firstName + '\'' + ", lastName='" + this.lastName + '\'' + ", alternativeNames='" + this.alternativeNames + '\'' + ", mainPicture=" + this.mainPicture + ", favorites=" + this.favorites + ", pictures=" + Arrays.toString(this.pictures) + ", biography='" + this.biography + '\'' + ", biographyDetails=" + this.biographyDetails + ", animeography=" + Arrays.toString(this.animeography) + '}';
            }
        };
    }

    static Animeography asAnimeography(final MyAnimeList mal, final Json.JsonObject schema) {
        return schema == null ? null : new Animeography(){
            private final Anime anime;
            private final String role;
            {
                this.anime = MyAnimeListSchema_Anime.asAnime(mal, schema.getJsonObject("node"));
                this.role = schema.getString("role");
            }

            @Override
            public final Anime getAnime() {
                return this.anime;
            }

            @Override
            public final String getRole() {
                return this.role;
            }

            public final String toString() {
                return "Animeography{anime=" + this.anime + ", role='" + this.role + '\'' + '}';
            }
        };
    }
}

