/*
 * Decompiled with CFR 0.152.
 */
package dev.katsute.mal4j;

import dev.katsute.mal4j.Json;
import dev.katsute.mal4j.MyAnimeList;
import dev.katsute.mal4j.MyAnimeListSchema;
import dev.katsute.mal4j.property.AlternativeTitles;
import dev.katsute.mal4j.property.Genre;
import dev.katsute.mal4j.property.Picture;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;

abstract class MyAnimeListSchema_Common
extends MyAnimeListSchema {
    private static final Pattern br = Pattern.compile("<br( ?\\/?)?>");
    private static final Pattern rn = Pattern.compile("(\\r?\\n)+");

    MyAnimeListSchema_Common() {
    }

    static AlternativeTitles asAlternativeTitles(MyAnimeList mal, final Json.JsonObject schema) {
        return schema == null ? null : new AlternativeTitles(){
            private final String[] synonyms;
            private final String english;
            private final String japanese;
            {
                this.synonyms = schema.getStringArray("synonyms");
                this.english = schema.getString("en");
                this.japanese = schema.getString("ja");
            }

            @Override
            public final String[] getSynonyms() {
                return this.synonyms != null ? Arrays.copyOf(this.synonyms, this.synonyms.length) : null;
            }

            @Override
            public final String getEnglish() {
                return this.english;
            }

            @Override
            public final String getJapanese() {
                return this.japanese;
            }

            public final String toString() {
                return "AlternativeTitles{synonyms=" + Arrays.toString(this.synonyms) + ", english='" + this.english + '\'' + ", japanese='" + this.japanese + '\'' + '}';
            }
        };
    }

    static Picture asPicture(MyAnimeList mal, final Json.JsonObject schema) {
        return schema == null ? null : new Picture(){
            private final String medium;
            private final String large;
            {
                this.medium = schema.getString("medium");
                this.large = schema.getString("large");
            }

            @Override
            public final String getMediumURL() {
                return this.medium;
            }

            @Override
            public final String getLargeURL() {
                return this.large;
            }

            public final String toString() {
                return "Picture{medium='" + this.medium + '\'' + ", large='" + this.large + '\'' + '}';
            }
        };
    }

    static Genre asGenre(MyAnimeList mal, final Json.JsonObject schema, final boolean animeGenre) {
        return schema == null ? null : new Genre(){
            private final Integer id;
            private final String name;
            private final boolean isAnimeGenre;
            {
                this.id = schema.getInt("id");
                this.name = schema.getString("name");
                this.isAnimeGenre = animeGenre;
            }

            @Override
            public final int getID() {
                if (this.id == null) {
                    throw new NullPointerException("There is no such ID for this genre");
                }
                return this.id;
            }

            @Override
            public final String getName() {
                return this.name;
            }

            @Override
            public final boolean isAnimeGenre() {
                return this.isAnimeGenre;
            }

            @Override
            public final boolean isMangaGenre() {
                return !this.isAnimeGenre;
            }

            public final String toString() {
                return "Genre{id=" + this.id + ", name='" + this.name + '\'' + ", isAnimeGenre=" + this.isAnimeGenre + '}';
            }

            public final boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                return Objects.equals(this.name, ((Genre)o).getName());
            }

            public final int hashCode() {
                return Objects.hash(this.name);
            }
        };
    }

    static Map<String, String> asMap(String s) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String ln : rn.split(br.matcher(s).replaceAll(""))) {
            int cn = ln.indexOf(58);
            if (cn > 0) {
                map.put(ln.substring(0, cn).trim(), ln.substring(cn + 1).trim());
                continue;
            }
            if (map.containsKey("*")) {
                map.put("*", (map.get("*") + '\n' + ln).trim());
                continue;
            }
            map.put("*", ln.trim());
        }
        return map;
    }
}

