/*
 * Decompiled with CFR 0.152.
 */
package dev.katsute.mal4j;

import dev.katsute.mal4j.Json;
import dev.katsute.mal4j.MyAnimeList;
import dev.katsute.mal4j.MyAnimeListSchema;
import dev.katsute.mal4j.forum.ForumBoard;
import dev.katsute.mal4j.forum.ForumCategory;
import dev.katsute.mal4j.forum.ForumSubBoard;
import dev.katsute.mal4j.forum.ForumTopic;
import dev.katsute.mal4j.forum.ForumTopicDetail;
import dev.katsute.mal4j.forum.Post;
import dev.katsute.mal4j.forum.property.ForumTopicCreator;
import dev.katsute.mal4j.forum.property.Poll;
import dev.katsute.mal4j.forum.property.PollOption;
import dev.katsute.mal4j.forum.property.PostAuthor;
import dev.katsute.mal4j.user.User;
import java.util.Arrays;
import java.util.Date;

abstract class MyAnimeListSchema_Forum
extends MyAnimeListSchema {
    MyAnimeListSchema_Forum() {
    }

    static ForumTopicCreator asForumTopicCreator(final MyAnimeList mal, final Json.JsonObject schema) {
        return schema == null ? null : new ForumTopicCreator(){
            private final Long id;
            private final String name;
            {
                this.id = schema.getLong("id");
                this.name = schema.getString("name");
            }

            @Override
            public final Long getID() {
                return this.id;
            }

            @Override
            public final String getName() {
                return this.name;
            }

            @Override
            public final User getUser() {
                return mal.getUser(this.name);
            }

            public final String toString() {
                return "ForumTopicCreator{id=" + this.id + ", name='" + this.name + '\'' + '}';
            }
        };
    }

    static ForumTopic asForumTopicDetail(final MyAnimeList mal, final Json.JsonObject schema, final Long boardid, final Long subboardid) {
        return schema == null ? null : new ForumTopic(){
            private final Long boardID;
            private final Long subBoardID;
            private final Long id;
            private final String title;
            private final Long createdAt;
            private final ForumTopicCreator createdBy;
            private final Integer posts;
            private final Long lastPostedAt;
            private final ForumTopicCreator lastPostedBy;
            private final Boolean locked;
            {
                this.boardID = boardid;
                this.subBoardID = subboardid;
                this.id = schema.getLong("id");
                this.title = schema.getString("title");
                this.createdAt = MyAnimeListSchema.parseISO8601(schema.getString("created_at"));
                this.createdBy = MyAnimeListSchema_Forum.asForumTopicCreator(mal, schema.getJsonObject("created_by"));
                this.posts = schema.getInt("number_of_posts");
                this.lastPostedAt = MyAnimeListSchema.parseISO8601(schema.getString("last_post_created_at"));
                this.lastPostedBy = MyAnimeListSchema_Forum.asForumTopicCreator(mal, schema.getJsonObject("last_post_created_by"));
                this.locked = schema.getBoolean("is_locked");
            }

            @Override
            public final Long getID() {
                return this.id;
            }

            @Override
            public final String getTitle() {
                return this.title;
            }

            @Override
            public final Date getCreatedAt() {
                return this.createdAt == null ? null : new Date(this.createdAt);
            }

            @Override
            public final Long getCreatedAtEpochMillis() {
                return this.createdAt;
            }

            @Override
            public final ForumTopicCreator getCreatedBy() {
                return this.createdBy;
            }

            @Override
            public final Integer getPostsCount() {
                return this.posts;
            }

            @Override
            public final Date getLastPostCreatedAt() {
                return this.lastPostedAt == null ? null : new Date(this.lastPostedAt);
            }

            @Override
            public final Long getLastPostCreatedAtEpochMillis() {
                return this.lastPostedAt;
            }

            @Override
            public final ForumTopicCreator getLastPostCreatedBy() {
                return this.lastPostedBy;
            }

            @Override
            public final Boolean isLocked() {
                return this.locked;
            }

            @Override
            public final Long getBoardID() {
                return this.boardID;
            }

            @Override
            public final Long getSubBoardID() {
                return this.subBoardID;
            }

            public final String toString() {
                return "ForumTopic{boardID=" + this.boardID + ", subBoardID=" + this.subBoardID + ", id=" + this.id + ", title='" + this.title + '\'' + ", createdAt=" + this.createdAt + ", createdBy=" + this.createdBy + ", posts=" + this.posts + ", lastPostedAt=" + this.lastPostedAt + ", lastPostedBy=" + this.lastPostedBy + ", locked=" + this.locked + '}';
            }
        };
    }

    static Poll asPoll(final MyAnimeList mal, final Json.JsonObject schema, final ForumTopicDetail forumTopic) {
        return schema == null ? null : new Poll(){
            private final Long id;
            private final String question;
            private final Boolean isClosed;
            private final PollOption[] options;
            {
                this.id = schema.getLong("id");
                this.question = schema.getString("question");
                this.isClosed = schema.getBoolean("closed");
                this.options = MyAnimeListSchema.adaptList(schema.getJsonArray("options"), o -> MyAnimeListSchema_Forum.asPollOption(mal, o, this), PollOption.class);
            }

            @Override
            public final Long getID() {
                return this.id;
            }

            @Override
            public final String getQuestion() {
                return this.question;
            }

            @Override
            public final Boolean isClosed() {
                return this.isClosed;
            }

            @Override
            public final PollOption[] getOptions() {
                return this.options != null ? Arrays.copyOf(this.options, this.options.length) : null;
            }

            @Override
            public final ForumTopicDetail getForumTopicDetail() {
                return forumTopic;
            }

            public final String toString() {
                return "Poll{id=" + this.id + ", question='" + this.question + '\'' + ", isClosed=" + this.isClosed + ", options=" + Arrays.toString(this.options) + '}';
            }
        };
    }

    static PollOption asPollOption(MyAnimeList mal, final Json.JsonObject schema, final Poll poll) {
        return schema == null ? null : new PollOption(){
            private final Long id;
            private final String text;
            private final Integer votes;
            {
                this.id = schema.getLong("id");
                this.text = schema.getString("text");
                this.votes = schema.getInt("votes");
            }

            @Override
            public final Long getID() {
                return this.id;
            }

            @Override
            public final String getText() {
                return this.text;
            }

            @Override
            public final Integer getVotes() {
                return this.votes;
            }

            @Override
            public final Poll getPoll() {
                return poll;
            }

            public final String toString() {
                return "PollOption{id=" + this.id + ", text='" + this.text + '\'' + ", votes=" + this.votes + '}';
            }
        };
    }

    static PostAuthor asPostAuthor(final MyAnimeList mal, final Json.JsonObject schema) {
        return schema == null ? null : new PostAuthor(){
            private final Long id;
            private final String name;
            private final String forumAvatarURL;
            {
                this.id = schema.getLong("id");
                this.name = schema.getString("name");
                this.forumAvatarURL = schema.getString("forum_avator");
            }

            @Override
            public final Long getID() {
                return this.id;
            }

            @Override
            public final String getName() {
                return this.name;
            }

            @Override
            public final String getForumAvatarURL() {
                return this.forumAvatarURL;
            }

            @Override
            public final User getUser() {
                return mal.getUser(this.name);
            }

            public final String toString() {
                return "PostAuthor{id=" + this.id + ", name='" + this.name + '\'' + ", forumAvatarURL='" + this.forumAvatarURL + '\'' + '}';
            }
        };
    }

    static ForumBoard asForumBoard(final MyAnimeList mal, final Json.JsonObject schema, final ForumCategory forumCategory) {
        return schema == null ? null : new ForumBoard(){
            private final Long id;
            private final String title;
            private final String description;
            private final ForumSubBoard[] subBoards;
            {
                this.id = schema.getLong("id");
                this.title = schema.getString("title");
                this.description = schema.getString("description");
                this.subBoards = MyAnimeListSchema.adaptList(schema.getJsonArray("subboards"), b -> MyAnimeListSchema_Forum.asForumSubBoard(mal, b, this), ForumSubBoard.class);
            }

            @Override
            public final Long getID() {
                return this.id;
            }

            @Override
            public final String getTitle() {
                return this.title;
            }

            @Override
            public final String getDescription() {
                return this.description;
            }

            @Override
            public final ForumSubBoard[] getSubBoards() {
                return this.subBoards != null ? Arrays.copyOf(this.subBoards, this.subBoards.length) : null;
            }

            @Override
            public final ForumCategory getCategory() {
                return forumCategory;
            }

            public final String toString() {
                return "ForumBoard{id=" + this.id + ", title='" + this.title + '\'' + ", description='" + this.description + '\'' + ", subBoards=" + Arrays.toString(this.subBoards) + '}';
            }
        };
    }

    static ForumCategory asForumCategory(final MyAnimeList mal, final Json.JsonObject schema) {
        return schema == null ? null : new ForumCategory(){
            private final String title;
            private final ForumBoard[] forumBoards;
            {
                this.title = schema.getString("title");
                this.forumBoards = MyAnimeListSchema.adaptList(schema.getJsonArray("boards"), b -> MyAnimeListSchema_Forum.asForumBoard(mal, b, this), ForumBoard.class);
            }

            @Override
            public final String getTitle() {
                return this.title;
            }

            @Override
            public final ForumBoard[] getForumBoards() {
                return this.forumBoards != null ? Arrays.copyOf(this.forumBoards, this.forumBoards.length) : null;
            }

            public final String toString() {
                return "ForumCategory{title='" + this.title + '\'' + ", forumBoards=" + Arrays.toString(this.forumBoards) + '}';
            }
        };
    }

    static ForumSubBoard asForumSubBoard(MyAnimeList mal, final Json.JsonObject schema, final ForumBoard forumBoard) {
        return schema == null ? null : new ForumSubBoard(){
            private final Long id;
            private final String title;
            {
                this.id = schema.getLong("id");
                this.title = schema.getString("title");
            }

            @Override
            public final Long getID() {
                return this.id;
            }

            @Override
            public final String getTitle() {
                return this.title;
            }

            @Override
            public final ForumBoard getBoard() {
                return forumBoard;
            }

            public final String toString() {
                return "ForumSubBoard{id=" + this.id + ", title='" + this.title + '\'' + '}';
            }
        };
    }

    static ForumTopicDetail asForumTopic(final MyAnimeList mal, final Json.JsonObject schema, final long topicid) {
        return schema == null ? null : new ForumTopicDetail(){
            private final long id;
            private final String title;
            private final Post[] posts;
            private final Poll poll;
            {
                this.id = topicid;
                this.title = schema.getString("title");
                this.posts = MyAnimeListSchema.adaptList(schema.getJsonArray("posts"), p -> MyAnimeListSchema_Forum.asPost(mal, p, this), Post.class);
                this.poll = MyAnimeListSchema_Forum.asPoll(mal, schema.getJsonObject("poll"), this);
            }

            @Override
            public final String getTitle() {
                return this.title;
            }

            @Override
            public final Post[] getPosts() {
                return this.posts != null ? Arrays.copyOf(this.posts, this.posts.length) : null;
            }

            @Override
            public final Poll getPoll() {
                return this.poll;
            }

            @Override
            public final Long getID() {
                return this.id;
            }

            public final String toString() {
                return "ForumTopicDetail{title='" + this.title + '\'' + ", posts=" + Arrays.toString(this.posts) + ", poll=" + this.poll + '}';
            }
        };
    }

    static Post asPost(final MyAnimeList mal, final Json.JsonObject schema, final ForumTopicDetail forumTopic) {
        return schema == null ? null : new Post(){
            private final Long id;
            private final Integer number;
            private final Long createdAt;
            private final PostAuthor author;
            private final String body;
            private final String signature;
            {
                this.id = schema.getLong("id");
                this.number = schema.getInt("number");
                this.createdAt = MyAnimeListSchema.parseISO8601(schema.getString("created_at"));
                this.author = MyAnimeListSchema_Forum.asPostAuthor(mal, schema.getJsonObject("created_by"));
                this.body = schema.getString("body");
                this.signature = schema.getString("signature");
            }

            @Override
            public final Long getID() {
                return this.id;
            }

            @Override
            public final Integer getNumber() {
                return this.number;
            }

            @Override
            public final Date getCreatedAt() {
                return this.createdAt == null ? null : new Date(this.createdAt);
            }

            @Override
            public final Long getCreatedAtEpochMillis() {
                return this.createdAt;
            }

            @Override
            public final PostAuthor getAuthor() {
                return this.author;
            }

            @Override
            public final String getBody() {
                return this.body;
            }

            @Override
            public final String getSignature() {
                return this.signature;
            }

            @Override
            public final ForumTopicDetail getForumTopicDetail() {
                return forumTopic;
            }

            public final String toString() {
                return "Post{id=" + this.id + ", number=" + this.number + ", createdAt=" + this.createdAt + ", author=" + this.author + ", body='" + this.body + '\'' + ", signature='" + this.signature + '\'' + '}';
            }
        };
    }

    static Post asPost(final MyAnimeList mal, final Json.JsonObject schema, final long ftdid) {
        return schema == null ? null : new Post(){
            private final Long id;
            private final Integer number;
            private final Long createdAt;
            private final PostAuthor author;
            private final String body;
            private final String signature;
            {
                this.id = schema.getLong("id");
                this.number = schema.getInt("number");
                this.createdAt = MyAnimeListSchema.parseISO8601(schema.getString("created_at"));
                this.author = MyAnimeListSchema_Forum.asPostAuthor(mal, schema.getJsonObject("created_by"));
                this.body = schema.getString("body");
                this.signature = schema.getString("signature");
            }

            @Override
            public final Long getID() {
                return this.id;
            }

            @Override
            public final Integer getNumber() {
                return this.number;
            }

            @Override
            public final Date getCreatedAt() {
                return this.createdAt == null ? null : new Date(this.createdAt);
            }

            @Override
            public final Long getCreatedAtEpochMillis() {
                return this.createdAt;
            }

            @Override
            public final PostAuthor getAuthor() {
                return this.author;
            }

            @Override
            public final String getBody() {
                return this.body;
            }

            @Override
            public final String getSignature() {
                return this.signature;
            }

            @Override
            public final ForumTopicDetail getForumTopicDetail() {
                return mal.getForumTopicDetail(ftdid);
            }

            public final String toString() {
                return "Post{id=" + this.id + ", number=" + this.number + ", createdAt=" + this.createdAt + ", author=" + this.author + ", body='" + this.body + '\'' + ", signature='" + this.signature + '\'' + '}';
            }
        };
    }
}

