/*
 * Decompiled with CFR 0.152.
 */
package dev.katsute.mal4j;

import dev.katsute.mal4j.Json;
import dev.katsute.mal4j.MyAnimeList;
import dev.katsute.mal4j.MyAnimeListImpl;
import dev.katsute.mal4j.MyAnimeListSchema;
import dev.katsute.mal4j.MyAnimeListSchema_Anime;
import dev.katsute.mal4j.MyAnimeListSchema_Common;
import dev.katsute.mal4j.anime.RelatedAnime;
import dev.katsute.mal4j.manga.Manga;
import dev.katsute.mal4j.manga.MangaListStatus;
import dev.katsute.mal4j.manga.MangaRanking;
import dev.katsute.mal4j.manga.MangaRecommendation;
import dev.katsute.mal4j.manga.RelatedManga;
import dev.katsute.mal4j.manga.property.Author;
import dev.katsute.mal4j.manga.property.MangaPublishStatus;
import dev.katsute.mal4j.manga.property.MangaStatus;
import dev.katsute.mal4j.manga.property.MangaType;
import dev.katsute.mal4j.manga.property.Publisher;
import dev.katsute.mal4j.manga.property.RereadValue;
import dev.katsute.mal4j.property.AlternativeTitles;
import dev.katsute.mal4j.property.Genre;
import dev.katsute.mal4j.property.NSFW;
import dev.katsute.mal4j.property.NullableDate;
import dev.katsute.mal4j.property.Picture;
import dev.katsute.mal4j.property.Priority;
import dev.katsute.mal4j.property.RelationType;
import dev.katsute.mal4j.query.MangaListUpdate;
import java.util.Arrays;
import java.util.Date;
import java.util.Objects;

abstract class MyAnimeListSchema_Manga
extends MyAnimeListSchema {
    MyAnimeListSchema_Manga() {
    }

    static Author asAuthor(MyAnimeList mal, final Json.JsonObject schema) {
        return schema == null ? null : new Author(){
            private final Long id;
            private final String firstName;
            private final String lastName;
            private final String role;
            {
                this.id = schema.getJsonObject("node").getLong("id");
                this.firstName = schema.getJsonObject("node").getString("first_name");
                this.lastName = schema.getJsonObject("node").getString("last_name");
                this.role = schema.getString("role");
            }

            @Override
            public final Long getID() {
                return this.id;
            }

            @Override
            public final String getFirstName() {
                return this.firstName;
            }

            @Override
            public final String getLastName() {
                return this.lastName;
            }

            @Override
            public final String getRole() {
                return this.role;
            }

            public final String toString() {
                return "Author{id=" + this.id + ", firstName='" + this.firstName + '\'' + ", lastName='" + this.lastName + '\'' + ", role='" + this.role + '\'' + '}';
            }
        };
    }

    static Publisher asPublisher(MyAnimeList mal, final Json.JsonObject schema) {
        return schema == null ? null : new Publisher(){
            private final Long id;
            private final String name;
            private final String role;
            {
                this.id = schema.getJsonObject("node").getLong("id");
                this.name = schema.getJsonObject("node").getString("name");
                this.role = schema.getString("role");
            }

            @Override
            public final Long getID() {
                return this.id;
            }

            @Override
            public final String getName() {
                return this.name;
            }

            @Override
            public final String getRole() {
                return this.role;
            }

            public final String toString() {
                return "Publisher{id=" + this.id + ", name='" + this.name + '\'' + ", role='" + this.role + '\'' + '}';
            }
        };
    }

    static Manga asManga(final MyAnimeList mal, final Json.JsonObject schema) {
        return schema == null ? null : new Manga(){
            boolean draft = true;
            private final Long id = schema.getLong("id");
            private String title;
            private Picture mainPicture;
            private AlternativeTitles alternativeTitles;
            private NullableDate startDate;
            private NullableDate endDate;
            private String synopsis;
            private Float meanRating;
            private Integer rank;
            private Integer popularity;
            private Integer usersListing;
            private Integer usersScoring;
            private String nsfw;
            private NSFW e_nsfw;
            private Genre[] genres;
            private Long createdAt;
            private Long updatedAt;
            private String type;
            private MangaType e_type;
            private String status;
            private MangaPublishStatus e_status;
            private MangaListStatus listStatus;
            private Integer volumes;
            private Integer chapters;
            private Author[] authors;
            private Picture[] pictures;
            private String background;
            private RelatedAnime[] relatedAnime;
            private RelatedManga[] relatedManga;
            private MangaRecommendation[] recommendations;
            private Publisher[] serialization;
            {
                this.populate(schema);
            }

            private void populate() {
                if (this.draft) {
                    this.draft = false;
                    this.populate(((MyAnimeListImpl)mal).getMangaSchema(this.id, null));
                }
            }

            private void populate(Json.JsonObject schema2) {
                this.title = schema2.getString("title");
                this.mainPicture = MyAnimeListSchema_Common.asPicture(mal, schema2.getJsonObject("main_picture"));
                this.alternativeTitles = MyAnimeListSchema_Common.asAlternativeTitles(mal, schema2.getJsonObject("alternative_titles"));
                this.startDate = MyAnimeListSchema.parseNullableDate(schema2.getString("start_date"));
                this.endDate = MyAnimeListSchema.parseNullableDate(schema2.getString("end_date"));
                this.synopsis = schema2.getString("synopsis");
                this.meanRating = schema2.getFloat("mean");
                this.rank = schema2.getInt("rank");
                this.popularity = schema2.getInt("popularity");
                this.usersListing = schema2.getInt("num_list_users");
                this.usersScoring = schema2.getInt("num_scoring_users");
                this.nsfw = schema2.getString("nsfw");
                this.e_nsfw = NSFW.asEnum(this.nsfw);
                this.genres = MyAnimeListSchema.adaptList(schema2.getJsonArray("genres"), g -> MyAnimeListSchema_Common.asGenre(mal, g, false), Genre.class);
                this.createdAt = MyAnimeListSchema.parseISO8601(schema2.getString("created_at"));
                this.updatedAt = MyAnimeListSchema.parseISO8601(schema2.getString("updated_at"));
                this.type = schema2.getString("media_type");
                this.e_type = MangaType.asEnum(this.type);
                this.status = schema2.getString("status");
                this.e_status = MangaPublishStatus.asEnum(this.status);
                this.listStatus = MyAnimeListSchema_Manga.asMangaListStatus(mal, schema2.getJsonObject("my_list_status"), this.id, this);
                this.volumes = schema2.getInt("num_volumes");
                this.chapters = schema2.getInt("num_chapters");
                this.authors = MyAnimeListSchema.adaptList(schema2.getJsonArray("authors"), a -> MyAnimeListSchema_Manga.asAuthor(mal, a), Author.class);
                this.pictures = MyAnimeListSchema.adaptList(schema2.getJsonArray("pictures"), p -> MyAnimeListSchema_Common.asPicture(mal, p), Picture.class);
                this.background = schema2.getString("background");
                this.relatedAnime = MyAnimeListSchema.adaptList(schema2.getJsonArray("related_anime"), a -> MyAnimeListSchema_Anime.asRelatedAnime(mal, a), RelatedAnime.class);
                this.relatedManga = MyAnimeListSchema.adaptList(schema2.getJsonArray("related_manga"), m -> MyAnimeListSchema_Manga.asRelatedManga(mal, m), RelatedManga.class);
                this.recommendations = MyAnimeListSchema.adaptList(schema2.getJsonArray("recommendations"), r -> MyAnimeListSchema_Manga.asMangaRecommendation(mal, r), MangaRecommendation.class);
                this.serialization = MyAnimeListSchema.adaptList(schema2.getJsonArray("serialization"), s -> MyAnimeListSchema_Manga.asPublisher(mal, s), Publisher.class);
            }

            @Override
            public final Long getID() {
                return this.id;
            }

            @Override
            public final String getTitle() {
                if (this.title == null && this.draft) {
                    this.populate();
                }
                return this.title;
            }

            @Override
            public final Picture getMainPicture() {
                if (this.mainPicture == null && this.draft) {
                    this.populate();
                }
                return this.mainPicture;
            }

            @Override
            public final AlternativeTitles getAlternativeTitles() {
                if (this.alternativeTitles == null && this.draft) {
                    this.populate();
                }
                return this.alternativeTitles;
            }

            @Override
            public final NullableDate getStartDate() {
                if (this.startDate == null && this.draft) {
                    this.populate();
                }
                return this.startDate;
            }

            @Override
            public final NullableDate getEndDate() {
                if (this.endDate == null && this.draft) {
                    this.populate();
                }
                return this.endDate;
            }

            @Override
            public final String getSynopsis() {
                if (this.synopsis == null && this.draft) {
                    this.populate();
                }
                return this.synopsis;
            }

            @Override
            public final Float getMeanRating() {
                if (this.meanRating == null && this.draft) {
                    this.populate();
                }
                return this.meanRating;
            }

            @Override
            public final Integer getRank() {
                if (this.rank == null && this.draft) {
                    this.populate();
                }
                return this.rank;
            }

            @Override
            public final Integer getPopularity() {
                if (this.popularity == null && this.draft) {
                    this.populate();
                }
                return this.popularity;
            }

            @Override
            public final Integer getUserListingCount() {
                if (this.usersListing == null && this.draft) {
                    this.populate();
                }
                return this.usersListing;
            }

            @Override
            public final Integer getUserScoringCount() {
                if (this.usersScoring == null && this.draft) {
                    this.populate();
                }
                return this.usersScoring;
            }

            @Override
            public final NSFW getNSFW() {
                if (this.e_nsfw == null && this.draft) {
                    this.populate();
                }
                return this.e_nsfw;
            }

            @Override
            public final String getRawNSFW() {
                if (this.nsfw == null && this.draft) {
                    this.populate();
                }
                return this.nsfw;
            }

            @Override
            public final Genre[] getGenres() {
                if (this.genres == null && this.draft) {
                    this.populate();
                }
                return this.genres != null ? Arrays.copyOf(this.genres, this.genres.length) : null;
            }

            @Override
            public final Date getCreatedAt() {
                if (this.createdAt == null && this.draft) {
                    this.populate();
                }
                return this.createdAt == null ? null : new Date(this.createdAt);
            }

            @Override
            public final Long getCreatedAtEpochMillis() {
                if (this.createdAt == null && this.draft) {
                    this.populate();
                }
                return this.createdAt;
            }

            @Override
            public final Date getUpdatedAt() {
                if (this.updatedAt == null && this.draft) {
                    this.populate();
                }
                return this.updatedAt == null ? null : new Date(this.updatedAt);
            }

            @Override
            public final Long getUpdatedAtEpochMillis() {
                if (this.updatedAt == null && this.draft) {
                    this.populate();
                }
                return this.updatedAt;
            }

            @Override
            public final MangaType getType() {
                if (this.e_type == MangaType.Unknown && this.draft) {
                    this.populate();
                }
                return this.e_type;
            }

            @Override
            public final String getRawType() {
                if (this.type == null && this.draft) {
                    this.populate();
                }
                return this.type;
            }

            @Override
            public final MangaPublishStatus getStatus() {
                if (this.e_status == MangaPublishStatus.Unknown && this.draft) {
                    this.populate();
                }
                return this.e_status;
            }

            @Override
            public String getRawStatus() {
                if (this.status == null && this.draft) {
                    this.populate();
                }
                return this.status;
            }

            @Override
            public final MangaListStatus getListStatus() {
                if (this.listStatus == null && this.draft) {
                    this.populate();
                }
                return this.listStatus;
            }

            @Override
            public final Integer getVolumes() {
                if (this.volumes == null && this.draft) {
                    this.populate();
                }
                return this.volumes;
            }

            @Override
            public final Integer getChapters() {
                if (this.chapters == null && this.draft) {
                    this.populate();
                }
                return this.chapters;
            }

            @Override
            public final Author[] getAuthors() {
                if (this.authors == null && this.draft) {
                    this.populate();
                }
                return this.authors != null ? Arrays.copyOf(this.authors, this.authors.length) : null;
            }

            @Override
            public final Picture[] getPictures() {
                if (this.pictures == null && this.draft) {
                    this.populate();
                }
                return this.pictures != null ? Arrays.copyOf(this.pictures, this.pictures.length) : null;
            }

            @Override
            public final String getBackground() {
                if (this.background == null && this.draft) {
                    this.populate();
                }
                return this.background;
            }

            @Override
            public final RelatedAnime[] getRelatedAnime() {
                if (this.relatedAnime == null && this.draft) {
                    this.populate();
                }
                return this.relatedAnime != null ? Arrays.copyOf(this.relatedAnime, this.relatedAnime.length) : null;
            }

            @Override
            public final RelatedManga[] getRelatedManga() {
                if (this.relatedManga == null && this.draft) {
                    this.populate();
                }
                return this.relatedManga != null ? Arrays.copyOf(this.relatedManga, this.relatedManga.length) : null;
            }

            public final MangaRecommendation[] getRecommendations() {
                if (this.recommendations == null && this.draft) {
                    this.populate();
                }
                return this.recommendations != null ? Arrays.copyOf(this.recommendations, this.recommendations.length) : null;
            }

            @Override
            public final Publisher[] getSerialization() {
                if (this.serialization == null && this.draft) {
                    this.populate();
                }
                return this.serialization != null ? Arrays.copyOf(this.serialization, this.serialization.length) : null;
            }

            public final String toString() {
                return "Manga{id=" + this.id + ", title='" + this.title + '\'' + ", mainPicture=" + this.mainPicture + ", alternativeTitles=" + this.alternativeTitles + ", startDate=" + this.startDate + ", endDate=" + this.endDate + ", synopsis='" + this.synopsis + '\'' + ", meanRating=" + this.meanRating + ", rank=" + this.rank + ", popularity=" + this.popularity + ", usersListing=" + this.usersListing + ", usersScoring=" + this.usersScoring + ", nsfw=" + this.nsfw + ", genres=" + Arrays.toString(this.genres) + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", type=" + this.type + ", status=" + this.status + ", listStatus=" + this.listStatus + ", volumes=" + this.volumes + ", chapters=" + this.chapters + ", authors=" + Arrays.toString(this.authors) + ", pictures=" + Arrays.toString(this.pictures) + ", background='" + this.background + '\'' + ", relatedAnime=" + Arrays.toString(this.relatedAnime) + ", relatedManga=" + Arrays.toString(this.relatedManga) + ", recommendations=" + Arrays.toString(this.recommendations) + ", serialization=" + Arrays.toString(this.serialization) + '}';
            }
        };
    }

    static MangaListStatus asMangaListStatus(MyAnimeList mal, Json.JsonObject schema, long manga_id) {
        return MyAnimeListSchema_Manga.asMangaListStatus(mal, schema, manga_id, null);
    }

    static MangaListStatus asMangaListStatus(MyAnimeList mal, Json.JsonObject schema, Manga manga) {
        return MyAnimeListSchema_Manga.asMangaListStatus(mal, schema, null, Objects.requireNonNull(manga, "Manga must not be null"));
    }

    static MangaListStatus asMangaListStatus(final MyAnimeList mal, final Json.JsonObject schema, final Long manga_id, final Manga manga_full) {
        if (manga_id == null && manga_full == null) {
            throw new NullPointerException("Manga and ID must not be both null");
        }
        return schema == null ? null : new MangaListStatus(){
            private Manga manga;
            private final Long id;
            private final String status;
            private final MangaStatus e_status;
            private final Integer score;
            private final Long startDate;
            private final Long finishDate;
            private final Integer priority;
            private final Priority e_priority;
            private final String[] tags;
            private final String comments;
            private final Long updatedAt;
            private final Integer volumesRead;
            private final Integer chaptersRead;
            private final Boolean rereading;
            private final Integer timesReread;
            private final Integer rereadValue;
            private final RereadValue e_rereadValue;
            {
                this.manga = manga_full;
                this.id = manga_id != null ? manga_id : manga_full.getID();
                this.status = schema.getString("status");
                this.e_status = MangaStatus.asEnum(this.status);
                this.score = schema.getInt("score");
                this.startDate = MyAnimeListSchema.parseDate(schema.getString("start_date"));
                this.finishDate = MyAnimeListSchema.parseDate(schema.getString("finish_date"));
                this.priority = schema.getInt("priority");
                this.e_priority = Priority.asEnum(this.priority);
                this.tags = schema.getStringArray("tags");
                this.comments = schema.getString("comments");
                this.updatedAt = MyAnimeListSchema.parseISO8601(schema.getString("updated_at"));
                this.volumesRead = schema.getInt("num_volumes_read");
                this.chaptersRead = schema.getInt("num_chapters_read");
                this.rereading = schema.getBoolean("is_rereading");
                this.timesReread = schema.getInt("num_times_reread");
                this.rereadValue = schema.getInt("reread_value");
                this.e_rereadValue = RereadValue.asEnum(this.rereadValue);
            }

            @Override
            public final MangaStatus getStatus() {
                return this.e_status;
            }

            @Override
            public final String getRawStatus() {
                return this.status;
            }

            @Override
            public final Integer getScore() {
                return this.score;
            }

            @Override
            public final Date getStartDate() {
                return this.startDate == null ? null : new Date(this.startDate);
            }

            @Override
            public final Date getFinishDate() {
                return this.finishDate == null ? null : new Date(this.finishDate);
            }

            @Override
            public final Priority getPriority() {
                return this.e_priority;
            }

            @Override
            public final Integer getRawPriority() {
                return this.priority;
            }

            @Override
            public final String[] getTags() {
                return this.tags != null ? Arrays.copyOf(this.tags, this.tags.length) : null;
            }

            @Override
            public final String getComments() {
                return this.comments;
            }

            @Override
            public final Date getUpdatedAt() {
                return this.updatedAt == null ? null : new Date(this.updatedAt);
            }

            @Override
            public final Long getUpdatedAtEpochMillis() {
                return this.updatedAt;
            }

            @Override
            public final Integer getVolumesRead() {
                return this.volumesRead;
            }

            @Override
            public final Integer getChaptersRead() {
                return this.chaptersRead;
            }

            @Override
            public final Boolean isRereading() {
                return this.rereading;
            }

            @Override
            public final Integer getTimesReread() {
                return this.timesReread;
            }

            @Override
            public final RereadValue getRereadValue() {
                return this.e_rereadValue;
            }

            @Override
            public final Integer getRawRereadValue() {
                return this.rereadValue;
            }

            @Override
            public final Manga getManga() {
                return this.manga != null ? this.manga : (this.manga = mal.getManga(this.id));
            }

            @Override
            public final MangaListUpdate edit() {
                return mal.updateMangaListing(this.id != null ? this.id : this.manga.getID());
            }

            public final String toString() {
                return "MangaListStatus{id=" + this.id + ", status=" + this.status + ", score=" + this.score + ", startDate=" + this.startDate + ", finishDate=" + this.finishDate + ", priority=" + this.priority + ", tags=" + Arrays.toString(this.tags) + ", comments='" + this.comments + '\'' + ", updatedAt=" + this.updatedAt + ", volumesRead=" + this.volumesRead + ", chaptersRead=" + this.chaptersRead + ", rereading=" + this.rereading + ", timesReread=" + this.timesReread + ", rereadValue=" + this.rereadValue + '}';
            }
        };
    }

    static MangaRanking asMangaRanking(final MyAnimeList mal, final Json.JsonObject schema) {
        return schema == null ? null : new MangaRanking(){
            private final Manga manga;
            private final Integer ranking;
            private final Integer previousRanking;
            {
                this.manga = MyAnimeListSchema_Manga.asManga(mal, schema.getJsonObject("node"));
                this.ranking = schema.getJsonObject("ranking").getInt("rank");
                this.previousRanking = schema.getJsonObject("ranking").getInt("previous_rank");
            }

            @Override
            public final Integer getRanking() {
                return this.ranking;
            }

            @Override
            public final Integer getPreviousRank() {
                return this.previousRanking;
            }

            @Override
            public final Manga getManga() {
                return this.manga;
            }

            public final String toString() {
                return "MangaRanking{manga=" + this.manga + ", ranking=" + this.ranking + ", previousRanking=" + this.previousRanking + '}';
            }
        };
    }

    static MangaRecommendation asMangaRecommendation(final MyAnimeList mal, final Json.JsonObject schema) {
        return schema == null ? null : new MangaRecommendation(){
            private final Manga manga;
            private final Integer recommendations;
            {
                this.manga = MyAnimeListSchema_Manga.asManga(mal, schema.getJsonObject("node"));
                this.recommendations = schema.getInt("num_recommendations");
            }

            @Override
            public final Integer getRecommendations() {
                return this.recommendations;
            }

            @Override
            public final Manga getManga() {
                return this.manga;
            }

            public final String toString() {
                return "MangaRecommendation{manga=" + this.manga + ", recommendations=" + this.recommendations + '}';
            }
        };
    }

    static RelatedManga asRelatedManga(final MyAnimeList mal, final Json.JsonObject schema) {
        return schema == null ? null : new RelatedManga(){
            private final Manga manga;
            private final String relationType;
            private final RelationType e_relationType;
            private final String relationTypeFormatted;
            {
                this.manga = MyAnimeListSchema_Manga.asManga(mal, schema.getJsonObject("node"));
                this.relationType = schema.getString("relation_type");
                this.e_relationType = RelationType.asEnum(this.relationType);
                this.relationTypeFormatted = schema.getString("relation_type_formatted");
            }

            @Override
            public final RelationType getRelationType() {
                return this.e_relationType;
            }

            @Override
            public final String getRawRelationType() {
                return this.relationType;
            }

            @Override
            public final String getRelationTypeFormat() {
                return this.relationTypeFormatted;
            }

            @Override
            public final Manga getManga() {
                return this.manga;
            }

            public final String toString() {
                return "RelatedManga{manga=" + this.manga + ", relationType=" + this.relationType + ", relationTypeFormatted='" + this.relationTypeFormatted + '\'' + '}';
            }
        };
    }
}

