/*
 * Decompiled with CFR 0.152.
 */
package dev.katsute.mal4j;

import dev.katsute.mal4j.Json;
import dev.katsute.mal4j.MyAnimeList;
import dev.katsute.mal4j.MyAnimeListSchema;
import dev.katsute.mal4j.MyAnimeListSchema_Common;
import dev.katsute.mal4j.people.Person;
import dev.katsute.mal4j.property.Picture;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

abstract class MyAnimeListSchema_People
extends MyAnimeListSchema {
    MyAnimeListSchema_People() {
    }

    static Person asPerson(final MyAnimeList mal, final Json.JsonObject schema) {
        return schema == null ? null : new Person(){
            private final Long id;
            private final String firstName;
            private final String lastName;
            private final Long birthday;
            private final String[] alternative_names;
            private final Integer favorites;
            private final Picture mainPicture;
            private final String more;
            private final Map<String, String> moreDetails;
            {
                this.id = schema.getLong("id");
                this.firstName = schema.getString("first_name");
                this.lastName = schema.getString("last_name");
                this.birthday = MyAnimeListSchema.parseDate(schema.getString("birthday"));
                this.alternative_names = schema.getStringArray("alternative_names");
                this.favorites = schema.getInt("num_favorites");
                this.mainPicture = MyAnimeListSchema_Common.asPicture(mal, schema.getJsonObject("main_picture"));
                this.more = schema.getString("more");
                this.moreDetails = this.more == null ? null : MyAnimeListSchema_Common.asMap(this.more);
            }

            @Override
            public final Long getID() {
                return this.id;
            }

            @Override
            public final String getFirstName() {
                return this.firstName;
            }

            @Override
            public final String getLastName() {
                return this.lastName;
            }

            @Override
            public final Date getBirthday() {
                return this.birthday == null ? null : new Date(this.birthday);
            }

            @Override
            public final String[] getAlternativeNames() {
                return this.alternative_names == null ? null : Arrays.copyOf(this.alternative_names, this.alternative_names.length);
            }

            @Override
            public final Picture getMainPicture() {
                return this.mainPicture;
            }

            @Override
            public final Integer getFavorites() {
                return this.favorites;
            }

            @Override
            public final String getMore() {
                return this.more;
            }

            @Override
            public final Map<String, String> getMoreDetails() {
                return this.moreDetails == null ? null : new HashMap<String, String>(this.moreDetails);
            }

            public final String toString() {
                return "Person{id=" + this.id + ", firstName='" + this.firstName + '\'' + ", lastName='" + this.lastName + '\'' + ", birthday=" + this.birthday + ", alternative_names=" + Arrays.toString(this.alternative_names) + ", favorites=" + this.favorites + ", mainPicture=" + this.mainPicture + ", more='" + this.more + '\'' + ", moreDetails=" + this.moreDetails + '}';
            }
        };
    }
}

