/*
 * Decompiled with CFR 0.152.
 */
package dev.katsute.mal4j;

import dev.katsute.mal4j.Fields;
import dev.katsute.mal4j.Json;
import dev.katsute.mal4j.MyAnimeList;
import dev.katsute.mal4j.MyAnimeListImpl;
import dev.katsute.mal4j.MyAnimeListSchema;
import dev.katsute.mal4j.anime.Anime;
import dev.katsute.mal4j.anime.AnimeListStatus;
import dev.katsute.mal4j.manga.Manga;
import dev.katsute.mal4j.manga.MangaListStatus;
import dev.katsute.mal4j.property.ExperimentalFeature;
import dev.katsute.mal4j.query.UserAnimeListQuery;
import dev.katsute.mal4j.query.UserMangaListQuery;
import dev.katsute.mal4j.user.User;
import dev.katsute.mal4j.user.UserAnimeStatistics;
import dev.katsute.mal4j.user.property.AffinityAlgorithm;
import dev.katsute.mal4j.user.property.AnimeAffinity;
import dev.katsute.mal4j.user.property.MangaAffinity;
import dev.katsute.mal4j.user.property.MyAnimeListAffinityAlgorithm;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

abstract class MyAnimeListSchema_User
extends MyAnimeListSchema {
    MyAnimeListSchema_User() {
    }

    static User asUser(final MyAnimeList mal, final Json.JsonObject schema) {
        return schema == null ? null : new User(){
            private final Long id;
            private final String name;
            private final String picture;
            private final String gender;
            private final Long birthday;
            private final String location;
            private final Long joinedAt;
            private final UserAnimeStatistics animeStatistics;
            private final String timezone;
            private final Boolean supporter;
            {
                this.id = schema.getLong("id");
                this.name = schema.getString("name");
                this.picture = schema.getString("picture");
                this.gender = schema.getString("gender");
                this.birthday = MyAnimeListSchema.parseDate(schema.getString("birthday"));
                this.location = schema.getString("location");
                this.joinedAt = MyAnimeListSchema.parseISO8601(schema.getString("joined_at"));
                this.animeStatistics = MyAnimeListSchema_User.asUserAnimeStatistics(mal, schema.getJsonObject("anime_statistics"));
                this.timezone = schema.getString("time_zone");
                this.supporter = schema.getBoolean("is_supporter");
            }

            @Override
            public final Long getID() {
                return this.id;
            }

            @Override
            public final String getName() {
                return this.name;
            }

            @Override
            public final String getPictureURL() {
                return this.picture;
            }

            @Override
            public final String getGender() {
                return this.gender;
            }

            @Override
            public final Date getBirthday() {
                return this.birthday == null ? null : new Date(this.birthday);
            }

            @Override
            public final String getLocation() {
                return this.location;
            }

            @Override
            public final Date getJoinedAt() {
                return this.joinedAt == null ? null : new Date(this.joinedAt);
            }

            @Override
            public final Long getJoinedAtEpochMillis() {
                return this.joinedAt;
            }

            @Override
            public final UserAnimeStatistics getAnimeStatistics() {
                return this.animeStatistics;
            }

            @Override
            public final String getTimeZone() {
                return this.timezone;
            }

            @Override
            public final Boolean isSupporter() {
                return this.supporter;
            }

            @Override
            public final UserAnimeListQuery getUserAnimeListing() {
                return mal.getUserAnimeListing(this.name);
            }

            @Override
            public final UserMangaListQuery getUserMangaListing() {
                return mal.getUserMangaListing(this.name);
            }

            @Override
            public final AnimeAffinity getAnimeAffinity() {
                return this.getAnimeAffinity(mal.getAuthenticatedUser(Fields.NO_FIELDS).getName());
            }

            @Override
            public final void getAnimeAffinity(Consumer<AnimeAffinity> callback) {
                new Thread(() -> callback.accept(this.getAnimeAffinity())).start();
            }

            @Override
            public final AnimeAffinity getAnimeAffinity(User user) {
                return this.getAnimeAffinity(Objects.requireNonNull(user, "User can not be null").getName());
            }

            @Override
            public final void getAnimeAffinity(User user, Consumer<AnimeAffinity> callback) {
                new Thread(() -> callback.accept(this.getAnimeAffinity(user))).start();
            }

            @Override
            public final AnimeAffinity getAnimeAffinity(String username) {
                ((MyAnimeListImpl)mal).checkExperimentalFeatureEnabled(ExperimentalFeature.AFFINITY);
                Objects.requireNonNull(username, "Username can not be null");
                HashMap selfListings = new HashMap();
                ((UserAnimeListQuery)((UserAnimeListQuery)this.getUserAnimeListing().includeNSFW().withFields(Fields.Anime.list_status)).withLimit(1000)).searchAll().forEachRemaining(e -> {
                    if (e.getScore() != null && e.getScore() > 0) {
                        selfListings.put(e.getAnime().getID(), e);
                    }
                });
                HashMap otherListings = new HashMap();
                if (mal.getAuthenticatedUser().getName().equals(username)) {
                    otherListings.putAll(selfListings);
                } else {
                    ((UserAnimeListQuery)((UserAnimeListQuery)mal.getUserAnimeListing(username).includeNSFW().withFields(Fields.Anime.list_status)).withLimit(1000)).searchAll().forEachRemaining(e -> {
                        Long id = e.getAnime().getID();
                        if (e.getScore() != null && e.getScore() > 0 && selfListings.containsKey(id)) {
                            otherListings.put(id, e);
                        }
                    });
                }
                final int len = otherListings.size();
                final Anime[] shared = new Anime[len];
                final int[] selfScores = new int[len];
                final int[] otherScores = new int[len];
                int index = 0;
                for (Map.Entry otherListing : otherListings.entrySet()) {
                    AnimeListStatus selfListing = (AnimeListStatus)selfListings.get(otherListing.getKey());
                    shared[index] = selfListing.getAnime();
                    selfScores[index] = selfListing.getScore();
                    otherScores[index] = ((AnimeListStatus)otherListing.getValue()).getScore();
                    ++index;
                }
                return new AnimeAffinity(){
                    private final int sharedCount;
                    private final Anime[] sharedPreviews;
                    private final int[] a_scores;
                    private final int[] b_scores;
                    {
                        this.sharedCount = len;
                        this.sharedPreviews = shared;
                        this.a_scores = selfScores;
                        this.b_scores = otherScores;
                    }

                    @Override
                    public final Anime[] getShared() {
                        return Arrays.copyOf(this.sharedPreviews, this.sharedCount);
                    }

                    @Override
                    public final int getSharedCount() {
                        return this.sharedCount;
                    }

                    @Override
                    public final float getAffinity() {
                        return this.getAffinity(new MyAnimeListAffinityAlgorithm());
                    }

                    @Override
                    public final float getAffinity(AffinityAlgorithm algorithm) {
                        return Objects.requireNonNull(algorithm, "Affinity algorithm can not be null").getAffinity(Arrays.copyOf(this.a_scores, this.sharedCount), Arrays.copyOf(this.b_scores, this.sharedCount));
                    }

                    public final String toString() {
                        return "AnimeAffinity{sharedCount=" + this.sharedCount + ", selfScores=" + Arrays.toString(this.a_scores) + ", otherScores=" + Arrays.toString(this.b_scores) + '}';
                    }
                };
            }

            @Override
            public final void getAnimeAffinity(String username, Consumer<AnimeAffinity> callback) {
                new Thread(() -> callback.accept(this.getAnimeAffinity(username))).start();
            }

            @Override
            public final MangaAffinity getMangaAffinity() {
                return this.getMangaAffinity(mal.getAuthenticatedUser(Fields.NO_FIELDS).getName());
            }

            @Override
            public final void getMangaAffinity(Consumer<MangaAffinity> callback) {
                new Thread(() -> callback.accept(this.getMangaAffinity())).start();
            }

            @Override
            public final MangaAffinity getMangaAffinity(User user) {
                return this.getMangaAffinity(Objects.requireNonNull(user, "User can not be null").getName());
            }

            @Override
            public final void getMangaAffinity(User user, Consumer<MangaAffinity> callback) {
                new Thread(() -> callback.accept(this.getMangaAffinity(user))).start();
            }

            @Override
            public final MangaAffinity getMangaAffinity(String username) {
                ((MyAnimeListImpl)mal).checkExperimentalFeatureEnabled(ExperimentalFeature.AFFINITY);
                Objects.requireNonNull(username, "Username can not be null");
                HashMap selfListings = new HashMap();
                ((UserMangaListQuery)((UserMangaListQuery)this.getUserMangaListing().includeNSFW().withFields(Fields.Manga.list_status)).withLimit(1000)).searchAll().forEachRemaining(e -> {
                    if (e.getScore() != null && e.getScore() > 0) {
                        selfListings.put(e.getManga().getID(), e);
                    }
                });
                HashMap otherListings = new HashMap();
                if (mal.getAuthenticatedUser().getName().equals(username)) {
                    otherListings.putAll(selfListings);
                } else {
                    ((UserMangaListQuery)((UserMangaListQuery)mal.getUserMangaListing(username).includeNSFW().withFields(Fields.Manga.list_status)).withLimit(1000)).searchAll().forEachRemaining(e -> {
                        Long id = e.getManga().getID();
                        if (e.getScore() != null && e.getScore() > 0 && selfListings.containsKey(id)) {
                            otherListings.put(id, e);
                        }
                    });
                }
                final int len = otherListings.size();
                final Manga[] shared = new Manga[len];
                final int[] selfScores = new int[len];
                final int[] otherScores = new int[len];
                int index = 0;
                for (Map.Entry otherListing : otherListings.entrySet()) {
                    MangaListStatus selfListing = (MangaListStatus)selfListings.get(otherListing.getKey());
                    shared[index] = selfListing.getManga();
                    selfScores[index] = selfListing.getScore();
                    otherScores[index] = ((MangaListStatus)otherListing.getValue()).getScore();
                    ++index;
                }
                return new MangaAffinity(){
                    private final int sharedCount;
                    private final Manga[] sharedPreviews;
                    private final int[] a_scores;
                    private final int[] b_scores;
                    {
                        this.sharedCount = len;
                        this.sharedPreviews = shared;
                        this.a_scores = selfScores;
                        this.b_scores = otherScores;
                    }

                    @Override
                    public final Manga[] getShared() {
                        return Arrays.copyOf(this.sharedPreviews, this.sharedCount);
                    }

                    @Override
                    public final int getSharedCount() {
                        return this.sharedCount;
                    }

                    @Override
                    public final float getAffinity() {
                        return this.getAffinity(new MyAnimeListAffinityAlgorithm());
                    }

                    @Override
                    public final float getAffinity(AffinityAlgorithm algorithm) {
                        return Objects.requireNonNull(algorithm, "Affinity algorithm can not be null").getAffinity(Arrays.copyOf(this.a_scores, this.sharedCount), Arrays.copyOf(this.b_scores, this.sharedCount));
                    }

                    public final String toString() {
                        return "MangaAffinity{sharedCount=" + this.sharedCount + ", selfScores=" + Arrays.toString(this.a_scores) + ", otherScores=" + Arrays.toString(this.b_scores) + '}';
                    }
                };
            }

            @Override
            public final void getMangaAffinity(String username, Consumer<MangaAffinity> callback) {
                new Thread(() -> callback.accept(this.getMangaAffinity(username))).start();
            }

            public final String toString() {
                return "User{id=" + this.id + ", name='" + this.name + '\'' + ", picture='" + this.picture + '\'' + ", gender='" + this.gender + '\'' + ", birthday=" + this.birthday + ", location='" + this.location + '\'' + ", joinedAt=" + this.joinedAt + ", animeStatistics=" + this.animeStatistics + ", timezone='" + this.timezone + '\'' + ", supporter=" + this.supporter + '}';
            }
        };
    }

    static UserAnimeStatistics asUserAnimeStatistics(MyAnimeList mal, final Json.JsonObject schema) {
        return schema == null ? null : new UserAnimeStatistics(){
            private final Integer watching;
            private final Integer completed;
            private final Integer onHold;
            private final Integer dropped;
            private final Integer planToWatch;
            private final Integer items;
            private final Float daysWatching;
            private final Float daysCompleted;
            private final Float daysOnHold;
            private final Float daysDropped;
            private final Float days;
            private final Integer episodesWatched;
            private final Integer timesRewatched;
            private final Float meanScore;
            {
                this.watching = schema.getInt("num_items_watching");
                this.completed = schema.getInt("num_items_completed");
                this.onHold = schema.getInt("num_items_on_hold");
                this.dropped = schema.getInt("num_items_dropped");
                this.planToWatch = schema.getInt("num_items_plan_to_watch");
                this.items = schema.getInt("num_items");
                this.daysWatching = schema.getFloat("num_days_watching");
                this.daysCompleted = schema.getFloat("num_days_completed");
                this.daysOnHold = schema.getFloat("num_days_on_hold");
                this.daysDropped = schema.getFloat("num_days_dropped");
                this.days = schema.getFloat("num_days");
                this.episodesWatched = schema.getInt("num_episodes");
                this.timesRewatched = schema.getInt("num_times_rewatched");
                this.meanScore = schema.getFloat("mean_score");
            }

            @Override
            public final Integer getItemsWatching() {
                return this.watching;
            }

            @Override
            public final Integer getItemsCompleted() {
                return this.completed;
            }

            @Override
            public final Integer getItemsOnHold() {
                return this.onHold;
            }

            @Override
            public final Integer getItemsDropped() {
                return this.dropped;
            }

            @Override
            public final Integer getItemsPlanToWatch() {
                return this.planToWatch;
            }

            @Override
            public final Integer getItems() {
                return this.items;
            }

            @Override
            public final Float getDaysWatched() {
                return this.days;
            }

            @Override
            public final Float getDaysWatching() {
                return this.daysWatching;
            }

            @Override
            public final Float getDaysCompleted() {
                return this.daysCompleted;
            }

            @Override
            public final Float getDaysOnHold() {
                return this.daysOnHold;
            }

            @Override
            public final Float getDaysDropped() {
                return this.daysDropped;
            }

            @Override
            public final Float getDays() {
                return this.days;
            }

            @Override
            public final Integer getEpisodes() {
                return this.episodesWatched;
            }

            @Override
            public final Integer getTimesRewatched() {
                return this.timesRewatched;
            }

            @Override
            public final Float getMeanScore() {
                return this.meanScore;
            }

            public final String toString() {
                return "UserAnimeStatistics{watching=" + this.watching + ", completed=" + this.completed + ", onHold=" + this.onHold + ", dropped=" + this.dropped + ", planToWatch=" + this.planToWatch + ", items=" + this.items + ", daysWatching=" + this.daysWatching + ", daysCompleted=" + this.daysCompleted + ", daysOnHold=" + this.daysOnHold + ", daysDropped=" + this.daysDropped + ", days=" + this.days + ", episodesWatched=" + this.episodesWatched + ", timesRewatched=" + this.timesRewatched + ", meanScore=" + this.meanScore + '}';
            }
        };
    }
}

