/*
 * Decompiled with CFR 0.152.
 */
package dev.katsute.mal4j;

import dev.katsute.mal4j.APICall;
import dev.katsute.mal4j.APIStruct;
import dev.katsute.mal4j.Json;

interface MyAnimeListService {
    public static final String baseURL = "https://api.myanimelist.net/v2/";

    public static MyAnimeListService create() {
        return APICall.create(baseURL, MyAnimeListService.class);
    }

    @APIStruct.Endpoint(method="GET", value="anime")
    public APIStruct.Response<Json.JsonObject> getAnime(@APIStruct.Header(value="Authorization") String var1, @APIStruct.Header(value="X-MAL-CLIENT-ID") String var2, @APIStruct.Query(value="q") String var3, @APIStruct.Query(value="limit") Integer var4, @APIStruct.Query(value="offset") Integer var5, @APIStruct.Query(value="fields", encoded=true) String var6, @APIStruct.Query(value="nsfw") Boolean var7);

    @APIStruct.Endpoint(method="GET", value="anime/{anime_id}")
    public APIStruct.Response<Json.JsonObject> getAnime(@APIStruct.Header(value="Authorization") String var1, @APIStruct.Header(value="X-MAL-CLIENT-ID") String var2, @APIStruct.Path(value="anime_id") Long var3, @APIStruct.Query(value="fields", encoded=true) String var4);

    @APIStruct.Endpoint(method="GET", value="anime/{anime_id}/characters")
    public APIStruct.Response<Json.JsonObject> getAnimeCharacters(@APIStruct.Header(value="Authorization") String var1, @APIStruct.Header(value="X-MAL-CLIENT-ID") String var2, @APIStruct.Path(value="anime_id") Long var3, @APIStruct.Query(value="limit") Integer var4, @APIStruct.Query(value="offset") Integer var5, @APIStruct.Query(value="fields", encoded=true) String var6);

    @APIStruct.Endpoint(method="GET", value="anime/ranking")
    public APIStruct.Response<Json.JsonObject> getAnimeRanking(@APIStruct.Header(value="Authorization") String var1, @APIStruct.Header(value="X-MAL-CLIENT-ID") String var2, @APIStruct.Query(value="ranking_type") String var3, @APIStruct.Query(value="limit") Integer var4, @APIStruct.Query(value="offset") Integer var5, @APIStruct.Query(value="fields", encoded=true) String var6, @APIStruct.Query(value="nsfw") Boolean var7);

    @APIStruct.Endpoint(method="GET", value="anime/season/{year}/{season}")
    public APIStruct.Response<Json.JsonObject> getAnimeSeason(@APIStruct.Header(value="Authorization") String var1, @APIStruct.Header(value="X-MAL-CLIENT-ID") String var2, @APIStruct.Path(value="year") Integer var3, @APIStruct.Path(value="season") String var4, @APIStruct.Query(value="sort") String var5, @APIStruct.Query(value="limit") Integer var6, @APIStruct.Query(value="offset") Integer var7, @APIStruct.Query(value="fields", encoded=true) String var8, @APIStruct.Query(value="nsfw") Boolean var9);

    @APIStruct.Endpoint(method="GET", value="anime/suggestions")
    public APIStruct.Response<Json.JsonObject> getAnimeSuggestions(@APIStruct.Header(value="Authorization") String var1, @APIStruct.Query(value="limit") Integer var2, @APIStruct.Query(value="offset") Integer var3, @APIStruct.Query(value="fields", encoded=true) String var4, @APIStruct.Query(value="nsfw") Boolean var5);

    @APIStruct.FormUrlEncoded
    @APIStruct.Endpoint(method="PATCH", value="anime/{anime_id}/my_list_status")
    public APIStruct.Response<Json.JsonObject> updateAnimeListing(@APIStruct.Header(value="Authorization") String var1, @APIStruct.Path(value="anime_id") Long var2, @APIStruct.Field(value="status") String var3, @APIStruct.Field(value="is_rewatching") Boolean var4, @APIStruct.Field(value="score") Integer var5, @APIStruct.Field(value="start_date", encoded=true) String var6, @APIStruct.Field(value="finish_date", encoded=true) String var7, @APIStruct.Field(value="num_watched_episodes") Integer var8, @APIStruct.Field(value="priority") Integer var9, @APIStruct.Field(value="num_times_rewatched") Integer var10, @APIStruct.Field(value="rewatch_value") Integer var11, @APIStruct.Field(value="tags") String var12, @APIStruct.Field(value="comments") String var13);

    @APIStruct.Endpoint(method="DELETE", value="anime/{anime_id}/my_list_status")
    public APIStruct.Response<Void> deleteAnimeListing(@APIStruct.Header(value="Authorization") String var1, @APIStruct.Path(value="anime_id") Integer var2);

    @APIStruct.Endpoint(method="GET", value="users/{user_name}/animelist")
    public APIStruct.Response<Json.JsonObject> getUserAnimeListing(@APIStruct.Header(value="Authorization") String var1, @APIStruct.Header(value="X-MAL-CLIENT-ID") String var2, @APIStruct.Path(value="user_name", encoded=true) String var3, @APIStruct.Query(value="status") String var4, @APIStruct.Query(value="sort") String var5, @APIStruct.Query(value="limit") Integer var6, @APIStruct.Query(value="offset") Integer var7, @APIStruct.Query(value="fields", encoded=true) String var8, @APIStruct.Query(value="nsfw") Boolean var9);

    @APIStruct.Endpoint(method="GET", value="characters/{character_id}")
    public APIStruct.Response<Json.JsonObject> getCharacter(@APIStruct.Header(value="Authorization") String var1, @APIStruct.Header(value="X-MAL-CLIENT-ID") String var2, @APIStruct.Path(value="character_id") Long var3, @APIStruct.Query(value="fields", encoded=true) String var4);

    @APIStruct.Endpoint(method="GET", value="forum/boards")
    public APIStruct.Response<Json.JsonObject> getForumBoards(@APIStruct.Header(value="Authorization") String var1, @APIStruct.Header(value="X-MAL-CLIENT-ID") String var2);

    @APIStruct.Endpoint(method="GET", value="forum/topic/{topic_id}")
    public APIStruct.Response<Json.JsonObject> getForumBoard(@APIStruct.Header(value="Authorization") String var1, @APIStruct.Header(value="X-MAL-CLIENT-ID") String var2, @APIStruct.Path(value="topic_id") Long var3, @APIStruct.Query(value="limit") Integer var4, @APIStruct.Query(value="offset") Integer var5);

    @APIStruct.Endpoint(method="GET", value="forum/topics")
    public APIStruct.Response<Json.JsonObject> getForumTopics(@APIStruct.Header(value="Authorization") String var1, @APIStruct.Header(value="X-MAL-CLIENT-ID") String var2, @APIStruct.Query(value="board_id") Long var3, @APIStruct.Query(value="subboard_id") Long var4, @APIStruct.Query(value="limit") Integer var5, @APIStruct.Query(value="offset") Integer var6, @APIStruct.Query(value="sort") String var7, @APIStruct.Query(value="q") String var8, @APIStruct.Query(value="topic_user_name") String var9, @APIStruct.Query(value="user_name") String var10);

    @APIStruct.Endpoint(method="GET", value="manga")
    public APIStruct.Response<Json.JsonObject> getManga(@APIStruct.Header(value="Authorization") String var1, @APIStruct.Header(value="X-MAL-CLIENT-ID") String var2, @APIStruct.Query(value="q") String var3, @APIStruct.Query(value="limit") Integer var4, @APIStruct.Query(value="offset") Integer var5, @APIStruct.Query(value="fields", encoded=true) String var6, @APIStruct.Query(value="nsfw") Boolean var7);

    @APIStruct.Endpoint(method="GET", value="manga/{manga_id}")
    public APIStruct.Response<Json.JsonObject> getManga(@APIStruct.Header(value="Authorization") String var1, @APIStruct.Header(value="X-MAL-CLIENT-ID") String var2, @APIStruct.Path(value="manga_id") Long var3, @APIStruct.Query(value="fields", encoded=true) String var4);

    @APIStruct.Endpoint(method="GET", value="manga/ranking")
    public APIStruct.Response<Json.JsonObject> getMangaRanking(@APIStruct.Header(value="Authorization") String var1, @APIStruct.Header(value="X-MAL-CLIENT-ID") String var2, @APIStruct.Query(value="ranking_type") String var3, @APIStruct.Query(value="limit") Integer var4, @APIStruct.Query(value="offset") Integer var5, @APIStruct.Query(value="fields", encoded=true) String var6, @APIStruct.Query(value="nsfw") Boolean var7);

    @APIStruct.FormUrlEncoded
    @APIStruct.Endpoint(method="PATCH", value="manga/{manga_id}/my_list_status")
    public APIStruct.Response<Json.JsonObject> updateMangaListing(@APIStruct.Header(value="Authorization") String var1, @APIStruct.Path(value="manga_id") Long var2, @APIStruct.Field(value="status") String var3, @APIStruct.Field(value="is_rereading") Boolean var4, @APIStruct.Field(value="score") Integer var5, @APIStruct.Field(value="start_date", encoded=true) String var6, @APIStruct.Field(value="finish_date", encoded=true) String var7, @APIStruct.Field(value="num_volumes_read") Integer var8, @APIStruct.Field(value="num_chapters_read") Integer var9, @APIStruct.Field(value="priority") Integer var10, @APIStruct.Field(value="num_times_reread") Integer var11, @APIStruct.Field(value="reread_value") Integer var12, @APIStruct.Field(value="tags") String var13, @APIStruct.Field(value="comments") String var14);

    @APIStruct.Endpoint(method="DELETE", value="manga/{manga_id}/my_list_status")
    public APIStruct.Response<Void> deleteMangaListing(@APIStruct.Header(value="Authorization") String var1, @APIStruct.Path(value="manga_id") Long var2);

    @APIStruct.Endpoint(method="GET", value="users/{user_name}/mangalist")
    public APIStruct.Response<Json.JsonObject> getUserMangaListing(@APIStruct.Header(value="Authorization") String var1, @APIStruct.Header(value="X-MAL-CLIENT-ID") String var2, @APIStruct.Path(value="user_name", encoded=true) String var3, @APIStruct.Query(value="status") String var4, @APIStruct.Query(value="sort") String var5, @APIStruct.Query(value="limit") Integer var6, @APIStruct.Query(value="offset") Integer var7, @APIStruct.Query(value="fields", encoded=true) String var8, @APIStruct.Query(value="nsfw") Boolean var9);

    @APIStruct.Endpoint(method="GET", value="people/{person_id}")
    public APIStruct.Response<Json.JsonObject> getPerson(@APIStruct.Header(value="Authorization") String var1, @APIStruct.Header(value="X-MAL-CLIENT-ID") String var2, @APIStruct.Path(value="person_id") Long var3, @APIStruct.Query(value="fields", encoded=true) String var4);

    @APIStruct.Endpoint(method="GET", value="users/{user_name}")
    public APIStruct.Response<Json.JsonObject> getUser(@APIStruct.Header(value="Authorization") String var1, @APIStruct.Path(value="user_name", encoded=true) String var2, @APIStruct.Query(value="fields", encoded=true) String var3);
}

