/*
 * Decompiled with CFR 0.152.
 */
package dev.katsute.mal4j;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;

public abstract class PaginatedIterator<T>
implements Iterator<T> {
    private int index = -1;
    List<T> list = new ArrayList<T>();
    int size;

    private boolean hasNextItem() {
        return this.index + 1 < this.size;
    }

    @Override
    public final boolean hasNext() {
        return this.hasNextItem() || this.hasNextPage();
    }

    @Override
    public final synchronized T next() {
        if (this.hasNextItem()) {
            return this.list.get(++this.index);
        }
        if (this.hasNextPage()) {
            this.nextPage();
            return this.list.get(++this.index);
        }
        throw new NoSuchElementException();
    }

    abstract boolean hasNextPage();

    private synchronized void nextPage() {
        this.list = this.getNextPage();
        this.size = this.list.size();
        this.index = -1;
    }

    abstract List<T> getNextPage();

    @Override
    public final synchronized void remove() {
        throw new UnsupportedOperationException();
    }

    public final List<T> toList() {
        return new ArrayList<T>(this.list);
    }

    public final Set<T> toSet() {
        return new LinkedHashSet<T>(this.list);
    }
}

