/*
 * Decompiled with CFR 0.152.
 */
package dev.katsute.mal4j.anime.property.time;

import dev.katsute.mal4j.property.FieldEnum;
import java.util.Arrays;

public enum Season implements FieldEnum
{
    Winter("winter", new String[]{"January", "February", "March"}),
    Spring("spring", new String[]{"April", "May", "June"}),
    Summer("summer", new String[]{"July", "August", "September"}),
    Fall("fall", new String[]{"October", "November", "December"});

    private final String field;
    private final String[] months;

    private Season(String field, String[] months) {
        this.field = field;
        this.months = months;
    }

    public final String[] getMonths() {
        return Arrays.copyOf(this.months, this.months.length);
    }

    public static Season fromMonth(String month) {
        for (Season value : Season.values()) {
            for (String m : value.getMonths()) {
                if (!m.equalsIgnoreCase(month)) continue;
                return value;
            }
        }
        return null;
    }

    @Override
    public final String field() {
        return this.field;
    }

    public static Season asEnum(String string) {
        if (string != null) {
            for (Season value : Season.values()) {
                if (!value.field.equalsIgnoreCase(string)) continue;
                return value;
            }
        }
        return null;
    }

    public String toString() {
        return "Season{field='" + this.field + '\'' + ", months=" + Arrays.toString(this.months) + '}';
    }
}

