/*
 * Decompiled with CFR 0.152.
 */
package dev.katsute.mal4j.user.property;

import dev.katsute.mal4j.user.property.AffinityAlgorithm;

public final class MyAnimeListAffinityAlgorithm
implements AffinityAlgorithm {
    @Override
    public final float getAffinity(int[] a_scores, int[] b_scores) {
        int len = a_scores.length;
        if (len != b_scores.length) {
            throw new IllegalArgumentException("Both arrays must be of the same length, argument 1 was of length " + a_scores.length + " while argument 2 was of length " + b_scores.length);
        }
        if (len == 0) {
            return 0.0f;
        }
        Integer diff = null;
        boolean sameDiff = true;
        int x_sum = 0;
        int y_sum = 0;
        for (int i = 0; i < len; ++i) {
            int a = a_scores[i];
            x_sum += a;
            int b = b_scores[i];
            y_sum += b;
            if (diff != null && sameDiff && diff != a - b) {
                sameDiff = false;
            }
            diff = a - b;
        }
        if (sameDiff) {
            return 1.0f;
        }
        double x_mean = (double)x_sum / (double)len;
        double y_mean = (double)y_sum / (double)len;
        double enumerate_xy_diff = 0.0;
        double enumerate_x_diff = 0.0;
        double enumerate_y_diff = 0.0;
        for (int i = 0; i < len; ++i) {
            double x_diff = (double)a_scores[i] - x_mean;
            double y_diff = (double)b_scores[i] - y_mean;
            enumerate_xy_diff += x_diff * y_diff;
            enumerate_x_diff += x_diff * x_diff;
            enumerate_y_diff += y_diff * y_diff;
        }
        double xy_sqrt = Math.sqrt(enumerate_x_diff) * Math.sqrt(enumerate_y_diff);
        return (float)(xy_sqrt == 0.0 ? 0.0 : enumerate_xy_diff / xy_sqrt);
    }
}

