/*
 * Decompiled with CFR 0.152.
 */
package dev.kilua.rpc;

import dev.kilua.rpc.DummyWebSocketSession;
import dev.kilua.rpc.RpcServiceManager;
import dev.kilua.rpc.RpcWebSocketHandler;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.reactive.handler.SimpleUrlHandlerMapping;
import org.springframework.web.reactive.socket.WebSocketSession;
import org.springframework.web.reactive.socket.server.support.WebSocketHandlerAdapter;

@Configuration
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B!\u0012\u0010\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\f\u001a\u00020\u000bH\u0017J\b\u0010\r\u001a\u00020\u000eH\u0017J\b\u0010\u000f\u001a\u00020\u0010H\u0017R\u0018\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Ldev/kilua/rpc/RpcWebSocketConfig;", "", "services", "", "Ldev/kilua/rpc/RpcServiceManager;", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "<init>", "(Ljava/util/List;Lorg/springframework/context/ApplicationContext;)V", "threadLocalWebSocketSession", "Ljava/lang/ThreadLocal;", "Lorg/springframework/web/reactive/socket/WebSocketSession;", "webSocketSession", "handlerMapping", "Lorg/springframework/web/reactive/HandlerMapping;", "handlerAdapter", "Lorg/springframework/web/reactive/socket/server/support/WebSocketHandlerAdapter;", "kilua-rpc-spring-boot"})
public class RpcWebSocketConfig {
    @NotNull
    private final List<RpcServiceManager<?>> services;
    @NotNull
    private final ApplicationContext applicationContext;
    @NotNull
    private final ThreadLocal<WebSocketSession> threadLocalWebSocketSession;

    public RpcWebSocketConfig(@NotNull List<? extends RpcServiceManager<?>> services, @NotNull ApplicationContext applicationContext) {
        Intrinsics.checkNotNullParameter(services, (String)"services");
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        this.services = services;
        this.applicationContext = applicationContext;
        this.threadLocalWebSocketSession = new ThreadLocal();
    }

    @Bean
    @Scope(value="prototype")
    @NotNull
    public WebSocketSession webSocketSession() {
        WebSocketSession webSocketSession = this.threadLocalWebSocketSession.get();
        if (webSocketSession == null) {
            webSocketSession = new DummyWebSocketSession();
        }
        return webSocketSession;
    }

    @Bean
    @NotNull
    public HandlerMapping handlerMapping() {
        Map map = MapsKt.mapOf((Pair)TuplesKt.to((Object)"/rpcws/*", (Object)new RpcWebSocketHandler(this.services, this.threadLocalWebSocketSession, this.applicationContext)));
        int order = -1;
        return (HandlerMapping)new SimpleUrlHandlerMapping(map, order);
    }

    @Bean
    @NotNull
    public WebSocketHandlerAdapter handlerAdapter() {
        return new WebSocketHandlerAdapter();
    }
}

