/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.data.message;

import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.AudioContent;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.ChatMessageDeserializer;
import dev.langchain4j.data.message.ChatMessageSerializer;
import dev.langchain4j.data.message.Content;
import dev.langchain4j.data.message.CustomMessage;
import dev.langchain4j.data.message.ImageContent;
import dev.langchain4j.data.message.PdfFileContent;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.data.message.TextFileContent;
import dev.langchain4j.data.message.ToolExecutionResultMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.data.message.VideoContent;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class ChatMessageSerializerTest {
    ChatMessageSerializerTest() {
    }

    @ParameterizedTest
    @MethodSource
    void should_serialize_and_deserialize_chat_message(ChatMessage message, String expectedJson) {
        String json = ChatMessageSerializer.messageToJson((ChatMessage)message);
        Assertions.assertThat((String)json).isEqualToIgnoringWhitespace((CharSequence)expectedJson);
        ChatMessage deserializedMessage = ChatMessageDeserializer.messageFromJson((String)json);
        Assertions.assertThat((Object)deserializedMessage).isEqualTo((Object)message);
    }

    static Stream<Arguments> should_serialize_and_deserialize_chat_message() {
        return Stream.of(Arguments.of((Object[])new Object[]{SystemMessage.from((String)"hello"), "{\"text\":\"hello\",\"type\":\"SYSTEM\"}"}), Arguments.of((Object[])new Object[]{UserMessage.from((String)"hello"), "{\"contents\":[{\"text\":\"hello\",\"type\":\"TEXT\"}],\"type\":\"USER\"}"}), Arguments.of((Object[])new Object[]{UserMessage.from((String)"Klaus", (String)"hello"), "{\"name\":\"Klaus\",\"contents\":[{\"text\":\"hello\",\"type\":\"TEXT\"}],\"type\":\"USER\"}"}), Arguments.of((Object[])new Object[]{UserMessage.from((Content[])new Content[]{ImageContent.from((String)"http://image.url")}), "{\"contents\":[{\"image\":{\"url\":\"http://image.url\"},\"detailLevel\":\"LOW\",\"type\":\"IMAGE\"}],\"type\":\"USER\"}"}), Arguments.of((Object[])new Object[]{UserMessage.from((Content[])new Content[]{ImageContent.from((String)"aGVsbG8=", (String)"image/png")}), "{\"contents\":[{\"image\":{\"base64Data\":\"aGVsbG8=\",\"mimeType\":\"image/png\"},\"detailLevel\":\"LOW\",\"type\":\"IMAGE\"}],\"type\":\"USER\"}"}), Arguments.of((Object[])new Object[]{UserMessage.from((Content[])new Content[]{AudioContent.from((String)"bXAz", (String)"audio/mp3")}), "{\"contents\":[{\"audio\":{\"base64Data\":\"bXAz\",\"mimeType\":\"audio/mp3\"},\"type\":\"AUDIO\"}],\"type\":\"USER\"}"}), Arguments.of((Object[])new Object[]{UserMessage.from((Content[])new Content[]{VideoContent.from((String)"bXA0", (String)"video/mp4")}), "{\"contents\":[{\"video\":{\"base64Data\":\"bXA0\",\"mimeType\":\"video/mp4\"},\"type\":\"VIDEO\"}],\"type\":\"USER\"}"}), Arguments.of((Object[])new Object[]{UserMessage.from((Content[])new Content[]{TextFileContent.from((String)"cGRm", (String)"text/markdown")}), "{\"contents\":[{\"textFile\":{\"base64Data\":\"cGRm\",\"mimeType\":\"text/markdown\"},\"type\":\"TEXT_FILE\"}],\"type\":\"USER\"}"}), Arguments.of((Object[])new Object[]{UserMessage.from((Content[])new Content[]{PdfFileContent.from((String)"cGRm", (String)"application/pdf")}), "{\"contents\":[{\"pdfFile\":{\"base64Data\":\"cGRm\"},\"type\":\"PDF\"}],\"type\":\"USER\"}"}), Arguments.of((Object[])new Object[]{AiMessage.from((String)"hello"), "{\"text\":\"hello\",\"type\":\"AI\"}"}), Arguments.of((Object[])new Object[]{AiMessage.from((ToolExecutionRequest[])new ToolExecutionRequest[]{ToolExecutionRequest.builder().name("weather").arguments("{\"city\": \"Munich\"}").build()}), "{\"toolExecutionRequests\":[{\"name\":\"weather\",\"arguments\":\"{\\\"city\\\": \\\"Munich\\\"}\"}],\"type\":\"AI\"}"}), Arguments.of((Object[])new Object[]{ToolExecutionResultMessage.from((String)"12345", (String)"weather", (String)"sunny"), "{\"id\":\"12345\",\"toolName\":\"weather\",\"text\":\"sunny\",\"type\":\"TOOL_EXECUTION_RESULT\"}"}), Arguments.of((Object[])new Object[]{CustomMessage.from((Map)new LinkedHashMap<String, Object>(){
            {
                this.put("k1", "v1");
                this.put("k2", "v2");
            }
        }), "{\"attributes\":{\"k1\":\"v1\", \"k2\":\"v2\"},\"type\":\"CUSTOM\"}"}));
    }

    @Test
    void should_serialize_and_deserialize_empty_list() {
        List messages = Collections.emptyList();
        String json = ChatMessageSerializer.messagesToJson(messages);
        List deserializedMessages = ChatMessageDeserializer.messagesFromJson((String)json);
        Assertions.assertThat((List)deserializedMessages).isEmpty();
    }

    @Test
    void should_deserialize_null_as_empty_list() {
        Assertions.assertThat((List)ChatMessageDeserializer.messagesFromJson(null)).isEmpty();
    }

    @Test
    void should_serialize_and_deserialize_list_with_one_message() {
        List<UserMessage> messages = Collections.singletonList(UserMessage.userMessage((String)"hello"));
        String json = ChatMessageSerializer.messagesToJson(messages);
        Assertions.assertThat((String)json).isEqualTo("[{\"contents\":[{\"text\":\"hello\",\"type\":\"TEXT\"}],\"type\":\"USER\"}]");
        List deserializedMessages = ChatMessageDeserializer.messagesFromJson((String)json);
        Assertions.assertThat((List)deserializedMessages).isEqualTo(messages);
    }
}

